/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.transform.BeanFilter;
import org.apache.juneau.transform.PropertyFilter;

public class BeanFilterBuilder<T> {
    Class<?> beanClass;
    String typeName;
    Set<String> bpi = new LinkedHashSet<String>();
    Set<String> bpx = new LinkedHashSet<String>();
    Set<String> bpro = new LinkedHashSet<String>();
    Set<String> bpwo = new LinkedHashSet<String>();
    Class<?> interfaceClass;
    Class<?> stopClass;
    boolean sortProperties;
    boolean fluentSetters;
    Object propertyNamer;
    List<Class<?>> dictionary;
    Object propertyFilter;

    protected BeanFilterBuilder() {
        this.beanClass = ClassInfo.of(this.getClass()).getParameterType(0, BeanFilterBuilder.class);
    }

    protected BeanFilterBuilder(Class<?> beanClass) {
        this.beanClass = beanClass;
    }

    public BeanFilterBuilder<T> typeName(String value) {
        this.typeName = value;
        return this;
    }

    @Deprecated
    public BeanFilterBuilder<T> properties(String ... value) {
        this.bpi = new LinkedHashSet<String>();
        for (String v : value) {
            this.bpi.addAll(Arrays.asList(StringUtils.split(v)));
        }
        return this;
    }

    @Deprecated
    public BeanFilterBuilder<T> excludeProperties(String ... value) {
        this.bpx = new LinkedHashSet<String>();
        for (String v : value) {
            this.bpx.addAll(Arrays.asList(StringUtils.split(v)));
        }
        return this;
    }

    public BeanFilterBuilder<T> interfaceClass(Class<?> value) {
        this.interfaceClass = value;
        return this;
    }

    public BeanFilterBuilder<T> stopClass(Class<?> value) {
        this.stopClass = value;
        return this;
    }

    public BeanFilterBuilder<T> sortProperties(boolean value) {
        this.sortProperties = value;
        return this;
    }

    public BeanFilterBuilder<T> sortProperties() {
        this.sortProperties = true;
        return this;
    }

    public BeanFilterBuilder<T> fluentSetters(boolean value) {
        this.fluentSetters = value;
        return this;
    }

    public BeanFilterBuilder<T> fluentSetters() {
        this.fluentSetters = true;
        return this;
    }

    public BeanFilterBuilder<T> propertyNamer(Class<? extends PropertyNamer> value) {
        this.propertyNamer = value;
        return this;
    }

    @Deprecated
    public BeanFilterBuilder<T> beanDictionary(Class<?> ... values) {
        if (this.dictionary == null) {
            this.dictionary = new ArrayList(Arrays.asList(values));
        } else {
            for (Class<?> cc : values) {
                this.dictionary.add(cc);
            }
        }
        return this;
    }

    public BeanFilterBuilder<T> bpi(String ... value) {
        this.bpi = new LinkedHashSet<String>();
        for (String v : value) {
            this.bpi.addAll(Arrays.asList(StringUtils.split(v)));
        }
        return this;
    }

    public BeanFilterBuilder<T> bpx(String ... value) {
        this.bpx = new LinkedHashSet<String>();
        for (String v : value) {
            this.bpx.addAll(Arrays.asList(StringUtils.split(v)));
        }
        return this;
    }

    public BeanFilterBuilder<T> bpro(String ... value) {
        this.bpro = new LinkedHashSet<String>();
        for (String v : value) {
            this.bpro.addAll(Arrays.asList(StringUtils.split(v)));
        }
        return this;
    }

    public BeanFilterBuilder<T> bpwo(String ... value) {
        this.bpwo = new LinkedHashSet<String>();
        for (String v : value) {
            this.bpwo.addAll(Arrays.asList(StringUtils.split(v)));
        }
        return this;
    }

    public BeanFilterBuilder<T> dictionary(Class<?> ... values) {
        if (this.dictionary == null) {
            this.dictionary = new ArrayList(Arrays.asList(values));
        } else {
            for (Class<?> cc : values) {
                this.dictionary.add(cc);
            }
        }
        return this;
    }

    public BeanFilterBuilder<T> propertyFilter(Class<? extends PropertyFilter> value) {
        this.propertyFilter = value;
        return this;
    }

    public BeanFilter build() {
        return new BeanFilter(this);
    }
}

