/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.processor;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.http.Header;
import org.apache.juneau.http.HttpHeaders;
import org.apache.juneau.http.resource.HttpResource;
import org.apache.juneau.rest.RestOpSession;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.processor.ResponseProcessor;
import org.apache.juneau.rest.util.FinishableServletOutputStream;

public final class HttpResourceProcessor
implements ResponseProcessor {
    @Override
    public int process(RestOpSession opSession) throws IOException {
        RestResponse res = opSession.getResponse();
        HttpResource r = res.getContent(HttpResource.class);
        if (r == null) {
            return 0;
        }
        res.setHeader(r.getContentType());
        res.setHeader(r.getContentEncoding());
        long contentLength = r.getContentLength();
        if (contentLength >= 0L) {
            res.setHeader((Header)HttpHeaders.contentLength((Long)contentLength));
        }
        r.getHeaders().forEach(x -> res.addHeader((Header)x));
        try (FinishableServletOutputStream os = res.getNegotiatedOutputStream();){
            r.writeTo((OutputStream)((Object)os));
            ((OutputStream)((Object)os)).flush();
        }
        return 1;
    }
}

