/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.parser;

import java.lang.reflect.InvocationTargetException;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.parser.Position;

public class ParseException
extends BasicRuntimeException {
    private static final long serialVersionUID = 1L;

    public static ParseException create(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getCause();
        }
        if (e instanceof ParseException) {
            return (ParseException)e;
        }
        return new ParseException(e);
    }

    public ParseException(String message, Object ... args) {
        super(message, args);
    }

    public ParseException(Throwable causedBy, String message, Object ... args) {
        super(causedBy, message, args);
    }

    public ParseException(Throwable causedBy) {
        super(causedBy);
    }

    public ParseException(ParserSession session, String message, Object ... args) {
        super(ParseException.getMessage(session, message, args), new Object[0]);
    }

    public ParseException(ParserSession session, Throwable causedBy, String message, Object ... args) {
        super(causedBy, ParseException.getMessage(session, message, args), new Object[0]);
    }

    public ParseException(ParserSession session, Exception causedBy) {
        super(causedBy, ParseException.getMessage(session, causedBy.getMessage(), new Object[0]), new Object[0]);
    }

    private static String getMessage(ParserSession session, String msg, Object ... args) {
        if (args.length != 0) {
            msg = StringUtils.format((String)msg, (Object[])args);
        }
        if (session != null) {
            String lines;
            Position p = session.getPosition();
            StringBuilder sb = new StringBuilder(msg);
            sb.append("\n\tAt: ").append(p);
            JsonMap lastLocation = session.getLastLocation();
            if (lastLocation != null) {
                sb.append("\n\tWhile parsing into: ");
                lastLocation.forEach((k, v) -> sb.append("\n\t\t").append((String)k).append(": ").append(v));
            }
            if ((lines = session.getInputAsString()) == null) {
                sb.append("\n\tUse BEAN_debug setting to display content.");
            } else {
                int numLines = session.getDebugOutputLines();
                int start = p.line - numLines;
                int end = p.line + numLines;
                sb.append("\n---start--\n").append(StringUtils.getNumberedLines((String)lines, (int)start, (int)end)).append("---end---");
            }
            msg = sb.toString();
        }
        return msg;
    }

    public ParseException getRootCause() {
        ParseException t = this;
        while (t.getCause() != null && t.getCause() instanceof ParseException) {
            t = (ParseException)t.getCause();
        }
        return t;
    }
}

