/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.config.mod;

import org.apache.juneau.common.internal.IOUtils;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.config.mod.Mod;

public class XorEncodeMod
extends Mod {
    public static final XorEncodeMod INSTANCE = new XorEncodeMod();
    private static final String KEY = System.getProperty("org.apache.juneau.config.XorEncoder.key", "nuy7og796Vh6G9O6bG230SHK0cc8QYkH");

    public XorEncodeMod() {
        super('*', null, null, null);
    }

    @Override
    public String apply(String value) {
        byte[] b = value.getBytes(IOUtils.UTF8);
        for (int i = 0; i < b.length; ++i) {
            int j = i % KEY.length();
            b[i] = (byte)(b[i] ^ KEY.charAt(j));
        }
        return "{" + StringUtils.base64Encode((byte[])b) + "}";
    }

    @Override
    public String remove(String value) {
        value = value.trim();
        value = value.substring(1, value.length() - 1);
        byte[] b = StringUtils.base64Decode((String)value);
        for (int i = 0; i < b.length; ++i) {
            int j = i % KEY.length();
            b[i] = (byte)(b[i] ^ KEY.charAt(j));
        }
        return new String(b, IOUtils.UTF8);
    }

    @Override
    public boolean isApplied(String value) {
        return StringUtils.startsWith((String)value, (char)'{') && StringUtils.endsWith((String)value, (char)'}');
    }
}

