/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.openapi3;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.dto.openapi3.Discriminator;
import org.apache.juneau.dto.openapi3.Items;
import org.apache.juneau.dto.openapi3.OpenApiElement;
import org.apache.juneau.dto.swagger.ExternalDocumentation;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.dto.swagger.Xml;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.MultiSet;

@Bean(properties="format,title,description,default,multipleOf,maximum,exclusiveMaximum,minimum,exclusiveMinimum,maxLength,minLength,pattern,maxItems,minItems,uniqueItems,maxProperties,minProperties,required,enum,type,items,allOf,anyOf,oneOf,properties,additionalProperties,not,discriminator,readOnly,writeOnly,nullable,deprecated,xml,externalDocs,example,$ref,*")
@FluentSetters
public class SchemaInfo
extends OpenApiElement {
    private String format;
    private String title;
    private String description;
    private String pattern;
    private String ref;
    private String type;
    private Number multipleOf;
    private Number maximum;
    private Number minimum;
    private Integer maxLength;
    private Integer minLength;
    private Integer maxItems;
    private Integer minItems;
    private Integer maxProperties;
    private Integer minProperties;
    private Boolean exclusiveMaximum;
    private Boolean exclusiveMinimum;
    private Boolean uniqueItems;
    private Boolean nullable;
    private Boolean writeOnly;
    private Boolean readOnly;
    private Boolean deprecated;
    private Object _default;
    private Object example;
    private Items items;
    private Xml xml;
    private ExternalDocumentation externalDocs;
    private List<Object> allOf;
    private List<Object> oneOf;
    private List<Object> anyOf;
    private List<Object> _enum;
    private List<String> required;
    private Discriminator discriminator;
    private Map<String, SchemaInfo> properties;
    private SchemaInfo additionalProperties;
    private SchemaInfo not;

    public SchemaInfo() {
    }

    public SchemaInfo(SchemaInfo copyFrom) {
        super(copyFrom);
        this.format = copyFrom.format;
        this.title = copyFrom.title;
        this.description = copyFrom.description;
        this.ref = copyFrom.ref;
        this.nullable = copyFrom.nullable;
        this.writeOnly = copyFrom.writeOnly;
        this.deprecated = copyFrom.deprecated;
        this.pattern = copyFrom.pattern;
        this.type = copyFrom.type;
        this.discriminator = copyFrom.discriminator;
        this.multipleOf = copyFrom.multipleOf;
        this.maximum = copyFrom.maximum;
        this.minimum = copyFrom.minimum;
        this.maxLength = copyFrom.maxLength;
        this.minLength = copyFrom.minLength;
        this.maxItems = copyFrom.maxItems;
        this.minItems = copyFrom.minItems;
        this.maxProperties = copyFrom.maxProperties;
        this.minProperties = copyFrom.minProperties;
        this.exclusiveMaximum = copyFrom.exclusiveMaximum;
        this.exclusiveMinimum = copyFrom.exclusiveMinimum;
        this.uniqueItems = copyFrom.uniqueItems;
        this.readOnly = copyFrom.readOnly;
        this._default = copyFrom._default;
        this.example = copyFrom.example;
        this.items = copyFrom.items == null ? null : copyFrom.items.copy();
        this.xml = copyFrom.xml == null ? null : copyFrom.xml.copy();
        this.externalDocs = copyFrom.externalDocs == null ? null : copyFrom.externalDocs.copy();
        this._enum = CollectionUtils.copyOf(copyFrom._enum);
        this.allOf = CollectionUtils.copyOf(copyFrom.allOf);
        this.required = CollectionUtils.copyOf(copyFrom.required);
        this.anyOf = CollectionUtils.copyOf(copyFrom.anyOf);
        this.oneOf = CollectionUtils.copyOf(copyFrom.oneOf);
        if (copyFrom.properties == null) {
            this.properties = null;
        } else {
            this.properties = new LinkedHashMap<String, SchemaInfo>();
            for (Map.Entry<String, SchemaInfo> e : copyFrom.properties.entrySet()) {
                this.properties.put(e.getKey(), e.getValue().copy());
            }
        }
        this.additionalProperties = copyFrom.additionalProperties == null ? null : copyFrom.additionalProperties.copy();
        this.not = copyFrom.not == null ? null : copyFrom.not.copy();
    }

    public SchemaInfo copy() {
        return new SchemaInfo(this);
    }

    public String getFormat() {
        return this.format;
    }

    public SchemaInfo setFormat(String value) {
        this.format = value;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public SchemaInfo setTitle(String value) {
        this.title = value;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public SchemaInfo setDescription(String value) {
        this.description = value;
        return this;
    }

    public Object getDefault() {
        return this._default;
    }

    public SchemaInfo setDefault(Object value) {
        this._default = value;
        return this;
    }

    public Number getMultipleOf() {
        return this.multipleOf;
    }

    public SchemaInfo setMultipleOf(Number value) {
        this.multipleOf = value;
        return this;
    }

    public Number getMaximum() {
        return this.maximum;
    }

    public SchemaInfo setMaximum(Number value) {
        this.maximum = value;
        return this;
    }

    public Boolean getExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public SchemaInfo setExclusiveMaximum(Boolean value) {
        this.exclusiveMaximum = value;
        return this;
    }

    public Number getMinimum() {
        return this.minimum;
    }

    public SchemaInfo setMinimum(Number value) {
        this.minimum = value;
        return this;
    }

    public Boolean getExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public SchemaInfo setExclusiveMinimum(Boolean value) {
        this.exclusiveMinimum = value;
        return this;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public SchemaInfo setMaxLength(Integer value) {
        this.maxLength = value;
        return this;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public SchemaInfo setMinLength(Integer value) {
        this.minLength = value;
        return this;
    }

    public String getPattern() {
        return this.pattern;
    }

    public SchemaInfo setPattern(String value) {
        this.pattern = value;
        return this;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public SchemaInfo setMaxItems(Integer value) {
        this.maxItems = value;
        return this;
    }

    public Integer getMinItems() {
        return this.minItems;
    }

    public SchemaInfo setMinItems(Integer value) {
        this.minItems = value;
        return this;
    }

    public Boolean getUniqueItems() {
        return this.uniqueItems;
    }

    public SchemaInfo setUniqueItems(Boolean value) {
        this.uniqueItems = value;
        return this;
    }

    public Boolean getNullable() {
        return this.nullable;
    }

    public SchemaInfo setNullable(Boolean value) {
        this.nullable = value;
        return this;
    }

    public Integer getMaxProperties() {
        return this.maxProperties;
    }

    public SchemaInfo setMaxProperties(Integer value) {
        this.maxProperties = value;
        return this;
    }

    public Integer getMinProperties() {
        return this.minProperties;
    }

    public SchemaInfo setMinProperties(Integer value) {
        this.minProperties = value;
        return this;
    }

    public List<String> getRequired() {
        return this.required;
    }

    public SchemaInfo setRequired(Collection<String> value) {
        this.required = CollectionUtils.listFrom(value);
        return this;
    }

    public SchemaInfo addRequired(String ... values) {
        this.required = CollectionUtils.listBuilder(String.class, new Type[0]).sparse().add((String[])values).build();
        return this;
    }

    public List<Object> getEnum() {
        return this._enum;
    }

    public SchemaInfo setEnum(Collection<Object> value) {
        this._enum = CollectionUtils.listFrom(value);
        return this;
    }

    public SchemaInfo addEnum(Object ... values) {
        this.setEnum(CollectionUtils.setBuilder(Object.class, new Type[0]).sparse().addAny(values).build());
        return this;
    }

    public String getType() {
        return this.type;
    }

    public SchemaInfo setType(String value) {
        this.type = value;
        return this;
    }

    public Items getItems() {
        return this.items;
    }

    public SchemaInfo setItems(Items value) {
        this.items = value;
        return this;
    }

    public List<Object> getAllOf() {
        return this.allOf;
    }

    public SchemaInfo setAllOf(Collection<Object> value) {
        this.allOf = CollectionUtils.listFrom(value);
        return this;
    }

    public SchemaInfo addAllOf(Object ... values) {
        this.allOf = CollectionUtils.listBuilder(this.allOf).sparse().addAny(values).build();
        return this;
    }

    public List<Object> getAnyOf() {
        return this.anyOf;
    }

    public SchemaInfo setAnyOf(Collection<Object> value) {
        this.anyOf = CollectionUtils.listFrom(value);
        return this;
    }

    public SchemaInfo addAnyOf(Object ... values) {
        this.anyOf = CollectionUtils.listBuilder(this.anyOf).sparse().addAny(values).build();
        return this;
    }

    public List<Object> getOneOf() {
        return this.oneOf;
    }

    public SchemaInfo setOneOf(Collection<Object> value) {
        this.oneOf = CollectionUtils.listFrom(value);
        return this;
    }

    public SchemaInfo addOneOf(Object ... values) {
        this.oneOf = CollectionUtils.listBuilder(this.oneOf).sparse().addAny(values).build();
        return this;
    }

    public Map<String, SchemaInfo> getProperties() {
        return this.properties;
    }

    public SchemaInfo setProperties(Map<String, SchemaInfo> value) {
        this.properties = CollectionUtils.copyOf(value);
        return this;
    }

    public SchemaInfo getAdditionalProperties() {
        return this.additionalProperties;
    }

    public SchemaInfo setAdditionalProperties(SchemaInfo value) {
        this.additionalProperties = value;
        return this;
    }

    public SchemaInfo getNot() {
        return this.not;
    }

    public SchemaInfo setNot(SchemaInfo value) {
        this.not = value;
        return this;
    }

    public Discriminator getDiscriminator() {
        return this.discriminator;
    }

    public SchemaInfo setDiscriminator(Discriminator value) {
        this.discriminator = value;
        return this;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public SchemaInfo setReadOnly(Boolean value) {
        this.readOnly = value;
        return this;
    }

    public Boolean getWriteOnly() {
        return this.writeOnly;
    }

    public SchemaInfo setWriteOnly(Boolean value) {
        this.writeOnly = value;
        return this;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public SchemaInfo setDeprecated(Boolean value) {
        this.deprecated = value;
        return this;
    }

    public Xml getXml() {
        return this.xml;
    }

    public SchemaInfo setXml(Xml value) {
        this.xml = value;
        return this;
    }

    public ExternalDocumentation getExternalDocs() {
        return this.externalDocs;
    }

    public SchemaInfo setExternalDocs(ExternalDocumentation value) {
        this.externalDocs = value;
        return this;
    }

    public Object getExample() {
        return this.example;
    }

    public SchemaInfo setExample(Object value) {
        this.example = value;
        return this;
    }

    @Beanp(value="$ref")
    public String getRef() {
        return this.ref;
    }

    @Beanp(value="$ref")
    public SchemaInfo setRef(Object value) {
        this.ref = StringUtils.stringify(value);
        return this;
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "format": {
                return ConverterUtils.toType(this.getFormat(), type);
            }
            case "title": {
                return ConverterUtils.toType(this.getTitle(), type);
            }
            case "description": {
                return ConverterUtils.toType(this.getDescription(), type);
            }
            case "default": {
                return ConverterUtils.toType(this.getDefault(), type);
            }
            case "multipleOf": {
                return ConverterUtils.toType(this.getMultipleOf(), type);
            }
            case "maximum": {
                return ConverterUtils.toType(this.getMaximum(), type);
            }
            case "exclusiveMaximum": {
                return ConverterUtils.toType(this.getExclusiveMaximum(), type);
            }
            case "minimum": {
                return ConverterUtils.toType(this.getMinimum(), type);
            }
            case "exclusiveMinimum": {
                return ConverterUtils.toType(this.getExclusiveMinimum(), type);
            }
            case "maxLength": {
                return ConverterUtils.toType(this.getMaxLength(), type);
            }
            case "minLength": {
                return ConverterUtils.toType(this.getMinLength(), type);
            }
            case "pattern": {
                return ConverterUtils.toType(this.getPattern(), type);
            }
            case "maxItems": {
                return ConverterUtils.toType(this.getMaxItems(), type);
            }
            case "minItems": {
                return ConverterUtils.toType(this.getMinItems(), type);
            }
            case "uniqueItems": {
                return ConverterUtils.toType(this.getUniqueItems(), type);
            }
            case "maxProperties": {
                return ConverterUtils.toType(this.getMaxProperties(), type);
            }
            case "minProperties": {
                return ConverterUtils.toType(this.getMinProperties(), type);
            }
            case "required": {
                return ConverterUtils.toType(this.getRequired(), type);
            }
            case "enum": {
                return ConverterUtils.toType(this.getEnum(), type);
            }
            case "type": {
                return ConverterUtils.toType(this.getType(), type);
            }
            case "items": {
                return ConverterUtils.toType(this.getItems(), type);
            }
            case "allOf": {
                return ConverterUtils.toType(this.getAllOf(), type);
            }
            case "oneOf": {
                return ConverterUtils.toType(this.getOneOf(), type);
            }
            case "anyOf": {
                return ConverterUtils.toType(this.getAnyOf(), type);
            }
            case "properties": {
                return ConverterUtils.toType(this.getProperties(), type);
            }
            case "additionalProperties": {
                return ConverterUtils.toType(this.getAdditionalProperties(), type);
            }
            case "not": {
                return ConverterUtils.toType(this.getNot(), type);
            }
            case "nullable": {
                return ConverterUtils.toType(this.getNullable(), type);
            }
            case "deprecated": {
                return ConverterUtils.toType(this.getDeprecated(), type);
            }
            case "discriminator": {
                return ConverterUtils.toType(this.getDiscriminator(), type);
            }
            case "readOnly": {
                return ConverterUtils.toType(this.getReadOnly(), type);
            }
            case "writeOnly": {
                return ConverterUtils.toType(this.getWriteOnly(), type);
            }
            case "xml": {
                return ConverterUtils.toType(this.getXml(), type);
            }
            case "externalDocs": {
                return ConverterUtils.toType(this.getExternalDocs(), type);
            }
            case "example": {
                return ConverterUtils.toType(this.getExample(), type);
            }
            case "$ref": {
                return ConverterUtils.toType(this.getRef(), type);
            }
        }
        return super.get(property, type);
    }

    @Override
    public SchemaInfo set(String property, Object value) {
        if (property == null) {
            return this;
        }
        switch (property) {
            case "format": {
                return this.setFormat(StringUtils.stringify(value));
            }
            case "title": {
                return this.setTitle(StringUtils.stringify(value));
            }
            case "description": {
                return this.setDescription(StringUtils.stringify(value));
            }
            case "default": {
                return this.setDefault(value);
            }
            case "multipleOf": {
                return this.setMultipleOf(ConverterUtils.toNumber(value));
            }
            case "maximum": {
                return this.setMaximum(ConverterUtils.toNumber(value));
            }
            case "exclusiveMaximum": {
                return this.setExclusiveMaximum(ConverterUtils.toBoolean(value));
            }
            case "minimum": {
                return this.setMinimum(ConverterUtils.toNumber(value));
            }
            case "exclusiveMinimum": {
                return this.setExclusiveMinimum(ConverterUtils.toBoolean(value));
            }
            case "maxLength": {
                return this.setMaxLength(ConverterUtils.toInteger(value));
            }
            case "minLength": {
                return this.setMinLength(ConverterUtils.toInteger(value));
            }
            case "pattern": {
                return this.setPattern(StringUtils.stringify(value));
            }
            case "maxItems": {
                return this.setMaxItems(ConverterUtils.toInteger(value));
            }
            case "minItems": {
                return this.setMinItems(ConverterUtils.toInteger(value));
            }
            case "uniqueItems": {
                return this.setUniqueItems(ConverterUtils.toBoolean(value));
            }
            case "maxProperties": {
                return this.setMaxProperties(ConverterUtils.toInteger(value));
            }
            case "minProperties": {
                return this.setMinProperties(ConverterUtils.toInteger(value));
            }
            case "required": {
                return this.addRequired(StringUtils.stringify(value));
            }
            case "enum": {
                return this.addEnum(value);
            }
            case "type": {
                return this.setType(StringUtils.stringify(value));
            }
            case "items": {
                return this.setItems(ConverterUtils.toType(value, Items.class));
            }
            case "allOf": {
                return this.addAllOf(value);
            }
            case "anyOf": {
                return this.addAnyOf(value);
            }
            case "oneOf": {
                return this.addOneOf(value);
            }
            case "properties": {
                return this.setProperties(CollectionUtils.mapBuilder(String.class, SchemaInfo.class, new Type[0]).sparse().addAny(value).build());
            }
            case "additionalProperties": {
                return this.setAdditionalProperties(ConverterUtils.toType(value, SchemaInfo.class));
            }
            case "not": {
                return this.setNot(ConverterUtils.toType(value, SchemaInfo.class));
            }
            case "nullable": {
                return this.setNullable(ConverterUtils.toBoolean(value));
            }
            case "deprecated": {
                return this.setDeprecated(ConverterUtils.toBoolean(value));
            }
            case "discriminator": {
                return this.setDiscriminator(ConverterUtils.toType(value, Discriminator.class));
            }
            case "readOnly": {
                return this.setReadOnly(ConverterUtils.toBoolean(value));
            }
            case "writeOnly": {
                return this.setWriteOnly(ConverterUtils.toBoolean(value));
            }
            case "xml": {
                return this.setXml(ConverterUtils.toType(value, Xml.class));
            }
            case "externalDocs": {
                return this.setExternalDocs(ConverterUtils.toType(value, ExternalDocumentation.class));
            }
            case "example": {
                return this.setExample(value);
            }
            case "$ref": {
                return this.setRef(value);
            }
        }
        super.set(property, value);
        return this;
    }

    @Override
    public Set<String> keySet() {
        Set<String> s = CollectionUtils.setBuilder(String.class, new Type[0]).addIf(this.format != null, "format").addIf(this.title != null, "title").addIf(this.description != null, "description").addIf(this._default != null, "default").addIf(this.multipleOf != null, "multipleOf").addIf(this.maximum != null, "maximum").addIf(this.exclusiveMaximum != null, "exclusiveMaximum").addIf(this.minimum != null, "minimum").addIf(this.exclusiveMinimum != null, "exclusiveMinimum").addIf(this.maxLength != null, "maxLength").addIf(this.minLength != null, "minLength").addIf(this.pattern != null, "pattern").addIf(this.maxItems != null, "maxItems").addIf(this.minItems != null, "minItems").addIf(this.uniqueItems != null, "uniqueItems").addIf(this.maxProperties != null, "maxProperties").addIf(this.minProperties != null, "minProperties").addIf(this.required != null, "required").addIf(this._enum != null, "enum").addIf(this.type != null, "type").addIf(this.items != null, "items").addIf(this.allOf != null, "allOf").addIf(this.anyOf != null, "anyOf").addIf(this.oneOf != null, "oneOf").addIf(this.properties != null, "properties").addIf(this.additionalProperties != null, "additionalProperties").addIf(this.nullable != null, "nullable").addIf(this.deprecated != null, "deprecated").addIf(this.not != null, "not").addIf(this.discriminator != null, "discriminator").addIf(this.readOnly != null, "readOnly").addIf(this.writeOnly != null, "writeOnly").addIf(this.xml != null, "xml").addIf(this.externalDocs != null, "externalDocs").addIf(this.example != null, "example").addIf(this.ref != null, "$ref").build();
        return new MultiSet<String>(s, super.keySet());
    }

    public SchemaInfo resolveRefs(Swagger swagger, Deque<String> refStack, int maxDepth) {
        if (this.ref != null) {
            if (refStack.contains(this.ref) || refStack.size() >= maxDepth) {
                return this;
            }
            refStack.addLast(this.ref);
            SchemaInfo r = swagger.findRef(this.ref, SchemaInfo.class).resolveRefs(swagger, refStack, maxDepth);
            refStack.removeLast();
            return r;
        }
        if (this.items != null) {
            this.items = this.items.resolveRefs(swagger, refStack, maxDepth);
        }
        if (this.properties != null) {
            for (Map.Entry<String, SchemaInfo> e : this.properties.entrySet()) {
                e.setValue(e.getValue().resolveRefs(swagger, refStack, maxDepth));
            }
        }
        if (this.additionalProperties != null) {
            this.additionalProperties = this.additionalProperties.resolveRefs(swagger, refStack, maxDepth);
        }
        this.example = null;
        return this;
    }
}

