/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.rest.errors;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ExceptionMapper;
import org.apache.kafka.connect.errors.AlreadyExistsException;
import org.apache.kafka.connect.errors.NotFoundException;
import org.apache.kafka.connect.runtime.rest.entities.ErrorMessage;
import org.apache.kafka.connect.runtime.rest.errors.ConnectRestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectExceptionMapper
implements ExceptionMapper<Exception> {
    private static final Logger log = LoggerFactory.getLogger(ConnectExceptionMapper.class);
    @Context
    private UriInfo uriInfo;

    public Response toResponse(Exception exception) {
        int statusCode;
        log.debug("Uncaught exception in REST call to /{}", (Object)this.uriInfo.getPath(), (Object)exception);
        if (exception instanceof ConnectRestException) {
            ConnectRestException restException = (ConnectRestException)((Object)exception);
            return Response.status((int)restException.statusCode()).entity((Object)new ErrorMessage(restException.errorCode(), restException.getMessage())).build();
        }
        if (exception instanceof NotFoundException || exception instanceof javax.ws.rs.NotFoundException) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorMessage(Response.Status.NOT_FOUND.getStatusCode(), exception.getMessage())).build();
        }
        if (exception instanceof AlreadyExistsException) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)new ErrorMessage(Response.Status.CONFLICT.getStatusCode(), exception.getMessage())).build();
        }
        if (!log.isDebugEnabled()) {
            log.error("Uncaught exception in REST call to /{}", (Object)this.uriInfo.getPath(), (Object)exception);
        }
        if (exception instanceof WebApplicationException) {
            Response.StatusType statusInfo = ((WebApplicationException)exception).getResponse().getStatusInfo();
            statusCode = statusInfo.getStatusCode();
        } else {
            statusCode = Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
        }
        return Response.status((int)statusCode).entity((Object)new ErrorMessage(statusCode, exception.getMessage())).build();
    }
}

