/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.cluster.Partition;
import kafka.log.UnifiedLog;
import kafka.server.AbstractFetcherThread;
import kafka.server.FailedPartitions;
import kafka.server.KafkaConfig;
import kafka.server.LeaderEndPoint;
import kafka.server.OffsetTruncationState;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.TierStateMachine;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001B\u000e\u001d\u0001\u0005B\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\ni\u0001\u0011\t\u0011)A\u0005kaB\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t{\u0001\u0011\t\u0011)A\u0005}!A\u0011\t\u0001B\u0001B\u0003%!\t\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0011!I\u0005A!A!\u0002\u00139\u0003\u0002\u0003&\u0001\u0005\u0003\u0005\u000b\u0011B&\t\u000bm\u0003A\u0011\u0001/\t\u0011\u0019\u0004!\u0019!C\u00019\u001dDa!\u001e\u0001!\u0002\u0013A\u0007b\u0002<\u0001\u0005\u0004%\tf\u001e\u0005\u0007w\u0002\u0001\u000b\u0011\u0002=\t\u000bq\u0004A\u0011K?\t\u000f\u00055\u0001\u0001\"\u0015\u0002\u0010!9\u0011\u0011\u0004\u0001\u0005R\u0005m\u0001bBA\u0010\u0001\u0011E\u0013\u0011\u0005\u0005\b\u0003c\u0001A\u0011IA\u001a\u0011\u001d\t)\u0004\u0001C!\u0003oAq!a\u0010\u0001\t\u0003\n9\u0004C\u0004\u0002B\u0001!\t%a\u0011\t\u000f\u0005E\u0004\u0001\"\u0003\u00028!9\u00111\u000f\u0001\u0005\n\u0005U\u0004bBAE\u0001\u0011\u0005\u00131\u0012\u0005\b\u00037\u0003A\u0011KAO\u00115\t)\u000b\u0001I\u0001\u0004\u0003\u0005I\u0011BATq\t!\"+\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012T!!\b\u0010\u0002\rM,'O^3s\u0015\u0005y\u0012!B6bM.\f7\u0001A\n\u0003\u0001\t\u0002\"a\t\u0013\u000e\u0003qI!!\n\u000f\u0003+\u0005\u00137\u000f\u001e:bGR4U\r^2iKJ$\u0006N]3bI\u0006!a.Y7f!\tA\u0013G\u0004\u0002*_A\u0011!&L\u0007\u0002W)\u0011A\u0006I\u0001\u0007yI|w\u000e\u001e \u000b\u00039\nQa]2bY\u0006L!\u0001M\u0017\u0002\rA\u0013X\rZ3g\u0013\t\u00114G\u0001\u0004TiJLgn\u001a\u0006\u0003a5\na\u0001\\3bI\u0016\u0014\bCA\u00127\u0013\t9DD\u0001\bMK\u0006$WM]#oIB{\u0017N\u001c;\n\u0005Q\"\u0013\u0001\u00042s_.,'oQ8oM&<\u0007CA\u0012<\u0013\taDDA\u0006LC\u001a\\\u0017mQ8oM&<\u0017\u0001\u00054bS2,G\rU1si&$\u0018n\u001c8t!\t\u0019s(\u0003\u0002A9\t\u0001b)Y5mK\u0012\u0004\u0016M\u001d;ji&|gn]\u0001\u000be\u0016\u0004H.[2b\u001b\u001e\u0014\bCA\u0012D\u0013\t!ED\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002\u000bE,x\u000e^1\u0011\u0005\r:\u0015B\u0001%\u001d\u00051\u0011V\r\u001d7jG\u0006\fVo\u001c;b\u0003%awn\u001a)sK\u001aL\u00070A\fnKR\fG-\u0019;b-\u0016\u00148/[8o'V\u0004\b\u000f\\5feB\u0019A*T(\u000e\u00035J!AT\u0017\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004C\u0001)Z\u001b\u0005\t&B\u0001*T\u0003\u0019\u0019w.\\7p]*\u0011Q\u0004\u0016\u0006\u0003?US!AV,\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0016aA8sO&\u0011!,\u0015\u0002\u0010\u001b\u0016$\u0018\rZ1uCZ+'o]5p]\u00061A(\u001b8jiz\"\u0012\"\u00180`A\u0006\u00147\rZ3\u0011\u0005\r\u0002\u0001\"\u0002\u0014\n\u0001\u00049\u0003\"\u0002\u001b\n\u0001\u0004)\u0004\"B\u001d\n\u0001\u0004Q\u0004\"B\u001f\n\u0001\u0004q\u0004\"B!\n\u0001\u0004\u0011\u0005\"B#\n\u0001\u00041\u0005\"B%\n\u0001\u00049\u0003\"\u0002&\n\u0001\u0004Y\u0015A\b9beRLG/[8og^KG\u000f\u001b(fo\"Kw\r[,bi\u0016\u0014X.\u0019:l+\u0005A\u0007cA5oa6\t!N\u0003\u0002lY\u00069Q.\u001e;bE2,'BA7.\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003_*\u0014aAQ;gM\u0016\u0014\bCA9t\u001b\u0005\u0011(B\u0001*U\u0013\t!(O\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002?A\f'\u000f^5uS>t7oV5uQ:+w\u000fS5hQ^\u000bG/\u001a:nCJ\\\u0007%A\u0010jg>3gm]3u\r>\u0014H*Z1eKJ,\u0005o\\2i'V\u0004\bo\u001c:uK\u0012,\u0012\u0001\u001f\t\u0003\u0019fL!A_\u0017\u0003\u000f\t{w\u000e\\3b]\u0006\u0001\u0013n](gMN,GOR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007nU;qa>\u0014H/\u001a3!\u0003-a\u0017\r^3ti\u0016\u0003xn\u00195\u0015\u0007y\fI\u0001\u0005\u0003M\u007f\u0006\r\u0011bAA\u0001[\t1q\n\u001d;j_:\u00042\u0001TA\u0003\u0013\r\t9!\f\u0002\u0004\u0013:$\bBBA\u0006\u001d\u0001\u0007\u0001/\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0002\u001d1|wm\u0015;beR|eMZ:fiR!\u0011\u0011CA\f!\ra\u00151C\u0005\u0004\u0003+i#\u0001\u0002'p]\u001eDa!a\u0003\u0010\u0001\u0004\u0001\u0018\u0001\u00047pO\u0016sGm\u00144gg\u0016$H\u0003BA\t\u0003;Aa!a\u0003\u0011\u0001\u0004\u0001\u0018!E3oI>3gm]3u\r>\u0014X\t]8dQR1\u00111EA\u0016\u0003[\u0001B\u0001T@\u0002&A\u0019\u0001+a\n\n\u0007\u0005%\u0012K\u0001\bPM\u001a\u001cX\r^!oI\u0016\u0003xn\u00195\t\r\u0005-\u0011\u00031\u0001q\u0011\u001d\ty#\u0005a\u0001\u0003\u0007\tQ!\u001a9pG\"\f\u0001#\u001b8ji&\fG/Z*ikR$wn\u001e8\u0015\u0003a\fQ\"Y<bSR\u001c\u0006.\u001e;e_^tGCAA\u001d!\ra\u00151H\u0005\u0004\u0003{i#\u0001B+oSR\fa\u0001Z8X_J\\\u0017\u0001\u00069s_\u000e,7o\u001d)beRLG/[8o\t\u0006$\u0018\r\u0006\u0006\u0002F\u0005m\u0013QLA1\u0003K\u0002B\u0001T@\u0002HA!\u0011\u0011JA,\u001b\t\tYE\u0003\u0003\u0002N\u0005=\u0013a\u00017pO*!\u0011\u0011KA*\u0003%Ig\u000e^3s]\u0006d7OC\u0002\u0002VQ\u000bqa\u001d;pe\u0006<W-\u0003\u0003\u0002Z\u0005-#!\u0004'pO\u0006\u0003\b/\u001a8e\u0013:4w\u000e\u0003\u0004\u0002\fU\u0001\r\u0001\u001d\u0005\b\u0003?*\u0002\u0019AA\t\u0003-1W\r^2i\u001f\u001a47/\u001a;\t\u000f\u0005\rT\u00031\u0001\u0002\u0004\u0005!\u0002/\u0019:uSRLwN\u001c'fC\u0012,'/\u00129pG\"Dq!a\u001a\u0016\u0001\u0004\tI'A\u0007qCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\t\u0005\u0003W\ni'D\u0001\u0001\u0013\r\ty\u0007\n\u0002\n\r\u0016$8\r\u001b#bi\u0006\fAdY8na2,G/\u001a#fY\u0006LX\r\u001a$fi\u000eD'+Z9vKN$8/A\u000enCf\u0014WmV1s]&3wJ^3sg&TX\r\u001a*fG>\u0014Hm\u001d\u000b\u0007\u0003s\t9(a\"\t\u000f\u0005et\u00031\u0001\u0002|\u00059!/Z2pe\u0012\u001c\b\u0003BA?\u0003\u0007k!!a \u000b\u0007\u0005\u0005%/\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0003\u000b\u000byHA\u0007NK6|'/\u001f*fG>\u0014Hm\u001d\u0005\u0007\u0003\u00179\u0002\u0019\u00019\u0002\u0011Q\u0014XO\\2bi\u0016$b!!\u000f\u0002\u000e\u0006E\u0005BBAH1\u0001\u0007\u0001/\u0001\u0002ua\"9\u00111\u0013\rA\u0002\u0005U\u0015!F8gMN,G\u000f\u0016:v]\u000e\fG/[8o'R\fG/\u001a\t\u0004G\u0005]\u0015bAAM9\t)rJ\u001a4tKR$&/\u001e8dCRLwN\\*uCR,\u0017a\u0006;sk:\u001c\u0017\r^3Gk2d\u00170\u00118e'R\f'\u000f^!u)\u0019\tI$a(\u0002\"\"1\u00111B\rA\u0002ADq!a)\u001a\u0001\u0004\t\t\"\u0001\u0004pM\u001a\u001cX\r^\u0001\rgV\u0004XM\u001d\u0013mK\u0006$WM]\u000b\u0002k\u0001")
public class ReplicaFetcherThread
extends AbstractFetcherThread {
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaMgr;
    private final ReplicaQuota quota;
    private final Function0<MetadataVersion> metadataVersionSupplier;
    private final Buffer<TopicPartition> partitionsWithNewHighWatermark;
    private final boolean isOffsetForLeaderEpochSupported;

    private /* synthetic */ LeaderEndPoint super$leader() {
        return super.leader();
    }

    public Buffer<TopicPartition> partitionsWithNewHighWatermark() {
        return this.partitionsWithNewHighWatermark;
    }

    @Override
    public boolean isOffsetForLeaderEpochSupported() {
        return this.isOffsetForLeaderEpochSupported;
    }

    @Override
    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logStartOffset(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).logStartOffset();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).logEndOffset();
    }

    @Override
    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.replicaMgr.localLogOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    public boolean initiateShutdown() {
        boolean justShutdown = super.initiateShutdown();
        if (justShutdown) {
            try {
                super.leader().initiateClose();
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(80).append("Failed to initiate shutdown of ").append(this.super$leader()).append(" after initiating replica fetcher thread shutdown").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            }
        }
        return justShutdown;
    }

    public void awaitShutdown() {
        super.awaitShutdown();
        try {
            super.leader().close();
            return;
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Failed to close ").append(this.super$leader()).append(" after shutting down replica fetcher thread").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            return;
        }
    }

    @Override
    public void doWork() {
        super.doWork();
        this.completeDelayedFetchRequests();
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, int partitionLeaderEpoch, FetchResponseData.PartitionData partitionData) {
        boolean logTrace = this.isTraceEnabled();
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        UnifiedLog log = partition.localLogOrException();
        MemoryRecords records = this.toMemoryRecords(FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData));
        this.maybeWarnIfOversizedRecords(records, topicPartition);
        if (fetchOffset != log.logEndOffset()) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Offset mismatch for partition %s: fetched offset = %d, log end offset = %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)log.logEndOffset())})));
        }
        if (logTrace) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Follower has replica log end offset %d for partition %s. Received %d bytes of messages and leader hw %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)log.logEndOffset()), topicPartition, BoxesRunTime.boxToInteger((int)records.sizeInBytes()), BoxesRunTime.boxToLong((long)partitionData.highWatermark())})));
        }
        Option<LogAppendInfo> logAppendInfo = partition.appendRecordsToFollowerOrFutureReplica(records, false, partitionLeaderEpoch);
        if (logTrace) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Follower has replica log end offset %d after appending %d bytes of messages for partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)log.logEndOffset()), BoxesRunTime.boxToInteger((int)records.sizeInBytes()), topicPartition})));
        }
        long leaderLogStartOffset = partitionData.logStartOffset();
        ObjectRef maybeUpdateHighWatermarkMessage = ObjectRef.create((Object)"but did not update replica high watermark");
        log.maybeUpdateHighWatermark(partitionData.highWatermark()).foreach((Function1 & Serializable & scala.Serializable)newHighWatermark -> ReplicaFetcherThread.$anonfun$processPartitionData$3(this, maybeUpdateHighWatermarkMessage, topicPartition, BoxesRunTime.unboxToLong((Object)newHighWatermark)));
        log.maybeIncrementLogStartOffset(leaderLogStartOffset, LogStartOffsetIncrementReason.LeaderOffsetIncremented);
        if (logTrace) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Follower received high watermark ").append(partitionData.highWatermark()).append(" from the leader ").append((String)maybeUpdateHighWatermarkMessage$1.elem).append(" for partition ").append(topicPartition).toString());
        }
        if (this.quota.isThrottled(topicPartition)) {
            this.quota.record(records.sizeInBytes());
        }
        if (partition.isReassigning() && partition.isAddingLocalReplica()) {
            this.brokerTopicStats().updateReassignmentBytesIn(records.sizeInBytes());
        }
        this.brokerTopicStats().updateReplicationBytesIn(records.sizeInBytes());
        return logAppendInfo;
    }

    private void completeDelayedFetchRequests() {
        if (this.partitionsWithNewHighWatermark().nonEmpty()) {
            this.replicaMgr.completeDelayedFetchRequests((Seq<TopicPartition>)this.partitionsWithNewHighWatermark().toSeq());
            this.partitionsWithNewHighWatermark().clear();
            return;
        }
    }

    private void maybeWarnIfOversizedRecords(MemoryRecords records, TopicPartition topicPartition) {
        if (((MetadataVersion)this.metadataVersionSupplier.apply()).fetchRequestVersion() <= 2 && records.sizeInBytes() > 0 && records.validBytes() <= 0) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(412).append("Replication is failing due to a message that is greater than replica.fetch.max.bytes for partition ").append(topicPartition).append(". ").append("This generally occurs when the max.message.bytes has been overridden to exceed this value and a suitably large ").append("message has also been sent. To fix this problem increase replica.fetch.max.bytes in your broker config to be ").append("equal or larger than your settings for max.message.bytes, both at a broker and topic level.").toString());
            return;
        }
    }

    @Override
    public void truncate(TopicPartition tp, OffsetTruncationState offsetTruncationState) {
        Partition partition = this.replicaMgr.getPartitionOrException(tp);
        UnifiedLog log = partition.localLogOrException();
        partition.truncateTo(offsetTruncationState.offset(), false);
        if (offsetTruncationState.offset() < log.highWatermark()) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Truncating ").append(tp).append(" to offset ").append(offsetTruncationState.offset()).append(" below high watermark ").append(log.highWatermark()).toString());
        }
        if (offsetTruncationState.truncationCompleted()) {
            this.replicaMgr.replicaAlterLogDirsManager().markPartitionsForTruncation(this.brokerConfig.brokerId(), tp, offsetTruncationState.offset());
            return;
        }
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        partition.truncateFullyAndStartAt(offset, false, partition.truncateFullyAndStartAt$default$3());
    }

    public static final /* synthetic */ Buffer $anonfun$processPartitionData$3(ReplicaFetcherThread $this, ObjectRef maybeUpdateHighWatermarkMessage$1, TopicPartition topicPartition$1, long newHighWatermark) {
        maybeUpdateHighWatermarkMessage$1.elem = new StringBuilder(38).append("and updated replica high watermark to ").append(newHighWatermark).toString();
        return $this.partitionsWithNewHighWatermark().$plus$eq((Object)topicPartition$1);
    }

    public ReplicaFetcherThread(String name, LeaderEndPoint leader, KafkaConfig brokerConfig, FailedPartitions failedPartitions, ReplicaManager replicaMgr, ReplicaQuota quota, String logPrefix, Function0<MetadataVersion> metadataVersionSupplier) {
        this.brokerConfig = brokerConfig;
        this.replicaMgr = replicaMgr;
        this.quota = quota;
        this.metadataVersionSupplier = metadataVersionSupplier;
        super(name, name, leader, failedPartitions, new TierStateMachine(leader, replicaMgr, false), Predef$.MODULE$.Integer2int(brokerConfig.replicaFetchBackoffMs()), false, replicaMgr.brokerTopicStats());
        this.logIdent_$eq(logPrefix);
        this.partitionsWithNewHighWatermark = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.isOffsetForLeaderEpochSupported = ((MetadataVersion)metadataVersionSupplier.apply()).isOffsetForLeaderEpochSupported();
    }
}

