/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.constants.SchemaConstants;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapAffectMultipleDsaException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapNoSuchObjectException;
import org.apache.directory.api.ldap.model.exception.LdapOperationErrorException;
import org.apache.directory.api.ldap.model.exception.LdapOtherException;
import org.apache.directory.api.ldap.model.exception.LdapPartialResultException;
import org.apache.directory.api.ldap.model.exception.LdapReferralException;
import org.apache.directory.api.ldap.model.exception.LdapServiceUnavailableException;
import org.apache.directory.api.ldap.model.exception.LdapURLEncodingException;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.url.LdapUrl;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.OperationManager;
import org.apache.directory.server.core.api.ReferralManager;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.Interceptor;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.api.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.GetRootDseOperationContext;
import org.apache.directory.server.core.api.interceptor.context.HasEntryOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.OperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.api.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.api.partition.PartitionReadTxn;
import org.apache.directory.server.core.api.partition.PartitionTxn;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOperationManager
implements OperationManager {
    private static final Logger OPERATION_LOG = LoggerFactory.getLogger((String)Loggers.OPERATION_LOG.getName());
    private static final Logger OPERATION_TIME = LoggerFactory.getLogger((String)Loggers.OPERATION_TIME.getName());
    private static final Logger OPERATION_STAT = LoggerFactory.getLogger((String)Loggers.OPERATION_STAT.getName());
    private static final boolean IS_DEBUG = OPERATION_LOG.isDebugEnabled();
    private static final boolean IS_TIME = OPERATION_TIME.isDebugEnabled();
    private static final boolean IS_STAT = OPERATION_STAT.isDebugEnabled();
    private final DirectoryService directoryService;
    private ReadWriteLock rwLock = new ReentrantReadWriteLock(true);

    public DefaultOperationManager(DirectoryService directoryService) {
        this.directoryService = directoryService;
    }

    public ReadWriteLock getRWLock() {
        return this.rwLock;
    }

    public void lockRead() {
        this.rwLock.readLock().lock();
    }

    public void lockWrite() {
        this.rwLock.writeLock().lock();
    }

    public void unlockWrite() {
        this.rwLock.writeLock().unlock();
    }

    public void unlockRead() {
        this.rwLock.readLock().unlock();
    }

    private void eagerlyPopulateFields(OperationContext opContext) throws LdapException {
        if (opContext.getEntry() == null) {
            CoreSession adminSession = opContext.getSession().getDirectoryService().getAdminSession();
            LookupOperationContext lookupContext = new LookupOperationContext(adminSession, opContext.getDn(), SchemaConstants.ALL_ATTRIBUTES_ARRAY);
            lookupContext.setPartition(opContext.getPartition());
            lookupContext.setTransaction(opContext.getTransaction());
            Entry foundEntry = opContext.getSession().getDirectoryService().getPartitionNexus().lookup(lookupContext);
            if (foundEntry != null) {
                opContext.setEntry(foundEntry);
            } else {
                throw new LdapNoSuchObjectException(I18n.err((I18n)I18n.ERR_256_NO_SUCH_OBJECT, (Object[])new Object[]{opContext.getDn()}));
            }
        }
    }

    private Entry getOriginalEntry(OperationContext opContext) throws LdapException {
        CoreSession adminSession = opContext.getSession().getDirectoryService().getAdminSession();
        Entry foundEntry = adminSession.lookup(opContext.getDn(), new String[]{"+", "*"});
        if (foundEntry != null) {
            return foundEntry;
        }
        throw new LdapNoSuchObjectException(I18n.err((I18n)I18n.ERR_256_NO_SUCH_OBJECT, (Object[])new Object[]{opContext.getDn()}));
    }

    private LdapReferralException buildReferralException(Entry parentEntry, Dn childDn) throws LdapException {
        Attribute refs = parentEntry.get("ref");
        ArrayList<String> urls = new ArrayList<String>();
        try {
            for (Value url : refs) {
                LdapUrl ldapUrl = new LdapUrl(url.getString());
                Dn urlDn = ldapUrl.getDn().add(childDn);
                ldapUrl.setDn(urlDn);
                urls.add(ldapUrl.toString());
            }
        }
        catch (LdapURLEncodingException luee) {
            throw new LdapOperationErrorException(luee.getMessage(), (Throwable)luee);
        }
        LdapReferralException lre = new LdapReferralException(urls);
        lre.setRemainingDn(childDn);
        lre.setResolvedDn(parentEntry.getDn());
        lre.setResolvedObject((Object)parentEntry);
        return lre;
    }

    private LdapReferralException buildReferralExceptionForSearch(Entry parentEntry, Dn childDn, SearchScope scope) throws LdapException {
        Attribute refs = parentEntry.get("ref");
        ArrayList<String> urls = new ArrayList<String>();
        for (Value url : refs) {
            try {
                LdapUrl ldapUrl = new LdapUrl(url.getString());
                StringBuilder urlString = new StringBuilder();
                if (ldapUrl.getDn() == null || ldapUrl.getDn() == Dn.ROOT_DSE) {
                    ldapUrl.setDn(parentEntry.getDn());
                } else {
                    Dn urlDn = ldapUrl.getDn().add(childDn);
                    ldapUrl.setDn(urlDn);
                }
                urlString.append(ldapUrl.toString()).append("??");
                switch (scope) {
                    case OBJECT: {
                        urlString.append("base");
                        break;
                    }
                    case SUBTREE: {
                        urlString.append("sub");
                        break;
                    }
                    case ONELEVEL: {
                        urlString.append("one");
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected scope " + scope);
                    }
                }
                urls.add(urlString.toString());
            }
            catch (LdapURLEncodingException luee) {
                urls.add(url.getString());
            }
        }
        LdapReferralException lre = new LdapReferralException(urls);
        lre.setRemainingDn(childDn);
        lre.setResolvedDn(parentEntry.getDn());
        lre.setResolvedObject((Object)parentEntry);
        return lre;
    }

    private LdapPartialResultException buildLdapPartialResultException(Dn childDn) {
        LdapPartialResultException lpre = new LdapPartialResultException(I18n.err((I18n)I18n.ERR_315, (Object[])new Object[0]));
        lpre.setRemainingDn(childDn);
        lpre.setResolvedDn(Dn.EMPTY_DN);
        return lpre;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(AddOperationContext addContext) throws LdapException {
        if (IS_DEBUG) {
            OPERATION_LOG.debug(">> AddOperation : {}", (Object)addContext);
        }
        long addStart = 0L;
        if (IS_TIME) {
            addStart = System.nanoTime();
        }
        this.ensureStarted();
        Dn dn = addContext.getDn();
        if (!dn.isSchemaAware()) {
            dn = new Dn(this.directoryService.getSchemaManager(), dn);
            addContext.setDn(dn);
        }
        Partition partition = this.directoryService.getPartitionNexus().getPartition(dn);
        addContext.setPartition(partition);
        this.directoryService.getReferralManager().lockRead();
        try {
            if (this.directoryService.getReferralManager().hasParentReferral(dn)) {
                Entry parentEntry = this.directoryService.getReferralManager().getParentReferral(dn);
                Dn childDn = dn.getDescendantOf(parentEntry.getDn());
                if (addContext.isReferralIgnored()) {
                    throw this.buildLdapPartialResultException(childDn);
                }
                throw this.buildReferralException(parentEntry, childDn);
            }
        }
        finally {
            this.directoryService.getReferralManager().unlock();
        }
        Interceptor head = this.directoryService.getInterceptor(addContext.getNextInterceptor());
        this.lockWrite();
        PartitionTxn transaction = addContext.getSession().getTransaction(partition);
        try {
            if (transaction == null) {
                transaction = partition.beginWriteTransaction();
                if (addContext.getSession().hasSessionTransaction()) {
                    addContext.getSession().addTransaction(partition, transaction);
                }
            }
            addContext.setTransaction(transaction);
            head.add(addContext);
            if (!addContext.getSession().hasSessionTransaction()) {
                transaction.commit();
            }
        }
        catch (LdapException le) {
            try {
                if (transaction != null) {
                    transaction.abort();
                }
                throw le;
            }
            catch (IOException ioe) {
                throw new LdapOtherException(ioe.getMessage(), (Throwable)ioe);
            }
        }
        catch (IOException ioe) {
            try {
                transaction.abort();
                throw new LdapOtherException(ioe.getMessage(), (Throwable)ioe);
            }
            catch (IOException ioe2) {
                throw new LdapOtherException(ioe2.getMessage(), (Throwable)ioe2);
            }
        }
        finally {
            this.unlockWrite();
        }
        if (IS_DEBUG) {
            OPERATION_LOG.debug("<< AddOperation successful");
        }
        if (IS_TIME) {
            OPERATION_TIME.debug("Add operation took {} ns", (Object)(System.nanoTime() - addStart));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(BindOperationContext bindContext) throws LdapException {
        if (IS_DEBUG) {
            OPERATION_LOG.debug(">> BindOperation : {}", (Object)bindContext);
        }
        long opStart = 0L;
        if (IS_TIME) {
            opStart = System.nanoTime();
        }
        this.ensureStarted();
        Interceptor head = this.directoryService.getInterceptor(bindContext.getNextInterceptor());
        Dn dn = bindContext.getDn();
        if (dn != null && !dn.isSchemaAware()) {
            dn = new Dn(this.directoryService.getSchemaManager(), dn);
            bindContext.setDn(dn);
        }
        this.lockRead();
        try {
            Partition partition = this.directoryService.getPartitionNexus().getPartition(dn);
            try (PartitionReadTxn partitionTxn = partition.beginReadTransaction();){
                bindContext.setPartition(partition);
                bindContext.setTransaction((PartitionTxn)partitionTxn);
                head.bind(bindContext);
            }
            catch (IOException ioe) {
                throw new LdapOtherException(ioe.getMessage(), (Throwable)ioe);
            }
        }
        finally {
            this.unlockRead();
        }
        if (IS_DEBUG) {
            OPERATION_LOG.debug("<< BindOperation successful");
        }
        if (IS_TIME) {
            OPERATION_TIME.debug("Bind operation took {} ns", (Object)(System.nanoTime() - opStart));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compare(CompareOperationContext compareContext) throws LdapException {
        if (IS_DEBUG) {
            OPERATION_LOG.debug(">> CompareOperation : {}", (Object)compareContext);
        }
        long opStart = 0L;
        if (IS_TIME) {
            opStart = System.nanoTime();
        }
        this.ensureStarted();
        Dn dn = compareContext.getDn();
        if (!dn.isSchemaAware()) {
            dn = new Dn(this.directoryService.getSchemaManager(), dn);
            compareContext.setDn(dn);
        }
        this.directoryService.getReferralManager().lockRead();
        try {
            Entry parentEntry = this.directoryService.getReferralManager().getParentReferral(dn);
            if (parentEntry != null) {
                Dn childDn = dn.getDescendantOf(parentEntry.getDn());
                if (this.directoryService.getReferralManager().isReferral(dn)) {
                    if (!compareContext.isReferralIgnored()) {
                        throw this.buildReferralException(parentEntry, childDn);
                    }
                } else if (this.directoryService.getReferralManager().hasParentReferral(dn)) {
                    if (compareContext.isReferralIgnored()) {
                        throw this.buildLdapPartialResultException(childDn);
                    }
                    throw this.buildReferralException(parentEntry, childDn);
                }
            }
        }
        finally {
            this.directoryService.getReferralManager().unlock();
        }
        compareContext.setOriginalEntry(this.getOriginalEntry((OperationContext)compareContext));
        Interceptor head = this.directoryService.getInterceptor(compareContext.getNextInterceptor());
        boolean result = false;
        this.lockRead();
        try {
            Partition partition = this.directoryService.getPartitionNexus().getPartition(dn);
            try (PartitionReadTxn partitionTxn = partition.beginReadTransaction();){
                compareContext.setPartition(partition);
                compareContext.setTransaction((PartitionTxn)partitionTxn);
                result = head.compare(compareContext);
            }
            catch (IOException ioe) {
                throw new LdapOtherException(ioe.getMessage(), (Throwable)ioe);
            }
        }
        finally {
            this.unlockRead();
        }
        if (IS_DEBUG) {
            OPERATION_LOG.debug("<< CompareOperation successful");
        }
        if (IS_TIME) {
            OPERATION_TIME.debug("Compare operation took {} ns", (Object)(System.nanoTime() - opStart));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(DeleteOperationContext deleteContext) throws LdapException {
        if (IS_DEBUG) {
            OPERATION_LOG.debug(">> DeleteOperation : {}", (Object)deleteContext);
        }
        long opStart = 0L;
        if (IS_TIME) {
            opStart = System.nanoTime();
        }
        this.ensureStarted();
        Dn dn = deleteContext.getDn();
        Partition partition = this.directoryService.getPartitionNexus().getPartition(dn);
        deleteContext.setPartition(partition);
        if (!dn.isSchemaAware()) {
            dn = new Dn(this.directoryService.getSchemaManager(), dn);
            deleteContext.setDn(dn);
        }
        this.directoryService.getReferralManager().lockRead();
        try {
            Entry parentEntry = this.directoryService.getReferralManager().getParentReferral(dn);
            if (parentEntry != null) {
                Dn childDn = dn.getDescendantOf(parentEntry.getDn());
                if (this.directoryService.getReferralManager().isReferral(dn)) {
                    if (!deleteContext.isReferralIgnored()) {
                        throw this.buildReferralException(parentEntry, childDn);
                    }
                } else if (this.directoryService.getReferralManager().hasParentReferral(dn)) {
                    if (deleteContext.isReferralIgnored()) {
                        throw this.buildLdapPartialResultException(childDn);
                    }
                    throw this.buildReferralException(parentEntry, childDn);
                }
            }
        }
        finally {
            this.directoryService.getReferralManager().unlock();
        }
        this.lockWrite();
        PartitionTxn transaction = deleteContext.getSession().getTransaction(partition);
        try {
            if (transaction == null) {
                transaction = partition.beginWriteTransaction();
                if (deleteContext.getSession().hasSessionTransaction()) {
                    deleteContext.getSession().addTransaction(partition, transaction);
                }
            }
            deleteContext.setTransaction(transaction);
            this.eagerlyPopulateFields((OperationContext)deleteContext);
            Interceptor head = this.directoryService.getInterceptor(deleteContext.getNextInterceptor());
            head.delete(deleteContext);
            if (!deleteContext.getSession().hasSessionTransaction()) {
                transaction.commit();
            }
        }
        catch (LdapException le) {
            try {
                if (transaction != null) {
                    transaction.abort();
                }
                throw le;
            }
            catch (IOException ioe) {
                throw new LdapOtherException(ioe.getMessage(), (Throwable)ioe);
            }
        }
        catch (IOException ioe) {
            try {
                transaction.abort();
                throw new LdapOtherException(ioe.getMessage(), (Throwable)ioe);
            }
            catch (IOException ioe2) {
                throw new LdapOtherException(ioe2.getMessage(), (Throwable)ioe2);
            }
        }
        finally {
            this.unlockWrite();
        }
        if (IS_DEBUG) {
            OPERATION_LOG.debug("<< DeleteOperation successful");
        }
        if (IS_TIME) {
            OPERATION_TIME.debug("Delete operation took {} ns", (Object)(System.nanoTime() - opStart));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry getRootDse(GetRootDseOperationContext getRootDseContext) throws LdapException {
        Entry root;
        if (IS_DEBUG) {
            OPERATION_LOG.debug(">> GetRootDseOperation : {}", (Object)getRootDseContext);
        }
        long opStart = 0L;
        if (IS_TIME) {
            opStart = System.nanoTime();
        }
        this.ensureStarted();
        Interceptor head = this.directoryService.getInterceptor(getRootDseContext.getNextInterceptor());
        try {
            this.lockRead();
            Partition partition = this.directoryService.getPartitionNexus().getPartition(Dn.ROOT_DSE);
            try (PartitionReadTxn partitionTxn = partition.beginReadTransaction();){
                getRootDseContext.setPartition(partition);
                getRootDseContext.setTransaction((PartitionTxn)partitionTxn);
                root = head.getRootDse(getRootDseContext);
            }
            catch (IOException ioe) {
                throw new LdapOtherException(ioe.getMessage(), (Throwable)ioe);
            }
        }
        finally {
            this.unlockRead();
        }
        if (IS_DEBUG) {
            OPERATION_LOG.debug("<< getRootDseOperation successful");
        }
        if (IS_TIME) {
            OPERATION_TIME.debug("GetRootDSE operation took {} ns", (Object)(System.nanoTime() - opStart));
        }
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasEntry(HasEntryOperationContext hasEntryContext) throws LdapException {
        if (IS_DEBUG) {
            OPERATION_LOG.debug(">> hasEntryOperation : {}", (Object)hasEntryContext);
        }
        long opStart = 0L;
        if (IS_TIME) {
            opStart = System.nanoTime();
        }
        this.ensureStarted();
        Interceptor head = this.directoryService.getInterceptor(hasEntryContext.getNextInterceptor());
        boolean result = false;
        this.lockRead();
        Dn dn = hasEntryContext.getDn();
        if (!dn.isSchemaAware()) {
            dn = new Dn(this.directoryService.getSchemaManager(), dn);
            hasEntryContext.setDn(dn);
        }
        try {
            Partition partition = this.directoryService.getPartitionNexus().getPartition(dn);
            try (PartitionReadTxn partitionTxn = partition.beginReadTransaction();){
                hasEntryContext.setPartition(partition);
                hasEntryContext.setTransaction((PartitionTxn)partitionTxn);
                result = head.hasEntry(hasEntryContext);
            }
            catch (IOException ioe) {
                throw new LdapOtherException(ioe.getMessage(), (Throwable)ioe);
            }
        }
        finally {
            this.unlockRead();
        }
        if (IS_DEBUG) {
            OPERATION_LOG.debug("<< HasEntryOperation successful");
        }
        if (IS_TIME) {
            OPERATION_TIME.debug("HasEntry operation took {} ns", (Object)(System.nanoTime() - opStart));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry lookup(LookupOperationContext lookupContext) throws LdapException {
        if (IS_DEBUG) {
            OPERATION_LOG.debug(">> LookupOperation : {}", (Object)lookupContext);
        }
        long opStart = 0L;
        if (IS_TIME) {
            opStart = System.nanoTime();
        }
        this.ensureStarted();
        Interceptor head = this.directoryService.getInterceptor(lookupContext.getNextInterceptor());
        Entry entry = null;
        Dn dn = lookupContext.getDn();
        if (!dn.isSchemaAware()) {
            dn = new Dn(this.directoryService.getSchemaManager(), dn);
            lookupContext.setDn(dn);
        }
        Partition partition = this.directoryService.getPartitionNexus().getPartition(dn);
        lookupContext.setPartition(partition);
        try (PartitionReadTxn transaction = partition.beginReadTransaction();){
            lookupContext.setTransaction((PartitionTxn)transaction);
            this.lockRead();
            try {
                entry = head.lookup(lookupContext);
            }
            finally {
                this.unlockRead();
            }
        }
        catch (IOException ioe) {
            throw new LdapOtherException(ioe.getMessage(), (Throwable)ioe);
        }
        if (IS_DEBUG) {
            OPERATION_LOG.debug("<< LookupOperation successful");
        }
        if (IS_TIME) {
            OPERATION_TIME.debug("Lookup operation took {} ns", (Object)(System.nanoTime() - opStart));
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        if (IS_DEBUG) {
            OPERATION_LOG.debug(">> ModifyOperation : {}", (Object)modifyContext);
        }
        long opStart = 0L;
        if (IS_TIME) {
            opStart = System.nanoTime();
        }
        this.ensureStarted();
        Dn dn = modifyContext.getDn();
        if (!dn.isSchemaAware()) {
            dn = new Dn(this.directoryService.getSchemaManager(), dn);
            modifyContext.setDn(dn);
        }
        ReferralManager referralManager = this.directoryService.getReferralManager();
        referralManager.lockRead();
        try {
            Entry parentEntry = referralManager.getParentReferral(dn);
            if (parentEntry != null) {
                if (referralManager.isReferral(dn)) {
                    if (!modifyContext.isReferralIgnored()) {
                        Dn childDn = dn.getDescendantOf(parentEntry.getDn());
                        throw this.buildReferralException(parentEntry, childDn);
                    }
                } else if (referralManager.hasParentReferral(dn)) {
                    if (modifyContext.isReferralIgnored()) {
                        Dn childDn = dn.getDescendantOf(parentEntry.getDn());
                        throw this.buildLdapPartialResultException(childDn);
                    }
                    Dn childDn = dn.getDescendantOf(parentEntry.getDn());
                    throw this.buildReferralException(parentEntry, childDn);
                }
            }
        }
        finally {
            referralManager.unlock();
        }
        Partition partition = this.directoryService.getPartitionNexus().getPartition(dn);
        modifyContext.setPartition(partition);
        this.lockWrite();
        PartitionTxn transaction = modifyContext.getSession().getTransaction(partition);
        try {
            if (transaction == null) {
                transaction = partition.beginWriteTransaction();
                if (modifyContext.getSession().hasSessionTransaction()) {
                    modifyContext.getSession().addTransaction(partition, transaction);
                }
            }
            modifyContext.setTransaction(transaction);
            this.eagerlyPopulateFields((OperationContext)modifyContext);
            Interceptor head = this.directoryService.getInterceptor(modifyContext.getNextInterceptor());
            head.modify(modifyContext);
            if (!modifyContext.getSession().hasSessionTransaction()) {
                transaction.commit();
            }
        }
        catch (LdapException le) {
            try {
                if (transaction != null) {
                    transaction.abort();
                }
                throw le;
            }
            catch (IOException ioe) {
                throw new LdapOtherException(ioe.getMessage(), (Throwable)ioe);
            }
        }
        catch (IOException ioe) {
            try {
                transaction.abort();
                throw new LdapOtherException(ioe.getMessage(), (Throwable)ioe);
            }
            catch (IOException ioe2) {
                throw new LdapOtherException(ioe2.getMessage(), (Throwable)ioe2);
            }
        }
        finally {
            this.unlockWrite();
        }
        if (IS_DEBUG) {
            OPERATION_LOG.debug("<< ModifyOperation successful");
        }
        if (IS_TIME) {
            OPERATION_TIME.debug("Modify operation took {} ns", (Object)(System.nanoTime() - opStart));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(MoveOperationContext moveContext) throws LdapException {
        Dn newSuperiorDn;
        if (IS_DEBUG) {
            OPERATION_LOG.debug(">> MoveOperation : {}", (Object)moveContext);
        }
        long opStart = 0L;
        if (IS_TIME) {
            opStart = System.nanoTime();
        }
        this.ensureStarted();
        Dn dn = moveContext.getDn();
        if (!dn.isSchemaAware()) {
            dn = new Dn(this.directoryService.getSchemaManager(), dn);
            moveContext.setDn(dn);
        }
        if (!(newSuperiorDn = moveContext.getNewSuperior()).isSchemaAware()) {
            newSuperiorDn = new Dn(this.directoryService.getSchemaManager(), newSuperiorDn);
            moveContext.setNewSuperior(newSuperiorDn);
        }
        this.directoryService.getReferralManager().lockRead();
        try {
            Entry parentEntry = this.directoryService.getReferralManager().getParentReferral(dn);
            if (parentEntry != null) {
                Dn childDn = dn.getDescendantOf(parentEntry.getDn());
                if (this.directoryService.getReferralManager().isReferral(dn)) {
                    if (!moveContext.isReferralIgnored()) {
                        throw this.buildReferralException(parentEntry, childDn);
                    }
                } else if (this.directoryService.getReferralManager().hasParentReferral(dn)) {
                    if (moveContext.isReferralIgnored()) {
                        throw this.buildLdapPartialResultException(childDn);
                    }
                    throw this.buildReferralException(parentEntry, childDn);
                }
            }
            if (this.directoryService.getReferralManager().isReferral(newSuperiorDn) || this.directoryService.getReferralManager().hasParentReferral(newSuperiorDn)) {
                throw new LdapAffectMultipleDsaException();
            }
        }
        finally {
            this.directoryService.getReferralManager().unlock();
        }
        this.lockWrite();
        Partition partition = this.directoryService.getPartitionNexus().getPartition(dn);
        moveContext.setPartition(partition);
        PartitionTxn transaction = moveContext.getSession().getTransaction(partition);
        try {
            if (transaction == null) {
                transaction = partition.beginWriteTransaction();
                if (moveContext.getSession().hasSessionTransaction()) {
                    moveContext.getSession().addTransaction(partition, transaction);
                }
            }
            moveContext.setTransaction(transaction);
            Entry originalEntry = this.getOriginalEntry((OperationContext)moveContext);
            moveContext.setOriginalEntry(originalEntry);
            Interceptor head = this.directoryService.getInterceptor(moveContext.getNextInterceptor());
            head.move(moveContext);
            if (!moveContext.getSession().hasSessionTransaction()) {
                transaction.commit();
            }
        }
        catch (LdapException le) {
            try {
                if (transaction != null) {
                    transaction.abort();
                }
                throw le;
            }
            catch (IOException ioe) {
                throw new LdapOtherException(ioe.getMessage(), (Throwable)ioe);
            }
        }
        catch (IOException ioe) {
            try {
                if (transaction != null) {
                    transaction.abort();
                }
                throw new LdapOtherException(ioe.getMessage(), (Throwable)ioe);
            }
            catch (IOException ioe2) {
                throw new LdapOtherException(ioe2.getMessage(), (Throwable)ioe2);
            }
        }
        finally {
            this.unlockWrite();
        }
        if (IS_DEBUG) {
            OPERATION_LOG.debug("<< MoveOperation successful");
        }
        if (IS_TIME) {
            OPERATION_TIME.debug("Move operation took {} ns", (Object)(System.nanoTime() - opStart));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveAndRename(MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        if (IS_DEBUG) {
            OPERATION_LOG.debug(">> MoveAndRenameOperation : {}", (Object)moveAndRenameContext);
        }
        long opStart = 0L;
        if (IS_TIME) {
            opStart = System.nanoTime();
        }
        this.ensureStarted();
        Dn dn = moveAndRenameContext.getDn();
        if (!dn.isSchemaAware()) {
            dn = new Dn(this.directoryService.getSchemaManager(), dn);
            moveAndRenameContext.setDn(dn);
        }
        this.directoryService.getReferralManager().lockRead();
        try {
            Dn newSuperiorDn;
            Entry parentEntry = this.directoryService.getReferralManager().getParentReferral(dn);
            if (parentEntry != null) {
                Dn childDn = dn.getDescendantOf(parentEntry.getDn());
                if (this.directoryService.getReferralManager().isReferral(dn)) {
                    if (!moveAndRenameContext.isReferralIgnored()) {
                        throw this.buildReferralException(parentEntry, childDn);
                    }
                } else if (this.directoryService.getReferralManager().hasParentReferral(dn)) {
                    if (moveAndRenameContext.isReferralIgnored()) {
                        throw this.buildLdapPartialResultException(childDn);
                    }
                    throw this.buildReferralException(parentEntry, childDn);
                }
            }
            if (!(newSuperiorDn = moveAndRenameContext.getNewSuperiorDn()).isSchemaAware()) {
                newSuperiorDn = new Dn(this.directoryService.getSchemaManager(), newSuperiorDn);
                moveAndRenameContext.setNewSuperiorDn(newSuperiorDn);
            }
            if (this.directoryService.getReferralManager().isReferral(newSuperiorDn) || this.directoryService.getReferralManager().hasParentReferral(newSuperiorDn)) {
                throw new LdapAffectMultipleDsaException();
            }
        }
        finally {
            this.directoryService.getReferralManager().unlock();
        }
        Partition partition = this.directoryService.getPartitionNexus().getPartition(dn);
        moveAndRenameContext.setPartition(partition);
        this.lockWrite();
        PartitionTxn transaction = moveAndRenameContext.getSession().getTransaction(partition);
        try {
            if (transaction == null) {
                transaction = partition.beginWriteTransaction();
                if (moveAndRenameContext.getSession().hasSessionTransaction()) {
                    moveAndRenameContext.getSession().addTransaction(partition, transaction);
                }
            }
            moveAndRenameContext.setOriginalEntry(this.getOriginalEntry((OperationContext)moveAndRenameContext));
            moveAndRenameContext.setModifiedEntry(moveAndRenameContext.getOriginalEntry().clone());
            moveAndRenameContext.setTransaction(transaction);
            Interceptor head = this.directoryService.getInterceptor(moveAndRenameContext.getNextInterceptor());
            head.moveAndRename(moveAndRenameContext);
            if (!moveAndRenameContext.getSession().hasSessionTransaction()) {
                transaction.commit();
            }
        }
        catch (LdapException le) {
            try {
                if (transaction != null) {
                    transaction.abort();
                }
                throw le;
            }
            catch (IOException ioe) {
                throw new LdapOtherException(ioe.getMessage(), (Throwable)ioe);
            }
        }
        catch (IOException ioe) {
            try {
                transaction.abort();
                throw new LdapOtherException(ioe.getMessage(), (Throwable)ioe);
            }
            catch (IOException ioe2) {
                throw new LdapOtherException(ioe2.getMessage(), (Throwable)ioe2);
            }
        }
        finally {
            this.unlockWrite();
        }
        if (IS_DEBUG) {
            OPERATION_LOG.debug("<< MoveAndRenameOperation successful");
        }
        if (IS_TIME) {
            OPERATION_TIME.debug("MoveAndRename operation took {} ns", (Object)(System.nanoTime() - opStart));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(RenameOperationContext renameContext) throws LdapException {
        if (IS_DEBUG) {
            OPERATION_LOG.debug(">> RenameOperation : {}", (Object)renameContext);
        }
        long opStart = 0L;
        if (IS_TIME) {
            opStart = System.nanoTime();
        }
        this.ensureStarted();
        Dn dn = renameContext.getDn();
        if (!dn.isSchemaAware()) {
            dn = new Dn(this.directoryService.getSchemaManager(), dn);
            renameContext.setDn(dn);
        }
        if (!dn.isEmpty()) {
            Dn newDn = dn.getParent();
            Rdn newRdn = renameContext.getNewRdn();
            if (!newRdn.isSchemaAware()) {
                newRdn = new Rdn(this.directoryService.getSchemaManager(), newRdn);
                renameContext.setNewRdn(newRdn);
            }
            newDn = newDn.add(renameContext.getNewRdn());
            renameContext.setNewDn(newDn);
        }
        this.directoryService.getReferralManager().lockRead();
        try {
            Entry parentEntry = this.directoryService.getReferralManager().getParentReferral(dn);
            if (parentEntry != null) {
                Dn childDn = dn.getDescendantOf(parentEntry.getDn());
                if (this.directoryService.getReferralManager().isReferral(dn)) {
                    if (!renameContext.isReferralIgnored()) {
                        throw this.buildReferralException(parentEntry, childDn);
                    }
                } else if (this.directoryService.getReferralManager().hasParentReferral(dn)) {
                    if (renameContext.isReferralIgnored()) {
                        throw this.buildLdapPartialResultException(childDn);
                    }
                    throw this.buildReferralException(parentEntry, childDn);
                }
            }
        }
        finally {
            this.directoryService.getReferralManager().unlock();
        }
        this.lockWrite();
        Partition partition = this.directoryService.getPartitionNexus().getPartition(dn);
        PartitionTxn transaction = renameContext.getSession().getTransaction(partition);
        try {
            if (transaction == null) {
                transaction = partition.beginWriteTransaction();
                if (renameContext.getSession().hasSessionTransaction()) {
                    renameContext.getSession().addTransaction(partition, transaction);
                }
            }
            renameContext.setPartition(partition);
            PartitionReadTxn partitionTxn = null;
            try {
                partitionTxn = partition.beginReadTransaction();
                renameContext.setTransaction((PartitionTxn)partitionTxn);
                this.eagerlyPopulateFields((OperationContext)renameContext);
            }
            finally {
                try {
                    if (partitionTxn != null) {
                        partitionTxn.close();
                    }
                }
                catch (IOException ioe) {
                    throw new LdapOtherException(ioe.getMessage(), (Throwable)ioe);
                }
            }
            Entry originalEntry = this.getOriginalEntry((OperationContext)renameContext);
            renameContext.setOriginalEntry(originalEntry);
            renameContext.setModifiedEntry(originalEntry.clone());
            Interceptor head = this.directoryService.getInterceptor(renameContext.getNextInterceptor());
            transaction = renameContext.getSession().getTransaction(partition);
            try {
                if (transaction == null) {
                    transaction = partition.beginWriteTransaction();
                    if (renameContext.getSession().hasSessionTransaction()) {
                        renameContext.getSession().addTransaction(partition, transaction);
                    }
                }
                renameContext.setTransaction(transaction);
                head.rename(renameContext);
                if (!renameContext.getSession().hasSessionTransaction()) {
                    transaction.commit();
                }
            }
            catch (LdapException le) {
                try {
                    if (transaction != null) {
                        transaction.abort();
                    }
                    throw le;
                }
                catch (IOException ioe) {
                    throw new LdapOtherException(ioe.getMessage(), (Throwable)ioe);
                }
            }
            catch (IOException ioe) {
                try {
                    if (transaction != null) {
                        transaction.abort();
                    }
                    throw new LdapOtherException(ioe.getMessage(), (Throwable)ioe);
                }
                catch (IOException ioe2) {
                    throw new LdapOtherException(ioe2.getMessage(), (Throwable)ioe2);
                }
            }
        }
        finally {
            this.unlockWrite();
        }
        if (IS_DEBUG) {
            OPERATION_LOG.debug("<< RenameOperation successful");
        }
        if (IS_TIME) {
            OPERATION_TIME.debug("Rename operation took {} ns", (Object)(System.nanoTime() - opStart));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryFilteringCursor search(SearchOperationContext searchContext) throws LdapException {
        if (IS_DEBUG) {
            OPERATION_LOG.debug(">> SearchOperation : {}", (Object)searchContext);
        }
        long opStart = 0L;
        if (IS_TIME) {
            opStart = System.nanoTime();
        }
        this.ensureStarted();
        Dn dn = searchContext.getDn();
        if (!dn.isSchemaAware()) {
            dn = new Dn(this.directoryService.getSchemaManager(), dn);
            searchContext.setDn(dn);
        }
        this.directoryService.getReferralManager().lockRead();
        try {
            Entry parentEntry = this.directoryService.getReferralManager().getParentReferral(dn);
            if (parentEntry != null) {
                Dn childDn = dn.getDescendantOf(parentEntry.getDn());
                if (this.directoryService.getReferralManager().isReferral(dn)) {
                    if (!searchContext.isReferralIgnored()) {
                        throw this.buildReferralExceptionForSearch(parentEntry, childDn, searchContext.getScope());
                    }
                } else if (this.directoryService.getReferralManager().hasParentReferral(dn)) {
                    if (searchContext.isReferralIgnored()) {
                        throw this.buildLdapPartialResultException(childDn);
                    }
                    throw this.buildReferralExceptionForSearch(parentEntry, childDn, searchContext.getScope());
                }
            }
        }
        finally {
            this.directoryService.getReferralManager().unlock();
        }
        Interceptor head = this.directoryService.getInterceptor(searchContext.getNextInterceptor());
        EntryFilteringCursor cursor = null;
        Partition partition = this.directoryService.getPartitionNexus().getPartition(dn);
        try (PartitionReadTxn partitionTxn = partition.beginReadTransaction();){
            searchContext.setPartition(partition);
            searchContext.setTransaction((PartitionTxn)partitionTxn);
            this.lockRead();
            try {
                cursor = head.search(searchContext);
            }
            finally {
                this.unlockRead();
            }
        }
        catch (IOException ioe) {
            throw new LdapOtherException(ioe.getMessage(), (Throwable)ioe);
        }
        if (IS_DEBUG) {
            OPERATION_LOG.debug("<< SearchOperation successful");
        }
        if (IS_TIME) {
            OPERATION_TIME.debug("Search operation took {} ns", (Object)(System.nanoTime() - opStart));
        }
        return cursor;
    }

    public void unbind(UnbindOperationContext unbindContext) throws LdapException {
        if (IS_DEBUG) {
            OPERATION_LOG.debug(">> UnbindOperation : {}", (Object)unbindContext);
        }
        long opStart = 0L;
        if (IS_TIME) {
            opStart = System.nanoTime();
        }
        this.ensureStarted();
        Interceptor head = this.directoryService.getInterceptor(unbindContext.getNextInterceptor());
        head.unbind(unbindContext);
        if (IS_DEBUG) {
            OPERATION_LOG.debug("<< UnbindOperation successful");
        }
        if (IS_TIME) {
            OPERATION_TIME.debug("Unbind operation took {} ns", (Object)(System.nanoTime() - opStart));
        }
    }

    private void ensureStarted() throws LdapServiceUnavailableException {
        if (!this.directoryService.isStarted()) {
            throw new LdapServiceUnavailableException(ResultCodeEnum.UNAVAILABLE, I18n.err((I18n)I18n.ERR_316, (Object[])new Object[0]));
        }
    }
}

