/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.request;

import java.util.Map;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapAuthenticationException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.exception.LdapUnwillingToPerformException;
import org.apache.directory.api.ldap.model.message.BindRequest;
import org.apache.directory.api.ldap.model.message.BindResponse;
import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.Request;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.LdapPrincipal;
import org.apache.directory.server.core.api.OperationEnum;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.api.interceptor.context.OperationContext;
import org.apache.directory.server.core.shared.DefaultCoreSession;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.ldap.LdapProtocolUtils;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.LdapRequestHandler;
import org.apache.directory.server.ldap.handlers.sasl.MechanismHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindRequestHandler
extends LdapRequestHandler<BindRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(BindRequestHandler.class);
    private Map<String, MechanismHandler> handlers;

    public void setSaslMechanismHandlers(Map<String, MechanismHandler> handlers) {
        this.handlers = handlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSimpleAuth(LdapSession ldapSession, BindRequest bindRequest) throws Exception {
        DirectoryService directoryService = this.ldapServer.getDirectoryService();
        BindResponse bindResponse = (BindResponse)bindRequest.getResultResponse();
        if (ldapSession.isAuthenticated()) {
            ldapSession.getCoreSession().unbind();
        }
        ldapSession.setSimpleAuthPending();
        BindOperationContext bindContext = new BindOperationContext(null);
        Dn bindDn = bindRequest.getDn();
        if (bindDn == null) {
            String name = bindRequest.getName();
            try {
                bindDn = new Dn(directoryService.getSchemaManager(), new String[]{name});
                bindRequest.setDn(bindDn);
            }
            catch (LdapInvalidDnException e) {
                LOG.debug("Unable to convert the name to a DN.");
            }
        }
        bindContext.setDn(bindRequest.getDn());
        bindContext.setCredentials(bindRequest.getCredentials());
        bindContext.setIoSession(ldapSession.getIoSession());
        bindContext.setInterceptors(directoryService.getInterceptors(OperationEnum.BIND));
        LdapProtocolUtils.setRequestControls((OperationContext)bindContext, (Request)bindRequest);
        try {
            Entry principalEntry = null;
            try {
                principalEntry = directoryService.getAdminSession().lookup(bindRequest.getDn(), new String[]{"*", "+"});
            }
            catch (Exception e) {
                // empty catch block
            }
            if (principalEntry == null) {
                LOG.info("The {} principalDN cannot be found in the server : bind failure.", (Object)bindRequest.getName());
            } else {
                if (((ClonedServerEntry)principalEntry).getOriginalEntry().contains("objectClass", new String[]{"referral"})) {
                    LOG.info("Bind principalDn points to referral.");
                    LdapResult result = bindResponse.getLdapResult();
                    result.setDiagnosticMessage("Bind principalDn points to referral.");
                    result.setResultCode(ResultCodeEnum.INVALID_CREDENTIALS);
                    ldapSession.setAnonymous();
                    ldapSession.getIoSession().write((Object)bindResponse);
                    return;
                }
                bindContext.setPrincipal(principalEntry);
            }
            bindContext.setInterceptors(directoryService.getInterceptors(OperationEnum.BIND));
            directoryService.getOperationManager().bind(bindContext);
            CoreSession coreSession = bindContext.getSession();
            ldapSession.setCoreSession(coreSession);
            ((DefaultCoreSession)coreSession).setIoSession(bindContext.getIoSession());
            if (!ldapSession.getCoreSession().isAnonymous()) {
                ldapSession.setAuthenticated();
            } else {
                ldapSession.setAnonymous();
            }
            bindResponse.addAllControls(bindContext.getResponseControls());
            this.sendBindSuccess(ldapSession, bindResponse, null);
        }
        catch (Exception e) {
            ResultCodeEnum code = null;
            LdapResult result = bindResponse.getLdapResult();
            if (e instanceof LdapUnwillingToPerformException) {
                code = ResultCodeEnum.UNWILLING_TO_PERFORM;
                result.setResultCode(code);
            } else if (e instanceof LdapInvalidDnException) {
                code = ResultCodeEnum.INVALID_DN_SYNTAX;
                result.setResultCode(code);
            } else {
                code = ResultCodeEnum.INVALID_CREDENTIALS;
                result.setResultCode(code);
            }
            String msg = code.toString() + ": Bind failed: " + e.getLocalizedMessage();
            if (LOG.isDebugEnabled()) {
                msg = msg + ":\n" + ExceptionUtils.getStackTrace((Throwable)e);
                msg = msg + "\n\nBindRequest = \n" + bindRequest.toString();
            }
            Dn dn = null;
            if (e instanceof LdapAuthenticationException) {
                dn = ((LdapAuthenticationException)e).getResolvedDn();
            }
            if (dn != null && (code == ResultCodeEnum.NO_SUCH_OBJECT || code == ResultCodeEnum.ALIAS_PROBLEM || code == ResultCodeEnum.INVALID_DN_SYNTAX || code == ResultCodeEnum.ALIAS_DEREFERENCING_PROBLEM)) {
                result.setMatchedDn(dn);
            }
            result.setDiagnosticMessage(msg);
            bindResponse.addAllControls(bindContext.getResponseControls());
            ldapSession.setAnonymous();
            ldapSession.getIoSession().write((Object)bindResponse);
        }
        finally {
            if (!ldapSession.isAuthenticated()) {
                ldapSession.setAnonymous();
            }
        }
    }

    private boolean checkMechanism(String saslMechanism) {
        if (!this.ldapServer.getSupportedMechanisms().contains(saslMechanism)) {
            LOG.error(I18n.err((I18n)I18n.ERR_160, (Object[])new Object[]{saslMechanism}));
            return false;
        }
        return true;
    }

    private void generateSaslChallengeOrComplete(LdapSession ldapSession, SaslServer ss, BindRequest bindRequest) throws Exception {
        BindResponse bindResponse = (BindResponse)bindRequest.getResultResponse();
        LdapResult result = bindResponse.getLdapResult();
        if (bindRequest.getCredentials() == null) {
            bindRequest.setCredentials(Strings.EMPTY_BYTES);
        }
        try {
            byte[] tokenBytes = ss.evaluateResponse(bindRequest.getCredentials());
            if (ss.isComplete()) {
                LdapPrincipal ldapPrincipal;
                if (tokenBytes != null) {
                    ldapSession.putSaslProperty("saslCreds", tokenBytes);
                }
                if ((ldapPrincipal = (LdapPrincipal)ldapSession.getSaslProperty("saslAuthentUser")) != null) {
                    DirectoryService ds = ldapSession.getLdapServer().getDirectoryService();
                    String saslMechanism = bindRequest.getSaslMechanism();
                    byte[] password = null;
                    if (ldapPrincipal.getUserPasswords() != null) {
                        password = ldapPrincipal.getUserPasswords()[0];
                    }
                    CoreSession userSession = ds.getSession(ldapPrincipal.getDn(), password, saslMechanism, null);
                    ldapSession.setCoreSession(userSession);
                    ((DefaultCoreSession)userSession).setIoSession(ldapSession.getIoSession());
                }
                ldapSession.setAuthenticated();
                MechanismHandler handler = (MechanismHandler)ldapSession.getSaslProperty("saslmechHandler");
                handler.cleanup(ldapSession);
                this.sendBindSuccess(ldapSession, bindResponse, tokenBytes);
            } else {
                LOG.info("Continuation token had length {}", (Object)tokenBytes.length);
                result.setResultCode(ResultCodeEnum.SASL_BIND_IN_PROGRESS);
                bindResponse.setServerSaslCreds(tokenBytes);
                ldapSession.setSaslAuthPending();
                ldapSession.getIoSession().write((Object)bindResponse);
                LOG.debug("Returning final authentication data to client to complete context.");
            }
        }
        catch (SaslException se) {
            this.sendInvalidCredentials(ldapSession, bindResponse, se);
        }
    }

    private void sendAuthMethNotSupported(LdapSession ldapSession, BindRequest bindRequest) {
        BindResponse bindResponse = (BindResponse)bindRequest.getResultResponse();
        ldapSession.clearSaslProperties();
        ldapSession.setAnonymous();
        LdapResult bindResult = bindResponse.getLdapResult();
        bindResult.setResultCode(ResultCodeEnum.AUTH_METHOD_NOT_SUPPORTED);
        bindResult.setDiagnosticMessage(ResultCodeEnum.AUTH_METHOD_NOT_SUPPORTED.toString() + ": " + bindRequest.getSaslMechanism() + " is not a supported mechanism.");
        ldapSession.getIoSession().write((Object)bindResponse);
    }

    private void sendInvalidCredentials(LdapSession ldapSession, BindResponse bindResponse, Exception e) {
        LdapResult result = bindResponse.getLdapResult();
        String message = "";
        message = e != null ? ResultCodeEnum.INVALID_CREDENTIALS + ": " + e.getLocalizedMessage() : ResultCodeEnum.INVALID_CREDENTIALS.toString();
        LOG.error(message);
        result.setResultCode(ResultCodeEnum.INVALID_CREDENTIALS);
        result.setDiagnosticMessage(message);
        ldapSession.clearSaslProperties();
        ldapSession.setAnonymous();
        ldapSession.getIoSession().write((Object)bindResponse);
    }

    private void sendBindSuccess(LdapSession ldapSession, BindResponse bindResponse, byte[] tokenBytes) {
        bindResponse.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
        bindResponse.setServerSaslCreds(tokenBytes);
        if (!ldapSession.getCoreSession().isAnonymous()) {
            ldapSession.setAuthenticated();
        } else {
            ldapSession.setAnonymous();
        }
        MechanismHandler handler = (MechanismHandler)ldapSession.getSaslProperty("saslmechHandler");
        if (handler != null) {
            handler.cleanup(ldapSession);
        }
        ldapSession.getIoSession().write((Object)bindResponse);
        LOG.debug("Returned SUCCESS message: {}.", (Object)bindResponse);
    }

    private void handleSaslAuthPending(LdapSession ldapSession, BindRequest bindRequest) throws Exception {
        String saslMechanism = bindRequest.getSaslMechanism();
        if (Strings.isEmpty((String)saslMechanism) || !ldapSession.getSaslProperty("saslMech").equals(saslMechanism)) {
            this.sendAuthMethNotSupported(ldapSession, bindRequest);
            return;
        }
        MechanismHandler mechanismHandler = this.handlers.get(saslMechanism);
        if (mechanismHandler == null) {
            String message = I18n.err((I18n)I18n.ERR_161, (Object[])new Object[]{saslMechanism});
            ldapSession.clearSaslProperties();
            ldapSession.setAnonymous();
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        SaslServer ss = mechanismHandler.handleMechanism(ldapSession, bindRequest);
        this.generateSaslChallengeOrComplete(ldapSession, ss, bindRequest);
    }

    public void handleSaslAuth(LdapSession ldapSession, BindRequest bindRequest) throws Exception {
        String saslMechanism = bindRequest.getSaslMechanism();
        if (ldapSession.isAuthenticated()) {
            ldapSession.getCoreSession().unbind();
            ldapSession.setAnonymous();
            ldapSession.clearSaslProperties();
        }
        if (ldapSession.isAnonymous()) {
            if (!this.checkMechanism(saslMechanism)) {
                this.sendAuthMethNotSupported(ldapSession, bindRequest);
                return;
            }
            ldapSession.putSaslProperty("saslMech", saslMechanism);
            MechanismHandler mechanismHandler = this.handlers.get(saslMechanism);
            ldapSession.putSaslProperty("saslmechHandler", mechanismHandler);
            mechanismHandler.init(ldapSession);
            SaslServer ss = mechanismHandler.handleMechanism(ldapSession, bindRequest);
            this.generateSaslChallengeOrComplete(ldapSession, ss, bindRequest);
        } else if (ldapSession.isAuthPending()) {
            try {
                this.handleSaslAuthPending(ldapSession, bindRequest);
            }
            catch (SaslException se) {
                this.sendInvalidCredentials(ldapSession, (BindResponse)bindRequest.getResultResponse(), se);
            }
        }
    }

    @Override
    public void handle(LdapSession ldapSession, BindRequest bindRequest) throws Exception {
        LOG.debug("Received: {}", (Object)bindRequest);
        if (!bindRequest.getVersion3()) {
            BindResponse bindResponse = (BindResponse)bindRequest.getResultResponse();
            LOG.error(I18n.err((I18n)I18n.ERR_162, (Object[])new Object[0]));
            LdapResult bindResult = bindResponse.getLdapResult();
            bindResult.setResultCode(ResultCodeEnum.PROTOCOL_ERROR);
            bindResult.setDiagnosticMessage(I18n.err((I18n)I18n.ERR_163, (Object[])new Object[0]));
            ldapSession.getIoSession().write((Object)bindResponse);
            return;
        }
        if (bindRequest.isSimple()) {
            this.handleSimpleAuth(ldapSession, bindRequest);
        } else {
            this.handleSaslAuth(ldapSession, bindRequest);
        }
    }
}

