/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.metadata.model.exception.LookupTableException;
import org.apache.kylin.rec.AbstractContext;
import org.apache.kylin.rest.aspect.WaitForSyncBeforeRPC;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.request.AutoIndexPlanRuleUpdateRequest;
import org.apache.kylin.rest.request.FavoriteRequest;
import org.apache.kylin.rest.request.ModelSuggestionRequest;
import org.apache.kylin.rest.request.OptRecRequest;
import org.apache.kylin.rest.request.SqlAccelerateRequest;
import org.apache.kylin.rest.request.WhiteListIndexRequest;
import org.apache.kylin.rest.response.AutoIndexPlanWhiteListResponse;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.OptRecResponse;
import org.apache.kylin.rest.response.SuggestionResponse;
import org.apache.kylin.rest.service.ModelService;
import org.apache.kylin.rest.service.ModelSmartService;
import org.apache.kylin.rest.service.OptRecApproveService;
import org.apache.kylin.rest.service.util.AutoIndexPlanRuleUtil;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@EnableDiscoveryClient
@RequestMapping(value={"/api/models"}, produces={"application/vnd.apache.kylin-v4+json"})
public class ModelRecController
extends NBasicController {
    @Generated
    private static final Logger log = Logger.getLogger(ModelRecController.class);
    private static final String MODEL_ID = "modelId";
    private static final String REC_COUNT_ACTION = "action";
    @Autowired
    @Qualifier(value="modelService")
    private ModelService modelService;
    @Autowired
    private OptRecApproveService optRecApproveService;
    @Autowired
    private ModelSmartService modelSmartService;

    @ApiOperation(value="suggestModel", tags={"AI"}, notes="")
    @PostMapping(value={"/suggest_model"})
    @ResponseBody
    @WaitForSyncBeforeRPC
    public EnvelopeResponse<SuggestionResponse> suggestModel(@RequestBody SqlAccelerateRequest request) {
        this.checkProjectName(request.getProject());
        this.checkProjectNotSemiAuto(request.getProject());
        AbstractContext proposeContext = this.modelSmartService.suggestModel(request.getProject(), request.getSqls(), request.getReuseExistedModel().booleanValue(), true);
        return new EnvelopeResponse("000", (Object)this.modelSmartService.buildModelSuggestionResponse(proposeContext), "");
    }

    @Deprecated
    @ApiOperation(value="checkIfCanAnsweredByExistedModel", tags={"AI"}, notes="")
    @PostMapping(value={"/can_answered_by_existed_model"})
    @ResponseBody
    @WaitForSyncBeforeRPC
    public EnvelopeResponse<Boolean> couldAnsweredByExistedModel(@RequestBody FavoriteRequest request) {
        this.checkProjectName(request.getProject());
        this.checkProjectNotSemiAuto(request.getProject());
        return new EnvelopeResponse("000", (Object)this.modelSmartService.couldAnsweredByExistedModel(request.getProject(), request.getSqls()), "");
    }

    @ApiOperation(value="suggestModel", tags={"AI"}, notes="")
    @PostMapping(value={"/model_recommendation"})
    @ResponseBody
    public EnvelopeResponse<String> approveSuggestModel(@RequestBody ModelSuggestionRequest request) {
        this.checkProjectName(request.getProject());
        this.checkProjectNotSemiAuto(request.getProject());
        try {
            request.getNewModels().forEach(req -> {
                req.setWithModelOnline(request.isWithModelOnline());
                req.setWithEmptySegment(request.isWithEmptySegment());
            });
            this.modelService.batchCreateModel(request.getProject(), request.getNewModels(), request.getReusedModels());
            return new EnvelopeResponse("000", (Object)"", "");
        }
        catch (LookupTableException e) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_CREATE_MODEL, e.getMessage(), (Throwable)e);
        }
    }

    @ApiOperation(value="approveOptimizeRecommendations", tags={"AI"}, notes="Add URL: {model}")
    @PostMapping(value={"/recommendations"})
    @ResponseBody
    public EnvelopeResponse<OptRecResponse> approveOptimizeRecommendations(@RequestBody OptRecRequest request) {
        this.checkProjectName(request.getProject());
        this.checkProjectNotSemiAuto(request.getProject());
        String modelId = request.getModelId();
        this.checkRequiredArg(MODEL_ID, modelId);
        OptRecResponse optRecResponse = this.optRecApproveService.approve(request.getProject(), request);
        return new EnvelopeResponse("000", (Object)optRecResponse, "");
    }

    @Deprecated
    @ApiOperation(value="getAutoIndexPlanRules", tags={"AI"}, notes="Update Param: todo")
    @GetMapping(value={"/{model_id:.+}/auto_index_plan_rule"})
    @ResponseBody
    @WaitForSyncBeforeRPC
    public EnvelopeResponse<Map<String, Object>> getAutoIndexPlanRules(@PathVariable(value="model_id") String modelId, @RequestParam(value="project") String project) {
        this.checkProjectName(project);
        return new EnvelopeResponse("000", (Object)this.modelSmartService.getAutoIndexPlanRule(modelId, project), "");
    }

    @ApiOperation(value="getIndexPlannerRules", tags={"AI"}, notes="Update Param: todo")
    @GetMapping(value={"/{model_id:.+}/index_planner_rule"})
    @ResponseBody
    @WaitForSyncBeforeRPC
    public EnvelopeResponse<Map<String, Object>> getIndexPlannerRules(@PathVariable(value="model_id") String modelId, @RequestParam(value="project") String project) {
        this.checkProjectName(project);
        return new EnvelopeResponse("000", (Object)this.modelSmartService.getIndexPlannerRule(modelId, project), "");
    }

    @Deprecated
    @ApiOperation(value="updateAutoIndexPlanRules", tags={"AI"}, notes="Update Param: todo")
    @PostMapping(value={"/{model_id:.+}/auto_index_plan_rule"})
    @ResponseBody
    public EnvelopeResponse<String> updateAutoIndexPlanRules(@PathVariable(value="model_id") String modelId, @RequestBody AutoIndexPlanRuleUpdateRequest request) {
        this.checkProjectName(request.getProject());
        AutoIndexPlanRuleUtil.checkUpdateFavoriteRuleArgs((AutoIndexPlanRuleUpdateRequest)request);
        this.modelSmartService.updateAutoIndexPlanRule(modelId, request);
        return new EnvelopeResponse("000", null, "");
    }

    @ApiOperation(value="updateIndexPlannerRules", tags={"AI"}, notes="Update Param: todo")
    @PutMapping(value={"/{model_id:.+}/index_planner_rule"})
    @ResponseBody
    public EnvelopeResponse<String> updateIndexPlannerRules(@PathVariable(value="model_id") String modelId, @RequestBody AutoIndexPlanRuleUpdateRequest request) {
        this.checkProjectName(request.getProject());
        AutoIndexPlanRuleUtil.checkUpdateFavoriteRuleArgs((AutoIndexPlanRuleUpdateRequest)request);
        this.modelSmartService.updateAutoIndexPlanRule(modelId, request);
        return new EnvelopeResponse("000", null, "");
    }

    @ApiOperation(value="getWhiteList", tags={"AI"}, notes="")
    @GetMapping(value={"/{model_id:.+}/index_white_list"})
    @ResponseBody
    @WaitForSyncBeforeRPC
    public EnvelopeResponse<AutoIndexPlanWhiteListResponse> getWhiteList(@PathVariable(value="model_id") String modelId, @RequestParam(value="project") String project) {
        this.checkProjectName(project);
        List indexes = this.modelSmartService.getAutoIndexPlanWhiteList(modelId, project);
        AutoIndexPlanWhiteListResponse response = new AutoIndexPlanWhiteListResponse(indexes);
        return new EnvelopeResponse("000", (Object)response, "");
    }

    @ApiOperation(value="addWhiteList", tags={"AI"}, notes="")
    @PostMapping(value={"/{model_id:.+}/index_white_list"})
    @ResponseBody
    @WaitForSyncBeforeRPC
    public EnvelopeResponse<String> addWhiteList(@PathVariable(value="model_id") String modelId, @RequestBody WhiteListIndexRequest request) {
        this.checkProjectName(request.getProject());
        this.modelSmartService.addToAutoIndexPlanWhiteList(modelId, request.getProject(), request.getIndexes());
        return new EnvelopeResponse("000", null, "");
    }

    @ApiOperation(value="deleteWhiteList", tags={"AI"}, notes="")
    @DeleteMapping(value={"/{model_id:.+}/index_white_list"})
    @ResponseBody
    @WaitForSyncBeforeRPC
    public EnvelopeResponse<String> deleteWhiteList(@PathVariable(value="model_id") String modelId, @RequestBody WhiteListIndexRequest request) {
        this.checkProjectName(request.getProject());
        this.modelSmartService.deleteFromAutoIndexPlanWhiteList(modelId, request.getProject(), request.getIndexes());
        return new EnvelopeResponse("000", null, "");
    }
}

