/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.scheduler;

import java.util.Locale;
import org.apache.kylin.job.JobContext;
import org.apache.kylin.job.core.AbstractJobExecutable;
import org.apache.kylin.job.execution.AbstractExecutable;

public class JobExecutor
implements AutoCloseable {
    private final JobContext jobContext;
    private final AbstractJobExecutable jobExecutable;
    private final String originThreadName;

    public JobExecutor(JobContext jobContext, AbstractJobExecutable jobExecutable) {
        this.jobContext = jobContext;
        this.jobExecutable = jobExecutable;
        this.originThreadName = Thread.currentThread().getName();
        this.setThreadName();
    }

    public AbstractJobExecutable getJobExecutable() {
        return this.jobExecutable;
    }

    public void execute() throws Exception {
        if (this.jobExecutable instanceof AbstractExecutable) {
            ((AbstractExecutable)this.jobExecutable).execute(this.jobContext);
        } else {
            this.jobExecutable.execute();
        }
    }

    private void setThreadName() {
        String project = this.jobExecutable.getProject();
        String jobFlag = this.jobExecutable.getJobId().split("-")[0];
        Thread.currentThread().setName(String.format(Locale.ROOT, "JobWorker(project:%s,jobid:%s)", project, jobFlag));
    }

    private void setbackThreadName() {
        Thread.currentThread().setName(this.originThreadName);
    }

    @Override
    public void close() throws Exception {
        this.jobContext.getResourceAcquirer().release(this.jobExecutable);
        this.setbackThreadName();
    }
}

