/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.protocol;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.celeborn.common.protocol.PbStorageInfo;

public class StorageInfo
implements Serializable {
    public static String UNKNOWN_DISK = "UNKNOWN_DISK";
    public static Map<Integer, Type> typesMap = new HashMap<Integer, Type>();
    public static Set<String> typeNames = new HashSet<String>();
    private Type type = Type.MEMORY;
    private String mountPoint = UNKNOWN_DISK;
    private boolean finalResult = false;
    private String filePath;

    public StorageInfo() {
    }

    public StorageInfo(Type type, boolean isFinal, String filePath) {
        this.type = type;
        this.finalResult = isFinal;
        this.filePath = filePath;
    }

    public StorageInfo(String mountPoint) {
        this.mountPoint = mountPoint;
    }

    public StorageInfo(Type type, String mountPoint) {
        this.type = type;
        this.mountPoint = mountPoint;
    }

    public StorageInfo(Type type, String mountPoint, boolean finalResult) {
        this.type = type;
        this.mountPoint = mountPoint;
        this.finalResult = finalResult;
    }

    public StorageInfo(Type type, String mountPoint, boolean finalResult, String filePath) {
        this.type = type;
        this.mountPoint = mountPoint;
        this.finalResult = finalResult;
        this.filePath = filePath;
    }

    public boolean isFinalResult() {
        return this.finalResult;
    }

    public void setFinalResult(boolean finalResult) {
        this.finalResult = finalResult;
    }

    public String getMountPoint() {
        return this.mountPoint;
    }

    public void setMountPoint(String mountPoint) {
        this.mountPoint = mountPoint;
    }

    public Type getType() {
        return this.type;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String toString() {
        return "StorageInfo{type=" + (Object)((Object)this.type) + ", mountPoint='" + this.mountPoint + '\'' + ", finalResult=" + this.finalResult + ", filePath=" + this.filePath + '}';
    }

    public static PbStorageInfo toPb(StorageInfo storageInfo) {
        String filePath = storageInfo.getFilePath();
        PbStorageInfo.Builder builder = PbStorageInfo.newBuilder();
        builder.setType(storageInfo.type.value).setFinalResult(storageInfo.finalResult).setMountPoint(storageInfo.mountPoint);
        if (filePath != null) {
            builder.setFilePath(filePath);
        }
        return builder.build();
    }

    public static StorageInfo fromPb(PbStorageInfo pbStorageInfo) {
        return new StorageInfo(typesMap.get(pbStorageInfo.getType()), pbStorageInfo.getMountPoint(), pbStorageInfo.getFinalResult(), pbStorageInfo.getFilePath());
    }

    public static boolean validateStorageType(String str) {
        return typeNames.contains(str);
    }

    static {
        for (Type type : Type.values()) {
            typesMap.put(type.value, type);
            typeNames.add(type.name());
        }
    }

    public static enum Type {
        MEMORY(0),
        HDD(1),
        SSD(2),
        HDFS(3),
        OSS(4);

        private final int value;

        private Type(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

