/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.cache;

import io.lettuce.core.KeyScanCursor;
import io.lettuce.core.ReadFrom;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanCursor;
import io.lettuce.core.SetArgs;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.codec.ByteArrayCodec;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.HostAndPort;
import io.lettuce.core.masterreplica.MasterReplica;
import io.lettuce.core.masterreplica.StatefulRedisMasterReplicaConnection;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.Singletons;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.util.EncryptUtil;
import org.apache.kylin.rest.cache.AbstractKylinCache;
import org.apache.kylin.rest.cache.KylinCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisCacheV2
extends AbstractKylinCache
implements KylinCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedisCacheV2.class);
    private static final AtomicBoolean isRecovering = new AtomicBoolean(false);
    private String redisExpireTimeUnit;
    private long redisExpireTime;
    private long redisExpireTimeForException;
    private StatefulRedisMasterReplicaConnection<byte[], byte[]> redisConnection;
    private RedisCommands<byte[], byte[]> syncCommands;

    private RedisCacheV2() {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        this.loadConfigurations(kylinConfig);
        this.createRedisClient(kylinConfig);
        log.info("Redis init success.");
    }

    public static KylinCache getInstance() {
        try {
            return (KylinCache)Singletons.getInstance(RedisCacheV2.class);
        }
        catch (Exception e) {
            log.error("Redis init failed:{} ", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    public void put(String type, String project, Object key, Object value) {
        long expireTime = this.isExceptionQuery(type) ? this.redisExpireTimeForException : this.redisExpireTime;
        this.put(this.getTypeProjectPrefix(type, project), key, value, "NX", this.redisExpireTimeUnit, expireTime);
    }

    public void put(String type, Object key, Object value, String ifExist, String expireTimeUnit, long expireTime) {
        byte[] realKey = this.convertKeyToByte(type, key);
        byte[] valueBytes = this.convertValueToByte(value);
        this.syncCommands.set((Object)realKey, (Object)valueBytes, this.createSetArgs(ifExist, expireTimeUnit, expireTime));
    }

    public void update(String type, String project, Object key, Object value) {
        long expireTime = this.isExceptionQuery(type) ? this.redisExpireTimeForException : this.redisExpireTime;
        this.put(this.getTypeProjectPrefix(type, project), key, value, "XX", this.redisExpireTimeUnit, expireTime);
    }

    public Object get(String type, String project, Object key) {
        byte[] realKey = this.convertKeyToByte(this.getTypeProjectPrefix(type, project), key);
        log.trace("redis get start");
        byte[] sqlResp = (byte[])this.syncCommands.get((Object)realKey);
        log.trace("redis get done, size = {}bytes", (Object)(sqlResp == null ? 0 : sqlResp.length));
        if (sqlResp != null) {
            Object result = this.convertByteToObject(sqlResp);
            log.trace("redis result deserialized");
            return result;
        }
        return null;
    }

    public boolean remove(String type, String project, Object key) {
        Long removedCount = this.syncCommands.del((Object[])new byte[][]{this.convertKeyToByte(this.getTypeProjectPrefix(type, project), key)});
        return removedCount != null && removedCount > 0L;
    }

    public void clearAll() {
        this.clearByType("", "");
    }

    public void clearByType(String type, String project) {
        KeyScanCursor scanCursor;
        String prefixAndType = "Kylin-";
        if (!type.isEmpty()) {
            prefixAndType = prefixAndType + this.getTypeProjectPrefix(type, project);
        }
        if ((scanCursor = this.syncCommands.scan(ScanArgs.Builder.matches((String)(prefixAndType + "*")))).isFinished()) {
            for (byte[] key : scanCursor.getKeys()) {
                this.syncCommands.del((Object[])new byte[][]{key});
            }
        }
        while (!scanCursor.isFinished()) {
            for (byte[] key : scanCursor.getKeys()) {
                this.syncCommands.del((Object[])new byte[][]{key});
            }
            scanCursor = this.syncCommands.scan((ScanCursor)scanCursor);
        }
    }

    public KylinCache recoverInstance() {
        RedisCacheV2 kylinCache = this;
        if (isRecovering.compareAndSet(false, true)) {
            try {
                log.info("Destroy RedisCacheV2.");
                if (this.redisConnection != null) {
                    this.redisConnection.close();
                }
                Singletons.clearInstance(RedisCacheV2.class);
                log.info("Initiate RedisCacheV2.");
                kylinCache = (KylinCache)Singletons.getInstance(RedisCacheV2.class);
            }
            finally {
                isRecovering.set(false);
            }
        }
        return kylinCache;
    }

    private void loadConfigurations(KylinConfig kylinConfig) {
        this.redisExpireTimeUnit = kylinConfig.getRedisExpireTimeUnit();
        this.redisExpireTime = kylinConfig.getRedisExpireTime();
        this.redisExpireTimeForException = kylinConfig.getRedisExpireTimeForException();
    }

    private List<HostAndPort> parseHosts(KylinConfig kylinConfig) {
        String redisHosts = kylinConfig.getRedisHosts().trim();
        String[] hostAndPorts = redisHosts.split(",");
        if (Arrays.stream(hostAndPorts).anyMatch(StringUtils::isBlank)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.REDIS_INIT_FAILED, "Redis client init failed because there are some errors in kylin.properties for 'kylin.cache.redis.hosts'");
        }
        return Arrays.stream(hostAndPorts).map(hostAndPort -> {
            String host = hostAndPort.split(":")[0].trim();
            int port = Integer.parseInt(hostAndPort.split(":")[1]);
            return HostAndPort.of((String)host, (int)port);
        }).collect(Collectors.toList());
    }

    private char[] parsePassword(KylinConfig kylinConfig) {
        String redisPassword = kylinConfig.getRedisPassword();
        if (EncryptUtil.isEncrypted((String)redisPassword)) {
            redisPassword = EncryptUtil.getDecryptedValue((String)redisPassword);
        }
        return redisPassword == null ? null : redisPassword.toCharArray();
    }

    private void createRedisClient(KylinConfig kylinConfig) {
        List<HostAndPort> hostAndPorts = this.parseHosts(kylinConfig);
        char[] redisPassword = this.parsePassword(kylinConfig);
        log.info("The 'kylin.cache.redis.sentinel-enabled' is {}", (Object)kylinConfig.isRedisSentinelEnabled());
        if (kylinConfig.isRedisSentinelEnabled()) {
            log.info("kylin will use redis sentinel");
            RedisURI redisURI = this.buildRedisURI(kylinConfig, hostAndPorts, redisPassword);
            RedisClient redisClient = RedisClient.create();
            this.redisConnection = MasterReplica.connect((RedisClient)redisClient, (RedisCodec)ByteArrayCodec.INSTANCE, (RedisURI)redisURI);
            this.redisConnection.setReadFrom(ReadFrom.REPLICA_PREFERRED);
            this.syncCommands = this.redisConnection.sync();
            log.info("Lettuce sentinel ping:{}", (Object)this.syncCommands.ping());
        }
    }

    private RedisURI buildRedisURI(KylinConfig kylinConfig, List<HostAndPort> hostAndPorts, char[] redisPassword) {
        RedisURI.Builder redisUriBuilder = RedisURI.builder().withSentinelMasterId(kylinConfig.getRedisSentinelMasterId()).withPassword(redisPassword).withTimeout(Duration.ofMillis(kylinConfig.getRedisConnectionTimeout()));
        for (HostAndPort hostAndPort : hostAndPorts) {
            redisUriBuilder.withSentinel(hostAndPort.getHostText(), hostAndPort.getPort());
        }
        RedisURI redisURI = redisUriBuilder.build();
        log.info("Redis uri:{}", (Object)redisURI);
        return redisURI;
    }

    private SetArgs createSetArgs(String ifExist, String expireTimeUnit, Long expireTime) {
        SetArgs setArgs = new SetArgs();
        setArgs = expireTimeUnit.equals("EX") ? setArgs.ex(expireTime.longValue()) : setArgs.px(expireTime.longValue());
        setArgs = ifExist.equals("NX") ? setArgs.nx() : setArgs.xx();
        return setArgs;
    }
}

