/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import net.sf.ehcache.CacheManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.util.DefaultHostInfoFetcher;
import org.apache.kylin.common.util.HostInfoFetcher;
import org.apache.kylin.common.util.TimeUtil;
import org.apache.kylin.rest.cluster.ClusterManager;
import org.apache.kylin.rest.cluster.DefaultClusterManager;
import org.apache.kylin.rest.handler.KapNoOpResponseErrorHandler;
import org.apache.kylin.rest.interceptor.ReloadAuthoritiesInterceptor;
import org.apache.kylin.rest.service.QuerySmartSupporter;
import org.apache.kylin.rest.session.MapIndexedSessionRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.cache.ehcache.EhCacheCacheManager;
import org.springframework.cache.ehcache.EhCacheManagerFactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpMethod;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.MapSession;
import org.springframework.session.Session;
import org.springframework.session.SessionRepository;
import org.springframework.session.security.SpringSessionBackedSessionRegistry;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class AppConfig
implements WebMvcConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppConfig.class);
    @Value(value="${kylin.thread.pool.core-pool-size:5}")
    private int threadPoolCorePoolSize;
    @Value(value="${kylin.thread.pool.max-pool-size:20}")
    private int threadPoolMaxPoolSize;
    @Value(value="${kylin.thread.pool.queue-capacity:200}")
    private int threadPoolQueueCapacity;
    @Value(value="${kylin.thread.pool.keep-alive-time:300s}")
    private String threadPoolKeepAliveTime;
    @Value(value="${server.port:7070}")
    private int port;
    @Value(value="${kylin.cache.config}")
    private String cacheConfigLocation;
    @Autowired(required=false)
    WebProperties webProperties;

    @Bean
    public TaskScheduler taskScheduler() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setPoolSize(5);
        scheduler.setThreadNamePrefix("DefaultTaskScheduler-");
        return scheduler;
    }

    @Bean(value={"projectScheduler"})
    public TaskScheduler projectScheduler() {
        ThreadPoolTaskScheduler autoRefreshSnapshotScheduler = new ThreadPoolTaskScheduler();
        autoRefreshSnapshotScheduler.setPoolSize(20);
        autoRefreshSnapshotScheduler.setAwaitTerminationSeconds(60);
        autoRefreshSnapshotScheduler.setThreadNamePrefix("ProjectScheduler-");
        return autoRefreshSnapshotScheduler;
    }

    @Bean
    public ThreadPoolTaskExecutor threadPoolTaskExecutor() {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        threadPoolTaskExecutor.setCorePoolSize(this.threadPoolCorePoolSize);
        threadPoolTaskExecutor.setMaxPoolSize(this.threadPoolMaxPoolSize);
        threadPoolTaskExecutor.setQueueCapacity(this.threadPoolQueueCapacity);
        int threadPoolKeepAliveSeconds = Math.toIntExact(TimeUtil.timeStringAs((String)(StringUtils.isBlank((CharSequence)this.threadPoolKeepAliveTime) ? "300s" : this.threadPoolKeepAliveTime), (TimeUnit)TimeUnit.SECONDS));
        threadPoolTaskExecutor.setKeepAliveSeconds(threadPoolKeepAliveSeconds);
        threadPoolTaskExecutor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        threadPoolTaskExecutor.setThreadNamePrefix("DefaultThreadPoolTaskExecutor-");
        return threadPoolTaskExecutor;
    }

    @Bean
    public EhCacheManagerFactoryBean cacheFactoryBean(Environment environment) {
        EhCacheManagerFactoryBean factory = new EhCacheManagerFactoryBean();
        factory.setShared(true);
        try {
            log.debug("Trying to use {}", (Object)this.cacheConfigLocation);
            factory.setConfigLocation((Resource)new UrlResource(this.cacheConfigLocation));
        }
        catch (MalformedURLException e) {
            log.warn("Cannot use " + this.cacheConfigLocation + ", use default ehcache.xml", (Throwable)e);
            factory.setConfigLocation((Resource)new ClassPathResource("ehcache.xml"));
        }
        return factory;
    }

    @Bean
    public CacheManager ehCacheCacheManager(Environment environment) {
        return this.cacheFactoryBean(environment).getObject();
    }

    @Bean
    public EhCacheCacheManager cacheManager(Environment environment) {
        EhCacheCacheManager manager = new EhCacheCacheManager();
        manager.setCacheManager(this.ehCacheCacheManager(environment));
        return manager;
    }

    @Bean
    @ConditionalOnMissingBean(value={ClusterManager.class})
    public ClusterManager clusterManager() {
        return new DefaultClusterManager(this.port);
    }

    @Bean
    @ConditionalOnMissingBean(value={QuerySmartSupporter.class})
    public QuerySmartSupporter querySmartSupporter() {
        return (project, queries) -> {};
    }

    @Bean(name={"normalRestTemplate"})
    public RestTemplate restTemplate() {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setErrorHandler((ResponseErrorHandler)new KapNoOpResponseErrorHandler());
        return restTemplate;
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        if (this.webProperties == null) {
            return;
        }
        registry.addResourceHandler(new String[]{"/index.html"}).addResourceLocations(this.webProperties.getResources().getStaticLocations()).setCacheControl(CacheControl.noStore());
    }

    @Bean
    public ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        SimpleFilterProvider filterProvider = new SimpleFilterProvider().addFilter("passwordFilter", SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[]{"password"}));
        return objectMapper.setFilterProvider((FilterProvider)filterProvider);
    }

    @Bean
    public MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter() {
        return new MappingJackson2HttpMessageConverter(this.getObjectMapper());
    }

    @Bean
    @ConditionalOnMissingBean(value={HostInfoFetcher.class})
    public HostInfoFetcher hostInfoFetcher() {
        return new DefaultHostInfoFetcher();
    }

    @Bean
    public ReloadAuthoritiesInterceptor getReloadAuthoritiesInterceptor() {
        return new ReloadAuthoritiesInterceptor();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.getReloadAuthoritiesInterceptor());
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.session", name={"store-type"}, havingValue="NONE", matchIfMissing=true)
    public SessionRepository sessionRepository() {
        return new MapIndexedSessionRepository(new ConcurrentHashMap<String, Session>(), new ConcurrentHashMap<String, Map<String, MapSession>>());
    }

    @Bean
    public SessionRegistry sessionRegistry(SessionRepository sessionRepository) {
        return new SpringSessionBackedSessionRegistry((FindByIndexNameSessionRepository)sessionRepository);
    }

    @Bean
    public MultipartResolver multipartResolver() {
        CommonsMultipartResolver commonsMultipartResolver = new CommonsMultipartResolver();
        commonsMultipartResolver.setSupportedMethods(new String[]{HttpMethod.POST.name(), HttpMethod.PUT.name()});
        return commonsMultipartResolver;
    }

    @Generated
    public int getPort() {
        return this.port;
    }
}

