/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import org.apache.iceberg.MetadataUpdate;
import org.apache.iceberg.MetadataUpdateParser;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.SortOrderParser;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.UnboundPartitionSpec;
import org.apache.iceberg.UnboundSortOrder;
import org.apache.iceberg.UpdateRequirement;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.catalog.TableIdentifierParser;
import org.apache.iceberg.rest.auth.OAuth2Util;
import org.apache.iceberg.rest.requests.CommitTransactionRequest;
import org.apache.iceberg.rest.requests.CommitTransactionRequestParser;
import org.apache.iceberg.rest.requests.ImmutableRegisterTableRequest;
import org.apache.iceberg.rest.requests.ImmutableReportMetricsRequest;
import org.apache.iceberg.rest.requests.RegisterTableRequest;
import org.apache.iceberg.rest.requests.RegisterTableRequestParser;
import org.apache.iceberg.rest.requests.ReportMetricsRequest;
import org.apache.iceberg.rest.requests.ReportMetricsRequestParser;
import org.apache.iceberg.rest.requests.UpdateRequirementParser;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.rest.requests.UpdateTableRequestParser;
import org.apache.iceberg.rest.responses.ErrorResponse;
import org.apache.iceberg.rest.responses.ErrorResponseParser;
import org.apache.iceberg.rest.responses.OAuthTokenResponse;
import org.apache.iceberg.util.JsonUtil;

public class RESTSerializers {
    private RESTSerializers() {
    }

    public static void registerAll(ObjectMapper mapper) {
        SimpleModule module = new SimpleModule();
        module.addSerializer(ErrorResponse.class, (JsonSerializer)new ErrorResponseSerializer()).addDeserializer(ErrorResponse.class, (JsonDeserializer)new ErrorResponseDeserializer()).addSerializer(TableIdentifier.class, (JsonSerializer)new TableIdentifierSerializer()).addDeserializer(TableIdentifier.class, (JsonDeserializer)new TableIdentifierDeserializer()).addSerializer(Namespace.class, (JsonSerializer)new NamespaceSerializer()).addDeserializer(Namespace.class, (JsonDeserializer)new NamespaceDeserializer()).addSerializer(Schema.class, (JsonSerializer)new SchemaSerializer()).addDeserializer(Schema.class, (JsonDeserializer)new SchemaDeserializer()).addSerializer(UnboundPartitionSpec.class, (JsonSerializer)new UnboundPartitionSpecSerializer()).addDeserializer(UnboundPartitionSpec.class, (JsonDeserializer)new UnboundPartitionSpecDeserializer()).addSerializer(UnboundSortOrder.class, (JsonSerializer)new UnboundSortOrderSerializer()).addDeserializer(UnboundSortOrder.class, (JsonDeserializer)new UnboundSortOrderDeserializer()).addSerializer(MetadataUpdate.class, (JsonSerializer)new MetadataUpdateSerializer()).addDeserializer(MetadataUpdate.class, (JsonDeserializer)new MetadataUpdateDeserializer()).addSerializer(TableMetadata.class, (JsonSerializer)new TableMetadataSerializer()).addDeserializer(TableMetadata.class, (JsonDeserializer)new TableMetadataDeserializer()).addSerializer(UpdateTableRequest.UpdateRequirement.class, (JsonSerializer)new UpdateRequirementSerializer()).addDeserializer(UpdateTableRequest.UpdateRequirement.class, (JsonDeserializer)new UpdateRequirementDeserializer()).addSerializer(UpdateRequirement.class, (JsonSerializer)new UpdateReqSerializer()).addDeserializer(UpdateRequirement.class, (JsonDeserializer)new UpdateReqDeserializer()).addSerializer(OAuthTokenResponse.class, (JsonSerializer)new OAuthTokenResponseSerializer()).addDeserializer(OAuthTokenResponse.class, (JsonDeserializer)new OAuthTokenResponseDeserializer()).addSerializer(ReportMetricsRequest.class, new ReportMetricsRequestSerializer()).addDeserializer(ReportMetricsRequest.class, new ReportMetricsRequestDeserializer()).addSerializer(ImmutableReportMetricsRequest.class, new ReportMetricsRequestSerializer()).addDeserializer(ImmutableReportMetricsRequest.class, new ReportMetricsRequestDeserializer()).addSerializer(CommitTransactionRequest.class, (JsonSerializer)new CommitTransactionRequestSerializer()).addDeserializer(CommitTransactionRequest.class, (JsonDeserializer)new CommitTransactionRequestDeserializer()).addSerializer(UpdateTableRequest.class, (JsonSerializer)new UpdateTableRequestSerializer()).addDeserializer(UpdateTableRequest.class, (JsonDeserializer)new UpdateTableRequestDeserializer()).addSerializer(RegisterTableRequest.class, new RegisterTableRequestSerializer()).addDeserializer(RegisterTableRequest.class, new RegisterTableRequestDeserializer()).addSerializer(ImmutableRegisterTableRequest.class, new RegisterTableRequestSerializer()).addDeserializer(ImmutableRegisterTableRequest.class, new RegisterTableRequestDeserializer());
        mapper.registerModule((Module)module);
    }

    public static class RegisterTableRequestDeserializer<T extends RegisterTableRequest>
    extends JsonDeserializer<T> {
        public T deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return (T)RegisterTableRequestParser.fromJson(jsonNode);
        }
    }

    public static class RegisterTableRequestSerializer<T extends RegisterTableRequest>
    extends JsonSerializer<T> {
        public void serialize(T request, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            RegisterTableRequestParser.toJson(request, gen);
        }
    }

    public static class UpdateTableRequestDeserializer
    extends JsonDeserializer<UpdateTableRequest> {
        public UpdateTableRequest deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return UpdateTableRequestParser.fromJson(jsonNode);
        }
    }

    public static class UpdateTableRequestSerializer
    extends JsonSerializer<UpdateTableRequest> {
        public void serialize(UpdateTableRequest request, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            UpdateTableRequestParser.toJson(request, gen);
        }
    }

    public static class CommitTransactionRequestDeserializer
    extends JsonDeserializer<CommitTransactionRequest> {
        public CommitTransactionRequest deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return CommitTransactionRequestParser.fromJson(jsonNode);
        }
    }

    public static class CommitTransactionRequestSerializer
    extends JsonSerializer<CommitTransactionRequest> {
        public void serialize(CommitTransactionRequest request, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            CommitTransactionRequestParser.toJson(request, gen);
        }
    }

    public static class ReportMetricsRequestDeserializer<T extends ReportMetricsRequest>
    extends JsonDeserializer<T> {
        public T deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return (T)ReportMetricsRequestParser.fromJson(jsonNode);
        }
    }

    public static class ReportMetricsRequestSerializer<T extends ReportMetricsRequest>
    extends JsonSerializer<T> {
        public void serialize(T request, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            ReportMetricsRequestParser.toJson(request, gen);
        }
    }

    public static class OAuthTokenResponseDeserializer
    extends JsonDeserializer<OAuthTokenResponse> {
        public OAuthTokenResponse deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return OAuth2Util.tokenResponseFromJson(jsonNode);
        }
    }

    public static class OAuthTokenResponseSerializer
    extends JsonSerializer<OAuthTokenResponse> {
        public void serialize(OAuthTokenResponse tokenResponse, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            OAuth2Util.tokenResponseToJson(tokenResponse, gen);
        }
    }

    public static class UnboundSortOrderDeserializer
    extends JsonDeserializer<UnboundSortOrder> {
        public UnboundSortOrder deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return SortOrderParser.fromJson(jsonNode);
        }
    }

    public static class UnboundSortOrderSerializer
    extends JsonSerializer<UnboundSortOrder> {
        public void serialize(UnboundSortOrder sortOrder, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            SortOrderParser.toJson(sortOrder, gen);
        }
    }

    public static class UnboundPartitionSpecDeserializer
    extends JsonDeserializer<UnboundPartitionSpec> {
        public UnboundPartitionSpec deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return PartitionSpecParser.fromJson(jsonNode);
        }
    }

    public static class UnboundPartitionSpecSerializer
    extends JsonSerializer<UnboundPartitionSpec> {
        public void serialize(UnboundPartitionSpec spec, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            PartitionSpecParser.toJson(spec, gen);
        }
    }

    public static class SchemaSerializer
    extends JsonSerializer<Schema> {
        public void serialize(Schema schema, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            SchemaParser.toJson(schema, gen);
        }
    }

    public static class SchemaDeserializer
    extends JsonDeserializer<Schema> {
        public Schema deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return SchemaParser.fromJson(jsonNode);
        }
    }

    public static class TableIdentifierSerializer
    extends JsonSerializer<TableIdentifier> {
        public void serialize(TableIdentifier identifier, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            TableIdentifierParser.toJson(identifier, gen);
        }
    }

    public static class TableIdentifierDeserializer
    extends JsonDeserializer<TableIdentifier> {
        public TableIdentifier deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return TableIdentifierParser.fromJson(jsonNode);
        }
    }

    public static class NamespaceSerializer
    extends JsonSerializer<Namespace> {
        public void serialize(Namespace namespace, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            String[] parts = namespace.levels();
            gen.writeArray(parts, 0, parts.length);
        }
    }

    public static class NamespaceDeserializer
    extends JsonDeserializer<Namespace> {
        public Namespace deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String[] levels = JsonUtil.getStringArray((JsonNode)p.getCodec().readTree(p));
            return Namespace.of((String[])levels);
        }
    }

    public static class ErrorResponseSerializer
    extends JsonSerializer<ErrorResponse> {
        public void serialize(ErrorResponse errorResponse, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            ErrorResponseParser.toJson(errorResponse, gen);
        }
    }

    public static class ErrorResponseDeserializer
    extends JsonDeserializer<ErrorResponse> {
        public ErrorResponse deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            return ErrorResponseParser.fromJson(node);
        }
    }

    public static class MetadataUpdateSerializer
    extends JsonSerializer<MetadataUpdate> {
        public void serialize(MetadataUpdate value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            MetadataUpdateParser.toJson(value, gen);
        }
    }

    public static class MetadataUpdateDeserializer
    extends JsonDeserializer<MetadataUpdate> {
        public MetadataUpdate deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            return MetadataUpdateParser.fromJson(node);
        }
    }

    public static class TableMetadataSerializer
    extends JsonSerializer<TableMetadata> {
        public void serialize(TableMetadata metadata, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            TableMetadataParser.toJson(metadata, gen);
        }
    }

    public static class TableMetadataDeserializer
    extends JsonDeserializer<TableMetadata> {
        public TableMetadata deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            return TableMetadataParser.fromJson(node);
        }
    }

    static class UpdateReqSerializer
    extends JsonSerializer<UpdateRequirement> {
        UpdateReqSerializer() {
        }

        public void serialize(UpdateRequirement value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            org.apache.iceberg.UpdateRequirementParser.toJson(value, gen);
        }
    }

    static class UpdateReqDeserializer
    extends JsonDeserializer<UpdateRequirement> {
        UpdateReqDeserializer() {
        }

        public UpdateRequirement deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            return org.apache.iceberg.UpdateRequirementParser.fromJson(node);
        }
    }

    @Deprecated
    public static class UpdateRequirementSerializer
    extends JsonSerializer<UpdateTableRequest.UpdateRequirement> {
        public void serialize(UpdateTableRequest.UpdateRequirement value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            UpdateRequirementParser.toJson(value, gen);
        }
    }

    @Deprecated
    public static class UpdateRequirementDeserializer
    extends JsonDeserializer<UpdateTableRequest.UpdateRequirement> {
        public UpdateTableRequest.UpdateRequirement deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            return UpdateRequirementParser.fromJson(node);
        }
    }
}

