/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kylin.common.util.ByteUnit;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableMap;

public class SizeConvertUtil {
    private static final BigDecimal ONE_KB = BigDecimal.valueOf(1024L);
    private static final BigDecimal ONE_MB = BigDecimal.valueOf(0x100000L);
    private static final BigDecimal ONE_GB = BigDecimal.valueOf(0x40000000L);
    private static final BigDecimal ONE_TB = BigDecimal.valueOf(0x10000000000L);
    private static final ImmutableMap<String, ByteUnit> byteSuffixes = ImmutableMap.builder().put((Object)"b", (Object)ByteUnit.BYTE).put((Object)"k", (Object)ByteUnit.KiB).put((Object)"kb", (Object)ByteUnit.KiB).put((Object)"m", (Object)ByteUnit.MiB).put((Object)"mb", (Object)ByteUnit.MiB).put((Object)"g", (Object)ByteUnit.GiB).put((Object)"gb", (Object)ByteUnit.GiB).put((Object)"t", (Object)ByteUnit.TiB).put((Object)"tb", (Object)ByteUnit.TiB).put((Object)"p", (Object)ByteUnit.PiB).put((Object)"pb", (Object)ByteUnit.PiB).build();

    private SizeConvertUtil() {
        throw new IllegalStateException("Wrong usage for utility class.");
    }

    public static String getReadableFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB", "PB", "EB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#", DecimalFormatSymbols.getInstance(Locale.getDefault(Locale.Category.FORMAT))).format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    public static long byteStringAsMb(String str) {
        return SizeConvertUtil.byteStringAs(str, ByteUnit.MiB);
    }

    public static long byteStringAs(String str, ByteUnit unit) {
        String lower = str.toLowerCase(Locale.ROOT).trim();
        try {
            Matcher m = Pattern.compile("([0-9]+)([a-z]+)?").matcher(lower);
            Matcher fractionMatcher = Pattern.compile("([0-9]+\\.[0-9]+)([a-z]+)?").matcher(lower);
            if (m.matches()) {
                long val = Long.parseLong(m.group(1));
                String suffix = m.group(2);
                if (suffix != null && !byteSuffixes.containsKey((Object)suffix)) {
                    throw new NumberFormatException("Invalid suffix: \"" + suffix + "\"");
                }
                return unit.convertFrom(val, suffix != null ? (ByteUnit)((Object)byteSuffixes.get((Object)suffix)) : unit);
            }
            if (fractionMatcher.matches()) {
                throw new NumberFormatException("Fractional values are not supported. Input was: " + fractionMatcher.group(1));
            }
            throw new NumberFormatException("Failed to parse byte string: " + str);
        }
        catch (NumberFormatException var8) {
            String byteError = "Size must be specified as bytes (b), kibibytes (k), mebibytes (m), gibibytes (g), tebibytes (t), or pebibytes(p). E.g. 50b, 100k, or 250m.";
            throw new NumberFormatException(byteError + "\n" + var8.getMessage());
        }
    }

    public static String byteCountToDisplaySize(BigDecimal size, int scale) {
        String displaySize = size.divide(ONE_TB, scale, RoundingMode.HALF_UP).compareTo(BigDecimal.ONE) >= 0 ? size.divide(ONE_TB, scale, RoundingMode.HALF_UP) + " TB" : (size.divide(ONE_GB, scale, RoundingMode.HALF_UP).compareTo(BigDecimal.ONE) >= 0 ? size.divide(ONE_GB, scale, RoundingMode.HALF_UP) + " GB" : (size.divide(ONE_MB, scale, RoundingMode.HALF_UP).compareTo(BigDecimal.ONE) >= 0 ? size.divide(ONE_MB, scale, RoundingMode.HALF_UP) + " MB" : (size.divide(ONE_KB, scale, RoundingMode.HALF_UP).compareTo(BigDecimal.ONE) >= 0 ? size.divide(ONE_KB, scale, RoundingMode.HALF_UP) + " KB" : size + " B")));
        return displaySize;
    }

    public static String byteCountToDisplaySize(long size, int scale) {
        return SizeConvertUtil.byteCountToDisplaySize(BigDecimal.valueOf(size), scale);
    }

    public static String byteCountToDisplaySize(long size) {
        return SizeConvertUtil.byteCountToDisplaySize(size, 2);
    }
}

