/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.streaming.merge;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.streaming.merge.MergePolicy;

public class CatchupMergePolicy
extends MergePolicy {
    private boolean segSizeMatched = false;

    @Override
    public List<NDataSegment> selectMatchedSegList(List<NDataSegment> segList, int layer, long thresholdOfSegSize, int numberOfSeg) {
        this.matchSegList.clear();
        this.segSizeMatched = false;
        int maxNumOfSeg = numberOfSeg * 5;
        int idx = this.findStartIndex(segList, thresholdOfSegSize);
        if (idx != -1) {
            List layerSegList = segList.subList(idx, segList.size()).stream().filter(item -> item.getAdditionalInfo().getOrDefault("file_layer", "0").equals(String.valueOf(layer))).collect(Collectors.toList());
            if (layerSegList.size() >= maxNumOfSeg) {
                this.segSizeMatched = true;
                long totalThresholdOfSegSize = 0L;
                for (int i = idx; i < segList.size(); ++i) {
                    this.matchSegList.add(segList.get(i));
                    if (this.isThresholdOfSegSizeOver(totalThresholdOfSegSize += segList.get(i).getStorageBytesSize(), thresholdOfSegSize)) break;
                }
                return this.matchSegList;
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    @Override
    public boolean matchMergeCondition(long thresholdOfSegSize) {
        return this.segSizeMatched || this.matchSegList.size() > 1 && this.isThresholdOfSegSizeOver(this.matchSegList.stream().mapToLong(NDataSegment::getStorageBytesSize).sum(), thresholdOfSegSize);
    }
}

