/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.engine;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.adapter.enumerable.EnumerableRules;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.interpreter.Bindables;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.volcano.AbstractConverter;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rel.rules.DateRangeRules;
import org.apache.calcite.rel.rules.JoinPushThroughJoinRule;
import org.apache.calcite.rel.rules.PruneEmptyRules;
import org.apache.calcite.rel.rules.TableScanRule;
import org.apache.calcite.rel.stream.StreamRules;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.guava30.shaded.common.base.Function;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.query.engine.meta.PlannerContext;
import org.apache.kylin.query.optrule.AggregateMultipleExpandRule;
import org.apache.kylin.query.optrule.AggregateProjectReduceRule;
import org.apache.kylin.query.optrule.CorrReduceFunctionRule;
import org.apache.kylin.query.optrule.ExtendedAggregateMergeRule;
import org.apache.kylin.query.optrule.OlapAggregateReduceFunctionsRule;
import org.apache.kylin.query.optrule.OlapAggregateRule;
import org.apache.kylin.query.optrule.OlapFilterJoinRule;
import org.apache.kylin.query.optrule.OlapFilterRule;
import org.apache.kylin.query.optrule.OlapJoinRule;
import org.apache.kylin.query.optrule.OlapLimitRule;
import org.apache.kylin.query.optrule.OlapMinusRule;
import org.apache.kylin.query.optrule.OlapModelViewRule;
import org.apache.kylin.query.optrule.OlapProjectMergeRule;
import org.apache.kylin.query.optrule.OlapProjectRule;
import org.apache.kylin.query.optrule.OlapReduceExpressionRule;
import org.apache.kylin.query.optrule.OlapSortRule;
import org.apache.kylin.query.optrule.OlapToEnumerableConverterRule;
import org.apache.kylin.query.optrule.OlapUnionRule;
import org.apache.kylin.query.optrule.OlapValuesRule;
import org.apache.kylin.query.optrule.OlapWindowRule;
import org.apache.kylin.query.optrule.RightJoinToLeftJoinRule;
import org.apache.kylin.query.relnode.ContextUtil;

public class PlannerFactory {
    public static final List<RelOptRule> ENUMERABLE_RULES = ImmutableList.of((Object)EnumerableRules.ENUMERABLE_JOIN_RULE, (Object)EnumerableRules.ENUMERABLE_MERGE_JOIN_RULE, (Object)EnumerableRules.ENUMERABLE_CORRELATE_RULE, (Object)EnumerableRules.ENUMERABLE_PROJECT_RULE, (Object)EnumerableRules.ENUMERABLE_FILTER_RULE, (Object)EnumerableRules.ENUMERABLE_CALC_RULE, (Object)EnumerableRules.ENUMERABLE_AGGREGATE_RULE, (Object)EnumerableRules.ENUMERABLE_SORT_RULE, (Object)EnumerableRules.ENUMERABLE_LIMIT_RULE, (Object)EnumerableRules.ENUMERABLE_COLLECT_RULE, (Object)EnumerableRules.ENUMERABLE_UNCOLLECT_RULE, (Object)EnumerableRules.ENUMERABLE_MERGE_UNION_RULE, (Object[])new RelOptRule[]{EnumerableRules.ENUMERABLE_UNION_RULE, EnumerableRules.ENUMERABLE_REPEAT_UNION_RULE, EnumerableRules.ENUMERABLE_TABLE_SPOOL_RULE, EnumerableRules.ENUMERABLE_INTERSECT_RULE, EnumerableRules.ENUMERABLE_MINUS_RULE, EnumerableRules.ENUMERABLE_TABLE_MODIFICATION_RULE, EnumerableRules.ENUMERABLE_VALUES_RULE, EnumerableRules.ENUMERABLE_WINDOW_RULE, EnumerableRules.ENUMERABLE_TABLE_SCAN_RULE, EnumerableRules.ENUMERABLE_TABLE_FUNCTION_SCAN_RULE});
    private static final List<RelOptRule> DEFAULT_RULES = ImmutableList.of((Object)CoreRules.AGGREGATE_STAR_TABLE, (Object)CoreRules.AGGREGATE_PROJECT_STAR_TABLE, (Object)TableScanRule.INSTANCE, (Object)CoreRules.PROJECT_MERGE, (Object)CoreRules.FILTER_SCAN, (Object)CoreRules.PROJECT_FILTER_TRANSPOSE, (Object)CoreRules.FILTER_PROJECT_TRANSPOSE, (Object)CoreRules.FILTER_INTO_JOIN, (Object)CoreRules.JOIN_PUSH_EXPRESSIONS, (Object)CoreRules.AGGREGATE_EXPAND_DISTINCT_AGGREGATES, (Object)OlapAggregateReduceFunctionsRule.INSTANCE, (Object)CoreRules.FILTER_AGGREGATE_TRANSPOSE, (Object[])new RelOptRule[]{CoreRules.PROJECT_WINDOW_TRANSPOSE, CoreRules.JOIN_COMMUTE, JoinPushThroughJoinRule.RIGHT, JoinPushThroughJoinRule.LEFT, CoreRules.SORT_PROJECT_TRANSPOSE, CoreRules.SORT_JOIN_TRANSPOSE, CoreRules.SORT_UNION_TRANSPOSE});
    private final KylinConfig kylinConfig;

    public PlannerFactory(KylinConfig kylinConfig) {
        this.kylinConfig = kylinConfig;
    }

    public VolcanoPlanner createVolcanoPlanner(CalciteConnectionConfig connectionConfig) {
        VolcanoPlanner planner = new VolcanoPlanner((Context)new PlannerContext(connectionConfig));
        this.registerDefaultRules(planner);
        this.registerCustomRules(planner);
        return planner;
    }

    private void registerDefaultRules(VolcanoPlanner planner) {
        planner.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
        planner.addRelTraitDef((RelTraitDef)RelCollationTraitDef.INSTANCE);
        planner.registerAbstractRelationalRules();
        RelOptUtil.registerAbstractRules((RelOptPlanner)planner);
        planner.removeRule(PruneEmptyRules.SORT_INSTANCE);
        for (RelOptRule rule : DEFAULT_RULES) {
            planner.addRule(rule);
        }
        planner.addRule(Bindables.BINDABLE_TABLE_SCAN_RULE);
        planner.addRule((RelOptRule)CoreRules.PROJECT_TABLE_SCAN);
        planner.addRule((RelOptRule)CoreRules.PROJECT_INTERPRETER_TABLE_SCAN);
        for (RelOptRule rule : ENUMERABLE_RULES) {
            planner.addRule(rule);
        }
        planner.addRule((RelOptRule)EnumerableRules.TO_INTERPRETER);
        for (RelOptRule rule : StreamRules.RULES) {
            planner.addRule(rule);
        }
    }

    private void registerCustomRules(VolcanoPlanner planner) {
        ContextUtil.clearThreadLocalContexts();
        planner.addRule((RelOptRule)OlapToEnumerableConverterRule.INSTANCE);
        planner.addRule(OlapFilterRule.INSTANCE);
        planner.addRule(OlapProjectRule.INSTANCE);
        planner.addRule((RelOptRule)OlapAggregateRule.INSTANCE);
        planner.addRule((RelOptRule)this.selectJoinRuleByConfig());
        planner.addRule(OlapLimitRule.INSTANCE);
        planner.addRule((RelOptRule)OlapSortRule.INSTANCE);
        planner.addRule((RelOptRule)OlapUnionRule.INSTANCE);
        planner.addRule((RelOptRule)OlapWindowRule.INSTANCE);
        planner.addRule((RelOptRule)OlapValuesRule.INSTANCE);
        planner.addRule((RelOptRule)OlapMinusRule.INSTANCE);
        planner.addRule(OlapModelViewRule.INSTANCE);
        planner.removeRule((RelOptRule)CoreRules.PROJECT_MERGE);
        planner.addRule((RelOptRule)OlapProjectMergeRule.INSTANCE);
        if (KapConfig.getInstanceFromEnv().splitGroupSetsIntoUnion()) {
            planner.addRule((RelOptRule)AggregateMultipleExpandRule.INSTANCE);
        }
        planner.addRule((RelOptRule)AggregateProjectReduceRule.INSTANCE);
        if (this.kylinConfig.isReduceExpressionsRulesEnabled()) {
            planner.addRule((RelOptRule)OlapReduceExpressionRule.PROJECT_INSTANCE);
            planner.addRule((RelOptRule)OlapReduceExpressionRule.FILTER_INSTANCE);
            planner.addRule((RelOptRule)OlapReduceExpressionRule.JOIN_INSTANCE);
            planner.addRule((RelOptRule)OlapReduceExpressionRule.CALC_INSTANCE);
        }
        this.removeRules((RelOptPlanner)planner, this.kylinConfig.getCalciteRemoveRule());
        if (!this.kylinConfig.isEnumerableRulesEnabled()) {
            for (RelOptRule rule : EnumerableRules.ENUMERABLE_RULES) {
                planner.removeRule(rule);
            }
        }
        planner.removeRule((RelOptRule)CoreRules.FILTER_INTO_JOIN);
        planner.removeRule((RelOptRule)CoreRules.JOIN_CONDITION_PUSH);
        planner.addRule((RelOptRule)OlapFilterJoinRule.OLAP_FILTER_ON_JOIN_JOIN);
        planner.addRule((RelOptRule)OlapFilterJoinRule.OLAP_FILTER_ON_JOIN_SCAN);
        planner.removeRule((RelOptRule)CoreRules.JOIN_COMMUTE);
        planner.removeRule((RelOptRule)JoinPushThroughJoinRule.LEFT);
        planner.removeRule((RelOptRule)JoinPushThroughJoinRule.RIGHT);
        planner.removeRule((RelOptRule)CoreRules.AGGREGATE_PROJECT_MERGE);
        planner.removeRule((RelOptRule)CoreRules.FILTER_PROJECT_TRANSPOSE);
        planner.removeRule((RelOptRule)CoreRules.SORT_JOIN_TRANSPOSE);
        planner.removeRule((RelOptRule)CoreRules.JOIN_PUSH_EXPRESSIONS);
        planner.removeRule((RelOptRule)CoreRules.SORT_UNION_TRANSPOSE);
        planner.removeRule((RelOptRule)CoreRules.JOIN_LEFT_UNION_TRANSPOSE);
        planner.removeRule((RelOptRule)CoreRules.JOIN_RIGHT_UNION_TRANSPOSE);
        planner.removeRule((RelOptRule)CoreRules.AGGREGATE_UNION_TRANSPOSE);
        planner.removeRule(DateRangeRules.FILTER_INSTANCE);
        planner.removeRule((RelOptRule)CoreRules.JOIN_TO_SEMI_JOIN);
        planner.removeRule((RelOptRule)CoreRules.PROJECT_TO_SEMI_JOIN);
        planner.removeRule((RelOptRule)CoreRules.AGGREGATE_EXPAND_DISTINCT_AGGREGATES);
        planner.removeRule((RelOptRule)AbstractConverter.ExpandConversionRule.INSTANCE);
        planner.addRule(RightJoinToLeftJoinRule.INSTANCE);
        planner.removeRule((RelOptRule)CoreRules.UNION_MERGE);
        planner.removeRule((RelOptRule)CoreRules.PROJECT_REMOVE);
        planner.removeRule((RelOptRule)CoreRules.PROJECT_AGGREGATE_MERGE);
        if (!KylinConfig.getInstanceFromEnv().getSkipCorrReduceRule()) {
            planner.addRule((RelOptRule)CorrReduceFunctionRule.INSTANCE);
        }
        planner.removeRule((RelOptRule)CoreRules.AGGREGATE_MERGE);
        planner.addRule((RelOptRule)ExtendedAggregateMergeRule.INSTANCE);
    }

    private ConverterRule selectJoinRuleByConfig() {
        return this.kylinConfig.isQueryNonEquiJoinModelEnabled() && !QueryContext.current().isForModeling() || this.kylinConfig.isNonEquiJoinRecommendationEnabled() && QueryContext.current().isForModeling() ? OlapJoinRule.NON_EQUI_INSTANCE : OlapJoinRule.INSTANCE;
    }

    protected void removeRules(final RelOptPlanner planner, List<String> rules) {
        this.modifyRules(rules, new Function<RelOptRule, Void>(){

            @Nullable
            public Void apply(@Nullable RelOptRule input) {
                planner.removeRule(input);
                return null;
            }
        });
    }

    private void modifyRules(List<String> rules, Function<RelOptRule, Void> func) {
        for (String rule : rules) {
            if (StringUtils.isEmpty((CharSequence)rule)) continue;
            String[] split = rule.split("#");
            if (split.length != 2) {
                throw new RuntimeException("Customized Rule should be in format <RuleClassName>#<FieldName>");
            }
            String clazz = split[0];
            String field = split[1];
            try {
                func.apply((Object)((RelOptRule)Class.forName(clazz).getDeclaredField(field).get(null)));
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

