/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api.histogram;

import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Utils;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.LongFunction;

public final class BucketDistributionSummary
implements DistributionSummary {
    private final Registry registry;
    private final Id id;
    private final LongFunction<String> f;
    private final ConcurrentHashMap<String, DistributionSummary> summaries;

    public static BucketDistributionSummary get(Registry registry, Id id, LongFunction<String> f) {
        return new BucketDistributionSummary(registry, id, f);
    }

    BucketDistributionSummary(Registry registry, Id id, LongFunction<String> f) {
        this.registry = registry;
        this.id = id;
        this.f = f;
        this.summaries = new ConcurrentHashMap();
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public Iterable<Measurement> measure() {
        return Collections.emptyList();
    }

    @Override
    public boolean hasExpired() {
        return false;
    }

    @Override
    public void record(long amount) {
        this.distributionSummary(this.f.apply(amount)).record(amount);
    }

    DistributionSummary distributionSummary(String bucket) {
        return Utils.computeIfAbsent(this.summaries, bucket, k -> this.registry.distributionSummary(this.id.withTag("bucket", (String)k)));
    }

    @Override
    public long count() {
        return 0L;
    }

    @Override
    public long totalAmount() {
        return 0L;
    }
}

