/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.collect.ArrayListMultimap;
import org.apache.kylin.guava30.shaded.common.collect.ListMultimap;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.optimization.FrequencyMap;
import org.apache.kylin.metadata.favorite.FavoriteRule;
import org.apache.kylin.metadata.favorite.FavoriteRuleManager;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.query.QueryHistory;
import org.apache.kylin.metadata.query.QueryHistoryInfo;
import org.apache.kylin.metadata.query.QueryHistorySql;
import org.apache.kylin.metadata.query.RDBMSQueryHistoryDAO;
import org.apache.kylin.metadata.recommendation.candidate.LayoutMetric;
import org.apache.kylin.metadata.recommendation.candidate.RawRecItem;
import org.apache.kylin.metadata.recommendation.candidate.RawRecManager;
import org.apache.kylin.metadata.recommendation.entity.RecItemV2;
import org.apache.kylin.metadata.recommendation.ref.OptRecManagerV2;
import org.apache.kylin.metadata.recommendation.ref.OptRecV2;
import org.apache.kylin.metadata.recommendation.util.RawRecUtil;
import org.apache.kylin.rec.AbstractContext;
import org.apache.kylin.rec.ModelReuseContext;
import org.apache.kylin.rec.ProposerJob;
import org.apache.kylin.rec.common.AccelerateInfo;
import org.apache.kylin.rec.util.QueryRecStatsCollector;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.ModelChangeSupporter;
import org.apache.kylin.rest.service.OptRecService;
import org.apache.kylin.rest.service.ProjectSmartService;
import org.apache.kylin.rest.service.ProjectSmartSupporter;
import org.apache.kylin.rest.service.QuerySmartSupporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Component;

@Component(value="rawRecService")
@Primary
public class RawRecService
extends BasicService
implements ModelChangeSupporter,
ProjectSmartSupporter,
QuerySmartSupporter {
    private static final Logger log = LoggerFactory.getLogger((String)"smart");
    @Autowired
    ProjectSmartService projectSmartService;
    @Autowired
    OptRecService optRecService;

    public static int recommendationSize(String project) {
        FavoriteRuleManager ruleManager = FavoriteRuleManager.getInstance((String)project);
        FavoriteRule favoriteRule = ruleManager.getOrDefaultByName("recommendations");
        FavoriteRule.Condition condition = (FavoriteRule.Condition)favoriteRule.getConds().get(0);
        return Integer.parseInt(condition.getRightThreshold());
    }

    public void accelerate(String project) {
        this.projectSmartService.accelerateImmediately(project);
        this.updateCostsAndTopNCandidates(project);
    }

    public void transferAndSaveRecommendations(AbstractContext proposeContext) {
        if (!(proposeContext instanceof ModelReuseContext)) {
            return;
        }
        proposeContext.setModelContexts(proposeContext.getModelContexts().stream().filter(modelContext -> modelContext.getOriginModel() != null).collect(Collectors.toList()));
        ModelReuseContext semiContextV2 = (ModelReuseContext)proposeContext;
        Map<String, RawRecItem> nonLayoutUniqueFlagRecMap = this.transferAndSaveModelRelatedRecItems(semiContextV2);
        this.transferToLayoutRecItemsAndSave(semiContextV2, (ArrayListMultimap<String, QueryHistory>)ArrayListMultimap.create(), nonLayoutUniqueFlagRecMap);
    }

    public void generateRawRecommendations(String project, List<QueryHistory> queryHistories) {
        if (CollectionUtils.isEmpty(queryHistories)) {
            return;
        }
        long startTime = System.currentTimeMillis();
        log.info("Semi-Auto-Mode project:{} generate suggestions by sqlList size: {}", (Object)project, (Object)queryHistories.size());
        ArrayList sqlList = Lists.newArrayList();
        ArrayListMultimap queryHistoryMap = ArrayListMultimap.create();
        queryHistories.forEach(arg_0 -> RawRecService.lambda$generateRawRecommendations$1(sqlList, (ListMultimap)queryHistoryMap, arg_0));
        KylinConfig projectConfig = NProjectManager.getProjectConfig((String)project);
        AbstractContext semiContextV2 = ProposerJob.propose(new ModelReuseContext(projectConfig, project, sqlList.toArray(new String[0])));
        Map<String, RawRecItem> nonLayoutRecItemMap = this.transferAndSaveModelRelatedRecItems(semiContextV2);
        ArrayListMultimap layoutToQHMap = ArrayListMultimap.create();
        for (AccelerateInfo accelerateInfo : semiContextV2.getAccelerateInfoMap().values()) {
            for (AccelerateInfo.QueryLayoutRelation layout : accelerateInfo.getRelatedLayouts()) {
                List queryHistoryList = queryHistoryMap.get((Object)layout.getSql());
                layoutToQHMap.putAll((Object)(layout.getModelId() + "_" + layout.getLayoutId()), (Iterable)queryHistoryList);
            }
        }
        this.transferToLayoutRecItemsAndSave(semiContextV2, (ArrayListMultimap<String, QueryHistory>)layoutToQHMap, nonLayoutRecItemMap);
        this.markFailAccelerateMessageToQueryHistory((ListMultimap<String, QueryHistory>)queryHistoryMap, semiContextV2);
        QueryRecStatsCollector.getInstance().doStatistics((ListMultimap<String, QueryHistory>)queryHistoryMap, nonLayoutRecItemMap, semiContextV2);
        log.info("Semi-Auto-Mode project:{} generate suggestions cost {}ms", (Object)project, (Object)(System.currentTimeMillis() - startTime));
    }

    private Map<String, RawRecItem> transferAndSaveModelRelatedRecItems(AbstractContext semiContext) {
        Map nonLayoutUniqueFlagRecMap = RawRecManager.getInstance((String)semiContext.getProject()).queryNonLayoutRecItems(null);
        List<RawRecItem> ccRawRecItems = this.transferToCCRawRecItemAndSave(semiContext, nonLayoutUniqueFlagRecMap);
        ccRawRecItems.forEach(recItem -> nonLayoutUniqueFlagRecMap.put(recItem.getUniqueFlag(), recItem));
        List<RawRecItem> dimensionRecItems = this.transferToDimensionRecItemsAndSave(semiContext, nonLayoutUniqueFlagRecMap);
        List<RawRecItem> measureRecItems = this.transferToMeasureRecItemsAndSave(semiContext, nonLayoutUniqueFlagRecMap);
        dimensionRecItems.forEach(recItem -> nonLayoutUniqueFlagRecMap.put(recItem.getUniqueFlag(), recItem));
        measureRecItems.forEach(recItem -> nonLayoutUniqueFlagRecMap.put(recItem.getUniqueFlag(), recItem));
        return nonLayoutUniqueFlagRecMap;
    }

    public void markFailAccelerateMessageToQueryHistory(ListMultimap<String, QueryHistory> queryHistoryMap, AbstractContext semiContextV2) {
        ArrayList idToQHInfoList = Lists.newArrayList();
        semiContextV2.getAccelerateInfoMap().forEach((sql, accelerateInfo) -> {
            if (!accelerateInfo.isNotSucceed()) {
                return;
            }
            queryHistoryMap.get(sql).forEach(qh -> {
                QueryHistoryInfo queryHistoryInfo = qh.getQueryHistoryInfo();
                if (queryHistoryInfo == null) {
                    queryHistoryInfo = new QueryHistoryInfo();
                }
                if (accelerateInfo.isFailed()) {
                    String failMessage;
                    Throwable cause = accelerateInfo.getFailedCause();
                    String string = failMessage = cause == null ? null : cause.getMessage();
                    if (failMessage != null && failMessage.length() > 256) {
                        failMessage = failMessage.substring(0, 256);
                    }
                    queryHistoryInfo.setErrorMsg(failMessage);
                } else if (accelerateInfo.isPending()) {
                    queryHistoryInfo.setErrorMsg(accelerateInfo.getPendingMsg());
                }
                idToQHInfoList.add(new Pair((Object)qh.getId(), (Object)queryHistoryInfo));
            });
        });
        RDBMSQueryHistoryDAO.getInstance().batchUpdateQueryHistoriesInfo((List)idToQHInfoList);
    }

    public void updateCostsAndTopNCandidates(String projectName) {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        ArrayList projectList = Lists.newArrayList();
        if (StringUtils.isEmpty((CharSequence)projectName)) {
            List instances = ((NProjectManager)this.getManager(NProjectManager.class)).listAllProjects().stream().filter(projectInstance -> !projectInstance.isExpertMode()).collect(Collectors.toList());
            projectList.addAll(instances);
        } else {
            ProjectInstance instance = ((NProjectManager)this.getManager(NProjectManager.class)).getProject(projectName);
            projectList.add(instance);
        }
        for (ProjectInstance projectInstance2 : projectList) {
            String project = projectInstance2.getName();
            if (projectInstance2.isExpertMode()) continue;
            try {
                log.info("Running update cost for project<{}>", (Object)project);
                RawRecManager rawRecManager = RawRecManager.getInstance((String)project);
                NDataModelManager modelManager = NDataModelManager.getInstance((KylinConfig)kylinConfig, (String)project);
                Set models = rawRecManager.updateAllCost(project);
                int topN = RawRecService.recommendationSize(project);
                HashSet needUpdateModels = Sets.newHashSet();
                for (String model : models) {
                    long current = System.currentTimeMillis();
                    NDataModel dataModel = modelManager.getDataModelDesc(model);
                    if (dataModel == null || dataModel.isBroken()) {
                        log.warn("Broken(or nonExist) model({}/{}) cannot update recommendations.", (Object)project, (Object)model);
                        continue;
                    }
                    log.info("Running update topN raw recommendation for model({}/{}).", (Object)project, (Object)model);
                    boolean recommendationCountChange = rawRecManager.updateRecommendedTopN(project, model, topN);
                    if (recommendationCountChange) {
                        needUpdateModels.add(model);
                    }
                    log.info("Update topN raw recommendations for model({}/{}) takes {} ms", new Object[]{project, model, System.currentTimeMillis() - current});
                }
                this.optRecService.updateRecommendationCount(project, needUpdateModels);
            }
            catch (Exception e) {
                log.error("Update cost and update topN failed for project({})", (Object)project, (Object)e);
            }
        }
    }

    public void onUpdate(String project, String modelId) {
        ProjectInstance prjInstance = ((NProjectManager)this.getManager(NProjectManager.class)).getProject(project);
        if (prjInstance.isSemiAutoMode()) {
            OptRecManagerV2.getInstance((String)project).loadOptRecV2(modelId);
            this.optRecService.updateRecommendationCount(project, modelId);
        }
    }

    public void onUpdateSingle(String project, String modelId) {
        this.optRecService.updateRecommendationCount(project, modelId);
    }

    public int getGaugeSize(String project, String modelId) {
        return this.optRecService.getOptRecLayoutsResponse(project, modelId, OptRecService.RecActionType.REMOVE_INDEX.name()).getSize();
    }

    public int getRecItemSize(String project, String modelId) {
        OptRecV2 optRecV2 = OptRecManagerV2.getInstance((String)project).loadOptRecV2(modelId);
        List<RawRecItem> rawRecItems = this.optRecService.getRecLayout(optRecV2, OptRecService.RecActionType.ALL);
        return CollectionUtils.isEmpty(rawRecItems) ? 0 : rawRecItems.size();
    }

    public void onUpdateCost(String project) {
        this.updateCostsAndTopNCandidates(project);
    }

    public int onShowSize(String project) {
        return RawRecService.recommendationSize(project);
    }

    public void onMatchQueryHistory(String project, List<QueryHistory> queries) {
        this.generateRawRecommendations(project, queries);
    }

    void transferToLayoutRecItemsAndSave(AbstractContext semiContextV2, ArrayListMultimap<String, QueryHistory> layoutToQHMap, Map<String, RawRecItem> nonLayoutUniqueFlagRecMap) {
        RawRecManager recManager = RawRecManager.getInstance((String)semiContextV2.getProject());
        String recSource = layoutToQHMap.isEmpty() ? "IMPORTED" : "QUERY_HISTORY";
        for (AbstractContext.ModelContext modelContext : semiContextV2.getModelContexts()) {
            NDataModel targetModel = modelContext.getTargetModel();
            if (targetModel == null) continue;
            Map layoutUniqueFlagRecMap = recManager.queryNonAppliedLayoutRawRecItems(targetModel.getUuid(), true);
            Map md5ToFlags = RawRecUtil.uniqueFlagsToMd5Map(layoutUniqueFlagRecMap.keySet());
            Set newCcUuids = modelContext.getCcRecItemMap().values().stream().map(item -> item.getCc().getUuid()).collect(Collectors.toSet());
            modelContext.getIndexRexItemMap().forEach((itemUUID, layoutItem) -> {
                layoutItem.updateLayoutContent(targetModel, nonLayoutUniqueFlagRecMap, newCcUuids);
                String content = RawRecUtil.getContent((String)semiContextV2.getProject(), (String)targetModel.getUuid(), (String)layoutItem.getUniqueContent(), (RawRecItem.RawRecType)RawRecItem.RawRecType.ADDITIONAL_LAYOUT);
                String md5 = RawRecUtil.computeMD5((String)content);
                AtomicBoolean retry = new AtomicBoolean(false);
                JdbcUtil.withTxAndRetry((DataSourceTransactionManager)recManager.getTransactionManager(), () -> {
                    RawRecItem recItem;
                    Pair recItemPair;
                    if (retry.get()) {
                        recItemPair = recManager.queryRecItemByMd5(md5, content);
                    } else {
                        retry.set(true);
                        recItemPair = RawRecUtil.getRawRecItemFromMap((String)md5, (String)content, (Map)md5ToFlags, (Map)layoutUniqueFlagRecMap);
                    }
                    if (recItemPair.getSecond() != null) {
                        recItem = (RawRecItem)recItemPair.getSecond();
                        recItem.setUpdateTime(System.currentTimeMillis());
                        recItem.restoreIfNeed();
                    } else {
                        recItem = new RawRecItem(semiContextV2.getProject(), targetModel.getUuid(), targetModel.getSemanticVersion(), RawRecItem.RawRecType.ADDITIONAL_LAYOUT);
                        recItem.setRecEntity((RecItemV2)layoutItem);
                        recItem.setCreateTime(layoutItem.getCreateTime());
                        recItem.setUpdateTime(layoutItem.getCreateTime());
                        recItem.setState(RawRecItem.RawRecState.INITIAL);
                        recItem.setUniqueFlag((String)recItemPair.getFirst());
                    }
                    recItem.setDependIDs(layoutItem.genDependIds());
                    recItem.setRecSource(recSource);
                    if (recSource.equalsIgnoreCase("IMPORTED")) {
                        recItem.cleanLayoutStatistics();
                        recItem.setState(RawRecItem.RawRecState.RECOMMENDED);
                    }
                    this.updateLayoutStatistic(recItem, (ListMultimap<String, QueryHistory>)layoutToQHMap, layoutItem.getLayout(), targetModel);
                    if (recItem.isAdditionalRecItemSavable()) {
                        recManager.saveOrUpdate(recItem);
                        nonLayoutUniqueFlagRecMap.put(layoutItem.getUniqueId(targetModel.getUuid()), recItem);
                    }
                    return null;
                });
            });
        }
    }

    private void updateLayoutStatistic(RawRecItem recItem, ListMultimap<String, QueryHistory> layoutToQHMap, LayoutEntity layout, NDataModel targetModel) {
        if (layoutToQHMap.isEmpty()) {
            return;
        }
        List queryHistories = layoutToQHMap.get((Object)(targetModel.getId() + "_" + layout.getId()));
        if (CollectionUtils.isEmpty((Collection)queryHistories)) {
            return;
        }
        LayoutMetric layoutMetric = recItem.getLayoutMetric();
        if (layoutMetric == null) {
            layoutMetric = new LayoutMetric(new FrequencyMap(), new LayoutMetric.LatencyMap());
        }
        LayoutMetric.LatencyMap latencyMap = layoutMetric.getLatencyMap();
        FrequencyMap frequencyMap = layoutMetric.getFrequencyMap();
        double totalTime = recItem.getTotalTime();
        double maxTime = recItem.getMaxTime();
        long minTime = Long.MAX_VALUE;
        int hitCount = recItem.getHitCount();
        for (QueryHistory qh : queryHistories) {
            ++hitCount;
            long duration = qh.getDuration();
            totalTime += (double)duration;
            if ((double)duration > maxTime) {
                maxTime = duration;
            }
            if (duration < minTime) {
                minTime = duration;
            }
            latencyMap.incLatency(qh.getQueryTime(), duration);
            frequencyMap.incFrequency(qh.getQueryTime());
        }
        recItem.setTotalTime(totalTime);
        recItem.setMaxTime(maxTime);
        recItem.setMinTime((double)minTime);
        recItem.setLayoutMetric(layoutMetric);
        recItem.setHitCount(hitCount);
    }

    private List<RawRecItem> transferToMeasureRecItemsAndSave(AbstractContext semiContextV2, Map<String, RawRecItem> nonLayoutUniqueFlagRecMap) {
        RawRecManager recManager = RawRecManager.getInstance((String)semiContextV2.getProject());
        ArrayList rawRecItems = Lists.newArrayList();
        Map md5ToFlags = RawRecUtil.uniqueFlagsToMd5Map(nonLayoutUniqueFlagRecMap.keySet());
        HashMap uuidToRecItemMap = new HashMap();
        nonLayoutUniqueFlagRecMap.values().forEach(recItem -> uuidToRecItemMap.put(recItem.getRecEntity().getUuid(), recItem));
        for (AbstractContext.ModelContext modelContext : semiContextV2.getModelContexts()) {
            if (modelContext.getTargetModel() == null) continue;
            modelContext.getMeasureRecItemMap().forEach((uniqueFlag, measureItem) -> {
                String content = RawRecUtil.getContent((String)semiContextV2.getProject(), (String)modelContext.getTargetModel().getUuid(), (String)measureItem.getUniqueContent(), (RawRecItem.RawRecType)RawRecItem.RawRecType.MEASURE);
                String md5 = RawRecUtil.computeMD5((String)content);
                AtomicBoolean retry = new AtomicBoolean(false);
                JdbcUtil.withTxAndRetry((DataSourceTransactionManager)recManager.getTransactionManager(), () -> {
                    RawRecItem item;
                    Pair recItemPair = null;
                    if (retry.get()) {
                        recItemPair = recManager.queryRecItemByMd5(md5, content);
                    } else {
                        retry.set(true);
                        recItemPair = RawRecUtil.getRawRecItemFromMap((String)md5, (String)content, (Map)md5ToFlags, (Map)nonLayoutUniqueFlagRecMap);
                    }
                    if (recItemPair.getSecond() != null) {
                        item = (RawRecItem)recItemPair.getSecond();
                        item.setUpdateTime(System.currentTimeMillis());
                    } else {
                        item = new RawRecItem(semiContextV2.getProject(), modelContext.getTargetModel().getUuid(), modelContext.getTargetModel().getSemanticVersion(), RawRecItem.RawRecType.MEASURE);
                        item.setUniqueFlag((String)recItemPair.getFirst());
                        item.setState(RawRecItem.RawRecState.INITIAL);
                        item.setCreateTime(measureItem.getCreateTime());
                        item.setUpdateTime(measureItem.getCreateTime());
                        item.setRecEntity((RecItemV2)measureItem);
                    }
                    item.setDependIDs(measureItem.genDependIds(uuidToRecItemMap, measureItem.getUniqueContent(), this.getOriginModel(semiContextV2.getProject(), modelContext)));
                    recManager.saveOrUpdate(item);
                    rawRecItems.add(item);
                    return null;
                });
            });
        }
        return rawRecItems;
    }

    private List<RawRecItem> transferToDimensionRecItemsAndSave(AbstractContext semiContextV2, Map<String, RawRecItem> uniqueRecItemMap) {
        RawRecManager recManager = RawRecManager.getInstance((String)semiContextV2.getProject());
        ArrayList rawRecItems = Lists.newArrayList();
        Map md5ToFlags = RawRecUtil.uniqueFlagsToMd5Map(uniqueRecItemMap.keySet());
        HashMap uuidToRecItemMap = new HashMap();
        uniqueRecItemMap.values().forEach(recItem -> uuidToRecItemMap.put(recItem.getRecEntity().getUuid(), recItem));
        for (AbstractContext.ModelContext modelContext : semiContextV2.getModelContexts()) {
            if (modelContext.getTargetModel() == null) continue;
            modelContext.getDimensionRecItemMap().forEach((uniqueFlag, dimItem) -> {
                String content = RawRecUtil.getContent((String)semiContextV2.getProject(), (String)modelContext.getTargetModel().getUuid(), (String)dimItem.getUniqueContent(), (RawRecItem.RawRecType)RawRecItem.RawRecType.DIMENSION);
                String md5 = RawRecUtil.computeMD5((String)content);
                AtomicBoolean retry = new AtomicBoolean(false);
                JdbcUtil.withTxAndRetry((DataSourceTransactionManager)recManager.getTransactionManager(), () -> {
                    RawRecItem item;
                    Pair recItemPair = null;
                    if (retry.get()) {
                        recItemPair = recManager.queryRecItemByMd5(md5, content);
                    } else {
                        retry.set(true);
                        recItemPair = RawRecUtil.getRawRecItemFromMap((String)md5, (String)content, (Map)md5ToFlags, (Map)uniqueRecItemMap);
                    }
                    if (recItemPair.getSecond() != null) {
                        item = (RawRecItem)recItemPair.getSecond();
                        item.setUpdateTime(System.currentTimeMillis());
                    } else {
                        item = new RawRecItem(semiContextV2.getProject(), modelContext.getTargetModel().getUuid(), modelContext.getTargetModel().getSemanticVersion(), RawRecItem.RawRecType.DIMENSION);
                        item.setUniqueFlag((String)recItemPair.getFirst());
                        item.setCreateTime(dimItem.getCreateTime());
                        item.setUpdateTime(dimItem.getCreateTime());
                        item.setState(RawRecItem.RawRecState.INITIAL);
                        item.setRecEntity((RecItemV2)dimItem);
                    }
                    item.setDependIDs(dimItem.genDependIds(uuidToRecItemMap, dimItem.getUniqueContent(), this.getOriginModel(semiContextV2.getProject(), modelContext)));
                    recManager.saveOrUpdate(item);
                    rawRecItems.add(item);
                    return null;
                });
            });
        }
        return rawRecItems;
    }

    private List<RawRecItem> transferToCCRawRecItemAndSave(AbstractContext semiContextV2, Map<String, RawRecItem> uniqueRecItemMap) {
        RawRecManager recManager = RawRecManager.getInstance((String)semiContextV2.getProject());
        ArrayList rawRecItems = Lists.newArrayList();
        Map md5ToFlags = RawRecUtil.uniqueFlagsToMd5Map(uniqueRecItemMap.keySet());
        for (AbstractContext.ModelContext modelContext : semiContextV2.getModelContexts()) {
            if (modelContext.getTargetModel() == null) continue;
            modelContext.getCcRecItemMap().forEach((uniqueFlag, ccItem) -> {
                String content = RawRecUtil.getContent((String)semiContextV2.getProject(), (String)modelContext.getTargetModel().getUuid(), (String)ccItem.getUniqueContent(), (RawRecItem.RawRecType)RawRecItem.RawRecType.COMPUTED_COLUMN);
                String md5 = RawRecUtil.computeMD5((String)content);
                AtomicBoolean retry = new AtomicBoolean(false);
                JdbcUtil.withTxAndRetry((DataSourceTransactionManager)recManager.getTransactionManager(), () -> {
                    RawRecItem item;
                    Pair recItemPair = null;
                    if (retry.get()) {
                        recItemPair = recManager.queryRecItemByMd5(md5, content);
                    } else {
                        retry.set(true);
                        recItemPair = RawRecUtil.getRawRecItemFromMap((String)md5, (String)content, (Map)md5ToFlags, (Map)uniqueRecItemMap);
                    }
                    if (recItemPair.getSecond() != null) {
                        item = (RawRecItem)recItemPair.getSecond();
                        item.setUpdateTime(System.currentTimeMillis());
                    } else {
                        item = new RawRecItem(semiContextV2.getProject(), modelContext.getTargetModel().getUuid(), modelContext.getTargetModel().getSemanticVersion(), RawRecItem.RawRecType.COMPUTED_COLUMN);
                        item.setCreateTime(ccItem.getCreateTime());
                        item.setUpdateTime(ccItem.getCreateTime());
                        item.setUniqueFlag((String)recItemPair.getFirst());
                        item.setRecEntity((RecItemV2)ccItem);
                        item.setState(RawRecItem.RawRecState.INITIAL);
                    }
                    item.setDependIDs(ccItem.genDependIds(this.getOriginModel(semiContextV2.getProject(), modelContext)));
                    recManager.saveOrUpdate(item);
                    rawRecItems.add(item);
                    return null;
                });
            });
        }
        return rawRecItems;
    }

    private NDataModel getOriginModel(String project, AbstractContext.ModelContext modelContext) {
        NDataModelManager modelManager = NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        return modelContext.getOriginModel().getJoinTables().size() == modelContext.getTargetModel().getJoinTables().size() ? modelContext.getOriginModel() : modelManager.getDataModelDesc(modelContext.getOriginModel().getUuid());
    }

    private static /* synthetic */ void lambda$generateRawRecommendations$1(List sqlList, ListMultimap queryHistoryMap, QueryHistory queryHistory) {
        QueryHistorySql queryHistorySql = queryHistory.getQueryHistorySql();
        String normalizedSql = queryHistorySql.getNormalizedSql();
        sqlList.add(normalizedSql);
        queryHistoryMap.put((Object)normalizedSql, (Object)queryHistory);
    }
}

