/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.query;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.NativeQueryRealization;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.model.FusionModelManager;
import org.apache.kylin.metadata.query.QueryHistoryInfo;
import org.apache.kylin.metadata.query.QueryHistorySql;
import org.apache.kylin.metadata.query.QueryMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryHistory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueryHistory.class);
    public static final String ADJ_SLOW = "Slow";
    public static final String QUERY_HISTORY_SUCCEEDED = "SUCCEEDED";
    public static final String QUERY_HISTORY_FAILED = "FAILED";
    public static final String DEFAULT_DATABASE = "KYLIN_HISTORY";
    public static final String DB_NAME = "KYLIN_HISTORY";
    public static final String QUERY_MEASUREMENT_SURFIX = "query_history";
    public static final String REALIZATION_MEASUREMENT_SURFIX = "query_history_realization";
    public static final String QUERY_HISTORY_ID = "id";
    public static final String QUERY_HISTORY_INFO = "query_history_info";
    public static final String QUERY_REALIZATIONS_METRICS = "realization_metrics";
    public static final String PROJECT_NAME = "project_name";
    public static final String QUERY_ID = "query_id";
    public static final String SQL_TEXT = "sql_text";
    public static final String SQL_PATTERN = "sql_pattern";
    public static final String QUERY_DURATION = "duration";
    public static final String CPU_TIME = "cpu_time";
    public static final String TOTAL_SCAN_BYTES = "total_scan_bytes";
    public static final String TOTAL_SCAN_COUNT = "total_scan_count";
    public static final String RESULT_ROW_COUNT = "result_row_count";
    public static final String SUBMITTER = "submitter";
    public static final String REALIZATIONS = "realizations";
    public static final String QUERY_SERVER = "server";
    public static final String SUITE = "suite";
    public static final String ERROR_TYPE = "error_type";
    public static final String ENGINE_TYPE = "engine_type";
    public static final String IS_CACHE_HIT = "cache_hit";
    public static final String QUERY_STATUS = "query_status";
    public static final String IS_INDEX_HIT = "index_hit";
    public static final String QUERY_TIME = "query_time";
    public static final String MONTH = "month";
    public static final String QUERY_FIRST_DAY_OF_MONTH = "query_first_day_of_month";
    public static final String QUERY_FIRST_DAY_OF_WEEK = "query_first_day_of_week";
    public static final String QUERY_DAY = "query_day";
    public static final String IS_TABLE_INDEX_USED = "is_table_index_used";
    public static final String IS_AGG_INDEX_USED = "is_agg_index_used";
    public static final String IS_TABLE_SNAPSHOT_USED = "is_table_snapshot_used";
    public static final String RESERVED_FIELD_3 = "reserved_field_3";
    public static final String MODEL = "model";
    public static final String LAYOUT_ID = "layout_id";
    public static final String INDEX_TYPE = "index_type";
    public static final String SYNTAX_ERROR = "Syntax error";
    public static final String NO_REALIZATION_FOUND_ERROR = "No realization found";
    public static final String NOT_SUPPORTED_SQL_BY_OLAP_ERROR = "Not Supported By OLAP SQL";
    public static final String OTHER_ERROR = "Other error";
    public static final String USER_STOP_QUERY_ERROR = "Stopped By User";
    @JsonProperty(value="sql_text")
    private String sql;
    @JsonProperty(value="sql_pattern")
    private String sqlPattern;
    @JsonProperty(value="query_time")
    private long queryTime;
    @JsonProperty(value="duration")
    private long duration;
    @JsonProperty(value="cpu_time")
    private Long cpuTime;
    private String queryRealizations;
    @JsonProperty(value="server")
    private String hostName;
    @JsonProperty(value="submitter")
    private String querySubmitter;
    @JsonProperty(value="query_status")
    private String queryStatus;
    @JsonProperty(value="query_id")
    private String queryId;
    @JsonProperty(value="id")
    private long id;
    @JsonProperty(value="total_scan_count")
    private long totalScanCount;
    @JsonProperty(value="total_scan_bytes")
    private long totalScanBytes;
    @JsonProperty(value="result_row_count")
    private long resultRowCount;
    @JsonProperty(value="cache_hit")
    private boolean cacheHit;
    @JsonProperty(value="index_hit")
    private boolean indexHit;
    @JsonProperty(value="engine_type")
    private String engineType;
    @JsonProperty(value="project_name")
    private String projectName;
    @JsonProperty(value="realizations")
    private List<NativeQueryRealization> nativeQueryRealizations;
    private int count;
    @JsonProperty(value="error_type")
    private String errorType;
    @JsonProperty(value="query_history_info")
    private QueryHistoryInfo queryHistoryInfo;
    private transient long insertTime;

    public QueryHistory() {
    }

    public QueryHistory(String sqlPattern, String queryStatus, String querySubmitter, long queryTime, long duration) {
        this.sqlPattern = sqlPattern;
        this.queryStatus = queryStatus;
        this.querySubmitter = querySubmitter;
        this.queryTime = queryTime;
        this.duration = duration;
    }

    public QueryHistory(String sql) {
        this.sql = sql;
    }

    public QueryHistorySql getQueryHistorySql() {
        if (JsonUtil.isJson((String)this.sql)) {
            try {
                QueryHistorySql ret = (QueryHistorySql)JsonUtil.readValue((String)this.sql, QueryHistorySql.class);
                if (StringUtils.isBlank((CharSequence)ret.getNormalizedSql())) {
                    ret.setNormalizedSql(this.sqlPattern);
                }
                return ret;
            }
            catch (IOException e) {
                log.error("Convert sql json string failed", (Throwable)e);
            }
        }
        return new QueryHistorySql(this.sql, this.sql, null);
    }

    public boolean isException() {
        return this.queryStatus.equals(QUERY_HISTORY_FAILED);
    }

    public List<NativeQueryRealization> transformRealizations(String project) {
        ArrayList realizations = Lists.newArrayList();
        if (this.queryHistoryInfo == null || this.queryHistoryInfo.getRealizationMetrics() == null || this.queryHistoryInfo.getRealizationMetrics().isEmpty()) {
            return this.transformStringRealizations();
        }
        List<QueryMetrics.RealizationMetrics> realizationMetrics = this.queryHistoryInfo.realizationMetrics;
        FusionModelManager fusionModelManager = FusionModelManager.getInstance(KylinConfig.getInstanceFromEnv(), project);
        for (QueryMetrics.RealizationMetrics metrics : realizationMetrics) {
            NativeQueryRealization realization = new NativeQueryRealization(metrics.modelId, metrics.layoutId == null || metrics.layoutId.equals("null") ? null : Long.valueOf(Long.parseLong(metrics.layoutId)), metrics.indexType == null || metrics.indexType.equals("null") ? null : metrics.indexType, (List)(metrics.snapshots == null || metrics.snapshots.isEmpty() ? Lists.newArrayList() : metrics.snapshots));
            realization.setStreamingLayout(metrics.isStreamingLayout);
            String modelId = fusionModelManager.getModelId(realization);
            realization.setModelId(modelId);
            realizations.add(realization);
        }
        return realizations;
    }

    public List<NativeQueryRealization> transformStringRealizations() {
        ArrayList realizations = Lists.newArrayList();
        if (StringUtils.isEmpty((CharSequence)this.queryRealizations)) {
            return realizations;
        }
        Pattern p = Pattern.compile("\\[.*?\\]+");
        String[] queryRealizations = p.matcher(this.queryRealizations).find() ? this.queryRealizations.split(";") : this.queryRealizations.split(",");
        for (String realization : queryRealizations) {
            String[] info = realization.split("#");
            this.transformStringRealizations(info, realizations);
        }
        return realizations;
    }

    private void transformStringRealizations(String[] info, List<NativeQueryRealization> realizations) {
        ArrayList snapshots = Lists.newArrayList();
        if (info.length > 3) {
            if (!info[3].equals("[]")) {
                snapshots.addAll(Lists.newArrayList((Object[])info[3].substring(1, info[3].length() - 1).split(",\\s*")));
            }
            realizations.add(new NativeQueryRealization(info[0], info[1].equalsIgnoreCase("null") ? null : Long.valueOf(Long.parseLong(info[1])), info[2].equalsIgnoreCase("null") ? null : info[2], (List)(info[3].equalsIgnoreCase("null") ? null : snapshots)));
        } else {
            realizations.add(new NativeQueryRealization(info[0], info[1].equalsIgnoreCase("null") ? null : Long.valueOf(Long.parseLong(info[1])), info[2].equalsIgnoreCase("null") ? null : info[2], (List)snapshots));
        }
    }

    public void setQueryHistoryInfo(QueryHistoryInfo info) {
        this.queryHistoryInfo = info;
        if (info == null || info.getQueryMetrics() == null) {
            return;
        }
        for (QueryMetrics.QueryMetric queryMetric : this.queryHistoryInfo.getQueryMetrics()) {
            if (!CPU_TIME.equals(queryMetric.getName())) continue;
            this.cpuTime = Long.parseLong(queryMetric.getValue().toString());
        }
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Generated
    public String getSqlPattern() {
        return this.sqlPattern;
    }

    @Generated
    public long getQueryTime() {
        return this.queryTime;
    }

    @Generated
    public long getDuration() {
        return this.duration;
    }

    @Generated
    public Long getCpuTime() {
        return this.cpuTime;
    }

    @Generated
    public String getQueryRealizations() {
        return this.queryRealizations;
    }

    @Generated
    public String getHostName() {
        return this.hostName;
    }

    @Generated
    public String getQuerySubmitter() {
        return this.querySubmitter;
    }

    @Generated
    public String getQueryStatus() {
        return this.queryStatus;
    }

    @Generated
    public String getQueryId() {
        return this.queryId;
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public long getTotalScanCount() {
        return this.totalScanCount;
    }

    @Generated
    public long getTotalScanBytes() {
        return this.totalScanBytes;
    }

    @Generated
    public long getResultRowCount() {
        return this.resultRowCount;
    }

    @Generated
    public boolean isCacheHit() {
        return this.cacheHit;
    }

    @Generated
    public boolean isIndexHit() {
        return this.indexHit;
    }

    @Generated
    public String getEngineType() {
        return this.engineType;
    }

    @Generated
    public String getProjectName() {
        return this.projectName;
    }

    @Generated
    public List<NativeQueryRealization> getNativeQueryRealizations() {
        return this.nativeQueryRealizations;
    }

    @Generated
    public int getCount() {
        return this.count;
    }

    @Generated
    public String getErrorType() {
        return this.errorType;
    }

    @Generated
    public QueryHistoryInfo getQueryHistoryInfo() {
        return this.queryHistoryInfo;
    }

    @Generated
    public long getInsertTime() {
        return this.insertTime;
    }

    @Generated
    public void setSql(String sql) {
        this.sql = sql;
    }

    @Generated
    public void setSqlPattern(String sqlPattern) {
        this.sqlPattern = sqlPattern;
    }

    @Generated
    public void setQueryTime(long queryTime) {
        this.queryTime = queryTime;
    }

    @Generated
    public void setDuration(long duration) {
        this.duration = duration;
    }

    @Generated
    public void setCpuTime(Long cpuTime) {
        this.cpuTime = cpuTime;
    }

    @Generated
    public void setQueryRealizations(String queryRealizations) {
        this.queryRealizations = queryRealizations;
    }

    @Generated
    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    @Generated
    public void setQuerySubmitter(String querySubmitter) {
        this.querySubmitter = querySubmitter;
    }

    @Generated
    public void setQueryStatus(String queryStatus) {
        this.queryStatus = queryStatus;
    }

    @Generated
    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    @Generated
    public void setId(long id) {
        this.id = id;
    }

    @Generated
    public void setTotalScanCount(long totalScanCount) {
        this.totalScanCount = totalScanCount;
    }

    @Generated
    public void setTotalScanBytes(long totalScanBytes) {
        this.totalScanBytes = totalScanBytes;
    }

    @Generated
    public void setResultRowCount(long resultRowCount) {
        this.resultRowCount = resultRowCount;
    }

    @Generated
    public void setCacheHit(boolean cacheHit) {
        this.cacheHit = cacheHit;
    }

    @Generated
    public void setIndexHit(boolean indexHit) {
        this.indexHit = indexHit;
    }

    @Generated
    public void setEngineType(String engineType) {
        this.engineType = engineType;
    }

    @Generated
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Generated
    public void setNativeQueryRealizations(List<NativeQueryRealization> nativeQueryRealizations) {
        this.nativeQueryRealizations = nativeQueryRealizations;
    }

    @Generated
    public void setCount(int count) {
        this.count = count;
    }

    @Generated
    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    @Generated
    public void setInsertTime(long insertTime) {
        this.insertTime = insertTime;
    }

    public static enum CacheType {
        EHCACHE,
        REDIS;

    }

    public static enum EngineType {
        NATIVE,
        CONSTANTS,
        RDBMS,
        HIVE;

    }
}

