/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.query;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import lombok.Generated;

public class QueryStatistics {
    @JsonProperty(value="engine_type")
    private String engineType;
    @JsonProperty(value="count")
    private long count;
    @JsonProperty(value="ratio")
    private double ratio;
    @JsonProperty(value="mean")
    private double meanDuration;
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="time")
    private Instant time;
    @JsonProperty(value="month")
    private String month;

    public QueryStatistics(String engineType) {
        this.engineType = engineType;
    }

    public void apply(QueryStatistics other) {
        this.count = other.count;
        this.ratio = other.ratio;
        this.meanDuration = other.meanDuration;
    }

    public void updateRatio(double amount) {
        if (amount > 0.0) {
            this.ratio = (double)Math.round((double)this.count / amount * 100.0) / 100.0;
        }
    }

    @Generated
    public String getEngineType() {
        return this.engineType;
    }

    @Generated
    public long getCount() {
        return this.count;
    }

    @Generated
    public double getRatio() {
        return this.ratio;
    }

    @Generated
    public double getMeanDuration() {
        return this.meanDuration;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public Instant getTime() {
        return this.time;
    }

    @Generated
    public String getMonth() {
        return this.month;
    }

    @Generated
    public void setEngineType(String engineType) {
        this.engineType = engineType;
    }

    @Generated
    public void setCount(long count) {
        this.count = count;
    }

    @Generated
    public void setRatio(double ratio) {
        this.ratio = ratio;
    }

    @Generated
    public void setMeanDuration(double meanDuration) {
        this.meanDuration = meanDuration;
    }

    @Generated
    public void setModel(String model) {
        this.model = model;
    }

    @Generated
    public void setTime(Instant time) {
        this.time = time;
    }

    @Generated
    public void setMonth(String month) {
        this.month = month;
    }

    @Generated
    public QueryStatistics() {
    }
}

