/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.recommendation.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.type.JdbcType;
import org.apache.kylin.common.Singletons;
import org.apache.kylin.common.logging.LogOutputStream;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.metadata.recommendation.candidate.RawRecItemMapper;
import org.mybatis.spring.transaction.SpringManagedTransactionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class RawRecStoreUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RawRecStoreUtil.class);
    private static final Charset DEFAULT_CHARSET = Charset.defaultCharset();
    public static final String CREATE_REC_TABLE = "create.rawrecommendation.store.table";
    public static final String CREATE_INDEX = "create.rawrecommendation.store.index";
    private static final String ADD_MVCC_COLUMN_SQL = "alter table %s add mvcc bigint";

    private RawRecStoreUtil() {
    }

    public static SqlSessionFactory getSqlSessionFactory(DataSource dataSource, String tableName) {
        return (SqlSessionFactory)Singletons.getInstance((String)"raw-recommendation-sql-session-factory", SqlSessionFactory.class, clz -> {
            log.info("Start to build SqlSessionFactory");
            SpringManagedTransactionFactory transactionFactory = new SpringManagedTransactionFactory();
            Environment environment = new Environment("raw recommendation", (TransactionFactory)transactionFactory, dataSource);
            Configuration configuration = new Configuration(environment);
            configuration.setUseGeneratedKeys(true);
            configuration.setJdbcTypeForNull(JdbcType.NULL);
            configuration.addMapper(RawRecItemMapper.class);
            RawRecStoreUtil.createTableIfNotExist((BasicDataSource)dataSource, tableName);
            return new SqlSessionFactoryBuilder().build(configuration);
        });
    }

    private static void createTableIfNotExist(BasicDataSource dataSource, String tableName) throws IOException, SQLException {
        if (JdbcUtil.isTableExists((Connection)dataSource.getConnection(), (String)tableName)) {
            log.info("{} already existed in database", (Object)tableName);
            if (!RawRecStoreUtil.hasMvccColumn(dataSource, tableName)) {
                log.info("Table {} does not have 'mvcc' column, try to add.", (Object)tableName);
                RawRecStoreUtil.addMvccColumn(dataSource, tableName);
            }
            return;
        }
        Properties properties = JdbcUtil.getProperties((BasicDataSource)dataSource);
        String createTableStmt = String.format(Locale.ROOT, properties.getProperty(CREATE_REC_TABLE), tableName);
        String crateIndexStmt = String.format(Locale.ROOT, properties.getProperty(CREATE_INDEX), tableName, tableName);
        try (Connection connection = dataSource.getConnection();){
            ScriptRunner sr = new ScriptRunner(connection);
            sr.setLogWriter(new PrintWriter(new OutputStreamWriter((OutputStream)new LogOutputStream(log), DEFAULT_CHARSET)));
            log.debug("start to create table({})", (Object)tableName);
            sr.runScript((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(createTableStmt.getBytes(DEFAULT_CHARSET)), DEFAULT_CHARSET));
            log.debug("create table finished");
            sr.runScript((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(crateIndexStmt.getBytes(DEFAULT_CHARSET)), DEFAULT_CHARSET));
        }
        if (!JdbcUtil.isTableExists((Connection)dataSource.getConnection(), (String)tableName)) {
            log.debug("failed to create table({})", (Object)tableName);
            throw new IllegalStateException(String.format(Locale.ROOT, "create table(%s) failed", tableName));
        }
        log.debug("table({}) already exists.", (Object)tableName);
    }

    private static boolean hasMvccColumn(BasicDataSource dataSource, String tableName) throws SQLException {
        return JdbcUtil.isColumnExists((Connection)dataSource.getConnection(), (String)tableName, (String)"mvcc");
    }

    private static void addMvccColumn(BasicDataSource dataSource, String tableName) {
        String addColumnSql = String.format(Locale.ROOT, ADD_MVCC_COLUMN_SQL, tableName);
        try {
            JdbcTemplate jdbcTemplate = new JdbcTemplate((DataSource)dataSource);
            jdbcTemplate.execute(addColumnSql);
            log.debug("Add 'mvcc' column to table {} succeed.", (Object)tableName);
        }
        catch (Throwable t) {
            log.error("Add 'mvcc' column to table " + tableName + " failed. The column might already exist?", t);
        }
    }
}

