/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.usergroup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RawResourceFilter;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.metadata.usergroup.UserGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NUserGroupManager {
    private static final Logger logger = LoggerFactory.getLogger(NUserGroupManager.class);
    private KylinConfig config;
    private CachedCrudAssist<UserGroup> crud;

    public static NUserGroupManager getInstance(KylinConfig config) {
        return (NUserGroupManager)config.getManager(NUserGroupManager.class);
    }

    static NUserGroupManager newInstance(KylinConfig config) {
        return new NUserGroupManager(config);
    }

    public NUserGroupManager(KylinConfig config) {
        if (!UnitOfWork.isAlreadyInTransaction()) {
            logger.info("Initializing NUserGroupManager with KylinConfig Id: {}", (Object)System.identityHashCode(config));
        }
        this.config = config;
        this.crud = new CachedCrudAssist<UserGroup>(this.getStore(), MetadataType.USER_GROUP, null, UserGroup.class){

            @Override
            protected UserGroup initEntityAfterReload(UserGroup userGroup, String resourceName) {
                return userGroup;
            }
        };
    }

    public ResourceStore getStore() {
        return ResourceStore.getKylinMetaStore((KylinConfig)this.config);
    }

    public List<String> getAllGroupNames() {
        NavigableSet userGroups = this.getStore().listResources(MetadataType.USER_GROUP.name());
        if (Objects.isNull(userGroups)) {
            return Collections.emptyList();
        }
        return userGroups.stream().map(path -> {
            String[] pathArray = StringUtils.split((String)path, (String)"/");
            return pathArray[pathArray.length - 1];
        }).collect(Collectors.toList());
    }

    public List<UserGroup> getAllGroups() {
        return ImmutableList.copyOf(this.crud.listAll());
    }

    public List<UserGroup> getGroupsByName(String groupName, boolean isFuzzy) {
        RawResourceFilter filter = RawResourceFilter.simpleFilter((RawResourceFilter.Operator)(isFuzzy ? RawResourceFilter.Operator.LIKE_CASE_INSENSITIVE : RawResourceFilter.Operator.EQUAL_CASE_INSENSITIVE), (String)"groupName", (Object)groupName);
        return ImmutableList.copyOf(this.crud.listByFilter(filter));
    }

    public boolean exists(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return false;
        }
        return Objects.nonNull((Object)this.crud.get(name));
    }

    public UserGroup copyForWrite(UserGroup userGroup) {
        return this.crud.copyForWrite(userGroup);
    }

    @VisibleForTesting
    public String getRealUserGroupByName(String groupName) {
        for (String name : this.getAllGroupNames()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)groupName)) continue;
            return name;
        }
        return null;
    }

    public List<String> getRealUserGroupByNames(List<String> names) {
        ArrayList result = Lists.newArrayList();
        List<String> allGroups = this.getAllGroupNames();
        block0: for (String tmp : names) {
            for (String name : allGroups) {
                if (!StringUtils.endsWithIgnoreCase((CharSequence)tmp, (CharSequence)name)) continue;
                result.add(tmp);
                continue block0;
            }
        }
        return result;
    }

    public void batchAdd(List<String> names) {
        List<String> realGroups = this.getRealUserGroupByNames(names);
        if (realGroups.size() > 0) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.DUPLICATE_USERGROUP_NAME, String.format(Locale.ROOT, MsgPicker.getMsg().getUserGroupExist(), String.join((CharSequence)",", realGroups)));
        }
        for (String name : names) {
            UserGroup userGroup = this.copyForWrite(new UserGroup(name));
            this.crud.save(userGroup);
        }
    }

    public void add(String name) {
        String realGroupName = this.getRealUserGroupByName(name);
        if (StringUtils.isNotEmpty((CharSequence)realGroupName)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.DUPLICATE_USERGROUP_NAME, String.format(Locale.ROOT, MsgPicker.getMsg().getUserGroupExist(), realGroupName));
        }
        UserGroup userGroup = this.copyForWrite(new UserGroup(name));
        this.crud.save(userGroup);
    }

    public void delete(String name) {
        String realGroupName = this.getRealUserGroupByName(name);
        if (StringUtils.isEmpty((CharSequence)realGroupName)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.USERGROUP_NOT_EXIST, String.format(Locale.ROOT, MsgPicker.getMsg().getUserGroupNotExist(), name));
        }
        this.crud.delete(realGroupName);
    }
}

