/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.springframework.security.acls.model.Permission;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class UserAcl
extends RootPersistentEntity {
    @JsonProperty
    private String username;
    @JsonProperty(value="permissions")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Set<Integer> permissionMasks = Collections.emptySet();
    @JsonProperty(value="data_query_projects")
    private List<String> dataQueryProjects;

    public UserAcl() {
    }

    public UserAcl(String username) {
        this(username, Collections.emptySet());
    }

    public UserAcl(String username, Set<Permission> permissions) {
        this.username = username;
        if (!CollectionUtils.isEmpty(permissions)) {
            this.permissionMasks = permissions.stream().map(Permission::getMask).collect(Collectors.toSet());
        }
    }

    public void addPermission(Integer permissionMask) {
        if (CollectionUtils.isEmpty(this.permissionMasks)) {
            this.permissionMasks = new HashSet<Integer>();
        }
        this.permissionMasks.add(permissionMask);
    }

    public void addPermission(Permission permission) {
        this.addPermission(permission.getMask());
    }

    public void addDataQueryProject(String project) {
        if (StringUtils.isEmpty((CharSequence)project)) {
            return;
        }
        if (CollectionUtils.isEmpty(this.dataQueryProjects)) {
            this.dataQueryProjects = new ArrayList<String>();
        }
        if (!this.dataQueryProjects.contains(project)) {
            this.dataQueryProjects.add(project);
        }
    }

    public void deletePermission(Integer permissionMask) {
        if (CollectionUtils.isNotEmpty(this.permissionMasks)) {
            this.permissionMasks.remove(permissionMask);
        }
    }

    public void deleteDataQueryProject(String project) {
        if (StringUtils.isEmpty((CharSequence)project) || CollectionUtils.isEmpty(this.dataQueryProjects)) {
            return;
        }
        this.dataQueryProjects.remove(project);
    }

    public void deletePermission(Permission permission) {
        this.deletePermission(permission.getMask());
    }

    public Set<Integer> getPermissionMasks() {
        return this.permissionMasks;
    }

    public boolean hasPermission(Permission permission) {
        return this.hasPermission(permission.getMask());
    }

    public boolean hasPermission(Integer permissionMask) {
        return CollectionUtils.isNotEmpty(this.permissionMasks) && this.permissionMasks.contains(permissionMask);
    }

    public String resourceName() {
        return this.username;
    }

    public MetadataType resourceType() {
        return MetadataType.USER_GLOBAL_ACL;
    }

    public int hashCode() {
        return 31 + (Objects.isNull(this.username) ? 0 : this.username.hashCode());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        UserAcl other = (UserAcl)((Object)obj);
        return Objects.equals(this.username, other.username);
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public List<String> getDataQueryProjects() {
        return this.dataQueryProjects;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPermissionMasks(Set<Integer> permissionMasks) {
        this.permissionMasks = permissionMasks;
    }

    @Generated
    public void setDataQueryProjects(List<String> dataQueryProjects) {
        this.dataQueryProjects = dataQueryProjects;
    }
}

