/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCallBinding;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.MappingType;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.Nullable;

@API(since="1.24", status=API.Status.INTERNAL)
class EnumerableTraitsUtils {
    private EnumerableTraitsUtils() {
    }

    private static boolean isCollationOnTrivialExpr(List<RexNode> projects, RelDataTypeFactory typeFactory, Mappings.TargetMapping map, RelFieldCollation fc, boolean passDown) {
        RexNode node;
        int index = fc.getFieldIndex();
        int target = map.getTargetOpt(index);
        if (target < 0) {
            return false;
        }
        RexNode rexNode = node = passDown ? projects.get(index) : projects.get(target);
        if (node.isA(SqlKind.CAST)) {
            RexCall cast = (RexCall)node;
            RelFieldCollation newFieldCollation = Objects.requireNonNull(RexUtil.apply(map, fc));
            RexCallBinding binding = RexCallBinding.create(typeFactory, cast, (List<RelCollation>)ImmutableList.of((Object)RelCollations.of(newFieldCollation)));
            if (cast.getOperator().getMonotonicity(binding) == SqlMonotonicity.NOT_MONOTONIC) {
                return false;
            }
        }
        return true;
    }

    static @Nullable Pair<RelTraitSet, List<RelTraitSet>> passThroughTraitsForProject(RelTraitSet required, List<RexNode> exps, RelDataType inputRowType, RelDataTypeFactory typeFactory, RelTraitSet currentTraits) {
        Object collation = required.getCollation();
        if (collation == null || collation == RelCollations.EMPTY) {
            return null;
        }
        Mappings.TargetMapping map = RelOptUtil.permutationIgnoreCast(exps, inputRowType);
        if (collation.getFieldCollations().stream().anyMatch(rc -> !EnumerableTraitsUtils.isCollationOnTrivialExpr(exps, typeFactory, map, rc, true))) {
            return null;
        }
        RelCollation newCollation = (RelCollation)collation.apply(map);
        return Pair.of(currentTraits.replace((RelTrait)collation), ImmutableList.of((Object)currentTraits.replace(newCollation)));
    }

    static @Nullable Pair<RelTraitSet, List<RelTraitSet>> deriveTraitsForProject(RelTraitSet childTraits, int childId, List<RexNode> exps, RelDataType inputRowType, RelDataTypeFactory typeFactory, RelTraitSet currentTraits) {
        RelFieldCollation rc;
        Object node2;
        Object collation = childTraits.getCollation();
        if (collation == null || collation == RelCollations.EMPTY) {
            return null;
        }
        int maxField = Math.max(exps.size(), inputRowType.getFieldCount());
        Mapping mapping = Mappings.create(MappingType.FUNCTION, maxField, maxField);
        for (Object node2 : Ord.zip(exps)) {
            RexNode operand;
            if (((Ord)node2).e instanceof RexInputRef) {
                mapping.set(((RexInputRef)((Ord)node2).e).getIndex(), ((Ord)node2).i);
                continue;
            }
            if (!((RexNode)((Ord)node2).e).isA(SqlKind.CAST) || !((operand = ((RexCall)((Ord)node2).e).getOperands().get(0)) instanceof RexInputRef)) continue;
            mapping.set(((RexInputRef)operand).getIndex(), ((Ord)node2).i);
        }
        ArrayList<RelFieldCollation> collationFieldsToDerive = new ArrayList<RelFieldCollation>();
        node2 = collation.getFieldCollations().iterator();
        while (node2.hasNext() && EnumerableTraitsUtils.isCollationOnTrivialExpr(exps, typeFactory, mapping, rc = (RelFieldCollation)node2.next(), false)) {
            collationFieldsToDerive.add(rc);
        }
        if (collationFieldsToDerive.size() > 0) {
            RelCollation newCollation = (RelCollation)RelCollations.of(collationFieldsToDerive).apply(mapping);
            return Pair.of(currentTraits.replace(newCollation), ImmutableList.of((Object)currentTraits.replace((RelTrait)collation)));
        }
        return null;
    }

    static @Nullable Pair<RelTraitSet, List<RelTraitSet>> passThroughTraitsForJoin(RelTraitSet required, JoinRelType joinType, int leftInputFieldCount, RelTraitSet joinTraitSet) {
        Object collation = required.getCollation();
        if (collation == null || collation == RelCollations.EMPTY || joinType == JoinRelType.FULL || joinType == JoinRelType.RIGHT) {
            return null;
        }
        for (RelFieldCollation fc : collation.getFieldCollations()) {
            if (fc.getFieldIndex() < leftInputFieldCount) continue;
            return null;
        }
        RelTraitSet passthroughTraitSet = joinTraitSet.replace((RelTrait)collation);
        return Pair.of(passthroughTraitSet, ImmutableList.of((Object)passthroughTraitSet, (Object)passthroughTraitSet.replace(RelCollations.EMPTY)));
    }

    static @Nullable Pair<RelTraitSet, List<RelTraitSet>> deriveTraitsForJoin(RelTraitSet childTraits, int childId, JoinRelType joinType, RelTraitSet joinTraitSet, RelTraitSet rightTraitSet) {
        assert (childId == 0);
        Object collation = childTraits.getCollation();
        if (collation == null || collation == RelCollations.EMPTY || joinType == JoinRelType.FULL || joinType == JoinRelType.RIGHT) {
            return null;
        }
        RelTraitSet derivedTraits = joinTraitSet.replace((RelTrait)collation);
        return Pair.of(derivedTraits, ImmutableList.of((Object)derivedTraits, (Object)rightTraitSet));
    }
}

