/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.TimeZone;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.delta.DeltaColumnMapping$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.SerializableFileStatus;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.AddFile$;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor;
import org.apache.spark.sql.delta.commands.ConvertTargetFile;
import org.apache.spark.sql.delta.commands.ConvertTargetTable;
import org.apache.spark.sql.delta.commands.ConvertToDeltaCommand$;
import org.apache.spark.sql.delta.commands.ParquetTable;
import org.apache.spark.sql.delta.commands.VacuumCommand$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.DateFormatter;
import org.apache.spark.sql.delta.util.DateFormatter$;
import org.apache.spark.sql.delta.util.DeltaFileOperations$;
import org.apache.spark.sql.delta.util.PartitionUtils;
import org.apache.spark.sql.delta.util.PartitionUtils$;
import org.apache.spark.sql.delta.util.TimestampFormatter;
import org.apache.spark.sql.delta.util.TimestampFormatter$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]faB\b\u0011!\u0003\r\t!\b\u0005\u0006U\u0001!\ta\u000b\u0005\b_\u0001\u0011\r\u0011\"\u00011\u0011\u001dI\u0004\u00011A\u0005\u0002ABqA\u000f\u0001A\u0002\u0013\u00051\bC\u0004?\u0001\u0001\u0007I\u0011\u0001\u0019\t\u000f}\u0002\u0001\u0019!C\u0001\u0001\")!\t\u0001C\u0001\u0007\"9a\u000fAI\u0001\n\u00039\bbBA\u0003\u0001\u0011\u0005\u0011q\u0001\u0005\b\u0003;\u0001A\u0011AA\u0010\u0011\u001d\ty\u0003\u0001C\u0001\u0003cAq!a\u0013\u0001\t\u0003\ti\u0005C\u0004\u0002\u0002\u0002!\t!a!\t\u000f\u0005]\u0005\u0001\"\u0001\u0002\u001a\nQ2i\u001c8wKJ$Hk\u001c#fYR\f7i\\7nC:$W\u000b^5mg*\u0011\u0011CE\u0001\tG>lW.\u00198eg*\u00111\u0003F\u0001\u0006I\u0016dG/\u0019\u0006\u0003+Y\t1a]9m\u0015\t9\u0002$A\u0003ta\u0006\u00148N\u0003\u0002\u001a5\u00051\u0011\r]1dQ\u0016T\u0011aG\u0001\u0004_J<7\u0001A\n\u0004\u0001y!\u0003CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#AB!osJ+g\r\u0005\u0002&Q5\taE\u0003\u0002(%\u0005AQ.\u001a;fe&tw-\u0003\u0002*M\taA)\u001a7uC2{wmZ5oO\u00061A%\u001b8ji\u0012\"\u0012\u0001\f\t\u0003?5J!A\f\u0011\u0003\tUs\u0017\u000e^\u0001\u001ai&lWm\u001d;b[B\u0004\u0016M\u001d;ji&|g\u000eU1ui\u0016\u0014h.F\u00012!\t\u0011t'D\u00014\u0015\t!T'\u0001\u0003mC:<'\"\u0001\u001c\u0002\t)\fg/Y\u0005\u0003qM\u0012aa\u0015;sS:<\u0017AG5dK\n,'oZ*qCJ\\G+\u00192mK\u000ec\u0017m]:QCRD\u0017AH5dK\n,'oZ*qCJ\\G+\u00192mK\u000ec\u0017m]:QCRDw\fJ3r)\taC\bC\u0004>\t\u0005\u0005\t\u0019A\u0019\u0002\u0007a$\u0013'\u0001\rjG\u0016\u0014WM]4MS\n$\u0016M\u00197f\u00072\f7o\u001d)bi\"\fA$[2fE\u0016\u0014x\rT5c)\u0006\u0014G.Z\"mCN\u001c\b+\u0019;i?\u0012*\u0017\u000f\u0006\u0002-\u0003\"9QHBA\u0001\u0002\u0004\t\u0014!D2sK\u0006$X-\u00113e\r&dW\rF\u0004E\u0015BSfLZ9\u0011\u0005\u0015CU\"\u0001$\u000b\u0005\u001d\u0013\u0012aB1di&|gn]\u0005\u0003\u0013\u001a\u0013q!\u00113e\r&dW\rC\u0003L\u000f\u0001\u0007A*\u0001\u0006uCJ<W\r\u001e$jY\u0016\u0004\"!\u0014(\u000e\u0003AI!a\u0014\t\u0003#\r{gN^3siR\u000b'oZ3u\r&dW\rC\u0003R\u000f\u0001\u0007!+\u0001\u0005cCN,\u0007+\u0019;i!\t\u0019\u0006,D\u0001U\u0015\t)f+\u0001\u0002gg*\u0011q\u000bG\u0001\u0007Q\u0006$wn\u001c9\n\u0005e#&\u0001\u0002)bi\"DQ!V\u0004A\u0002m\u0003\"a\u0015/\n\u0005u#&A\u0003$jY\u0016\u001c\u0016p\u001d;f[\")ql\u0002a\u0001A\u0006!1m\u001c8g!\t\tG-D\u0001c\u0015\t\u0019G#\u0001\u0005j]R,'O\\1m\u0013\t)'MA\u0004T#2\u001buN\u001c4\t\u000b\u001d<\u0001\u0019\u00015\u0002\u001fA\f'\u000f^5uS>t7k\u00195f[\u0006\u00042aH5l\u0013\tQ\u0007E\u0001\u0004PaRLwN\u001c\t\u0003Y>l\u0011!\u001c\u0006\u0003]R\tQ\u0001^=qKNL!\u0001]7\u0003\u0015M#(/^2u)f\u0004X\rC\u0004s\u000fA\u0005\t\u0019A:\u0002\u001fU\u001cX-\u00112t_2,H/\u001a)bi\"\u0004\"a\b;\n\u0005U\u0004#a\u0002\"p_2,\u0017M\\\u0001\u0018GJ,\u0017\r^3BI\u00124\u0015\u000e\\3%I\u00164\u0017-\u001e7uIY*\u0012\u0001\u001f\u0016\u0003gf\\\u0013A\u001f\t\u0004w\u0006\u0005Q\"\u0001?\u000b\u0005ut\u0018!C;oG\",7m[3e\u0015\ty\b%\u0001\u0006b]:|G/\u0019;j_:L1!a\u0001}\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0018SND\u0015N^3TifdW\rU1scV,G\u000fV1cY\u0016$2a]A\u0005\u0011\u001d\tY!\u0003a\u0001\u0003\u001b\tAbY1uC2|w\rV1cY\u0016\u0004B!a\u0004\u0002\u001a5\u0011\u0011\u0011\u0003\u0006\u0005\u0003'\t)\"A\u0004dCR\fGn\\4\u000b\u0007\u0005]A#\u0001\u0005dCR\fG._:u\u0013\u0011\tY\"!\u0005\u0003\u0019\r\u000bG/\u00197pOR\u000b'\r\\3\u0002!\u001d,G/U;bY&4\u0017.\u001a3QCRDG#\u0002*\u0002\"\u0005-\u0002BB\f\u000b\u0001\u0004\t\u0019\u0003\u0005\u0003\u0002&\u0005\u001dR\"\u0001\u000b\n\u0007\u0005%BC\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000e\u0003\u0004\u0002.)\u0001\rAU\u0001\u0005a\u0006$\b.A\niS\u0012$WM\u001c#je:\u000bW.\u001a$jYR,'\u000fF\u0002t\u0003gAq!!\u000e\f\u0001\u0004\t9$\u0001\u0005gS2,g*Y7f!\u0011\tI$a\u0012\u000f\t\u0005m\u00121\t\t\u0004\u0003{\u0001SBAA \u0015\r\t\t\u0005H\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u0015\u0003%\u0001\u0004Qe\u0016$WMZ\u0005\u0004q\u0005%#bAA#A\u0005a1m\\7qkR,7\u000b^1ugRA\u0011qJA1\u0003[\n9\bE\u0003\u0002R\u0005mCI\u0004\u0003\u0002T\u0005]c\u0002BA\u001f\u0003+J\u0011!I\u0005\u0004\u00033\u0002\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003;\nyF\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\r\tI\u0006\t\u0005\b\u0003Gb\u0001\u0019AA3\u0003!!W\r\u001c;b\u0019><\u0007\u0003BA4\u0003Sj\u0011AE\u0005\u0004\u0003W\u0012\"\u0001\u0003#fYR\fGj\\4\t\u000f\u0005=D\u00021\u0001\u0002r\u0005A1O\\1qg\"|G\u000f\u0005\u0003\u0002h\u0005M\u0014bAA;%\tA1K\\1qg\"|G\u000fC\u0004\u0002z1\u0001\r!a\u001f\u0002\u0011\u0005$GMR5mKN\u0004R!!\u0015\u0002~\u0011KA!a \u0002`\t\u00191+Z9\u0002\u001f\u001d,G\u000fU1scV,G\u000fV1cY\u0016$\"\"!\"\u0002\f\u00065\u0015\u0011SAK!\ri\u0015qQ\u0005\u0004\u0003\u0013\u0003\"AE\"p]Z,'\u000f\u001e+be\u001e,G\u000fV1cY\u0016DaaF\u0007A\u0002\u0005\r\u0002bBAH\u001b\u0001\u0007\u0011qG\u0001\ni\u0006\u0014x-\u001a;ESJDq!a\u0003\u000e\u0001\u0004\t\u0019\n\u0005\u0003 S\u00065\u0001\"B4\u000e\u0001\u0004A\u0017aD4fi&\u001bWMY3sOR\u000b'\r\\3\u0015\u0015\u0005\u0015\u00151TAO\u0003?\u000b\u0019\f\u0003\u0004\u0018\u001d\u0001\u0007\u00111\u0005\u0005\b\u0003\u001fs\u0001\u0019AA\u001c\u0011\u001d\t\tK\u0004a\u0001\u0003G\u000b!b\u001d9be.$\u0016M\u00197f!\u0011y\u0012.!*\u0011\t\u0005\u001d\u0016qV\u0007\u0003\u0003SSA!a\u0005\u0002,*\u0019\u0011Q\u0016\u000b\u0002\u0013\r|gN\\3di>\u0014\u0018\u0002BAY\u0003S\u0013Q\u0001V1cY\u0016Da!!.\u000f\u0001\u0004A\u0017a\u0003;bE2,7k\u00195f[\u0006\u0004")
public interface ConvertToDeltaCommandUtils
extends DeltaLogging {
    public void org$apache$spark$sql$delta$commands$ConvertToDeltaCommandUtils$_setter_$timestampPartitionPattern_$eq(String var1);

    public String timestampPartitionPattern();

    public String icebergSparkTableClassPath();

    public void icebergSparkTableClassPath_$eq(String var1);

    public String icebergLibTableClassPath();

    public void icebergLibTableClassPath_$eq(String var1);

    public static /* synthetic */ AddFile createAddFile$(ConvertToDeltaCommandUtils $this, ConvertTargetFile targetFile, Path basePath, FileSystem fs, SQLConf conf, Option partitionSchema, boolean useAbsolutePath) {
        return $this.createAddFile(targetFile, basePath, fs, conf, (Option<StructType>)partitionSchema, useAbsolutePath);
    }

    default public AddFile createAddFile(ConvertTargetFile targetFile, Path basePath, FileSystem fs, SQLConf conf, Option<StructType> partitionSchema, boolean useAbsolutePath) {
        String string;
        Seq partitionFields = (Seq)partitionSchema.map((Function1 & Serializable & scala.Serializable)x$18 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$18.fields())).toSeq()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        Seq partitionColNames = (Seq)partitionSchema.map((Function1 & Serializable & scala.Serializable)x$19 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$19.fieldNames())).toSeq()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        Seq physicalPartitionColNames = (Seq)partitionSchema.map((Function1 & Serializable & scala.Serializable)x$20 -> (Seq)x$20.map((Function1 & Serializable & scala.Serializable)f -> DeltaColumnMapping$.MODULE$.getPhysicalName((StructField)f), Seq$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        SerializableFileStatus file = targetFile.fileStatus();
        Path path = file.getHadoopPath();
        Map partition = (Map)targetFile.partitionValues().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            Option partitionOpt;
            String pathStr = file.getHadoopPath().toUri().toString();
            DateFormatter dateFormatter = DateFormatter$.MODULE$.apply();
            TimestampFormatter timestampFormatter = TimestampFormatter$.MODULE$.apply(this.timestampPartitionPattern(), TimeZone.getDefault());
            Function2 resolver = conf.resolver();
            Path dir = file.isDir() ? file.getHadoopPath() : file.getHadoopPath().getParent();
            Tuple2<Option<PartitionUtils.PartitionValues>, Option<Path>> tuple2 = PartitionUtils$.MODULE$.parsePartition(dir, false, (Set<Path>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{basePath}))), (Map<String, DataType>)Predef$.MODULE$.Map().empty(), false, TimeZone.getDefault(), dateFormatter, timestampFormatter);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Option option = partitionOpt = (Option)tuple2._1();
            Option partitionOpt2 = option;
            return (Map)partitionOpt2.map((Function1 & Serializable & scala.Serializable)partValues -> {
                if (partitionColNames.size() != partValues.columnNames().size()) {
                    throw DeltaErrors$.MODULE$.unexpectedNumPartitionColumnsFromFileNameException(pathStr, partValues.columnNames(), (Seq<String>)partitionColNames);
                }
                Option tz = Option$.MODULE$.apply((Object)conf.sessionLocalTimeZone());
                if (!BoxesRunTime.unboxToBoolean((Object)conf.getConf(DeltaSQLConf$.MODULE$.DELTA_CONVERT_PARTITION_VALUES_IGNORE_CAST_FAILURE()))) {
                    ((IterableLike)partValues.literals().zip((GenIterable)partitionFields, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        ConvertToDeltaCommandUtils.$anonfun$createAddFile$10(tz, x0$1);
                        return BoxedUnit.UNIT;
                    });
                }
                Seq values = (Seq)((TraversableLike)partValues.literals().map((Function1 & Serializable & scala.Serializable)l -> {
                    Cast qual$3 = new Cast((Expression)l, (DataType)StringType$.MODULE$, tz, false);
                    InternalRow x$3 = qual$3.eval$default$1();
                    return qual$3.eval(x$3);
                }, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$22 -> (String)Option$.MODULE$.apply(x$22).map((Function1 & Serializable & scala.Serializable)x$23 -> x$23.toString()).orNull(Predef$.MODULE$.$conforms()), Seq$.MODULE$.canBuildFrom());
                ((IterableLike)partitionColNames.zip(partValues.columnNames(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    ConvertToDeltaCommandUtils.$anonfun$createAddFile$15(resolver, pathStr, x0$2);
                    return BoxedUnit.UNIT;
                });
                return ((TraversableOnce)physicalPartitionColNames.zip((GenIterable)values, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                if (partitionColNames.nonEmpty()) {
                    throw DeltaErrors$.MODULE$.unexpectedNumPartitionColumnsFromFileNameException(pathStr, (Seq<String>)((Seq)Nil$.MODULE$), (Seq<String>)partitionColNames);
                }
                return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            });
        });
        if (!useAbsolutePath) {
            Path relativePath = DeltaFileOperations$.MODULE$.tryRelativizePath(fs, basePath, path, DeltaFileOperations$.MODULE$.tryRelativizePath$default$4());
            Predef$.MODULE$.assert(!relativePath.isAbsolute(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Fail to relativize path ").append(path).append(" against base path ").append(basePath).append(".").toString());
            string = relativePath.toUri().toString();
        } else {
            string = path.toUri().toString();
        }
        String pathStrForAddFile = string;
        return new AddFile(pathStrForAddFile, (Map<String, String>)partition, file.length(), file.modificationTime(), true, AddFile$.MODULE$.apply$default$6(), AddFile$.MODULE$.apply$default$7(), AddFile$.MODULE$.apply$default$8());
    }

    public static /* synthetic */ boolean createAddFile$default$6$(ConvertToDeltaCommandUtils $this) {
        return $this.createAddFile$default$6();
    }

    default public boolean createAddFile$default$6() {
        return false;
    }

    public static /* synthetic */ boolean isHiveStyleParquetTable$(ConvertToDeltaCommandUtils $this, CatalogTable catalogTable) {
        return $this.isHiveStyleParquetTable(catalogTable);
    }

    default public boolean isHiveStyleParquetTable(CatalogTable catalogTable) {
        return catalogTable.provider().contains((Object)"hive") && catalogTable.storage().serde().contains((Object)"org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe");
    }

    public static /* synthetic */ Path getQualifiedPath$(ConvertToDeltaCommandUtils $this, SparkSession spark, Path path) {
        return $this.getQualifiedPath(spark, path);
    }

    default public Path getQualifiedPath(SparkSession spark, Path path) {
        Path qualifiedPath;
        Configuration sessionHadoopConf = spark.sessionState().newHadoopConf();
        FileSystem fs = path.getFileSystem(sessionHadoopConf);
        if (!fs.exists(qualifiedPath = fs.makeQualified(path))) {
            throw DeltaErrors$.MODULE$.directoryNotFoundException(qualifiedPath.toString());
        }
        return qualifiedPath;
    }

    public static /* synthetic */ boolean hiddenDirNameFilter$(ConvertToDeltaCommandUtils $this, String fileName) {
        return $this.hiddenDirNameFilter(fileName);
    }

    default public boolean hiddenDirNameFilter(String fileName) {
        return DeltaFileOperations$.MODULE$.defaultHiddenFileFilter(fileName) && !fileName.contains("=");
    }

    public static /* synthetic */ Iterator computeStats$(ConvertToDeltaCommandUtils $this, DeltaLog deltaLog, Snapshot snapshot, Seq addFiles) {
        return $this.computeStats(deltaLog, snapshot, (Seq<AddFile>)addFiles);
    }

    default public Iterator<AddFile> computeStats(DeltaLog deltaLog, Snapshot snapshot, Seq<AddFile> addFiles) {
        Dataset filesWithStats = deltaLog.createDataFrame(snapshot, addFiles, deltaLog.createDataFrame$default$3(), deltaLog.createDataFrame$default$4()).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.input_file_name()})).agg(functions$.MODULE$.to_json(snapshot.statsCollector()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0]));
        Map<String, AddFile> pathToAddFileMap = VacuumCommand$.MODULE$.generateCandidateFileMap(deltaLog.dataPath(), addFiles);
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filesWithStats.collect())).iterator().map((Function1 & Serializable & scala.Serializable)row -> {
            AddFile addFile = VacuumCommand$.MODULE$.getTouchedFile(deltaLog.dataPath(), row.getString(0), pathToAddFileMap);
            String x$1 = row.getString(1);
            String x$2 = addFile.copy$default$1();
            Map<String, String> x$3 = addFile.copy$default$2();
            long x$4 = addFile.copy$default$3();
            long x$5 = addFile.copy$default$4();
            boolean x$6 = addFile.copy$default$5();
            Map<String, String> x$7 = addFile.copy$default$7();
            DeletionVectorDescriptor x$8 = addFile.copy$default$8();
            return addFile.copy(x$2, x$3, x$4, x$5, x$6, x$1, x$7, x$8);
        });
    }

    public static /* synthetic */ ConvertTargetTable getParquetTable$(ConvertToDeltaCommandUtils $this, SparkSession spark, String targetDir, Option catalogTable, Option partitionSchema) {
        return $this.getParquetTable(spark, targetDir, (Option<CatalogTable>)catalogTable, (Option<StructType>)partitionSchema);
    }

    default public ConvertTargetTable getParquetTable(SparkSession spark, String targetDir, Option<CatalogTable> catalogTable, Option<StructType> partitionSchema) {
        String qualifiedDir = ConvertToDeltaCommand$.MODULE$.getQualifiedPath(spark, new Path(targetDir)).toString();
        return new ParquetTable(spark, qualifiedDir, catalogTable, partitionSchema);
    }

    public static /* synthetic */ ConvertTargetTable getIcebergTable$(ConvertToDeltaCommandUtils $this, SparkSession spark, String targetDir, Option sparkTable, Option tableSchema) {
        return $this.getIcebergTable(spark, targetDir, (Option<Table>)sparkTable, (Option<StructType>)tableSchema);
    }

    default public ConvertTargetTable getIcebergTable(SparkSession spark, String targetDir, Option<Table> sparkTable, Option<StructType> tableSchema) {
        ConvertTargetTable convertTargetTable;
        try {
            Class clazz = Utils$.MODULE$.classForName(this.icebergSparkTableClassPath(), Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
            if (sparkTable.isDefined()) {
                Constructor constFromTable = clazz.getConstructor(SparkSession.class, Utils$.MODULE$.classForName(this.icebergLibTableClassPath(), Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3()), Option.class);
                Method method = sparkTable.get().getClass().getMethod("table", new Class[0]);
                convertTargetTable = (ConvertTargetTable)constFromTable.newInstance(spark, method.invoke(sparkTable.get(), new Object[0]), tableSchema);
            } else {
                String baseDir = ConvertToDeltaCommand$.MODULE$.getQualifiedPath(spark, new Path(targetDir)).toString();
                Constructor constFromPath = clazz.getConstructor(SparkSession.class, String.class, Option.class);
                convertTargetTable = (ConvertTargetTable)constFromPath.newInstance(spark, baseDir, tableSchema);
            }
        }
        catch (ClassNotFoundException e) {
            this.logError((Function0 & Serializable & scala.Serializable)() -> "Failed to find Iceberg class", e);
            throw DeltaErrors$.MODULE$.icebergClassMissing(spark.sparkContext().getConf(), e);
        }
        catch (InvocationTargetException e) {
            this.logError((Function0 & Serializable & scala.Serializable)() -> "Got error when creating an Iceberg Converter", e);
            throw ExceptionUtils.getRootCause((Throwable)e);
        }
        return convertTargetTable;
    }

    public static /* synthetic */ void $anonfun$createAddFile$10(Option tz$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            InternalRow x$1;
            Cast qual$1;
            Literal literal = (Literal)tuple2._1();
            StructField field = (StructField)tuple2._2();
            if (literal.eval(literal.eval$default$1()) != null && (qual$1 = new Cast((Expression)literal, field.dataType(), tz$1, false)).eval(x$1 = qual$1.eval$default$1()) == null) {
                Cast qual$2 = new Cast((Expression)literal, (DataType)StringType$.MODULE$, tz$1, false);
                InternalRow x$2 = qual$2.eval$default$1();
                Object partitionValue = qual$2.eval(x$2);
                String partitionValueStr = (String)Option$.MODULE$.apply(partitionValue).map((Function1 & Serializable & scala.Serializable)x$21 -> x$21.toString()).orNull(Predef$.MODULE$.$conforms());
                throw DeltaErrors$.MODULE$.castPartitionValueException(partitionValueStr, field.dataType());
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static /* synthetic */ void $anonfun$createAddFile$15(Function2 resolver$1, String pathStr$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String parsed;
            String expected = (String)tuple2._1();
            if (!BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)expected, (Object)(parsed = (String)tuple2._2())))) {
                throw DeltaErrors$.MODULE$.unexpectedPartitionColumnFromFileNameException(pathStr$1, parsed, expected);
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static void $init$(ConvertToDeltaCommandUtils $this) {
        $this.org$apache$spark$sql$delta$commands$ConvertToDeltaCommandUtils$_setter_$timestampPartitionPattern_$eq("yyyy-MM-dd HH:mm:ss[.S]");
        $this.icebergSparkTableClassPath_$eq("org.apache.spark.sql.delta.IcebergTable");
        $this.icebergLibTableClassPath_$eq("org.apache.iceberg.Table");
    }
}

