/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.deletionvectors;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.delta.RowIndexFilter;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor;
import org.apache.spark.sql.delta.deletionvectors.DeletedRowsMarkingFilter$;
import org.apache.spark.sql.delta.deletionvectors.RoaringBitmapArray;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001]4Aa\u0003\u0007\u00033!Aa\u0005\u0001B\u0001B\u0003%q\u0005C\u0003,\u0001\u0011\u0005A\u0006C\u00030\u0001\u0011\u0005\u0003gB\u0003I\u0019!\u0005\u0011JB\u0003\f\u0019!\u0005!\nC\u0003,\u000b\u0011\u0005a\nC\u0003P\u000b\u0011\u0005\u0001K\u0002\u0003o\u000b\u0011y\u0007\"B\u0016\t\t\u0003\u0001\b\"B\u0018\t\t\u0003\u001a(\u0001\u0007#fY\u0016$X\r\u001a*poNl\u0015M]6j]\u001e4\u0015\u000e\u001c;fe*\u0011QBD\u0001\u0010I\u0016dW\r^5p]Z,7\r^8sg*\u0011q\u0002E\u0001\u0006I\u0016dG/\u0019\u0006\u0003#I\t1a]9m\u0015\t\u0019B#A\u0003ta\u0006\u00148N\u0003\u0002\u0016-\u00051\u0011\r]1dQ\u0016T\u0011aF\u0001\u0004_J<7\u0001A\n\u0004\u0001i\u0011\u0003CA\u000e!\u001b\u0005a\"BA\u000f\u001f\u0003\u0011a\u0017M\\4\u000b\u0003}\tAA[1wC&\u0011\u0011\u0005\b\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005\r\"S\"\u0001\b\n\u0005\u0015r!A\u0004*po&sG-\u001a=GS2$XM]\u0001\u0007E&$X.\u00199\u0011\u0005!JS\"\u0001\u0007\n\u0005)b!A\u0005*pCJLgn\u001a\"ji6\f\u0007/\u0011:sCf\fa\u0001P5oSRtDCA\u0017/!\tA\u0003\u0001C\u0003'\u0005\u0001\u0007q%A\u000bnCR,'/[1mSj,\u0017J\u001c;p-\u0016\u001cGo\u001c:\u0015\tE:DH\u0010\t\u0003eUj\u0011a\r\u0006\u0002i\u0005)1oY1mC&\u0011ag\r\u0002\u0005+:LG\u000fC\u00039\u0007\u0001\u0007\u0011(A\u0003ti\u0006\u0014H\u000f\u0005\u00023u%\u00111h\r\u0002\u0005\u0019>tw\rC\u0003>\u0007\u0001\u0007\u0011(A\u0002f]\u0012DQaP\u0002A\u0002\u0001\u000bQAY1uG\"\u0004\"!\u0011$\u000e\u0003\tS!a\u0011#\u0002\u0015Y,7\r^8sSj,GM\u0003\u0002F!\u0005IQ\r_3dkRLwN\\\u0005\u0003\u000f\n\u0013Ac\u0016:ji\u0006\u0014G.Z\"pYVlgNV3di>\u0014\u0018\u0001\u0007#fY\u0016$X\r\u001a*poNl\u0015M]6j]\u001e4\u0015\u000e\u001c;feB\u0011\u0001&B\n\u0003\u000b-\u0003\"A\r'\n\u00055\u001b$AB!osJ+g\rF\u0001J\u00039\u0019'/Z1uK&s7\u000f^1oG\u0016$BAI)ZG\")!k\u0002a\u0001'\u0006qA-\u001a7fi&|gNV3di>\u0014\bC\u0001+X\u001b\u0005)&B\u0001,\u000f\u0003\u001d\t7\r^5p]NL!\u0001W+\u00031\u0011+G.\u001a;j_:4Vm\u0019;pe\u0012+7o\u0019:jaR|'\u000fC\u0003[\u000f\u0001\u00071,\u0001\u0006iC\u0012|w\u000e]\"p]\u001a\u0004\"\u0001X1\u000e\u0003uS!AX0\u0002\t\r|gN\u001a\u0006\u0003AR\ta\u0001[1e_>\u0004\u0018B\u00012^\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\")Am\u0002a\u0001K\u0006IA/\u00192mKB\u000bG\u000f\u001b\t\u0004e\u0019D\u0017BA44\u0005\u0019y\u0005\u000f^5p]B\u0011\u0011\u000e\\\u0007\u0002U*\u00111nX\u0001\u0003MNL!!\u001c6\u0003\tA\u000bG\u000f\u001b\u0002\u0012\u0017\u0016,\u0007/\u00117m%><8OR5mi\u0016\u00148c\u0001\u0005\u001bEQ\t\u0011\u000f\u0005\u0002s\u00115\tQ\u0001\u0006\u00032iV4\b\"\u0002\u001d\u000b\u0001\u0004I\u0004\"B\u001f\u000b\u0001\u0004I\u0004\"B \u000b\u0001\u0004\u0001\u0005")
public final class DeletedRowsMarkingFilter
implements RowIndexFilter {
    private final RoaringBitmapArray bitmap;

    public static RowIndexFilter createInstance(DeletionVectorDescriptor deletionVectorDescriptor, Configuration configuration, Option<Path> option) {
        return DeletedRowsMarkingFilter$.MODULE$.createInstance(deletionVectorDescriptor, configuration, option);
    }

    @Override
    public void materializeIntoVector(long start, long end, WritableColumnVector batch) {
        int batchSize = (int)(end - start);
        for (int rowId = 0; rowId < batchSize; ++rowId) {
            boolean isContained = this.bitmap.contains(start + (long)rowId);
            byte filterOutput = isContained ? (byte)1 : 0;
            batch.putByte(rowId, filterOutput);
        }
    }

    public DeletedRowsMarkingFilter(RoaringBitmapArray bitmap) {
        this.bitmap = bitmap;
    }

    private static class KeepAllRowsFilter
    implements RowIndexFilter {
        @Override
        public void materializeIntoVector(long start, long end, WritableColumnVector batch) {
            int batchSize = (int)(end - start);
            for (int rowId = 0; rowId < batchSize; ++rowId) {
                batch.putByte(rowId, (byte)0);
            }
        }
    }
}

