/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.exception;

import java.text.MessageFormat;
import org.apache.linkis.cli.application.exception.error.ErrorLevel;
import org.apache.linkis.cli.application.exception.error.ErrorMsg;

public class LinkisClientRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 342134234324357L;
    private String code;
    private String msg;
    private String extMsg;
    private ErrorLevel level;
    private ErrorMsg errMsg;

    public LinkisClientRuntimeException(String code, ErrorLevel level, ErrorMsg errMsg, String[] param, String ... extMsg) {
        super(null == code ? "" : code);
        this.init(code, level, errMsg, param, extMsg);
    }

    public LinkisClientRuntimeException(String code, ErrorLevel level, ErrorMsg errMsg, Object ... paramsList) {
        super(null == code ? "" : code);
        Object[] params;
        this.code = code;
        if (paramsList != null && paramsList.length > 0 && paramsList[paramsList.length - 1] instanceof Throwable) {
            Object[] newParam = new Object[paramsList.length - 1];
            System.arraycopy(paramsList, 0, newParam, 0, newParam.length);
            params = newParam;
            super.initCause((Throwable)paramsList[paramsList.length - 1]);
        } else {
            params = paramsList;
            super.initCause(null);
        }
        this.code = null == code ? null : code;
        this.level = null == level ? ErrorLevel.ERROR : level;
        this.extMsg = this.msg = null == errMsg ? "" : MessageFormat.format(errMsg.getMsgTemplate(), params);
    }

    public LinkisClientRuntimeException(String code, ErrorLevel level, ErrorMsg errMsg, Throwable e, String[] param, String ... extMsg) {
        super(null == code ? "" : code, e);
        this.init(code, level, errMsg, param, extMsg);
    }

    private void init(String code, ErrorLevel level, ErrorMsg errMsg, Object[] param, String ... extMsg) {
        this.errMsg = errMsg;
        this.code = null == code ? null : code;
        this.level = null == level ? ErrorLevel.ERROR : level;
        this.msg = null == errMsg ? "" : MessageFormat.format(errMsg.getMsgTemplate(), param);
        StringBuilder builder = new StringBuilder(100);
        builder.append(this.msg);
        if (null != extMsg) {
            for (String ext : extMsg) {
                builder.append("[").append(ext).append("]");
            }
        }
        this.extMsg = builder.toString();
    }

    public String getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getExtMsg() {
        return this.extMsg;
    }

    public ErrorLevel getLevel() {
        return this.level;
    }

    public ErrorMsg getErrMsg() {
        return this.errMsg;
    }

    @Override
    public String getMessage() {
        return super.getMessage() + "," + this.extMsg;
    }
}

