/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cli.application.interactor.validate;

import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.cli.application.exception.LinkisClientRuntimeException;
import org.apache.linkis.cli.application.exception.ValidateException;
import org.apache.linkis.cli.application.exception.error.CommonErrMsg;
import org.apache.linkis.cli.application.exception.error.ErrorLevel;
import org.apache.linkis.cli.application.exception.error.ErrorMsg;
import org.apache.linkis.cli.application.interactor.job.jobcmd.JobCmdDesc;

public class JobCmdDescValidator {
    public void doValidation(JobCmdDesc desc) throws LinkisClientRuntimeException {
        boolean ok = true;
        StringBuilder reasonSb = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)desc.getJobID())) {
            reasonSb.append("jobId cannot be empty or blank").append(System.lineSeparator());
            ok = false;
        }
        if (StringUtils.isBlank((CharSequence)desc.getUser())) {
            reasonSb.append("user cannot be empty or blank").append(System.lineSeparator());
            ok = false;
        }
        if (!ok) {
            throw new ValidateException("VLD0008", ErrorLevel.ERROR, (ErrorMsg)CommonErrMsg.ValidationErr, "LinkisJobMan validation failed. Reason: " + reasonSb.toString());
        }
    }
}

