/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.client.builder;

import org.apache.linkis.common.conf.CommonVars;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.cs.client.builder.ContextClientConfig;
import org.apache.linkis.cs.client.utils.ContextClientConf;
import org.apache.linkis.httpclient.authentication.AuthenticationStrategy;
import org.apache.linkis.httpclient.config.ClientConfig;
import org.apache.linkis.httpclient.config.ClientConfigBuilder;
import org.apache.linkis.httpclient.dws.authentication.TokenAuthenticationStrategy;

public class HttpContextClientConfig
extends ContextClientConfig {
    private ClientConfig clientConfig;
    private static final int CS_CONNECTION_TIMEOUT = (Integer)CommonVars.apply((String)"wds.linkis.cs.connection.timeout", (Object)180000).getValue();
    private static final int CS_READ_TIMEOUT = (Integer)CommonVars.apply((String)"wds.linkis.cs.read.timeout", (Object)180000).getValue();
    private static final int CS_MAX_CONNECTION = (Integer)CommonVars.apply((String)"wds.linkis.cs.max.connection", (Object)50).getValue();

    public HttpContextClientConfig() {
        String gatewayUrl = Configuration.getGateWayURL();
        TokenAuthenticationStrategy authenticationStrategy = new TokenAuthenticationStrategy();
        this.clientConfig = ClientConfigBuilder.newBuilder().addServerUrl(gatewayUrl).connectionTimeout((long)CS_CONNECTION_TIMEOUT).discoveryEnabled(false).loadbalancerEnabled(false).maxConnectionSize(CS_MAX_CONNECTION).retryEnabled(false).readTimeout((long)CS_READ_TIMEOUT).setAuthenticationStrategy((AuthenticationStrategy)authenticationStrategy).setAuthTokenKey((String)ContextClientConf.CONTEXT_CLIENT_AUTH_KEY().getValue()).setAuthTokenValue((String)ContextClientConf.CONTEXT_CLIENT_AUTH_VALUE().getValue()).build();
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }
}

