/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.imexport.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.linkis.common.conf.CommonVars;
import org.apache.linkis.common.conf.CommonVars$;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.storage.FSFactory$;
import org.apache.linkis.storage.fs.FileSystem;
import org.apache.linkis.storage.utils.FileSystemUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.Breaks;

public final class BackGroundServiceUtils$
implements Logging {
    public static BackGroundServiceUtils$ MODULE$;
    private final CommonVars<String> CODE_STORE_PREFIX;
    private final CommonVars<String> CODE_STORE_SUFFIX;
    private final String CHARSET;
    private final String CODE_SPLIT;
    private final String LENGTH_SPLIT;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new BackGroundServiceUtils$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        BackGroundServiceUtils$ backGroundServiceUtils$ = this;
        synchronized (backGroundServiceUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private CommonVars<String> CODE_STORE_PREFIX() {
        return this.CODE_STORE_PREFIX;
    }

    private CommonVars<String> CODE_STORE_SUFFIX() {
        return this.CODE_STORE_SUFFIX;
    }

    private String CHARSET() {
        return this.CHARSET;
    }

    private String CODE_SPLIT() {
        return this.CODE_SPLIT;
    }

    private String LENGTH_SPLIT() {
        return this.LENGTH_SPLIT;
    }

    public String storeExecutionCode(String destination, String user) {
        if (destination.length() < 60000) {
            return null;
        }
        String path = this.getCodeStorePath(user);
        FsPath fsPath = new FsPath(path);
        FileSystem fileSystem = (FileSystem)FSFactory$.MODULE$.getFsByProxyUser(fsPath, user);
        fileSystem.init(null);
        ObjectRef os = ObjectRef.create(null);
        LongRef position = LongRef.create((long)0L);
        byte[] codeBytes = destination.getBytes(this.CHARSET());
        Utils$.MODULE$.tryFinally((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String string = path.intern();
            synchronized (string) {
                if (!fileSystem.exists(fsPath)) {
                    FileSystemUtils$.MODULE$.createNewFile(fsPath, user, true);
                }
                os$1.elem = fileSystem.write(fsPath, false);
                position$1.elem = fileSystem.get(path).getLength();
                IOUtils.write((byte[])codeBytes, (OutputStream)((OutputStream)os$1.elem));
            }
        }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (fileSystem != null) {
                fileSystem.close();
            }
            IOUtils.closeQuietly((OutputStream)((OutputStream)os$1.elem));
        });
        int length = codeBytes.length;
        return new StringBuilder(0).append(path).append(this.CODE_SPLIT()).append(position.elem).append(this.LENGTH_SPLIT()).append(length).toString();
    }

    public String exchangeExecutionCode(String codePath) {
        String path = codePath.substring(0, codePath.lastIndexOf(this.CODE_SPLIT()));
        String codeInfo = codePath.substring(codePath.lastIndexOf(this.CODE_SPLIT()) + 1);
        String[] infos = codeInfo.split(this.LENGTH_SPLIT());
        int position = new StringOps(Predef$.MODULE$.augmentString(infos[0])).toInt();
        IntRef lengthLeft = IntRef.create((int)new StringOps(Predef$.MODULE$.augmentString(infos[1])).toInt());
        byte[] tub = new byte[1024];
        scala.collection.mutable.StringBuilder executionCode = new scala.collection.mutable.StringBuilder();
        FsPath fsPath = new FsPath(path);
        FileSystem fileSystem = (FileSystem)FSFactory$.MODULE$.getFsByProxyUser(fsPath, System.getProperty("user.name"));
        fileSystem.init(null);
        ObjectRef is = ObjectRef.create(null);
        if (!fileSystem.exists(fsPath)) {
            return null;
        }
        Breaks loop = new Breaks();
        Utils$.MODULE$.tryFinally((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            is$1.elem = fileSystem.read(fsPath);
            Object object = position > 0 ? BoxesRunTime.boxToLong((long)((InputStream)is$1.elem).skip(position)) : BoxedUnit.UNIT;
            loop.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                while (lengthLeft$1.elem > 0) {
                    int readed = ((InputStream)is$1.elem).read(tub);
                    int useful = Math.min(readed, lengthLeft$1.elem);
                    if (useful < 0) {
                        throw loop.break();
                    }
                    lengthLeft$1.elem -= useful;
                    executionCode.append(new String(tub, 0, useful, MODULE$.CHARSET()));
                }
            });
        }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (fileSystem != null) {
                fileSystem.close();
            }
            IOUtils.closeQuietly((InputStream)((InputStream)is$1.elem));
        });
        return executionCode.toString();
    }

    private String getCodeStorePath(String user) {
        String date = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd");
        return new StringBuilder(26).append(this.CODE_STORE_PREFIX().getValue()).append(user).append(this.CODE_STORE_SUFFIX().getValue()).append("/executionCode/").append(date).append("/_bgservice").toString();
    }

    private BackGroundServiceUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.CODE_STORE_PREFIX = CommonVars$.MODULE$.apply("linkis.bgservice.store.prefix", (Object)"hdfs:///tmp/bdp-ide/");
        this.CODE_STORE_SUFFIX = CommonVars$.MODULE$.apply("linkis.bgservice.store.suffix", (Object)"");
        this.CHARSET = "utf-8";
        this.CODE_SPLIT = ";";
        this.LENGTH_SPLIT = "#";
    }
}

