/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconn.computation.executor.upstream.service;

import javax.annotation.PostConstruct;
import org.apache.linkis.common.listener.Event;
import org.apache.linkis.common.listener.EventListener;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.engineconn.computation.executor.conf.ComputationExecutorConf$;
import org.apache.linkis.engineconn.computation.executor.upstream.ECTaskEntranceMonitor;
import org.apache.linkis.engineconn.computation.executor.upstream.event.TaskStatusChangedForUpstreamMonitorEvent;
import org.apache.linkis.engineconn.computation.executor.upstream.listener.TaskStatusChangedForUpstreamMonitorListener;
import org.apache.linkis.engineconn.executor.listener.EngineConnSyncListenerBus;
import org.apache.linkis.engineconn.executor.listener.ExecutorListenerBusContext$;
import org.apache.linkis.engineconn.executor.listener.event.EngineConnSyncEvent;
import org.apache.linkis.governance.common.entity.ExecutionNodeStatus;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.reflect.ScalaSignature;

@Component
@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001B\u0006\r\u0001uAQA\r\u0001\u0005\u0002MBqA\u000e\u0001C\u0002\u0013%q\u0007\u0003\u0004=\u0001\u0001\u0006I\u0001\u000f\u0005\b{\u0001\u0011\r\u0011\"\u0003?\u0011\u0019)\u0005\u0001)A\u0005\u007f!)a\t\u0001C\u0001\u000f\")A\u000b\u0001C!+\")Q\f\u0001C!=\")Q\r\u0001C!M\")1\u0010\u0001C\u0001\u000f\naRi\u0011+bg.,e\u000e\u001e:b]\u000e,Wj\u001c8ji>\u00148+\u001a:wS\u000e,'BA\u0007\u000f\u0003\u001d\u0019XM\u001d<jG\u0016T!a\u0004\t\u0002\u0011U\u00048\u000f\u001e:fC6T!!\u0005\n\u0002\u0011\u0015DXmY;u_JT!a\u0005\u000b\u0002\u0017\r|W\u000e];uCRLwN\u001c\u0006\u0003+Y\t!\"\u001a8hS:,7m\u001c8o\u0015\t9\u0002$\u0001\u0004mS:\\\u0017n\u001d\u0006\u00033i\ta!\u00199bG\",'\"A\u000e\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001qBE\u000b\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0005\u001dr\u0011\u0001\u00037jgR,g.\u001a:\n\u0005%2#a\u000b+bg.\u001cF/\u0019;vg\u000eC\u0017M\\4fI\u001a{'/\u00169tiJ,\u0017-\\'p]&$xN\u001d'jgR,g.\u001a:\u0011\u0005-\u0002T\"\u0001\u0017\u000b\u00055r\u0013!B;uS2\u001c(BA\u0018\u0017\u0003\u0019\u0019w.\\7p]&\u0011\u0011\u0007\f\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\tA\u0007\u0005\u00026\u00015\tA\"A\u000bf\u0007R\u000b7o[#oiJ\fgnY3N_:LGo\u001c:\u0016\u0003a\u0002\"!\u000f\u001e\u000e\u00039I!a\u000f\b\u0003+\u0015\u001bE+Y:l\u000b:$(/\u00198dK6{g.\u001b;pe\u00061Rm\u0011+bg.,e\u000e\u001e:b]\u000e,Wj\u001c8ji>\u0014\b%A\bts:\u001cG*[:uK:,'OQ;t+\u0005y\u0004C\u0001!D\u001b\u0005\t%BA\u0014C\u0015\t\tB#\u0003\u0002E\u0003\nIRI\\4j]\u0016\u001cuN\u001c8Ts:\u001cG*[:uK:,'OQ;t\u0003A\u0019\u0018P\\2MSN$XM\\3s\u0005V\u001c\b%\u0001\u0003j]&$H#\u0001%\u0011\u0005}I\u0015B\u0001&!\u0005\u0011)f.\u001b;)\u0005\u0019a\u0005CA'S\u001b\u0005q%BA(Q\u0003)\tgN\\8uCRLwN\u001c\u0006\u0002#\u0006)!.\u0019<bq&\u00111K\u0014\u0002\u000e!>\u001cHoQ8ogR\u0014Xo\u0019;\u0002\u000f=tWI^3oiR\u0011\u0001J\u0016\u0005\u0006/\u001e\u0001\r\u0001W\u0001\u0006KZ,g\u000e\u001e\t\u00033nk\u0011A\u0017\u0006\u0003/\u0006K!\u0001\u0018.\u0003'\u0015sw-\u001b8f\u0007>tgnU=oG\u00163XM\u001c;\u0002'=tG+Y:l'R\fG/^:DQ\u0006tw-\u001a3\u0015\u0005!{\u0006\"B,\t\u0001\u0004\u0001\u0007CA1d\u001b\u0005\u0011'BA,\u000f\u0013\t!'M\u0001\u0015UCN\\7\u000b^1ukN\u001c\u0005.\u00198hK\u00124uN]+qgR\u0014X-Y7N_:LGo\u001c:Fm\u0016tG/\u0001\u0007p]\u00163XM\u001c;FeJ|'\u000fF\u0002IO6DQaV\u0005A\u0002!\u0004\"![6\u000e\u0003)T!a\n\u0018\n\u00051T'!B#wK:$\b\"\u00028\n\u0001\u0004y\u0017!\u0001;\u0011\u0005ADhBA9w\u001d\t\u0011X/D\u0001t\u0015\t!H$\u0001\u0004=e>|GOP\u0005\u0002C%\u0011q\u000fI\u0001\ba\u0006\u001c7.Y4f\u0013\tI(PA\u0005UQJ|w/\u00192mK*\u0011q\u000fI\u0001\tg\",H\u000fZ8x]\"\u0012\u0001! \t\u0004}\u0006\u001dQ\"A@\u000b\t\u0005\u0005\u00111A\u0001\u000bgR,'/Z8usB,'bAA\u00035\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148.C\u0002\u0002\n}\u0014\u0011bQ8na>tWM\u001c;")
public class ECTaskEntranceMonitorService
implements TaskStatusChangedForUpstreamMonitorListener,
Logging {
    private final ECTaskEntranceMonitor eCTaskEntranceMonitor;
    private final EngineConnSyncListenerBus syncListenerBus;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        ECTaskEntranceMonitorService eCTaskEntranceMonitorService = this;
        synchronized (eCTaskEntranceMonitorService) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private ECTaskEntranceMonitor eCTaskEntranceMonitor() {
        return this.eCTaskEntranceMonitor;
    }

    private EngineConnSyncListenerBus syncListenerBus() {
        return this.syncListenerBus;
    }

    @PostConstruct
    public void init() {
        boolean shouldStartMonitor = ComputationExecutorConf$.MODULE$.UPSTREAM_MONITOR_ECTASK_SHOULD_START();
        if (shouldStartMonitor) {
            this.syncListenerBus().addListener((EventListener)this);
            this.eCTaskEntranceMonitor().start();
            return;
        }
    }

    public void onEvent(EngineConnSyncEvent event) {
        EngineConnSyncEvent engineConnSyncEvent = event;
        if (engineConnSyncEvent instanceof TaskStatusChangedForUpstreamMonitorEvent) {
            TaskStatusChangedForUpstreamMonitorEvent taskStatusChangedForUpstreamMonitorEvent = (TaskStatusChangedForUpstreamMonitorEvent)engineConnSyncEvent;
            this.onTaskStatusChanged(taskStatusChangedForUpstreamMonitorEvent);
            return;
        }
        this.logger().info(new StringBuilder(28).append("ignored EngineConnSyncEvent ").append(event.getClass().getCanonicalName()).toString());
    }

    @Override
    public void onTaskStatusChanged(TaskStatusChangedForUpstreamMonitorEvent event) {
        ExecutionNodeStatus toStatus;
        ExecutionNodeStatus fromStatus;
        block6: {
            block5: {
                fromStatus = event.fromStatus();
                toStatus = event.toStatus();
                ExecutionNodeStatus executionNodeStatus = fromStatus;
                ExecutionNodeStatus executionNodeStatus2 = ExecutionNodeStatus.Inited;
                if (!(executionNodeStatus == null ? executionNodeStatus2 != null : !executionNodeStatus.equals(executionNodeStatus2))) break block5;
                ExecutionNodeStatus executionNodeStatus3 = fromStatus;
                ExecutionNodeStatus executionNodeStatus4 = ExecutionNodeStatus.Scheduled;
                if (executionNodeStatus3 != null ? !executionNodeStatus3.equals(executionNodeStatus4) : executionNodeStatus4 != null) break block6;
            }
            ExecutionNodeStatus executionNodeStatus = toStatus;
            ExecutionNodeStatus executionNodeStatus5 = ExecutionNodeStatus.Running;
            if (!(executionNodeStatus != null ? !executionNodeStatus.equals(executionNodeStatus5) : executionNodeStatus5 != null)) {
                this.logger().info(new StringBuilder(22).append("registering new task: ").append(event.taskId()).toString());
                this.eCTaskEntranceMonitor().register(event.task(), event.executor());
                return;
            }
        }
        if (!ExecutionNodeStatus.isCompleted((ExecutionNodeStatus)fromStatus) && ExecutionNodeStatus.isCompleted((ExecutionNodeStatus)toStatus)) {
            this.logger().info(new StringBuilder(20).append("unRegistering task: ").append(event.taskId()).toString());
            this.eCTaskEntranceMonitor().unregister(event.task().getTaskId());
            return;
        }
    }

    public void onEventError(Event event, Throwable t) {
    }

    public void shutdown() {
        this.eCTaskEntranceMonitor().shutdown();
    }

    public ECTaskEntranceMonitorService() {
        Logging.$init$((Logging)this);
        this.eCTaskEntranceMonitor = new ECTaskEntranceMonitor();
        this.syncListenerBus = ExecutorListenerBusContext$.MODULE$.getExecutorListenerBusContext().getEngineConnSyncListenerBus();
    }
}

