/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.entrance.interceptor.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.linkis.entrance.interceptor.impl.CommentHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.util.matching.Regex;

public final class SQLCommentHelper$
implements CommentHelper {
    public static SQLCommentHelper$ MODULE$;
    private final Regex commentPattern;
    private final String comment;
    private final String comment_sem;
    private final Logger logger;

    static {
        new SQLCommentHelper$();
    }

    @Override
    public Regex commentPattern() {
        return this.commentPattern;
    }

    private String comment() {
        return this.comment;
    }

    private String comment_sem() {
        return this.comment_sem;
    }

    private Logger logger() {
        return this.logger;
    }

    public String replaceComment(String code) {
        String string;
        try {
            Pattern pattern = Pattern.compile(this.comment_sem());
            Matcher matcher = pattern.matcher(code);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                String commentKeyword = matcher.group(1);
                String comment = matcher.group(2);
                String escapedComment = comment.replaceAll(";", "\\\\\\\\;");
                matcher.appendReplacement(sb, new StringBuilder(3).append(commentKeyword).append(" '").append(escapedComment).append("'").toString());
            }
            matcher.appendTail(sb);
            string = sb.toString();
        }
        catch (Exception e) {
            this.logger().warn("sql comment semicolon replace failed");
            string = code;
        }
        catch (Throwable t) {
            this.logger().warn("sql comment semicolon replace failed");
            string = code;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String dealComment(String code) {
        String string;
        try {
            void var3_3;
            Pattern p = Pattern.compile(this.comment());
            String sql = p.matcher(code).replaceAll("$1");
            string = var3_3;
        }
        catch (Exception e) {
            this.logger().warn("sql comment failed");
            string = code;
        }
        catch (Throwable t) {
            this.logger().warn("sql comment failed");
            string = code;
        }
        return string;
    }

    private SQLCommentHelper$() {
        MODULE$ = this;
        this.commentPattern = (Regex)new StringOps(Predef$.MODULE$.augmentString("\\s*--.+\\s*")).r().unanchored();
        this.comment = "(?ms)('(?:''|[^'])*')|--.*?$|/\\*.*?\\*/|#.*?$|";
        this.comment_sem = "(?i)(comment)\\s+'([^']*)'";
        this.logger = LoggerFactory.getLogger(this.getClass());
    }
}

