/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import org.apache.hadoop.hive.ql.exec.spark.SparkPlan;
import org.apache.hadoop.hive.ql.exec.spark.SparkShuffler;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.io.BytesWritable;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.storage.StorageLevel;

public class SortByShuffler
implements SparkShuffler<BytesWritable> {
    private final boolean totalOrder;
    private final SparkPlan sparkPlan;

    public SortByShuffler(boolean totalOrder, SparkPlan sparkPlan) {
        this.totalOrder = totalOrder;
        this.sparkPlan = sparkPlan;
    }

    @Override
    public JavaPairRDD<HiveKey, BytesWritable> shuffle(JavaPairRDD<HiveKey, BytesWritable> input, int numPartitions) {
        JavaPairRDD rdd;
        if (this.totalOrder) {
            if (numPartitions > 0) {
                if (numPartitions > 1 && input.getStorageLevel() == StorageLevel.NONE()) {
                    input.persist(StorageLevel.DISK_ONLY());
                    this.sparkPlan.addCachedRDDId(input.id());
                }
                rdd = input.sortByKey(true, numPartitions);
            } else {
                rdd = input.sortByKey(true);
            }
        } else {
            HashPartitioner partitioner = new HashPartitioner(numPartitions);
            rdd = input.repartitionAndSortWithinPartitions((Partitioner)partitioner);
        }
        return rdd;
    }

    @Override
    public String getName() {
        return "SortBy";
    }
}

