/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.resources;

import com.netflix.appinfo.EurekaAccept;
import com.netflix.eureka.EurekaServerContext;
import com.netflix.eureka.EurekaServerContextHolder;
import com.netflix.eureka.registry.Key;
import com.netflix.eureka.resources.AbstractVIPResource;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/{version}/vips")
@Produces(value={"application/xml", "application/json"})
public class VIPResource
extends AbstractVIPResource {
    @Inject
    VIPResource(EurekaServerContext server) {
        super(server);
    }

    public VIPResource() {
        this(EurekaServerContextHolder.getInstance().getServerContext());
    }

    @GET
    @Path(value="{vipAddress}")
    public Response statusUpdate(@PathParam(value="version") String version, @PathParam(value="vipAddress") String vipAddress, @HeaderParam(value="Accept") String acceptHeader, @HeaderParam(value="X-Eureka-Accept") String eurekaAccept) {
        return this.getVipResponse(version, vipAddress, acceptHeader, EurekaAccept.fromString((String)eurekaAccept), Key.EntityType.VIP);
    }
}

