/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.persistence.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.manager.common.entity.persistence.PersistenceLabel;
import org.apache.linkis.manager.common.entity.persistence.PersistenceLabelRel;
import org.apache.linkis.manager.common.entity.persistence.PersistenceNode;
import org.apache.linkis.manager.common.entity.persistence.PersistenceResource;
import org.apache.linkis.manager.dao.LabelManagerMapper;
import org.apache.linkis.manager.dao.NodeManagerMapper;
import org.apache.linkis.manager.entity.Tunple;
import org.apache.linkis.manager.errorcode.LinkisManagerPersistenceErrorCodeSummary;
import org.apache.linkis.manager.exception.PersistenceWarnException;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.persistence.LabelManagerPersistence;
import org.apache.linkis.manager.util.PersistenceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;

public class DefaultLabelManagerPersistence
implements LabelManagerPersistence {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private LabelManagerMapper labelManagerMapper;
    private NodeManagerMapper nodeManagerMapper;

    public LabelManagerMapper getLabelManagerMapper() {
        return this.labelManagerMapper;
    }

    public void setLabelManagerMapper(LabelManagerMapper labelManagerMapper) {
        this.labelManagerMapper = labelManagerMapper;
    }

    public NodeManagerMapper getNodeManagerMapper() {
        return this.nodeManagerMapper;
    }

    public void setNodeManagerMapper(NodeManagerMapper nodeManagerMapper) {
        this.nodeManagerMapper = nodeManagerMapper;
    }

    @Override
    public List<PersistenceLabelRel> getLabelByPattern(String labelValuePattern, String labelKey, Integer page, Integer size) {
        return this.labelManagerMapper.listLabelBySQLPattern(labelValuePattern, labelKey);
    }

    @Override
    public void addLabel(PersistenceLabel persistenceLabel) {
        this.labelManagerMapper.registerLabel(persistenceLabel);
        int labelId = persistenceLabel.getId();
        Map labelValueKeyAndContent = (Map)persistenceLabel.getValue();
    }

    @Override
    public void removeLabel(int id) {
        this.labelManagerMapper.deleteUserById(id);
        this.labelManagerMapper.deleteLabelKeyVaules(id);
        this.labelManagerMapper.deleteLabel(id);
    }

    @Override
    public void removeLabel(PersistenceLabel persistenceLabel) {
        String labelKey = persistenceLabel.getLabelKey();
        String labelStringValue = persistenceLabel.getStringValue();
        int labelId = persistenceLabel.getId();
        if (labelId <= 0) {
            PersistenceLabel labelByKeyValue = this.labelManagerMapper.getLabelByKeyValue(labelKey, labelStringValue);
            if (null == labelByKeyValue) {
                this.logger.warn("Can not find label labelKey {}, label value {}", (Object)labelKey, (Object)labelStringValue);
                return;
            }
            labelId = labelByKeyValue.getId();
        }
        if (labelId > 0) {
            this.labelManagerMapper.deleteLabel(labelId);
            this.labelManagerMapper.deleteLabelKeyVaules(labelId);
        }
    }

    @Override
    public void updateLabel(int id, PersistenceLabel persistenceLabel) {
        persistenceLabel.setUpdateTime(new Date());
        this.labelManagerMapper.updateLabel(id, persistenceLabel);
        this.labelManagerMapper.deleteLabelKeyVaules(id);
    }

    private void replaceIntoLabelKeyValues(Map<String, String> labelValueKeyAndContent, int labelId) {
        if (null != labelValueKeyAndContent && labelId > 0) {
            for (Map.Entry<String, String> labelKeyValue : labelValueKeyAndContent.entrySet()) {
                if (!StringUtils.isNotBlank((CharSequence)labelKeyValue.getKey())) continue;
                this.labelManagerMapper.replaceIntoLabelKeyValue(labelKeyValue.getKey(), labelKeyValue.getValue(), labelId);
            }
        }
    }

    @Override
    @Retryable(value={CannotGetJdbcConnectionException.class}, maxAttempts=5, backoff=@Backoff(delay=10000L))
    public PersistenceLabel getLabel(int id) {
        PersistenceLabel persistenceLabel = this.labelManagerMapper.getLabel(id);
        if (null != persistenceLabel) {
            PersistenceUtils.setValue(persistenceLabel);
        }
        return persistenceLabel;
    }

    @Override
    public List<PersistenceLabel> getLabelByServiceInstance(ServiceInstance serviceInstance) {
        List<PersistenceLabel> persistenceLabelList = this.labelManagerMapper.getLabelByServiceInstance(serviceInstance.getInstance());
        persistenceLabelList.forEach(PersistenceUtils::setValue);
        return persistenceLabelList;
    }

    @Override
    public List<PersistenceLabel> getLabelByResource(PersistenceResource persistenceResource) {
        List<PersistenceLabel> persistenceLabelList = this.labelManagerMapper.getLabelByResource(persistenceResource);
        return persistenceLabelList;
    }

    @Override
    public void addLabelToNode(ServiceInstance serviceInstance, List<Integer> labelIds) {
        if (!CollectionUtils.isEmpty(labelIds)) {
            this.labelManagerMapper.addLabelServiceInstance(serviceInstance.getInstance(), labelIds);
        }
    }

    @Override
    public List<PersistenceLabel> getLabelsByValue(Map<String, String> value, Label.ValueRelation valueRelation) {
        return this.getLabelsByValueList(Collections.singletonList(value), valueRelation);
    }

    @Override
    @Deprecated
    public List<PersistenceLabel> getLabelsByValueList(List<Map<String, String>> valueList, Label.ValueRelation valueRelation) {
        if (PersistenceUtils.valueListIsEmpty(valueList)) {
            return Collections.emptyList();
        }
        if (valueRelation == null) {
            valueRelation = Label.ValueRelation.ALL;
        }
        return null;
    }

    @Override
    public PersistenceLabel getLabelsByKeyValue(String labelKey, Map<String, String> value, Label.ValueRelation valueRelation) {
        List<PersistenceLabel> labelsByValueList = this.getLabelsByKeyValueMap(Collections.singletonMap(labelKey, value), valueRelation);
        return labelsByValueList.isEmpty() ? null : labelsByValueList.get(0);
    }

    @Override
    public List<PersistenceLabel> getLabelsByKeyValueMap(Map<String, Map<String, String>> keyValueMap, Label.ValueRelation valueRelation) {
        if (PersistenceUtils.KeyValueMapIsEmpty(keyValueMap)) {
            return Collections.emptyList();
        }
        if (valueRelation == null) {
            valueRelation = Label.ValueRelation.ALL;
        }
        return this.labelManagerMapper.dimListLabelByKeyValueMap(PersistenceUtils.filterEmptyKeyValueMap(keyValueMap), valueRelation.name()).stream().map(PersistenceUtils::setValue).collect(Collectors.toList());
    }

    @Override
    public List<PersistenceLabel> getLabelsByKey(String labelKey) {
        List<PersistenceLabel> persistenceLabelList = this.labelManagerMapper.getLabelsByLabelKey(labelKey);
        return persistenceLabelList;
    }

    @Override
    public void removeNodeLabels(ServiceInstance serviceInstance, List<Integer> labelIds) {
        String instance = serviceInstance.getInstance();
        if (null != labelIds && !labelIds.isEmpty()) {
            this.labelManagerMapper.deleteLabelIdsAndInstance(instance, labelIds);
        }
    }

    @Override
    public List<ServiceInstance> getNodeByLabel(int labelId) {
        List<PersistenceNode> persistenceNodeList = this.labelManagerMapper.getInstanceByLabelId(labelId);
        ArrayList<ServiceInstance> serviceInstanceList = new ArrayList<ServiceInstance>();
        for (PersistenceNode persistenceNode : persistenceNodeList) {
            ServiceInstance serviceInstance = new ServiceInstance();
            serviceInstance.setInstance(persistenceNode.getInstance());
            serviceInstance.setApplicationName(persistenceNode.getName());
            serviceInstanceList.add(serviceInstance);
        }
        return serviceInstanceList;
    }

    @Override
    public List<ServiceInstance> getNodeByLabels(List<Integer> labelIds) {
        if (labelIds == null || labelIds.isEmpty()) {
            return Collections.emptyList();
        }
        List<String> instances = this.labelManagerMapper.getInstanceIdsByLabelIds(labelIds);
        List<PersistenceNode> persistenceNodeList = this.nodeManagerMapper.getNodesByInstances(instances);
        ArrayList<ServiceInstance> serviceInstanceList = new ArrayList<ServiceInstance>();
        for (PersistenceNode persistenceNode : persistenceNodeList) {
            ServiceInstance serviceInstance = new ServiceInstance();
            serviceInstance.setInstance(persistenceNode.getInstance());
            serviceInstance.setApplicationName(persistenceNode.getName());
            serviceInstanceList.add(serviceInstance);
        }
        return serviceInstanceList;
    }

    @Override
    public void addLabelToUser(String userName, List<Integer> labelIds) {
        this.labelManagerMapper.addLabelsByUser(userName, labelIds);
    }

    @Override
    public void removeLabelFromUser(String userName, List<Integer> labelIds) {
        this.labelManagerMapper.deleteLabelIdsByUser(userName, labelIds);
    }

    @Override
    public List<String> getUserByLabel(int label) {
        List<String> userNames = this.labelManagerMapper.getUserNameByLabelId(label);
        return userNames;
    }

    @Override
    public List<String> getUserByLabels(List<Integer> labelIds) {
        List<String> userNames = this.labelManagerMapper.getUserNamesByLabelIds(labelIds);
        return userNames;
    }

    @Override
    public List<PersistenceLabel> getLabelsByUser(String userName) {
        List<PersistenceLabel> persistenceLabelList = this.labelManagerMapper.getLabelsByUser(userName);
        return persistenceLabelList;
    }

    @Override
    public Map<PersistenceLabel, List<ServiceInstance>> getNodeRelationsByLabels(List<PersistenceLabel> persistenceLabels) {
        if (PersistenceUtils.persistenceLabelListIsEmpty(persistenceLabels)) {
            return Collections.emptyMap();
        }
        try {
            List<Map<String, Object>> nodeRelationsByLabels = this.labelManagerMapper.getNodeRelationsByLabels(persistenceLabels);
            ArrayList<Tunple<PersistenceLabel, ServiceInstance>> arrays = new ArrayList<Tunple<PersistenceLabel, ServiceInstance>>();
            for (Map<String, Object> nodeRelationsByLabel : nodeRelationsByLabels) {
                ServiceInstance serviceInstance = new ServiceInstance();
                PersistenceLabel persistenceLabel = new PersistenceLabel();
                BeanUtils.populate((Object)serviceInstance, nodeRelationsByLabel);
                BeanUtils.populate((Object)persistenceLabel, nodeRelationsByLabel);
                PersistenceUtils.setValue(persistenceLabel);
                arrays.add(new Tunple<PersistenceLabel, ServiceInstance>(persistenceLabel, serviceInstance));
            }
            return arrays.stream().collect(Collectors.groupingBy(Tunple::getKey)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, f -> ((List)f.getValue()).stream().map(Tunple::getValue).collect(Collectors.toList())));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new PersistenceWarnException(LinkisManagerPersistenceErrorCodeSummary.BEANUTILS_POPULATE_FAILED.getErrorCode(), LinkisManagerPersistenceErrorCodeSummary.BEANUTILS_POPULATE_FAILED.getErrorDesc(), e);
        }
    }

    @Override
    public Map<ServiceInstance, List<PersistenceLabel>> getLabelRelationsByServiceInstance(List<ServiceInstance> serviceInstances) {
        if (CollectionUtils.isEmpty(serviceInstances)) {
            return Collections.emptyMap();
        }
        try {
            List<Map<String, Object>> nodeRelationsByLabels = this.labelManagerMapper.listLabelRelationByServiceInstance(serviceInstances);
            ArrayList arrays = new ArrayList();
            for (Map<String, Object> nodeRelationsByLabel : nodeRelationsByLabels) {
                Optional<ServiceInstance> instanceOption = serviceInstances.stream().filter(serviceInstance1 -> serviceInstance1.getInstance().equalsIgnoreCase(String.valueOf(nodeRelationsByLabel.get("instance")))).findFirst();
                PersistenceLabel persistenceLabel = new PersistenceLabel();
                BeanUtils.populate((Object)persistenceLabel, nodeRelationsByLabel);
                PersistenceUtils.setValue(persistenceLabel);
                instanceOption.ifPresent(serviceInstance -> arrays.add(new Tunple<ServiceInstance, PersistenceLabel>((ServiceInstance)serviceInstance, persistenceLabel)));
            }
            return arrays.stream().collect(Collectors.groupingBy(Tunple::getKey)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, f -> ((List)f.getValue()).stream().map(Tunple::getValue).collect(Collectors.toList())));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new PersistenceWarnException(LinkisManagerPersistenceErrorCodeSummary.BEANUTILS_POPULATE_FAILED.getErrorCode(), LinkisManagerPersistenceErrorCodeSummary.BEANUTILS_POPULATE_FAILED.getErrorDesc(), e);
        }
    }

    @Override
    public PersistenceLabel getLabelByKeyValue(String labelKey, String stringValue) {
        return this.labelManagerMapper.getLabelByKeyValue(labelKey, stringValue);
    }

    @Override
    public List<ServiceInstance> getNodeByLabelKeyValue(String labelKey, String stringValue) {
        return this.labelManagerMapper.getNodeByLabelKeyValue(labelKey, stringValue);
    }
}

