/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.orchestrator.execution.impl;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.linkis.common.listener.Event;
import org.apache.linkis.common.utils.ByteTimeUtils;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.governance.common.entity.ExecutionNodeStatus;
import org.apache.linkis.orchestrator.conf.OrchestratorConfiguration$;
import org.apache.linkis.orchestrator.execution.CompletedTaskResponse;
import org.apache.linkis.orchestrator.execution.ExecTaskRunner;
import org.apache.linkis.orchestrator.execution.ExecTaskRunner$;
import org.apache.linkis.orchestrator.execution.ExecutionTask;
import org.apache.linkis.orchestrator.execution.FailedTaskResponse;
import org.apache.linkis.orchestrator.execution.SucceedTaskResponse;
import org.apache.linkis.orchestrator.execution.impl.AbstractTaskManager;
import org.apache.linkis.orchestrator.execution.impl.BaseExecutionTask;
import org.apache.linkis.orchestrator.execution.impl.UserRunningNumber;
import org.apache.linkis.orchestrator.execution.impl.UserTaskRunner;
import org.apache.linkis.orchestrator.execution.impl.UserTaskRunnerPriorityQueue;
import org.apache.linkis.orchestrator.listener.OrchestratorSyncEvent;
import org.apache.linkis.orchestrator.listener.execution.ExecutionTaskCompletedEvent;
import org.apache.linkis.orchestrator.listener.task.RootTaskResponseEvent;
import org.apache.linkis.orchestrator.listener.task.TaskConsumerEvent;
import org.apache.linkis.orchestrator.plans.ast.ASTContext;
import org.apache.linkis.orchestrator.plans.physical.ExecTask;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.Set;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u0015a\u0001\u0002\u0013&\u0001IBQa\u0010\u0001\u0005\u0002\u0001CqA\u0011\u0001C\u0002\u0013%1\t\u0003\u0004Q\u0001\u0001\u0006I\u0001\u0012\u0005\b#\u0002\u0011\r\u0011\"\u0003S\u0011\u0019\u0019\u0007\u0001)A\u0005'\"9A\r\u0001b\u0001\n\u0013)\u0007BB:\u0001A\u0003%a\rC\u0004u\u0001\t\u0007I\u0011B3\t\rU\u0004\u0001\u0015!\u0003g\u0011\u001d1\bA1A\u0005\n]Da\u0001 \u0001!\u0002\u0013A\bbB?\u0001\u0005\u0004%IA \u0005\b\u0003\u000b\u0001\u0001\u0015!\u0003\u0000\u0011\u001d\t9\u0001\u0001C!\u0003\u0013Aq!a\b\u0001\t\u0003\t\t\u0003C\u0004\u0002*\u0001!\t%a\u000b\t\u000f\u0005%\u0002\u0001\"\u0011\u00024!9\u0011q\u0007\u0001\u0005B\u0005e\u0002bBA\u001c\u0001\u0011\u0005\u0013Q\b\u0005\b\u0003\u0003\u0002A\u0011AA\"\u0011\u001d\t9\u0005\u0001C\u0001\u0003\u0013Bq!!\u0015\u0001\t#\t\u0019\u0005C\u0004\u0002T\u0001!\t%!\u0016\t\u000f\u0005m\u0003\u0001\"\u0011\u0002^!9\u0011q\f\u0001\u0005B\u0005\u0005\u0004bBA6\u0001\u0011\u0005\u00131\t\u0005\b\u0003[\u0002A\u0011BA8\u0011\u001d\t\u0019\t\u0001C\u0005\u0003\u000bCq!!%\u0001\t\u0013\t\u0019\nC\u0004\u0002\u001e\u0002!\t\"a(\t\u000f\u0005\r\u0006\u0001\"\u0011\u0002&\"9\u0011q\u0017\u0001\u0005\n\u0005e\u0006bBA_\u0001\u0011\u0005\u0013q\u0018\u0005\b\u0003\u001f\u0004A\u0011KAi\u0011\u001d\ty\u000e\u0001C!\u0003C\u0014!\u0003R3gCVdG\u000fV1tW6\u000bg.Y4fe*\u0011aeJ\u0001\u0005S6\u0004HN\u0003\u0002)S\u0005IQ\r_3dkRLwN\u001c\u0006\u0003U-\nAb\u001c:dQ\u0016\u001cHO]1u_JT!\u0001L\u0017\u0002\r1Lgn[5t\u0015\tqs&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002a\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aM\u001c\u0011\u0005Q*T\"A\u0013\n\u0005Y*#aE!cgR\u0014\u0018m\u0019;UCN\\W*\u00198bO\u0016\u0014\bC\u0001\u001d>\u001b\u0005I$B\u0001\u001e<\u0003\u0015)H/\u001b7t\u0015\ta4&\u0001\u0004d_6lwN\\\u0005\u0003}e\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002\u0003B\u0011A\u0007A\u0001\u000fKb,7-\u001e;j_:$\u0016m]6t+\u0005!\u0005cA#K\u00196\taI\u0003\u0002H\u0011\u0006!Q\u000f^5m\u0015\u0005I\u0015\u0001\u00026bm\u0006L!a\u0013$\u0003\t1K7\u000f\u001e\t\u0003\u001b:k\u0011aJ\u0005\u0003\u001f\u001e\u0012Q\"\u0012=fGV$\u0018n\u001c8UCN\\\u0017aD3yK\u000e,H/[8o)\u0006\u001c8n\u001d\u0011\u0002/\u0015DXm\u0019+bg.$v.\u0012=fGV$\u0018n\u001c8UCN\\W#A*\u0011\t\u0015#f\u000bT\u0005\u0003+\u001a\u00131!T1q!\t9\u0006M\u0004\u0002Y=B\u0011\u0011\fX\u0007\u00025*\u00111,M\u0001\u0007yI|w\u000e\u001e \u000b\u0003u\u000bQa]2bY\u0006L!a\u0018/\u0002\rA\u0013X\rZ3g\u0013\t\t'M\u0001\u0004TiJLgn\u001a\u0006\u0003?r\u000b\u0001$\u001a=fGR\u000b7o\u001b+p\u000bb,7-\u001e;j_:$\u0016m]6!\u0003y)\u00070Z2vi&|g\u000eV1tWR{'+\u001e8oS:<W\t_3d)\u0006\u001c8.F\u0001g!\u00119GNV7\u000e\u0003!T!!\u001b6\u0002\u000f5,H/\u00192mK*\u00111\u000eX\u0001\u000bG>dG.Z2uS>t\u0017BA+i!\r9g\u000e]\u0005\u0003_\"\u00141\"\u0011:sCf\u0014UO\u001a4feB\u0011Q*]\u0005\u0003e\u001e\u0012a\"\u0012=fGR\u000b7o\u001b*v]:,'/A\u0010fq\u0016\u001cW\u000f^5p]R\u000b7o\u001b+p%Vtg.\u001b8h\u000bb,7\rV1tW\u0002\n\u0001%\u001a=fGV$\u0018n\u001c8UCN\\Gk\\\"p[BdW\r^3e\u000bb,7\rV1tW\u0006\tS\r_3dkRLwN\u001c+bg.$vnQ8na2,G/\u001a3Fq\u0016\u001cG+Y:lA\u0005!R*\u0011-`%Vse*\u0012*`)\u0006\u001b6jX*J5\u0016+\u0012\u0001\u001f\t\u0003sjl\u0011\u0001X\u0005\u0003wr\u00131!\u00138u\u0003Ui\u0015\tW0S+:sUIU0U\u0003N[ulU%[\u000b\u0002\n\u0011#^:feJ+hN\\5oO:+XNY3s+\u0005y\bc\u0001\u001b\u0002\u0002%\u0019\u00111A\u0013\u0003#U\u001bXM\u001d*v]:Lgn\u001a(v[\n,'/\u0001\nvg\u0016\u0014(+\u001e8oS:<g*^7cKJ\u0004\u0013a\u00039vi\u0016CXm\u0019+bg.$2\u0001TA\u0006\u0011\u001d\tiA\u0004a\u0001\u0003\u001f\tA\u0001^1tWB!\u0011\u0011CA\u000e\u001b\t\t\u0019B\u0003\u0003\u0002\u0016\u0005]\u0011\u0001\u00039isNL7-\u00197\u000b\u0007\u0005e\u0011&A\u0003qY\u0006t7/\u0003\u0003\u0002\u001e\u0005M!\u0001C#yK\u000e$\u0016m]6\u00021\u001d,GOU;o]&tw-\u0012=fGV$\u0018n\u001c8UCN\\7/\u0006\u0002\u0002$A!\u00110!\nW\u0013\r\t9\u0003\u0018\u0002\u0006\u0003J\u0014\u0018-_\u0001\u000fO\u0016$(+\u001e8oS:<G+Y:l)\u0011\ti#a\f\u0011\te\f)\u0003\u001d\u0005\u0007\u0003c\u0001\u0002\u0019\u0001,\u0002\u001f\u0015DXmY;uS>tG+Y:l\u0013\u0012$B!!\f\u00026!9\u0011QB\tA\u0002\u0005=\u0011!E4fi\u000e{W\u000e\u001d7fi\u0016$G+Y:lgR!\u0011QFA\u001e\u0011\u0019\t\tD\u0005a\u0001-R!\u0011QFA \u0011\u001d\tia\u0005a\u0001\u0003\u001f\t\u0011dZ3u%Vtg.\u00192mK\u0016CXmY;uS>tG+Y:lgV\u0011\u0011Q\t\t\u0005s\u0006\u0015B*\u0001\u0013hKR\u0014VO\u001c8bE2,W\t_3dkRLwN\u001c+bg.\u001c\u0018I\u001c3Fq\u0016\u001cG+Y:l+\t\tY\u0005E\u0004z\u0003\u001b\n)%!\f\n\u0007\u0005=CL\u0001\u0004UkBdWMM\u0001\u001aO\u0016$8+^5uC\ndW-\u0012=fGV$\u0018n\u001c8UCN\\7/A\tuCN\\'+\u001e8oC\ndW\rV1tWN$B!!\f\u0002X!9\u0011\u0011L\fA\u0002\u00055\u0012aD3yK\u000e$\u0016m]6Sk:tWM]:\u0002!\u001d,GOU;o]\u0006\u0014G.\u001a+bg.\u001cXCAA\u0017\u0003A\tG\rZ\"p[BdW\r^3e)\u0006\u001c8\u000e\u0006\u0003\u0002d\u0005%\u0004cA=\u0002f%\u0019\u0011q\r/\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003\u001bI\u0002\u0019\u00019\u00027A|G\u000e\\\"p[BdW\r^3e\u000bb,7-\u001e;j_:$\u0016m]6t\u0003Y9W\r^*vER\u000b7o[:SK\u000e,(o]5wK2LH\u0003CA2\u0003c\n)(!\u001f\t\r\u0005M4\u00041\u0001M\u00035)\u00070Z2vi&|g\u000eV1tW\"9\u0011qO\u000eA\u0002\u0005=\u0011\u0001C3yK\u000e$\u0016m]6\t\u000f\u0005m4\u00041\u0001\u0002~\u0005A1/\u001e2UCN\\7\u000fE\u0003h\u0003\u007f\ny!C\u0002\u0002\u0002\"\u00141aU3u\u0003)I7/\u0012=fGV$X\r\u001a\u000b\u0007\u0003\u000f\u000bi)a$\u0011\u0007e\fI)C\u0002\u0002\fr\u0013qAQ8pY\u0016\fg\u000e\u0003\u0004\u0002tq\u0001\r\u0001\u0014\u0005\b\u0003ob\u0002\u0019AA\b\u0003a1\u0017N\u001c3V]\u000e{W\u000e\u001d7fi\u0016$W\t_3d)\u0006\u001c8n\u001d\u000b\u0007\u0003+\u000b9*!'\u0011\u000be\f)#a\u0004\t\r\u0005ER\u00041\u0001W\u0011\u001d\tY*\ba\u0001\u0003+\u000bQ\u0001^1tWN\fA#\u001a=fGR\u000b7o\u001b+p)\u0006\u001c8NU;o]\u0016\u0014Hc\u00019\u0002\"\"9\u0011q\u000f\u0010A\u0002\u0005=\u0011aC8o'ft7-\u0012<f]R$B!a\u0019\u0002(\"9\u0011\u0011V\u0010A\u0002\u0005-\u0016!B3wK:$\b\u0003BAW\u0003gk!!a,\u000b\u0007\u0005E\u0016&\u0001\u0005mSN$XM\\3s\u0013\u0011\t),a,\u0003+=\u00138\r[3tiJ\fGo\u001c:Ts:\u001cWI^3oi\u0006\u00112\r\\3be\u0016CXmY;uS>tG+Y:l)\u0011\t\u0019'a/\t\r\u0005M\u0004\u00051\u0001M\u0003]ygNU8piR\u000b7o\u001b*fgB|gn]3Fm\u0016tG\u000f\u0006\u0003\u0002d\u0005\u0005\u0007bBAbC\u0001\u0007\u0011QY\u0001\u0016e>|G\u000fV1tWJ+7\u000f]8og\u0016,e/\u001a8u!\u0011\t9-a3\u000e\u0005\u0005%'\u0002BA\u0007\u0003_KA!!4\u0002J\n)\"k\\8u)\u0006\u001c8NU3ta>t7/Z#wK:$\u0018AG7be.,\u00050Z2vi&|g\u000eV1tW\u000e{W\u000e\u001d7fi\u0016$GCBA2\u0003'\f)\u000e\u0003\u0004\u0002t\t\u0002\r\u0001\u0014\u0005\b\u0003/\u0014\u0003\u0019AAm\u00031!\u0018m]6SKN\u0004xN\\:f!\ri\u00151\\\u0005\u0004\u0003;<#!F\"p[BdW\r^3e)\u0006\u001c8NU3ta>t7/Z\u0001\r_:,e/\u001a8u\u000bJ\u0014xN\u001d\u000b\u0007\u0003G\n\u0019/a<\t\u000f\u0005%6\u00051\u0001\u0002fB!\u0011q]Av\u001b\t\tIOC\u0002\u00022nJA!!<\u0002j\n)QI^3oi\"9\u0011\u0011_\u0012A\u0002\u0005M\u0018!\u0001;\u0011\t\u0005U\u0018q \b\u0005\u0003o\fYPD\u0002Z\u0003sL\u0011!X\u0005\u0004\u0003{d\u0016a\u00029bG.\fw-Z\u0005\u0005\u0005\u0003\u0011\u0019AA\u0005UQJ|w/\u00192mK*\u0019\u0011Q /")
public class DefaultTaskManager
extends AbstractTaskManager
implements Logging {
    private final List<ExecutionTask> executionTasks;
    private final Map<String, ExecutionTask> execTaskToExecutionTask;
    private final scala.collection.mutable.Map<String, ArrayBuffer<ExecTaskRunner>> executionTaskToRunningExecTask;
    private final scala.collection.mutable.Map<String, ArrayBuffer<ExecTaskRunner>> executionTaskToCompletedExecTask;
    private final int MAX_RUNNER_TASK_SIZE;
    private final UserRunningNumber userRunningNumber;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        DefaultTaskManager defaultTaskManager = this;
        synchronized (defaultTaskManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private List<ExecutionTask> executionTasks() {
        return this.executionTasks;
    }

    private Map<String, ExecutionTask> execTaskToExecutionTask() {
        return this.execTaskToExecutionTask;
    }

    private scala.collection.mutable.Map<String, ArrayBuffer<ExecTaskRunner>> executionTaskToRunningExecTask() {
        return this.executionTaskToRunningExecTask;
    }

    private scala.collection.mutable.Map<String, ArrayBuffer<ExecTaskRunner>> executionTaskToCompletedExecTask() {
        return this.executionTaskToCompletedExecTask;
    }

    private int MAX_RUNNER_TASK_SIZE() {
        return this.MAX_RUNNER_TASK_SIZE;
    }

    private UserRunningNumber userRunningNumber() {
        return this.userRunningNumber;
    }

    @Override
    public ExecutionTask putExecTask(ExecTask task) {
        if (task != null) {
            BaseExecutionTask executionTask = new BaseExecutionTask(BoxesRunTime.unboxToInt((Object)OrchestratorConfiguration$.MODULE$.EXECUTION_TASK_MAX_PARALLELISM().getValue()), task);
            this.executionTasks().add(executionTask);
            this.execTaskToExecutionTask().put(task.getId(), executionTask);
            this.logger().info(new StringBuilder(50).append("submit execTask ").append(task.getIDInfo()).append(" to taskManager get executionTask ").append(executionTask.getId()).toString());
            task.getPhysicalContext().broadcastAsyncEvent(new TaskConsumerEvent(task));
            return executionTask;
        }
        return null;
    }

    public String[] getRunningExecutionTasks() {
        return (String[])this.executionTaskToRunningExecTask().keysIterator().toArray(ClassTag$.MODULE$.apply(String.class));
    }

    @Override
    public ExecTaskRunner[] getRunningTask(String executionTaskId) {
        return (ExecTaskRunner[])this.executionTaskToRunningExecTask().get((Object)executionTaskId).map((Function1 & Serializable & scala.Serializable)x$1 -> (ExecTaskRunner[])x$1.toArray(ClassTag$.MODULE$.apply(ExecTaskRunner.class))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (ExecTaskRunner[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ExecTaskRunner.class)));
    }

    @Override
    public ExecTaskRunner[] getRunningTask(ExecTask task) {
        ExecutionTask executionTask = this.execTaskToExecutionTask().get(task.getId());
        if (executionTask != null) {
            return (ExecTaskRunner[])this.executionTaskToRunningExecTask().get((Object)executionTask.getId()).map((Function1 & Serializable & scala.Serializable)x$2 -> (ExecTaskRunner[])x$2.toArray(ClassTag$.MODULE$.apply(ExecTaskRunner.class))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (ExecTaskRunner[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ExecTaskRunner.class)));
        }
        return (ExecTaskRunner[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ExecTaskRunner.class));
    }

    @Override
    public ExecTaskRunner[] getCompletedTasks(String executionTaskId) {
        return (ExecTaskRunner[])this.executionTaskToCompletedExecTask().get((Object)executionTaskId).map((Function1 & Serializable & scala.Serializable)x$3 -> (ExecTaskRunner[])x$3.toArray(ClassTag$.MODULE$.apply(ExecTaskRunner.class))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (ExecTaskRunner[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ExecTaskRunner.class)));
    }

    @Override
    public ExecTaskRunner[] getCompletedTasks(ExecTask task) {
        ExecutionTask executionTask = this.execTaskToExecutionTask().get(task.getId());
        if (executionTask != null) {
            return (ExecTaskRunner[])this.executionTaskToCompletedExecTask().get((Object)executionTask.getId()).map((Function1 & Serializable & scala.Serializable)x$4 -> (ExecTaskRunner[])x$4.toArray(ClassTag$.MODULE$.apply(ExecTaskRunner.class))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (ExecTaskRunner[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ExecTaskRunner.class)));
        }
        return (ExecTaskRunner[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ExecTaskRunner.class));
    }

    public ExecutionTask[] getRunnableExecutionTasks() {
        return (ExecutionTask[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getSuitableExecutionTasks())).filter((Function1 & Serializable & scala.Serializable)executionTask -> BoxesRunTime.boxToBoolean((boolean)DefaultTaskManager.$anonfun$getRunnableExecutionTasks$1(this, executionTask)));
    }

    public Tuple2<ExecutionTask[], ExecTaskRunner[]> getRunnableExecutionTasksAndExecTask() {
        ArrayBuffer execTaskRunners = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ExecutionTask[] runningExecutionTasks = (ExecutionTask[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getSuitableExecutionTasks())).filter((Function1 & Serializable & scala.Serializable)executionTask -> BoxesRunTime.boxToBoolean((boolean)DefaultTaskManager.$anonfun$getRunnableExecutionTasksAndExecTask$1(this, execTaskRunners, executionTask)));
        return new Tuple2((Object)runningExecutionTasks, execTaskRunners.toArray(ClassTag$.MODULE$.apply(ExecTaskRunner.class)));
    }

    public ExecutionTask[] getSuitableExecutionTasks() {
        return (ExecutionTask[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.executionTasks()).asScala()).filter((Function1 & Serializable & scala.Serializable)executionTask -> BoxesRunTime.boxToBoolean((boolean)DefaultTaskManager.$anonfun$getSuitableExecutionTasks$1(executionTask)))).toArray(ClassTag$.MODULE$.apply(ExecutionTask.class));
    }

    @Override
    public ExecTaskRunner[] taskRunnableTasks(ExecTaskRunner[] execTaskRunners) {
        int maxRunning;
        int nowRunningNumber = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.executionTaskToRunningExecTask().values().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.length()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        int n = maxRunning = nowRunningNumber >= this.MAX_RUNNER_TASK_SIZE() ? 0 : this.MAX_RUNNER_TASK_SIZE() - nowRunningNumber;
        if (maxRunning == 0) {
            this.logger().warn(new StringBuilder(52).append("The current running has exceeded the maximum, now: ").append(nowRunningNumber).append(" ").toString());
            return (ExecTaskRunner[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ExecTaskRunner.class));
        }
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])execTaskRunners)).isEmpty()) {
            this.logger().debug("There are no tasks to run now");
            return (ExecTaskRunner[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ExecTaskRunner.class));
        }
        UserTaskRunnerPriorityQueue userTaskRunnerQueue = new UserTaskRunnerPriorityQueue();
        userTaskRunnerQueue.addAll((ExecTaskRunner[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])execTaskRunners)).toArray(ClassTag$.MODULE$.apply(ExecTaskRunner.class)), this.userRunningNumber().copy());
        UserTaskRunner[] userTaskRunners = userTaskRunnerQueue.takeTaskRunner(maxRunning);
        ArrayBuffer runners = new ArrayBuffer();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])userTaskRunners)).foreach((Function1 & Serializable & scala.Serializable)userTaskRunner -> {
            ExecTask execTask = userTaskRunner.taskRunner().task();
            ExecutionTask executionTask = this.execTaskToExecutionTask().get(execTask.getPhysicalContext().getRootTask().getId());
            if (executionTask != null) {
                ArrayBuffer arrayBuffer;
                String executionTaskId = executionTask.getId();
                scala.collection.mutable.Map<String, ArrayBuffer<ExecTaskRunner>> map = this.executionTaskToRunningExecTask();
                synchronized (map) {
                    ArrayBuffer arrayBuffer2;
                    if (!this.executionTaskToRunningExecTask().contains((Object)executionTaskId)) {
                        ArrayBuffer taskRunnerBuffer = new ArrayBuffer();
                        this.executionTaskToRunningExecTask().put((Object)executionTaskId, (Object)taskRunnerBuffer);
                        ASTContext astContext = execTask.getTaskDesc().getOrigin().getASTOrchestration().getASTContext();
                        int oldNumber = this.userRunningNumber().addNumber(astContext.getExecuteUser(), astContext.getLabels(), this.userRunningNumber().addNumber$default$3());
                        this.logger().info(new StringBuilder(55).append("user key ").append(this.userRunningNumber().getKey(astContext.getLabels(), astContext.getExecuteUser())).append(", ").append("executionTaskId ").append(executionTaskId).append(" to addNumber: ").append(oldNumber + 1).append(", maxRunning:").append(maxRunning).toString());
                        arrayBuffer2 = taskRunnerBuffer;
                    } else {
                        arrayBuffer2 = (ArrayBuffer)this.executionTaskToRunningExecTask().apply((Object)executionTaskId);
                    }
                    ArrayBuffer runningExecTaskRunner = arrayBuffer2;
                    runningExecTaskRunner.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecTaskRunner[]{userTaskRunner.taskRunner()}));
                    arrayBuffer = runners.$plus$eq((Object)userTaskRunner.taskRunner());
                }
                return arrayBuffer;
            }
            return BoxedUnit.UNIT;
        });
        return (ExecTaskRunner[])runners.toArray(ClassTag$.MODULE$.apply(ExecTaskRunner.class));
    }

    @Override
    public ExecTaskRunner[] getRunnableTasks() {
        long startTime = System.currentTimeMillis();
        this.logger().debug(new StringBuilder(37).append("Start to getRunnableTasks startTime: ").append(startTime).toString());
        ArrayBuffer execTaskRunners = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ExecutionTask[] runningExecutionTasks = this.getSuitableExecutionTasks();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])runningExecutionTasks)).foreach((Function1 & Serializable & scala.Serializable)executionTask -> {
            ExecTask execTask2 = executionTask.getRootExecTask();
            HashSet runnableSubTasks = new HashSet();
            this.getSubTasksRecursively((ExecutionTask)executionTask, execTask2, (Set<ExecTask>)runnableSubTasks);
            HashSet subExecTaskRunners = (HashSet)runnableSubTasks.map((Function1 & Serializable & scala.Serializable)execTask -> this.execTaskToTaskRunner((ExecTask)execTask), HashSet$.MODULE$.canBuildFrom());
            return execTaskRunners.$plus$plus$eq((TraversableOnce)subExecTaskRunners);
        });
        long finishTime = System.currentTimeMillis();
        this.logger().debug(new StringBuilder(49).append("Finished to getRunnableTasks finishTime: ").append(finishTime).append(",").append("taken: ").append(ByteTimeUtils.msDurationToString((long)(finishTime - startTime))).toString());
        return this.taskRunnableTasks((ExecTaskRunner[])execTaskRunners.toArray(ClassTag$.MODULE$.apply(ExecTaskRunner.class)));
    }

    @Override
    public void addCompletedTask(ExecTaskRunner task) {
        this.logger().info(new StringBuilder(44).append(task.task().getIDInfo()).append(" task completed, now remove from taskManager").toString());
        ExecTask rootTask = task.task().getPhysicalContext().getRootTask();
        ASTContext astContext = rootTask.getTaskDesc().getOrigin().getASTOrchestration().getASTContext();
        ExecutionTask executionTask = this.execTaskToExecutionTask().get(rootTask.getId());
        if (executionTask != null) {
            scala.collection.mutable.Map<String, ArrayBuffer<ExecTaskRunner>> map = this.executionTaskToCompletedExecTask();
            synchronized (map) {
                ArrayBuffer arrayBuffer;
                ArrayBuffer completedRunners = (ArrayBuffer)this.executionTaskToCompletedExecTask().getOrElseUpdate((Object)executionTask.getId(), (Function0 & Serializable & scala.Serializable)() -> new ArrayBuffer());
                if (!completedRunners.exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DefaultTaskManager.$anonfun$addCompletedTask$2(task, x$6)))) {
                    arrayBuffer = completedRunners.$plus$eq((Object)task);
                } else {
                    this.logger().error(new StringBuilder(40).append("Task").append(task.task().getIDInfo()).append(" has completed, but has in completed").toString());
                    arrayBuffer = BoxedUnit.UNIT;
                }
            }
            scala.collection.mutable.Map<String, ArrayBuffer<ExecTaskRunner>> map2 = this.executionTaskToRunningExecTask();
            synchronized (map2) {
                BoxedUnit boxedUnit;
                ArrayBuffer oldRunningTasks = (ArrayBuffer)this.executionTaskToRunningExecTask().getOrElse((Object)executionTask.getId(), (Function0 & Serializable & scala.Serializable)() -> null);
                boolean shouldMinusTaskNumber = false;
                if (oldRunningTasks != null) {
                    ArrayBuffer runningRunners = (ArrayBuffer)oldRunningTasks.filterNot((Function1 & Serializable & scala.Serializable)runner -> BoxesRunTime.boxToBoolean((boolean)DefaultTaskManager.$anonfun$addCompletedTask$4(task, runner)));
                    if (runningRunners.isEmpty()) {
                        this.executionTaskToRunningExecTask().remove((Object)executionTask.getId());
                        shouldMinusTaskNumber = true;
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = this.executionTaskToRunningExecTask().put((Object)executionTask.getId(), (Object)runningRunners);
                    }
                } else {
                    shouldMinusTaskNumber = true;
                    boxedUnit = BoxedUnit.UNIT;
                }
                if (shouldMinusTaskNumber) {
                    int oldNumber = this.userRunningNumber().minusNumber(astContext.getExecuteUser(), astContext.getLabels(), this.userRunningNumber().minusNumber$default$3());
                    this.logger().info(new StringBuilder(57).append("executionTask(").append(executionTask.getId()).append(") no task running, user key ").append(this.userRunningNumber().getKey(astContext.getLabels(), astContext.getExecuteUser())).append(", minusNumber: ").append(oldNumber - 1).toString());
                }
            }
        }
        rootTask.getPhysicalContext().broadcastAsyncEvent(new TaskConsumerEvent(task.task()));
    }

    @Override
    public ExecutionTask[] pollCompletedExecutionTasks() {
        return (ExecutionTask[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.executionTasks()).asScala()).filter((Function1 & Serializable & scala.Serializable)executionTask -> BoxesRunTime.boxToBoolean((boolean)DefaultTaskManager.$anonfun$pollCompletedExecutionTasks$1(executionTask)))).toArray(ClassTag$.MODULE$.apply(ExecutionTask.class));
    }

    private void getSubTasksRecursively(ExecutionTask executionTask, ExecTask execTask, Set<ExecTask> subTasks) {
        if (subTasks.size() > executionTask.getMaxParallelism() || this.isExecuted(executionTask, execTask)) {
            return;
        }
        ExecTask[] tasks = this.findUnCompletedExecTasks(executionTask.getId(), (ExecTask[])execTask.getChildren());
        if (tasks == null || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tasks)).isEmpty()) {
            if (execTask.canExecute()) {
                subTasks.add((Object)execTask);
                return;
            }
            return;
        }
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tasks)).foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            this.getSubTasksRecursively(executionTask, x$7, (Set<ExecTask>)subTasks);
            return BoxedUnit.UNIT;
        });
    }

    private boolean isExecuted(ExecutionTask executionTask, ExecTask execTask) {
        boolean runningDefined = this.executionTaskToRunningExecTask().get((Object)executionTask.getId()).exists((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)DefaultTaskManager.$anonfun$isExecuted$2(execTask$1, x$9)))));
        boolean completedDefined = this.executionTaskToCompletedExecTask().get((Object)executionTask.getId()).exists((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.exists((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)DefaultTaskManager.$anonfun$isExecuted$4(execTask$1, x$11)))));
        return runningDefined || completedDefined;
    }

    private ExecTask[] findUnCompletedExecTasks(String executionTaskId, ExecTask[] tasks) {
        Option maybeRunners = this.executionTaskToCompletedExecTask().get((Object)executionTaskId);
        if (maybeRunners.isDefined()) {
            ArrayBuffer completedTask = (ArrayBuffer)maybeRunners.get();
            return (ExecTask[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tasks)).filter((Function1 & Serializable & scala.Serializable)execTask -> BoxesRunTime.boxToBoolean((boolean)DefaultTaskManager.$anonfun$findUnCompletedExecTasks$1(completedTask, execTask)));
        }
        return tasks;
    }

    public ExecTaskRunner execTaskToTaskRunner(ExecTask execTask) {
        ExecTaskRunner execTaskRunner = ExecTaskRunner$.MODULE$.getExecTaskRunnerFactory().createExecTaskRunner(execTask);
        return execTaskRunner;
    }

    @Override
    public void onSyncEvent(OrchestratorSyncEvent event) {
        OrchestratorSyncEvent orchestratorSyncEvent = event;
        if (orchestratorSyncEvent instanceof RootTaskResponseEvent) {
            RootTaskResponseEvent rootTaskResponseEvent = (RootTaskResponseEvent)orchestratorSyncEvent;
            this.onRootTaskResponseEvent(rootTaskResponseEvent);
            return;
        }
    }

    private void clearExecutionTask(ExecutionTask executionTask) {
        Option option;
        ExecTask task = executionTask.getRootExecTask();
        ASTContext astContext = task.getTaskDesc().getOrigin().getASTOrchestration().getASTContext();
        this.logger().info(new StringBuilder(34).append("executionTask(").append(executionTask.getId()).append(") finished user key ").append(this.userRunningNumber().getKey(astContext.getLabels(), astContext.getExecuteUser())).toString());
        this.executionTasks().remove(executionTask);
        this.execTaskToExecutionTask().remove(task.getId());
        scala.collection.mutable.Map<String, ArrayBuffer<ExecTaskRunner>> map = this.executionTaskToCompletedExecTask();
        synchronized (map) {
            this.executionTaskToCompletedExecTask().remove((Object)executionTask.getId());
        }
        scala.collection.mutable.Map<String, ArrayBuffer<ExecTaskRunner>> map2 = this.executionTaskToRunningExecTask();
        synchronized (map2) {
            option = this.executionTaskToRunningExecTask().remove((Object)executionTask.getId());
        }
        Option maybeRunners = option;
        if (maybeRunners.isDefined()) {
            int oldNumber = this.userRunningNumber().minusNumber(astContext.getExecuteUser(), astContext.getLabels(), this.userRunningNumber().minusNumber$default$3());
            this.logger().info(new StringBuilder(49).append("executionTask(").append(executionTask.getId()).append(") finished user key ").append(this.userRunningNumber().getKey(astContext.getLabels(), astContext.getExecuteUser())).append(", minusNumber: ").append(oldNumber - 1).toString());
            return;
        }
    }

    @Override
    public void onRootTaskResponseEvent(RootTaskResponseEvent rootTaskResponseEvent) {
        this.logger().info(new StringBuilder(31).append("received rootTaskResponseEvent ").append(rootTaskResponseEvent.execTask().getIDInfo()).toString());
        ExecTask rootTask = rootTaskResponseEvent.execTask();
        ExecutionTask executionTask = this.execTaskToExecutionTask().get(rootTask.getId());
        if (executionTask != null) {
            CompletedTaskResponse completedTaskResponse = rootTaskResponseEvent.taskResponse();
            if (completedTaskResponse instanceof FailedTaskResponse) {
                FailedTaskResponse failedTaskResponse = (FailedTaskResponse)completedTaskResponse;
                this.markExecutionTaskCompleted(executionTask, failedTaskResponse);
                return;
            }
            if (completedTaskResponse instanceof SucceedTaskResponse) {
                SucceedTaskResponse succeedTaskResponse = (SucceedTaskResponse)completedTaskResponse;
                this.markExecutionTaskCompleted(executionTask, succeedTaskResponse);
                return;
            }
            throw new MatchError((Object)completedTaskResponse);
        }
    }

    @Override
    public void markExecutionTaskCompleted(ExecutionTask executionTask, CompletedTaskResponse taskResponse) {
        this.logger().debug(new StringBuilder(58).append("Start to mark executionTask(").append(executionTask.getId()).append(") rootExecTask ").append(executionTask.getRootExecTask().getIDInfo()).append(" to  Completed.").toString());
        this.clearExecutionTask(executionTask);
        executionTask.getRootExecTask().getPhysicalContext().broadcastSyncEvent(new ExecutionTaskCompletedEvent(executionTask.getId(), executionTask, taskResponse));
        this.logger().info(new StringBuilder(61).append("Finished to mark executionTask(").append(executionTask.getId()).append(") rootExecTask ").append(executionTask.getRootExecTask().getIDInfo()).append(" to  Completed.").toString());
    }

    public void onEventError(Event event, Throwable t) {
    }

    public static final /* synthetic */ boolean $anonfun$getRunnableExecutionTasks$1(DefaultTaskManager $this, ExecutionTask executionTask) {
        ExecTask execTask = executionTask.getRootExecTask();
        HashSet subTasks = new HashSet();
        $this.getSubTasksRecursively(executionTask, execTask, (Set<ExecTask>)subTasks);
        return subTasks.nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$getRunnableExecutionTasksAndExecTask$1(DefaultTaskManager $this, ArrayBuffer execTaskRunners$1, ExecutionTask executionTask) {
        ExecTask execTask2 = executionTask.getRootExecTask();
        HashSet runnableSubTasks = new HashSet();
        $this.getSubTasksRecursively(executionTask, execTask2, (Set<ExecTask>)runnableSubTasks);
        if (runnableSubTasks.nonEmpty()) {
            HashSet subExecTaskRunners = (HashSet)runnableSubTasks.map((Function1 & Serializable & scala.Serializable)execTask -> $this.execTaskToTaskRunner((ExecTask)execTask), HashSet$.MODULE$.canBuildFrom());
            execTaskRunners$1.$plus$plus$eq((TraversableOnce)subExecTaskRunners);
            return true;
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$getSuitableExecutionTasks$1(ExecutionTask executionTask) {
        return executionTask.getRootExecTask().canExecute() && !ExecutionNodeStatus.isCompleted((ExecutionNodeStatus)executionTask.getStatus());
    }

    public static final /* synthetic */ boolean $anonfun$addCompletedTask$2(ExecTaskRunner task$1, ExecTaskRunner x$6) {
        return x$6.task().getId().equals(task$1.task().getId());
    }

    public static final /* synthetic */ boolean $anonfun$addCompletedTask$4(ExecTaskRunner task$1, ExecTaskRunner runner) {
        return task$1.task().getId().equals(runner.task().getId());
    }

    public static final /* synthetic */ boolean $anonfun$pollCompletedExecutionTasks$1(ExecutionTask executionTask) {
        return ExecutionNodeStatus.isCompleted((ExecutionNodeStatus)executionTask.getStatus());
    }

    public static final /* synthetic */ boolean $anonfun$isExecuted$2(ExecTask execTask$1, ExecTaskRunner x$9) {
        return x$9.task().getId().equals(execTask$1.getId());
    }

    public static final /* synthetic */ boolean $anonfun$isExecuted$4(ExecTask execTask$1, ExecTaskRunner x$11) {
        return x$11.task().getId().equals(execTask$1.getId());
    }

    public static final /* synthetic */ boolean $anonfun$findUnCompletedExecTasks$2(ExecTask execTask$2, ExecTaskRunner x$12) {
        return x$12.task().getId().equals(execTask$2.getId());
    }

    public static final /* synthetic */ boolean $anonfun$findUnCompletedExecTasks$1(ArrayBuffer completedTask$1, ExecTask execTask) {
        return !completedTask$1.exists((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)DefaultTaskManager.$anonfun$findUnCompletedExecTasks$2(execTask, x$12)));
    }

    public DefaultTaskManager() {
        Logging.$init$((Logging)this);
        this.executionTasks = new CopyOnWriteArrayList<ExecutionTask>();
        this.execTaskToExecutionTask = new ConcurrentHashMap<String, ExecutionTask>();
        this.executionTaskToRunningExecTask = new HashMap();
        this.executionTaskToCompletedExecTask = new HashMap();
        this.MAX_RUNNER_TASK_SIZE = BoxesRunTime.unboxToInt((Object)OrchestratorConfiguration$.MODULE$.TASK_RUNNER_MAX_SIZE().getValue());
        this.userRunningNumber = new UserRunningNumber();
    }
}

