/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.datasourcemanager.core.service.impl;

import java.io.InputStream;
import javax.annotation.PostConstruct;
import org.apache.linkis.bml.client.BmlClient;
import org.apache.linkis.bml.client.BmlClientFactory;
import org.apache.linkis.bml.protocol.BmlDeleteResponse;
import org.apache.linkis.bml.protocol.BmlUpdateResponse;
import org.apache.linkis.bml.protocol.BmlUploadResponse;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.datasourcemanager.common.errorcode.LinkisDatasourceManagerErrorCodeSummary;
import org.apache.linkis.datasourcemanager.core.service.BmlAppService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@Service
@RefreshScope
public class BmlAppServiceImpl
implements BmlAppService {
    private static final Logger LOG = LoggerFactory.getLogger(BmlAppService.class);
    private BmlClient client;

    @PostConstruct
    public void buildClient() {
        this.client = BmlClientFactory.createBmlClient();
    }

    @Override
    public String clientUploadResource(String userName, String fileName, InputStream inputStream) throws ErrorException {
        LOG.info("Upload resource to bml server: [ proxy_to_user: " + userName + ", file name:" + fileName + " ]");
        try {
            BmlUploadResponse response = this.client.uploadResource(userName, fileName, inputStream);
            if (!response.isSuccess()) {
                throw new ErrorException(LinkisDatasourceManagerErrorCodeSummary.EXPRESS_IS_NULL.getErrorCode(), "");
            }
            return response.resourceId();
        }
        catch (Exception e) {
            LOG.error("Failed to upload resource to bml server[\u4e0a\u4f20\u8d44\u6e90\u6587\u4ef6\u5931\u8d25], [ proxy_to_user: " + userName + ", file name:" + fileName + " ]", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void clientRemoveResource(String userName, String resourceId) throws ErrorException {
        LOG.info("Remove resource to bml server: [ proxy_to_user: " + userName + ", resource id:" + resourceId + " ]");
        try {
            BmlDeleteResponse response = this.client.deleteResource(userName, resourceId);
            if (!response.isSuccess()) {
                throw new ErrorException(LinkisDatasourceManagerErrorCodeSummary.EXPRESS_IS_NULL.getErrorCode(), "");
            }
        }
        catch (Exception e) {
            LOG.error("Fail to remove resource to bml server[\u5220\u9664\u8d44\u6e90\u6587\u4ef6\u5931\u8d25], [ proxy_to_user: " + userName + ", resource id:" + resourceId + " ]");
            throw e;
        }
    }

    @Override
    public String clientUpdateResource(String userName, String resourceId, InputStream inputStream) throws ErrorException {
        LOG.info("Update resource to bml server: [ proxy_to_user: " + userName + ", resource id:" + resourceId + " ]");
        try {
            BmlUpdateResponse response = this.client.updateResource(userName, resourceId, "filename", inputStream);
            if (!response.isSuccess()) {
                throw new ErrorException(LinkisDatasourceManagerErrorCodeSummary.EXPRESS_IS_NULL.getErrorCode(), "");
            }
            return response.version();
        }
        catch (Exception e) {
            LOG.error("Fail to update resource to bml server[\u66f4\u65b0\u8d44\u6e90\u6587\u4ef6\u5931\u8d25], [ proxy_to_user: " + userName + ", resource id:" + resourceId + " ]");
            throw e;
        }
    }
}

