/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.am.service.engine;

import feign.RetryableException;
import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.linkis.common.conf.TimeType;
import org.apache.linkis.common.exception.LinkisRetryException;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.governance.common.utils.JobUtils$;
import org.apache.linkis.governance.common.utils.LoggerUtils;
import org.apache.linkis.manager.am.conf.AMConfiguration;
import org.apache.linkis.manager.am.hook.AskEngineConnHook;
import org.apache.linkis.manager.am.hook.AskEngineConnHookContext;
import org.apache.linkis.manager.am.label.MultiUserEngineReuseLabelChooser;
import org.apache.linkis.manager.am.service.engine.AbstractEngineService;
import org.apache.linkis.manager.am.service.engine.EngineAskEngineService;
import org.apache.linkis.manager.am.service.engine.EngineAskEngineService$;
import org.apache.linkis.manager.am.service.engine.EngineCreateService;
import org.apache.linkis.manager.am.service.engine.EngineReuseService;
import org.apache.linkis.manager.am.service.engine.EngineSwitchService;
import org.apache.linkis.manager.common.entity.node.EngineNode;
import org.apache.linkis.manager.common.protocol.engine.EngineAskAsyncResponse;
import org.apache.linkis.manager.common.protocol.engine.EngineAskRequest;
import org.apache.linkis.manager.common.protocol.engine.EngineCreateError;
import org.apache.linkis.manager.common.protocol.engine.EngineCreateRequest;
import org.apache.linkis.manager.common.protocol.engine.EngineCreateSuccess;
import org.apache.linkis.manager.common.protocol.engine.EngineReuseRequest;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactory;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactoryContext;
import org.apache.linkis.manager.label.entity.CombinedLabel;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.utils.LabelUtil$;
import org.apache.linkis.manager.label.utils.LabelUtils;
import org.apache.linkis.manager.rm.domain.RMLabelContainer;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.rpc.Sender$;
import org.apache.linkis.rpc.message.annotation.Receiver;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005h\u0001B\r\u001b\u0001%BQ!\u000f\u0001\u0005\u0002iB\u0011\u0002\u0010\u0001A\u0002\u0003\u0007I\u0011B\u001f\t\u0013\u0005\u0003\u0001\u0019!a\u0001\n\u0013\u0011\u0005\"C&\u0001\u0001\u0004\u0005\t\u0015)\u0003?\u0011%I\u0006\u00011AA\u0002\u0013%!\fC\u0005_\u0001\u0001\u0007\t\u0019!C\u0005?\"I\u0011\r\u0001a\u0001\u0002\u0003\u0006Ka\u0017\u0005\nG\u0002\u0001\r\u00111A\u0005\n\u0011D\u0011\u0002\u001b\u0001A\u0002\u0003\u0007I\u0011B5\t\u0013-\u0004\u0001\u0019!A!B\u0013)\u0007\"C7\u0001\u0001\u0004\u0005\r\u0011\"\u0003o\u0011%)\b\u00011AA\u0002\u0013%a\u000fC\u0005y\u0001\u0001\u0007\t\u0011)Q\u0005_\"I!\u0010\u0001a\u0001\u0002\u0004%\ta\u001f\u0005\f\u0003\u0017\u0001\u0001\u0019!a\u0001\n\u0003\ti\u0001\u0003\u0006\u0002\u0012\u0001\u0001\r\u0011!Q!\nqD\u0011\"!\t\u0001\u0005\u0004%I!a\t\t\u0011\u0005U\u0002\u0001)A\u0005\u0003KA\u0011\"a\u000e\u0001\u0005\u0004%Y!!\u000f\t\u0011\u0005\u001d\u0003\u0001)A\u0005\u0003wA\u0011\"!\u0013\u0001\u0005\u0004%I!a\u0013\t\u0011\u0005u\u0004\u0001)A\u0005\u0003\u001bBq!a \u0001\t\u0003\n\t\tC\u0004\u0002>\u0002!I!a0\u0003;\u0011+g-Y;mi\u0016sw-\u001b8f\u0003N\\WI\\4j]\u0016\u001cVM\u001d<jG\u0016T!a\u0007\u000f\u0002\r\u0015tw-\u001b8f\u0015\tib$A\u0004tKJ4\u0018nY3\u000b\u0005}\u0001\u0013AA1n\u0015\t\t#%A\u0004nC:\fw-\u001a:\u000b\u0005\r\"\u0013A\u00027j].L7O\u0003\u0002&M\u00051\u0011\r]1dQ\u0016T\u0011aJ\u0001\u0004_J<7\u0001A\n\u0005\u0001)r\u0013\u0007\u0005\u0002,Y5\t!$\u0003\u0002.5\t)\u0012IY:ue\u0006\u001cG/\u00128hS:,7+\u001a:wS\u000e,\u0007CA\u00160\u0013\t\u0001$D\u0001\fF]\u001eLg.Z!tW\u0016sw-\u001b8f'\u0016\u0014h/[2f!\t\u0011t'D\u00014\u0015\t!T'A\u0003vi&d7O\u0003\u00027E\u000511m\\7n_:L!\u0001O\u001a\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012a\u000f\t\u0003W\u0001\t1#\u001a8hS:,7I]3bi\u0016\u001cVM\u001d<jG\u0016,\u0012A\u0010\t\u0003W}J!\u0001\u0011\u000e\u0003'\u0015sw-\u001b8f\u0007J,\u0017\r^3TKJ4\u0018nY3\u0002/\u0015tw-\u001b8f\u0007J,\u0017\r^3TKJ4\u0018nY3`I\u0015\fHCA\"J!\t!u)D\u0001F\u0015\u00051\u0015!B:dC2\f\u0017B\u0001%F\u0005\u0011)f.\u001b;\t\u000f)\u001b\u0011\u0011!a\u0001}\u0005\u0019\u0001\u0010J\u0019\u0002)\u0015tw-\u001b8f\u0007J,\u0017\r^3TKJ4\u0018nY3!Q\t!Q\n\u0005\u0002O/6\tqJ\u0003\u0002Q#\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005I\u001b\u0016a\u00024bGR|'/\u001f\u0006\u0003)V\u000bQAY3b]NT!A\u0016\u0014\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.L!\u0001W(\u0003\u0013\u0005+Ho\\<je\u0016$\u0017AE3oO&tWMU3vg\u0016\u001cVM\u001d<jG\u0016,\u0012a\u0017\t\u0003WqK!!\u0018\u000e\u0003%\u0015sw-\u001b8f%\u0016,8/Z*feZL7-Z\u0001\u0017K:<\u0017N\\3SKV\u001cXmU3sm&\u001cWm\u0018\u0013fcR\u00111\t\u0019\u0005\b\u0015\u001a\t\t\u00111\u0001\\\u0003M)gnZ5oKJ+Wo]3TKJ4\u0018nY3!Q\t9Q*A\nf]\u001eLg.Z*xSR\u001c\u0007nU3sm&\u001cW-F\u0001f!\tYc-\u0003\u0002h5\t\u0019RI\\4j]\u0016\u001cv/\u001b;dQN+'O^5dK\u00069RM\\4j]\u0016\u001cv/\u001b;dQN+'O^5dK~#S-\u001d\u000b\u0003\u0007*DqAS\u0005\u0002\u0002\u0003\u0007Q-\u0001\u000bf]\u001eLg.Z*xSR\u001c\u0007nU3sm&\u001cW\r\t\u0015\u0003\u00155\u000b\u0001%\\;mi&,6/\u001a:F]\u001eLg.\u001a*fkN,G*\u00192fY\u000eCwn\\:feV\tq\u000e\u0005\u0002qg6\t\u0011O\u0003\u0002s=\u0005)A.\u00192fY&\u0011A/\u001d\u0002!\u001bVdG/[+tKJ,enZ5oKJ+Wo]3MC\n,Gn\u00115p_N,'/\u0001\u0013nk2$\u0018.V:fe\u0016sw-\u001b8f%\u0016,8/\u001a'bE\u0016d7\t[8pg\u0016\u0014x\fJ3r)\t\u0019u\u000fC\u0004K\u0019\u0005\u0005\t\u0019A8\u0002C5,H\u000e^5Vg\u0016\u0014XI\\4j]\u0016\u0014V-^:f\u0019\u0006\u0014W\r\\\"i_>\u001cXM\u001d\u0011)\u00055i\u0015A\u00035p_.\u001c\u0018I\u001d:bsV\tA\u0010E\u0002E{~L!A`#\u0003\u000b\u0005\u0013(/Y=\u0011\t\u0005\u0005\u0011qA\u0007\u0003\u0003\u0007Q1!!\u0002\u001f\u0003\u0011Awn\\6\n\t\u0005%\u00111\u0001\u0002\u0012\u0003N\\WI\\4j]\u0016\u001cuN\u001c8I_>\\\u0017A\u00045p_.\u001c\u0018I\u001d:bs~#S-\u001d\u000b\u0004\u0007\u0006=\u0001b\u0002&\u0010\u0003\u0003\u0005\r\u0001`\u0001\fQ>|7n]!se\u0006L\b\u0005K\u0002\u0011\u0003+\u00012ATA\f\u0013\r\tIb\u0014\u0002\n#V\fG.\u001b4jKJDc\u0001E'\u0002\u001e\u0005}\u0011\u0001\u0003:fcVL'/\u001a3\u001a\u0003\u0001\t1\u0003\\1cK2\u0014U/\u001b7eKJ4\u0015m\u0019;pef,\"!!\n\u0011\t\u0005\u001d\u0012\u0011G\u0007\u0003\u0003SQ1AUA\u0016\u0015\u0011\ti#a\f\u0002\u000f\t,\u0018\u000e\u001c3fe*\u0011!\u000fI\u0005\u0005\u0003g\tICA\nMC\n,GNQ;jY\u0012,'OR1di>\u0014\u00180\u0001\u000bmC\n,GNQ;jY\u0012,'OR1di>\u0014\u0018\u0010I\u0001\tKb,7-\u001e;peV\u0011\u00111\b\t\u0005\u0003{\t\u0019%\u0004\u0002\u0002@)\u0019\u0011\u0011I#\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002F\u0005}\"aH#yK\u000e,H/[8o\u0007>tG/\u001a=u\u000bb,7-\u001e;peN+'O^5dK\u0006IQ\r_3dkR|'\u000fI\u0001\u0019K:<\u0017N\\3De\u0016\fG/Z*f[\u0006\u0004\bn\u001c:f\u001b\u0006\u0004XCAA'!!\ty%!\u0017\u0002^\u0005MTBAA)\u0015\u0011\t\u0019&!\u0016\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003/\nAA[1wC&!\u00111LA)\u0005\ri\u0015\r\u001d\t\u0005\u0003?\niG\u0004\u0003\u0002b\u0005%\u0004cAA2\u000b6\u0011\u0011Q\r\u0006\u0004\u0003OB\u0013A\u0002\u001fs_>$h(C\u0002\u0002l\u0015\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA8\u0003c\u0012aa\u0015;sS:<'bAA6\u000bB!\u0011QOA=\u001b\t\t9H\u0003\u0003\u0002B\u0005E\u0013\u0002BA>\u0003o\u0012\u0011bU3nCBDwN]3\u00023\u0015tw-\u001b8f\u0007J,\u0017\r^3TK6\f\u0007\u000f[8sK6\u000b\u0007\u000fI\u0001\nCN\\WI\\4j]\u0016$b!a!\u0002\n\u0006u\u0005c\u0001#\u0002\u0006&\u0019\u0011qQ#\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002\f^\u0001\r!!$\u0002!\u0015tw-\u001b8f\u0003N\\'+Z9vKN$\b\u0003BAH\u00033k!!!%\u000b\u0007m\t\u0019J\u0003\u0003\u0002\u0016\u0006]\u0015\u0001\u00039s_R|7m\u001c7\u000b\u0005Y\u0002\u0013\u0002BAN\u0003#\u0013\u0001#\u00128hS:,\u0017i]6SKF,Xm\u001d;\t\u000f\u0005}u\u00031\u0001\u0002\"\u000611/\u001a8eKJ\u0004B!a)\u0002*6\u0011\u0011Q\u0015\u0006\u0004\u0003O\u0013\u0013a\u0001:qG&!\u00111VAS\u0005\u0019\u0019VM\u001c3fe\"\u001aq#a,\u0011\t\u0005E\u0016\u0011X\u0007\u0003\u0003gS1\u0001UA[\u0015\u0011\t9,!*\u0002\u000f5,7o]1hK&!\u00111XAZ\u0005!\u0011VmY3jm\u0016\u0014\u0018AE4fi.+\u00170\u00118e'\u0016l\u0017\r\u001d5pe\u0016$B!!1\u0002HB9A)a1\u0002^\u0005M\u0014bAAc\u000b\n1A+\u001e9mKJBq!!3\u0019\u0001\u0004\tY-\u0001\u0004mC\n,Gn\u001d\t\t\u0003\u001f\nI&!\u0018\u0002NB\u0019A)a4\n\u0007\u0005EWI\u0001\u0004B]f\u0014VM\u001a\u0015\u0004\u0001\u0005U\u0007\u0003BAl\u0003;l!!!7\u000b\u0007\u0005mW+\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!a8\u0002Z\n91+\u001a:wS\u000e,\u0007")
public class DefaultEngineAskEngineService
extends AbstractEngineService
implements EngineAskEngineService,
Logging {
    @Autowired
    private EngineCreateService engineCreateService;
    @Autowired
    private EngineReuseService engineReuseService;
    @Autowired
    private EngineSwitchService engineSwitchService;
    @Autowired
    private MultiUserEngineReuseLabelChooser multiUserEngineReuseLabelChooser;
    @Autowired(required=false)
    @Qualifier
    private AskEngineConnHook[] hooksArray;
    private final LabelBuilderFactory labelBuilderFactory;
    private final ExecutionContextExecutorService executor;
    private final Map<String, Semaphore> engineCreateSemaphoreMap;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        DefaultEngineAskEngineService defaultEngineAskEngineService = this;
        synchronized (defaultEngineAskEngineService) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private EngineCreateService engineCreateService() {
        return this.engineCreateService;
    }

    private void engineCreateService_$eq(EngineCreateService x$1) {
        this.engineCreateService = x$1;
    }

    private EngineReuseService engineReuseService() {
        return this.engineReuseService;
    }

    private void engineReuseService_$eq(EngineReuseService x$1) {
        this.engineReuseService = x$1;
    }

    private EngineSwitchService engineSwitchService() {
        return this.engineSwitchService;
    }

    private void engineSwitchService_$eq(EngineSwitchService x$1) {
        this.engineSwitchService = x$1;
    }

    private MultiUserEngineReuseLabelChooser multiUserEngineReuseLabelChooser() {
        return this.multiUserEngineReuseLabelChooser;
    }

    private void multiUserEngineReuseLabelChooser_$eq(MultiUserEngineReuseLabelChooser x$1) {
        this.multiUserEngineReuseLabelChooser = x$1;
    }

    public AskEngineConnHook[] hooksArray() {
        return this.hooksArray;
    }

    public void hooksArray_$eq(AskEngineConnHook[] x$1) {
        this.hooksArray = x$1;
    }

    private LabelBuilderFactory labelBuilderFactory() {
        return this.labelBuilderFactory;
    }

    private ExecutionContextExecutorService executor() {
        return this.executor;
    }

    private Map<String, Semaphore> engineCreateSemaphoreMap() {
        return this.engineCreateSemaphoreMap;
    }

    @Override
    @Receiver
    public Object askEngine(EngineAskRequest engineAskRequest, Sender sender) {
        Object object;
        Object object2 = new Object();
        try {
            String taskId = JobUtils$.MODULE$.getJobIdFromStringMap(engineAskRequest.getProperties());
            LoggerUtils.setJobIdMDC((String)taskId);
            this.logger().info(new StringBuilder(34).append("received task: ").append(taskId).append(", engineAskRequest ").append(engineAskRequest).toString());
            if (this.hooksArray() != null && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.hooksArray())).size() > 0) {
                AskEngineConnHookContext ctx = new AskEngineConnHookContext(engineAskRequest, sender);
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.hooksArray())).foreach((Function1 & Serializable & scala.Serializable)h -> {
                    Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> h.doHook(ctx), (Function1 & Serializable & scala.Serializable)t -> {
                        Throwable throwable;
                        String engineAskAsyncId = EngineAskEngineService$.MODULE$.getAsyncId();
                        Throwable throwable2 = t;
                        boolean retryFlag = throwable2 instanceof LinkisRetryException ? true : (throwable2 instanceof RetryableException ? true : ((throwable = ExceptionUtils.getRootCause((Throwable)t)) instanceof SocketTimeoutException ? true : throwable instanceof TimeoutException));
                        throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new EngineCreateError(engineAskAsyncId, ExceptionUtils.getRootCauseMessage((Throwable)t), retryFlag));
                    });
                    return BoxedUnit.UNIT;
                });
            }
            String engineAskAsyncId = EngineAskEngineService$.MODULE$.getAsyncId();
            Future createNodeThread = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                LoggerUtils.setJobIdMDC((String)taskId);
                Tuple2 tuple2 = (Tuple2)Utils$.MODULE$.tryAndWarn((Function0 & Serializable & scala.Serializable)() -> this.getKeyAndSemaphore(engineAskRequest.getLabels()), this.logger());
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String engineCreateKey = (String)tuple2._1();
                Semaphore semaphore = (Semaphore)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)engineCreateKey, (Object)semaphore);
                String engineCreateKey2 = (String)tuple22._1();
                Semaphore semaphore2 = (Semaphore)tuple22._2();
                return (Tuple2)Utils$.MODULE$.tryFinally((Function0 & Serializable & scala.Serializable)() -> {
                    if (semaphore2 != null) {
                        try {
                            semaphore2.acquire();
                            this.logger().info(new StringBuilder(20).append(engineCreateKey2).append(" succeed to get lock").toString());
                        }
                        catch (Exception e) {
                            this.logger().warn(new StringBuilder(37).append("Task: ").append(taskId).append(" user ").append(engineAskRequest.getUser()).append(" acquire semaphore failed").toString(), (Throwable)e);
                        }
                    }
                    EngineNode reuseNode = null;
                    if (!engineAskRequest.getLabels().containsKey("executeOnce")) {
                        EngineReuseRequest engineReuseRequest = new EngineReuseRequest();
                        engineReuseRequest.setLabels(engineAskRequest.getLabels());
                        engineReuseRequest.setTimeOut(engineAskRequest.getTimeOut());
                        engineReuseRequest.setUser(engineAskRequest.getUser());
                        engineReuseRequest.setProperties(engineAskRequest.getProperties());
                        reuseNode = (EngineNode)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> this.engineReuseService().reuseEngine(engineReuseRequest, sender), (Function1 & Serializable & scala.Serializable)t -> {
                            Throwable throwable = t;
                            if (throwable instanceof LinkisRetryException) {
                                this.logger().info(new StringBuilder(33).append("Task: ").append(taskId).append(" user ").append(engineAskRequest.getUser()).append(" reuse engine failed ").append(t.getMessage()).toString());
                            } else {
                                this.logger().info(new StringBuilder(32).append("Task: ").append(taskId).append(" user ").append(engineAskRequest.getUser()).append(" reuse engine failed").toString(), t);
                            }
                            return null;
                        });
                    }
                    if (reuseNode != null) {
                        this.logger().info(new StringBuilder(54).append("Task: ").append(taskId).append(" finished to ask engine for user ").append(engineAskRequest.getUser()).append(" by reuse node ").append(reuseNode).toString());
                        return new Tuple2(reuseNode, (Object)BoxesRunTime.boxToBoolean((boolean)true));
                    }
                    this.logger().info(new StringBuilder(38).append("Task: ").append(taskId).append(" start to async(").append(engineAskAsyncId).append(") createEngine, ").append(engineAskRequest.getCreateService()).toString());
                    engineAskRequest.getLabels().remove("engineInstance");
                    Map labels = engineAskRequest.getLabels();
                    labels.put("taskId", taskId);
                    EngineCreateRequest engineCreateRequest = new EngineCreateRequest();
                    engineCreateRequest.setLabels(engineAskRequest.getLabels());
                    engineCreateRequest.setTimeout(engineAskRequest.getTimeOut());
                    engineCreateRequest.setUser(engineAskRequest.getUser());
                    engineCreateRequest.setProperties(engineAskRequest.getProperties());
                    engineCreateRequest.setCreateService(engineAskRequest.getCreateService());
                    EngineNode createNode = this.engineCreateService().createEngine(engineCreateRequest, sender);
                    long timeout = engineCreateRequest.getTimeout() <= 0L ? ((TimeType)AMConfiguration.ENGINE_START_MAX_TIME.getValue()).toLong() : engineCreateRequest.getTimeout();
                    EngineNode createEngineNode = this.getEngineNodeManager().useEngine(createNode, timeout);
                    if (createEngineNode == null) {
                        throw new LinkisRetryException(30002, new StringBuilder(47).append("create engine").append(createNode.getServiceInstance()).append(" success, but to use engine failed").toString());
                    }
                    this.logger().info(new StringBuilder(55).append("Task: ").append(taskId).append(" finished to ask engine for user ").append(engineAskRequest.getUser()).append(" by create node ").append(createEngineNode).toString());
                    return new Tuple2((Object)createEngineNode, (Object)BoxesRunTime.boxToBoolean((boolean)false));
                }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        if (semaphore2 != null) {
                            semaphore2.release();
                            this.logger().info(new StringBuilder(24).append(engineCreateKey2).append(" succeed to relaese lock").toString());
                            return;
                        }
                    }, this.logger());
                    LoggerUtils.removeJobIdMDC();
                });
            }, (ExecutionContext)this.executor());
            createNodeThread.onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DefaultEngineAskEngineService.$anonfun$askEngine$11(this, taskId, engineAskAsyncId, sender, x0$1);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)this.executor());
            LoggerUtils.removeJobIdMDC();
            object = new EngineAskAsyncResponse(engineAskAsyncId, Sender$.MODULE$.getThisServiceInstance());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object2) {
                object = ex.value();
            }
            throw ex;
        }
        return object;
    }

    private Tuple2<String, Semaphore> getKeyAndSemaphore(Map<String, Object> labels) {
        Semaphore semaphore;
        List labelList = LabelUtils.distinctLabel((List)this.labelBuilderFactory().getLabels(labels), new ArrayList());
        List<Label<?>> chooseLabels = this.multiUserEngineReuseLabelChooser().chooseLabels(labelList);
        CombinedLabel userCreatorAndEngineTypeLabel = new RMLabelContainer(chooseLabels).getCombinedResourceLabel();
        String engineCreateKey = userCreatorAndEngineTypeLabel != null ? new StringBuilder(0).append(userCreatorAndEngineTypeLabel.getStringValue()).append(LabelUtil$.MODULE$.getTenantValue(chooseLabels)).toString() : "";
        String engineType = LabelUtil$.MODULE$.getEngineType(chooseLabels);
        if (AMConfiguration.AM_ENGINE_ASK_MAX_NUMBER.containsKey(engineType.toLowerCase(Locale.getDefault())) && StringUtils.isNotBlank((CharSequence)engineCreateKey)) {
            BoxedUnit boxedUnit;
            String keyLock = engineCreateKey.intern();
            if (!this.engineCreateSemaphoreMap().containsKey(engineCreateKey)) {
                String string = keyLock;
                synchronized (string) {
                    BoxedUnit boxedUnit2 = !this.engineCreateSemaphoreMap().containsKey(engineCreateKey) ? this.engineCreateSemaphoreMap().put(engineCreateKey, new Semaphore(Predef$.MODULE$.Integer2int(AMConfiguration.AM_ENGINE_ASK_MAX_NUMBER.getOrDefault(engineType.toLowerCase(Locale.getDefault()), Predef$.MODULE$.int2Integer(10))))) : BoxedUnit.UNIT;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 4, 6] lbl13 : MonitorExitStatement: MONITOREXIT : var9_8
                    boxedUnit = boxedUnit2;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            semaphore = this.engineCreateSemaphoreMap().get(engineCreateKey);
        } else {
            semaphore = null;
        }
        Semaphore semaphore2 = semaphore;
        return new Tuple2((Object)engineCreateKey, semaphore2);
    }

    public static final /* synthetic */ void $anonfun$askEngine$11(DefaultEngineAskEngineService $this, String taskId$1, String engineAskAsyncId$1, Sender sender$1, Try x0$1) {
        Success success;
        Tuple2 tuple2;
        Try try_ = x0$1;
        if (try_ instanceof Success && (tuple2 = (Tuple2)(success = (Success)try_).value()) != null) {
            EngineNode engineNode = (EngineNode)tuple2._1();
            boolean isReuse = tuple2._2$mcZ$sp();
            LoggerUtils.setJobIdMDC((String)taskId$1);
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Utils$.MODULE$.tryFinally((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                if (isReuse) {
                    $this.logger().info(new StringBuilder(38).append("Task: ").append(taskId$1).append(" Success to async(").append(engineAskAsyncId$1).append(") reuseEngine ").append(engineNode).toString());
                } else {
                    $this.logger().info(new StringBuilder(39).append("Task: ").append(taskId$1).append(" Success to async(").append(engineAskAsyncId$1).append(") createEngine ").append(engineNode).toString());
                }
                if (sender$1 != null) {
                    sender$1.send((Object)new EngineCreateSuccess(engineAskAsyncId$1, engineNode, isReuse));
                    return;
                }
                $this.logger().info("Will not send async useing null sender.");
            }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> LoggerUtils.removeJobIdMDC());
            return;
        }
        if (try_ instanceof Failure) {
            Throwable throwable;
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            LoggerUtils.setJobIdMDC((String)taskId$1);
            Throwable throwable2 = exception;
            boolean retryFlag = throwable2 instanceof LinkisRetryException ? true : (throwable2 instanceof RetryableException ? true : ((throwable = ExceptionUtils.getRootCause((Throwable)exception)) instanceof SocketTimeoutException ? true : throwable instanceof TimeoutException));
            String msg = new StringBuilder(57).append("Task: ").append(taskId$1).append(" Failed  to async(").append(engineAskAsyncId$1).append(") create/reuse Engine, can Retry ").append(retryFlag).toString();
            if (!retryFlag) {
                $this.logger().info(msg, exception);
            } else {
                $this.logger().info(new StringBuilder(26).append("msg: ").append(msg).append(" canRetry Exception: ").append(exception.getClass().getName()).toString());
            }
            BoxedUnit cfr_ignored_1 = (BoxedUnit)Utils$.MODULE$.tryFinally((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> sender$1.send((Object)new EngineCreateError(engineAskAsyncId$1, ExceptionUtils.getRootCauseMessage((Throwable)exception), retryFlag)), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> LoggerUtils.removeJobIdMDC());
            return;
        }
        throw new MatchError((Object)try_);
    }

    public DefaultEngineAskEngineService() {
        Logging.$init$((Logging)this);
        this.labelBuilderFactory = LabelBuilderFactoryContext.getLabelBuilderFactory();
        this.executor = Utils$.MODULE$.newCachedExecutionContext(AMConfiguration.ASK_ENGINE_ASYNC_MAX_THREAD_SIZE, "AskEngineService-Thread-", Utils$.MODULE$.newCachedExecutionContext$default$3());
        this.engineCreateSemaphoreMap = new ConcurrentHashMap<String, Semaphore>();
    }
}

