/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.am.util;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.common.utils.ByteTimeUtils;
import org.apache.linkis.governance.common.conf.GovernanceCommonConf;
import org.apache.linkis.manager.am.vo.ResourceVo;
import org.apache.linkis.manager.common.entity.enumeration.NodeStatus;
import org.apache.linkis.manager.common.entity.node.AMEMNode;
import org.apache.linkis.manager.common.entity.node.AMEngineNode;
import org.apache.linkis.manager.common.entity.node.EMNode;
import org.apache.linkis.manager.common.entity.persistence.ECResourceInfoRecord;
import org.apache.linkis.server.BDPJettyServerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ECResourceInfoUtils {
    private static Logger logger = LoggerFactory.getLogger(ECResourceInfoUtils.class);
    public static String NAME_REGEX = "^[a-zA-Z\\d_\\.]+$";

    public static boolean checkNameValid(String creator) {
        return Pattern.compile(NAME_REGEX).matcher(creator).find();
    }

    public static String strCheckAndDef(String str, String def) {
        return StringUtils.isBlank((CharSequence)str) ? def : str;
    }

    public static ResourceVo getStringToMap(String str, ECResourceInfoRecord info) {
        ResourceVo resourceVo = null;
        Map map = (Map)BDPJettyServerHelper.gson().fromJson(str, new HashMap().getClass());
        if (MapUtils.isNotEmpty((Map)map)) {
            resourceVo = new ResourceVo();
            if (info.getLabelValue().contains("spark") || info.getLabelValue().contains("flink")) {
                if (null != map.get("driver")) {
                    Map divermap = MapUtils.getMap((Map)map, (Object)"driver");
                    resourceVo.setInstance(((Double)divermap.get("instance")).intValue());
                    resourceVo.setCores(((Double)divermap.get("cpu")).intValue());
                    String memoryStr = String.valueOf(divermap.getOrDefault("memory", "0k"));
                    long memorylong = 0L;
                    if (!ECResourceInfoUtils.getScientific(memoryStr)) {
                        memorylong = ByteTimeUtils.byteStringAsBytes((String)memoryStr);
                    }
                    resourceVo.setMemory(memorylong);
                    return resourceVo;
                }
                logger.warn("Compatible with old data ,{},{}", (Object)info.getLabelValue(), (Object)info);
                return null;
            }
            String memoryStr = String.valueOf(map.getOrDefault("memory", "0k"));
            long memorylong = 0L;
            if (!ECResourceInfoUtils.getScientific(memoryStr)) {
                memorylong = ByteTimeUtils.byteStringAsBytes((String)memoryStr);
            }
            resourceVo.setInstance(((Double)map.get("instance")).intValue());
            resourceVo.setMemory(memorylong);
            Double core = null == map.get("cpu") ? (Double)map.get("cores") : (Double)map.get("cpu");
            resourceVo.setCores(core.intValue());
        }
        return resourceVo;
    }

    public static Map<String, Object> getStringToMap(String usedResourceStr) {
        Map<String, Object> resourceMap = new HashMap<String, Object>();
        Map map = (Map)BDPJettyServerHelper.gson().fromJson(usedResourceStr, new HashMap().getClass());
        if (MapUtils.isNotEmpty((Map)map)) {
            if (!usedResourceStr.contains("driver")) {
                resourceMap.put("driver", map);
            } else {
                resourceMap = map;
            }
        }
        return resourceMap;
    }

    public static AMEngineNode convertECInfoTOECNode(ECResourceInfoRecord ecInfo) {
        AMEngineNode engineNode = new AMEngineNode();
        AMEMNode ecmNode = new AMEMNode();
        ServiceInstance ecmInstance = new ServiceInstance();
        ecmInstance.setApplicationName((String)GovernanceCommonConf.ENGINE_CONN_MANAGER_SPRING_NAME().getValue());
        ecmInstance.setInstance(ecInfo.getEcmInstance());
        ecmNode.setServiceInstance(ecmInstance);
        engineNode.setEMNode((EMNode)ecmNode);
        ServiceInstance ecInstance = new ServiceInstance();
        ecInstance.setInstance(ecInfo.getServiceInstance());
        ecInstance.setApplicationName((String)GovernanceCommonConf.ENGINE_CONN_SPRING_NAME().getValue());
        engineNode.setServiceInstance(ecInstance);
        engineNode.setOwner(ecInfo.getCreateUser());
        engineNode.setNodeStatus(NodeStatus.valueOf((String)ecInfo.getStatus()));
        engineNode.setTicketId(ecInfo.getTicketId());
        engineNode.setStartTime(ecInfo.getCreateTime());
        engineNode.setUpdateTime(ecInfo.getReleaseTime());
        engineNode.setEcMetrics(ecInfo.getMetrics());
        return engineNode;
    }

    public static boolean getScientific(String input) {
        String regx = "^((-?\\d+.?\\d*)[Ee]{1}(-?\\d+))$";
        Pattern pattern = Pattern.compile(regx);
        return pattern.matcher(input).matches();
    }
}

