/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.metadata.query.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.datasourcemanager.common.util.json.Json;
import org.apache.linkis.metadata.query.common.domain.MetaColumnInfo;
import org.apache.linkis.metadata.query.common.service.AbstractDbMetaService;
import org.apache.linkis.metadata.query.common.service.MetadataConnection;
import org.apache.linkis.metadata.query.service.MongoDbConnection;
import org.apache.linkis.metadata.query.service.MongoDbParamsMapper;

public class MongodbMetaService
extends AbstractDbMetaService<MongoDbConnection> {
    public MetadataConnection<MongoDbConnection> getConnection(String operator, Map<String, Object> params) throws Exception {
        String host = String.valueOf(params.getOrDefault(MongoDbParamsMapper.PARAM_MONGO_HOST.getValue(), ""));
        Integer port = Double.valueOf(String.valueOf(params.getOrDefault(MongoDbParamsMapper.PARAM_MONGO_PORT.getValue(), 0))).intValue();
        String username = String.valueOf(params.getOrDefault(MongoDbParamsMapper.PARAM_MONGO_USERNAME.getValue(), ""));
        String password = String.valueOf(params.getOrDefault(MongoDbParamsMapper.PARAM_MONGO_PASSWORD.getValue(), ""));
        String database = String.valueOf(params.getOrDefault(MongoDbParamsMapper.PARAM_MONGO_DATABASE.getValue(), ""));
        Map extraParams = new HashMap();
        Object sqlParamObj = params.get(MongoDbParamsMapper.PARAM_MONGO_EXTRA_PARAMS.getValue());
        if (null != sqlParamObj) {
            if (!(sqlParamObj instanceof Map)) {
                String paramStr = String.valueOf(sqlParamObj);
                if (StringUtils.isNotBlank((CharSequence)paramStr)) {
                    extraParams = (Map)Json.fromJson((String)paramStr, Map.class, (Class[])new Class[]{String.class, Object.class});
                }
            } else {
                extraParams = (Map)sqlParamObj;
            }
        }
        assert (extraParams != null);
        return new MetadataConnection((Object)new MongoDbConnection(host, port, username, password, database, extraParams));
    }

    public List<String> queryDatabases(MongoDbConnection connection) {
        try {
            return connection.getAllDatabases();
        }
        catch (Exception e) {
            throw new RuntimeException("Fail to get Sql databases(\u83b7\u53d6\u6570\u636e\u5e93\u5217\u8868\u5931\u8d25)", e);
        }
    }

    public List<String> queryTables(MongoDbConnection connection, String database) {
        try {
            return connection.getAllTables(database);
        }
        catch (Exception e) {
            throw new RuntimeException("Fail to get Sql tables(\u83b7\u53d6\u8868\u5217\u8868\u5931\u8d25)", e);
        }
    }

    public List<MetaColumnInfo> queryColumns(MongoDbConnection connection, String database, String table) {
        try {
            return connection.getColumns(database, table);
        }
        catch (Exception e) {
            throw new RuntimeException("Fail to get Sql columns(\u83b7\u53d6\u5b57\u6bb5\u5217\u8868\u5931\u8d25)", e);
        }
    }
}

