/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.bml.common;

import org.apache.linkis.bml.common.HdfsResourceHelper;
import org.apache.linkis.bml.common.LocalResourceHelper;
import org.apache.linkis.bml.common.ResourceHelper;
import org.apache.linkis.bml.common.S3ResourceHelper;
import org.apache.linkis.bml.conf.BmlServerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceHelperFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceHelperFactory.class);
    private static final String FILESYSTEM_TYPE = (String)BmlServerConfiguration.BML_FILESYSTEM_TYPE().getValue();
    private static final ResourceHelper HDFS_RESOURCE_HELPER = new HdfsResourceHelper();
    private static final ResourceHelper LOCAL_RESOURCE_HELPER = new LocalResourceHelper();
    private static final ResourceHelper S3_RESOURCE_HELPER = new S3ResourceHelper();

    public static ResourceHelper getResourceHelper() {
        if (FILESYSTEM_TYPE.equals("hdfs")) {
            LOGGER.info("will store resource in hdfs");
            return HDFS_RESOURCE_HELPER;
        }
        if (FILESYSTEM_TYPE.equals("s3")) {
            LOGGER.info("will store resource in s3");
            return S3_RESOURCE_HELPER;
        }
        LOGGER.info("will store resource in local");
        return LOCAL_RESOURCE_HELPER;
    }
}

