/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.List;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SecureHeadersProperties;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.http.HttpHeaders;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class SecureHeadersGatewayFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    public static final String X_XSS_PROTECTION_HEADER = "X-Xss-Protection";
    public static final String STRICT_TRANSPORT_SECURITY_HEADER = "Strict-Transport-Security";
    public static final String X_FRAME_OPTIONS_HEADER = "X-Frame-Options";
    public static final String X_CONTENT_TYPE_OPTIONS_HEADER = "X-Content-Type-Options";
    public static final String REFERRER_POLICY_HEADER = "Referrer-Policy";
    public static final String CONTENT_SECURITY_POLICY_HEADER = "Content-Security-Policy";
    public static final String X_DOWNLOAD_OPTIONS_HEADER = "X-Download-Options";
    public static final String X_PERMITTED_CROSS_DOMAIN_POLICIES_HEADER = "X-Permitted-Cross-Domain-Policies";
    private final SecureHeadersProperties properties;

    public SecureHeadersGatewayFilterFactory(SecureHeadersProperties properties) {
        super(Config.class);
        this.properties = properties;
    }

    @Override
    public GatewayFilter apply(final Config originalConfig) {
        return new GatewayFilter(){

            @Override
            public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
                HttpHeaders headers = exchange.getResponse().getHeaders();
                List<String> disabled = SecureHeadersGatewayFilterFactory.this.properties.getDisable();
                Config config = originalConfig.withDefaults(SecureHeadersGatewayFilterFactory.this.properties);
                return chain.filter(exchange).then(Mono.fromRunnable(() -> {
                    if (SecureHeadersGatewayFilterFactory.this.isEnabled(disabled, SecureHeadersGatewayFilterFactory.X_XSS_PROTECTION_HEADER)) {
                        headers.addIfAbsent((Object)SecureHeadersGatewayFilterFactory.X_XSS_PROTECTION_HEADER, (Object)config.getXssProtectionHeader());
                    }
                    if (SecureHeadersGatewayFilterFactory.this.isEnabled(disabled, SecureHeadersGatewayFilterFactory.STRICT_TRANSPORT_SECURITY_HEADER)) {
                        headers.addIfAbsent((Object)SecureHeadersGatewayFilterFactory.STRICT_TRANSPORT_SECURITY_HEADER, (Object)config.getStrictTransportSecurity());
                    }
                    if (SecureHeadersGatewayFilterFactory.this.isEnabled(disabled, SecureHeadersGatewayFilterFactory.X_FRAME_OPTIONS_HEADER)) {
                        headers.addIfAbsent((Object)SecureHeadersGatewayFilterFactory.X_FRAME_OPTIONS_HEADER, (Object)config.getFrameOptions());
                    }
                    if (SecureHeadersGatewayFilterFactory.this.isEnabled(disabled, SecureHeadersGatewayFilterFactory.X_CONTENT_TYPE_OPTIONS_HEADER)) {
                        headers.addIfAbsent((Object)SecureHeadersGatewayFilterFactory.X_CONTENT_TYPE_OPTIONS_HEADER, (Object)config.getContentTypeOptions());
                    }
                    if (SecureHeadersGatewayFilterFactory.this.isEnabled(disabled, SecureHeadersGatewayFilterFactory.REFERRER_POLICY_HEADER)) {
                        headers.addIfAbsent((Object)SecureHeadersGatewayFilterFactory.REFERRER_POLICY_HEADER, (Object)config.getReferrerPolicy());
                    }
                    if (SecureHeadersGatewayFilterFactory.this.isEnabled(disabled, SecureHeadersGatewayFilterFactory.CONTENT_SECURITY_POLICY_HEADER)) {
                        headers.addIfAbsent((Object)SecureHeadersGatewayFilterFactory.CONTENT_SECURITY_POLICY_HEADER, (Object)config.getContentSecurityPolicy());
                    }
                    if (SecureHeadersGatewayFilterFactory.this.isEnabled(disabled, SecureHeadersGatewayFilterFactory.X_DOWNLOAD_OPTIONS_HEADER)) {
                        headers.addIfAbsent((Object)SecureHeadersGatewayFilterFactory.X_DOWNLOAD_OPTIONS_HEADER, (Object)config.getDownloadOptions());
                    }
                    if (SecureHeadersGatewayFilterFactory.this.isEnabled(disabled, SecureHeadersGatewayFilterFactory.X_PERMITTED_CROSS_DOMAIN_POLICIES_HEADER)) {
                        headers.addIfAbsent((Object)SecureHeadersGatewayFilterFactory.X_PERMITTED_CROSS_DOMAIN_POLICIES_HEADER, (Object)config.getPermittedCrossDomainPolicies());
                    }
                }));
            }

            public String toString() {
                return GatewayToStringStyler.filterToStringCreator(SecureHeadersGatewayFilterFactory.this).toString();
            }
        };
    }

    private boolean isEnabled(List<String> disabledHeaders, String header) {
        return !disabledHeaders.contains(header.toLowerCase());
    }

    public static class Config {
        private String xssProtectionHeader;
        private String strictTransportSecurity;
        private String frameOptions;
        private String contentTypeOptions;
        private String referrerPolicy;
        private String contentSecurityPolicy;
        private String downloadOptions;
        private String permittedCrossDomainPolicies;

        public Config withDefaults(SecureHeadersProperties properties) {
            Config config = new Config();
            config.setXssProtectionHeader(this.xssProtectionHeader);
            config.setStrictTransportSecurity(this.strictTransportSecurity);
            config.setFrameOptions(this.frameOptions);
            config.setContentTypeOptions(this.contentTypeOptions);
            config.setReferrerPolicy(this.referrerPolicy);
            config.setContentSecurityPolicy(this.contentSecurityPolicy);
            config.setDownloadOptions(this.downloadOptions);
            config.setPermittedCrossDomainPolicies(this.permittedCrossDomainPolicies);
            if (config.xssProtectionHeader == null) {
                config.xssProtectionHeader = properties.getXssProtectionHeader();
            }
            if (config.strictTransportSecurity == null) {
                config.strictTransportSecurity = properties.getStrictTransportSecurity();
            }
            if (config.frameOptions == null) {
                config.frameOptions = properties.getFrameOptions();
            }
            if (config.contentTypeOptions == null) {
                config.contentTypeOptions = properties.getContentTypeOptions();
            }
            if (config.referrerPolicy == null) {
                config.referrerPolicy = properties.getReferrerPolicy();
            }
            if (config.contentSecurityPolicy == null) {
                config.contentSecurityPolicy = properties.getContentSecurityPolicy();
            }
            if (config.downloadOptions == null) {
                config.downloadOptions = properties.getDownloadOptions();
            }
            if (config.permittedCrossDomainPolicies == null) {
                config.permittedCrossDomainPolicies = properties.getPermittedCrossDomainPolicies();
            }
            return config;
        }

        public String getXssProtectionHeader() {
            return this.xssProtectionHeader;
        }

        public void setXssProtectionHeader(String xssProtectionHeader) {
            this.xssProtectionHeader = xssProtectionHeader;
        }

        public String getStrictTransportSecurity() {
            return this.strictTransportSecurity;
        }

        public void setStrictTransportSecurity(String strictTransportSecurity) {
            this.strictTransportSecurity = strictTransportSecurity;
        }

        public String getFrameOptions() {
            return this.frameOptions;
        }

        public void setFrameOptions(String frameOptions) {
            this.frameOptions = frameOptions;
        }

        public String getContentTypeOptions() {
            return this.contentTypeOptions;
        }

        public void setContentTypeOptions(String contentTypeOptions) {
            this.contentTypeOptions = contentTypeOptions;
        }

        public String getReferrerPolicy() {
            return this.referrerPolicy;
        }

        public void setReferrerPolicy(String referrerPolicy) {
            this.referrerPolicy = referrerPolicy;
        }

        public String getContentSecurityPolicy() {
            return this.contentSecurityPolicy;
        }

        public void setContentSecurityPolicy(String contentSecurityPolicy) {
            this.contentSecurityPolicy = contentSecurityPolicy;
        }

        public String getDownloadOptions() {
            return this.downloadOptions;
        }

        public void setDownloadOptions(String downloadOptions) {
            this.downloadOptions = downloadOptions;
        }

        public String getPermittedCrossDomainPolicies() {
            return this.permittedCrossDomainPolicies;
        }

        public void setPermittedCrossDomainPolicies(String permittedCrossDomainPolicies) {
            this.permittedCrossDomainPolicies = permittedCrossDomainPolicies;
        }
    }
}

