/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.storage.resultset;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.common.io.resultset.ResultSerializer;
import org.apache.linkis.common.io.resultset.ResultSet;
import org.apache.linkis.common.io.resultset.ResultSetWriter;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.storage.FSFactory$;
import org.apache.linkis.storage.conf.LinkisStorageConf$;
import org.apache.linkis.storage.domain.Dolphin$;
import org.apache.linkis.storage.fs.FileSystem;
import org.apache.linkis.storage.utils.FileSystemUtils$;
import org.apache.linkis.storage.utils.StorageUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tud\u0001B\u001b7\u0001\u0005C\u0001\u0002\u001b\u0001\u0003\u0002\u0003\u0006I!\u001b\u0005\tY\u0002\u0011\t\u0011)A\u0005[\"A\u0001\u000f\u0001B\u0001B\u0003%\u0011\u000fC\u0003u\u0001\u0011\u0005Q\u000fC\u0004|\u0001\t\u0007I\u0011\u0002?\t\u000f\u0005\u0005\u0001\u0001)A\u0005{\"I\u00111\u0001\u0001A\u0002\u0013%\u0011Q\u0001\u0005\n\u0003\u001b\u0001\u0001\u0019!C\u0005\u0003\u001fA\u0001\"a\u0007\u0001A\u0003&\u0011q\u0001\u0005\f\u0003;\u0001\u0001\u0019!a\u0001\n\u0013\ty\u0002C\u0006\u00020\u0001\u0001\r\u00111A\u0005\n\u0005E\u0002bCA\u001b\u0001\u0001\u0007\t\u0011)Q\u0005\u0003CA\u0011\"a\u000e\u0001\u0001\u0004%I!!\u000f\t\u0013\u0005\u0005\u0003\u00011A\u0005\n\u0005\r\u0003\u0002CA$\u0001\u0001\u0006K!a\u000f\t\u0013\u0005%\u0003A1A\u0005\n\u0005-\u0003\u0002CA2\u0001\u0001\u0006I!!\u0014\t\u0017\u0005\u0015\u0004\u00011AA\u0002\u0013%\u0011q\r\u0005\f\u0003_\u0002\u0001\u0019!a\u0001\n\u0013\t\t\bC\u0006\u0002v\u0001\u0001\r\u0011!Q!\n\u0005%\u0004bCA<\u0001\u0001\u0007\t\u0019!C\u0005\u0003sB1\"a\u001f\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002~!Q\u0011\u0011\u0011\u0001A\u0002\u0003\u0005\u000b\u0015B,\t\u0013\u0005\r\u0005\u00011A\u0005\n\u0005\u0015\u0005\"CAO\u0001\u0001\u0007I\u0011BAP\u0011!\t\u0019\u000b\u0001Q!\n\u0005\u001d\u0005\"CAS\u0001\u0001\u0007I\u0011BA\u0003\u0011%\t9\u000b\u0001a\u0001\n\u0013\tI\u000b\u0003\u0005\u0002.\u0002\u0001\u000b\u0015BA\u0004\u0011%\ty\u000b\u0001a\u0001\n\u0013\t)\u0001C\u0005\u00022\u0002\u0001\r\u0011\"\u0003\u00024\"A\u0011q\u0017\u0001!B\u0013\t9\u0001C\u0005\u0002:\u0002\u0011\r\u0011\"\u0003\u0002<\"A\u0011\u0011\u001a\u0001!\u0002\u0013\ti\fC\u0005\u0002L\u0002\u0011\r\u0011\"\u0003\u0002<\"A\u0011Q\u001a\u0001!\u0002\u0013\ti\fC\u0004\u0002P\u0002!\t!!\u001f\t\u000f\u0005E\u0007\u0001\"\u0001\u0002T\"9\u0011q\u001b\u0001\u0005\u0002\u0005\u0015\u0001bBAm\u0001\u0011\u0005\u00111\u001c\u0005\b\u0003;\u0004A\u0011AAp\u0011\u001d\t\t\u000f\u0001C\u0001\u0003GD\u0011\"a=\u0001#\u0003%\t!!>\t\u000f\t-\u0001\u0001\"\u0011\u0002\u0006\"9!Q\u0002\u0001\u0005B\t=\u0001b\u0002B\t\u0001\u0011\u0005#1\u0003\u0005\b\u00053\u0001A\u0011\tB\u000e\u0011\u001d\u0011y\u0002\u0001C!\u0005CAqAa\u0019\u0001\t\u0003\u0012)\u0007C\u0004\u0003x\u0001!\t!a8\t\u000f\te\u0004\u0001\"\u0011\u0002\\\"9!1\u0010\u0001\u0005B\u0005m'AF*u_J\fw-\u001a*fgVdGoU3u/JLG/\u001a:\u000b\u0005]B\u0014!\u0003:fgVdGo]3u\u0015\tI$(A\u0004ti>\u0014\u0018mZ3\u000b\u0005mb\u0014A\u00027j].L7O\u0003\u0002>}\u00051\u0011\r]1dQ\u0016T\u0011aP\u0001\u0004_J<7\u0001A\u000b\u0004\u0005:c6c\u0001\u0001DEB!AI\u0013'\\\u001b\u0005)%BA\u001cG\u0015\t9\u0005*\u0001\u0002j_*\u0011\u0011JO\u0001\u0007G>lWn\u001c8\n\u0005-+%a\u0004*fgVdGoU3u/JLG/\u001a:\u0011\u00055sE\u0002\u0001\u0003\u0006\u001f\u0002\u0011\r\u0001\u0015\u0002\u0002\u0017F\u0011\u0011k\u0016\t\u0003%Vk\u0011a\u0015\u0006\u0002)\u0006)1oY1mC&\u0011ak\u0015\u0002\b\u001d>$\b.\u001b8h!\tA\u0016,D\u0001G\u0013\tQfI\u0001\u0005NKR\fG)\u0019;b!\tiE\fB\u0003^\u0001\t\u0007aLA\u0001W#\t\tv\f\u0005\u0002YA&\u0011\u0011M\u0012\u0002\u0007%\u0016\u001cwN\u001d3\u0011\u0005\r4W\"\u00013\u000b\u0005\u0015D\u0015!B;uS2\u001c\u0018BA4e\u0005\u001daunZ4j]\u001e\f\u0011B]3tk2$8+\u001a;\u0011\t\u0011SGjW\u0005\u0003W\u0016\u0013\u0011BU3tk2$8+\u001a;\u0002\u00195\f\u0007pQ1dQ\u0016\u001c\u0016N_3\u0011\u0005Is\u0017BA8T\u0005\u0011auN\\4\u0002\u0013M$xN]3QCRD\u0007C\u0001-s\u0013\t\u0019hI\u0001\u0004GgB\u000bG\u000f[\u0001\u0007y%t\u0017\u000e\u001e \u0015\tYD\u0018P\u001f\t\u0005o\u0002a5,D\u00017\u0011\u0015AG\u00011\u0001j\u0011\u0015aG\u00011\u0001n\u0011\u0015\u0001H\u00011\u0001r\u0003)\u0019XM]5bY&TXM]\u000b\u0002{B\u0011AI`\u0005\u0003\u007f\u0016\u0013\u0001CU3tk2$8+\u001a:jC2L'0\u001a:\u0002\u0017M,'/[1mSj,'\u000fI\u0001\u000f[>4X\rV8Xe&$XMU8x+\t\t9\u0001E\u0002S\u0003\u0013I1!a\u0003T\u0005\u001d\u0011un\u001c7fC:\f!#\\8wKR{wK]5uKJ{wo\u0018\u0013fcR!\u0011\u0011CA\f!\r\u0011\u00161C\u0005\u0004\u0003+\u0019&\u0001B+oSRD\u0011\"!\u0007\t\u0003\u0003\u0005\r!a\u0002\u0002\u0007a$\u0013'A\bn_Z,Gk\\,sSR,'k\\<!\u00031yW\u000f\u001e9viN#(/Z1n+\t\t\t\u0003\u0005\u0003\u0002$\u0005-RBAA\u0013\u0015\r9\u0015q\u0005\u0006\u0003\u0003S\tAA[1wC&!\u0011QFA\u0013\u00051yU\u000f\u001e9viN#(/Z1n\u0003AyW\u000f\u001e9viN#(/Z1n?\u0012*\u0017\u000f\u0006\u0003\u0002\u0012\u0005M\u0002\"CA\r\u0017\u0005\u0005\t\u0019AA\u0011\u00035yW\u000f\u001e9viN#(/Z1nA\u0005A!o\\<D_VtG/\u0006\u0002\u0002<A\u0019!+!\u0010\n\u0007\u0005}2KA\u0002J]R\fAB]8x\u0007>,h\u000e^0%KF$B!!\u0005\u0002F!I\u0011\u0011\u0004\b\u0002\u0002\u0003\u0007\u00111H\u0001\ne><8i\\;oi\u0002\naAY;gM\u0016\u0014XCAA'!\u0019\ty%!\u0017\u0002^5\u0011\u0011\u0011\u000b\u0006\u0005\u0003'\n)&A\u0004nkR\f'\r\\3\u000b\u0007\u0005]3+\u0001\u0006d_2dWm\u0019;j_:LA!a\u0017\u0002R\tY\u0011I\u001d:bs\n+hMZ3s!\r\u0011\u0016qL\u0005\u0004\u0003C\u001a&\u0001\u0002\"zi\u0016\fqAY;gM\u0016\u0014\b%\u0001\u0002ggV\u0011\u0011\u0011\u000e\t\u00041\u0006-\u0014bAA7\r\n\u0011ai]\u0001\u0007MN|F%Z9\u0015\t\u0005E\u00111\u000f\u0005\n\u00033\u0019\u0012\u0011!a\u0001\u0003S\n1AZ:!\u0003%\u0011X*\u001a;b\t\u0006$\u0018-F\u0001X\u00035\u0011X*\u001a;b\t\u0006$\u0018m\u0018\u0013fcR!\u0011\u0011CA@\u0011!\tIBFA\u0001\u0002\u00049\u0016A\u0003:NKR\fG)\u0019;bA\u0005I\u0001O]8ysV\u001bXM]\u000b\u0003\u0003\u000f\u0003B!!#\u0002\u0018:!\u00111RAJ!\r\tiiU\u0007\u0003\u0003\u001fS1!!%A\u0003\u0019a$o\\8u}%\u0019\u0011QS*\u0002\rA\u0013X\rZ3g\u0013\u0011\tI*a'\u0003\rM#(/\u001b8h\u0015\r\t)jU\u0001\u000eaJ|\u00070_+tKJ|F%Z9\u0015\t\u0005E\u0011\u0011\u0015\u0005\n\u00033I\u0012\u0011!a\u0001\u0003\u000f\u000b!\u0002\u001d:pqf,6/\u001a:!\u0003-1\u0017\u000e\\3De\u0016\fG/\u001a3\u0002\u001f\u0019LG.Z\"sK\u0006$X\rZ0%KF$B!!\u0005\u0002,\"I\u0011\u0011\u0004\u000f\u0002\u0002\u0003\u0007\u0011qA\u0001\rM&dWm\u0011:fCR,G\rI\u0001\u0007G2|7/\u001a3\u0002\u0015\rdwn]3e?\u0012*\u0017\u000f\u0006\u0003\u0002\u0012\u0005U\u0006\"CA\r?\u0005\u0005\t\u0019AA\u0004\u0003\u001d\u0019Gn\\:fI\u0002\n!c\u0016*J)\u0016\u0013v\fT(D\u0017~\u001b%+R!U\u000bV\u0011\u0011Q\u0018\t\u0005\u0003\u007f\u000b)-\u0004\u0002\u0002B*!\u00111YA\u0014\u0003\u0011a\u0017M\\4\n\t\u0005\u001d\u0017\u0011\u0019\u0002\u0007\u001f\nTWm\u0019;\u0002']\u0013\u0016\nV#S?2{5iS0D%\u0016\u000bE+\u0012\u0011\u0002#]\u0013\u0016\nV#S?2{5iS0D\u0019>\u001bV)\u0001\nX%&#VIU0M\u001f\u000e[ul\u0011'P'\u0016\u0003\u0013aC4fi6+G/\u0019#bi\u0006\fAb]3u!J|\u00070_+tKJ$B!!\u0005\u0002V\"9\u00111\u0011\u0014A\u0002\u0005\u001d\u0015aB5t\u000b6\u0004H/_\u0001\u0005S:LG\u000f\u0006\u0002\u0002\u0012\u0005i1M]3bi\u0016tUm\u001e$jY\u0016,\"!!\u0005\u0002\u0013]\u0014\u0018\u000e^3MS:,GCBA\t\u0003K\fy\u000fC\u0004\u0002h*\u0002\r!!;\u0002\u000b\tLH/Z:\u0011\u000bI\u000bY/!\u0018\n\u0007\u000558KA\u0003BeJ\f\u0017\u0010C\u0005\u0002r*\u0002\n\u00111\u0001\u0002\b\u0005)1-Y2iK\u0006\u0019rO]5uK2Kg.\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\u001f\u0016\u0005\u0003\u000f\tIp\u000b\u0002\u0002|B!\u0011Q B\u0004\u001b\t\tyP\u0003\u0003\u0003\u0002\t\r\u0011!C;oG\",7m[3e\u0015\r\u0011)aU\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0005\u0003\u007f\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003!!xn\u0015;sS:<\u0017\u0001\u0003;p\rN\u0003\u0016\r\u001e5\u0016\u0003E\f!$\u00193e\u001b\u0016$\u0018\rR1uC\u0006sGMU3d_J$7\u000b\u001e:j]\u001e$B!!\u0005\u0003\u0016!9!q\u0003\u0018A\u0002\u0005\u001d\u0015aB2p]R,g\u000e^\u0001\u0010C\u0012$'+Z2pe\u0012\u001cFO]5oOR!\u0011\u0011\u0003B\u000f\u0011\u001d\u00119b\fa\u0001\u0003\u000f\u000b1\"\u00193e\u001b\u0016$\u0018\rR1uCR!\u0011\u0011\u0003B\u0012\u0011\u0019\u0011)\u0003\ra\u0001/\u0006AQ.\u001a;b\t\u0006$\u0018\rK\u00031\u0005S\u0011)\u0004E\u0003S\u0005W\u0011y#C\u0002\u0003.M\u0013a\u0001\u001e5s_^\u001c\b\u0003BA\u0012\u0005cIAAa\r\u0002&\tY\u0011jT#yG\u0016\u0004H/[8oc\u001dq\u0012q\u0011B\u001c\u0005C\n\u0014b\tB\u001d\u0005\u007f\u00119F!\u0011\u0016\t\u0005\u0015%1\b\u0003\b\u0005{\u0001%\u0019\u0001B$\u0005\u0005!\u0016\u0002\u0002B!\u0005\u0007\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n$b\u0001B#'\u00061A\u000f\u001b:poN\f2!\u0015B%!\u0011\u0011YE!\u0015\u000f\u0007I\u0013i%C\u0002\u0003PM\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0003T\tU#!\u0003+ie><\u0018M\u00197f\u0015\r\u0011yeU\u0019\nG\te#1\fB/\u0005\u000br1A\u0015B.\u0013\r\u0011)eU\u0019\u0006EI\u001b&q\f\u0002\u0006g\u000e\fG.Y\u0019\u0004M\t=\u0012!C1eIJ+7m\u001c:e)\u0011\t\tBa\u001a\t\r\t%\u0014\u00071\u0001`\u0003\u0019\u0011XmY8sI\"*\u0011G!\u000b\u0003nE:a$a\"\u0003p\tU\u0014'C\u0012\u0003:\t}\"\u0011\u000fB!c%\u0019#\u0011\fB.\u0005g\u0012)%M\u0003#%N\u0013y&M\u0002'\u0005_\tqa\u00197pg\u001645/A\u0003dY>\u001cX-A\u0003gYV\u001c\b\u000e")
public class StorageResultSetWriter<K extends MetaData, V extends Record>
extends ResultSetWriter<K, V>
implements Logging {
    private final ResultSet<K, V> resultSet;
    private final long maxCacheSize;
    private final FsPath storePath;
    private final ResultSerializer serializer;
    private boolean moveToWriteRow;
    private OutputStream outputStream;
    private int rowCount;
    private final ArrayBuffer<Object> buffer;
    private Fs fs;
    private MetaData rMetaData;
    private String proxyUser;
    private boolean fileCreated;
    private boolean closed;
    private final Object WRITER_LOCK_CREATE;
    private final Object WRITER_LOCK_CLOSE;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        StorageResultSetWriter storageResultSetWriter = this;
        synchronized (storageResultSetWriter) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private ResultSerializer serializer() {
        return this.serializer;
    }

    private boolean moveToWriteRow() {
        return this.moveToWriteRow;
    }

    private void moveToWriteRow_$eq(boolean x$1) {
        this.moveToWriteRow = x$1;
    }

    private OutputStream outputStream() {
        return this.outputStream;
    }

    private void outputStream_$eq(OutputStream x$1) {
        this.outputStream = x$1;
    }

    private int rowCount() {
        return this.rowCount;
    }

    private void rowCount_$eq(int x$1) {
        this.rowCount = x$1;
    }

    private ArrayBuffer<Object> buffer() {
        return this.buffer;
    }

    private Fs fs() {
        return this.fs;
    }

    private void fs_$eq(Fs x$1) {
        this.fs = x$1;
    }

    private MetaData rMetaData() {
        return this.rMetaData;
    }

    private void rMetaData_$eq(MetaData x$1) {
        this.rMetaData = x$1;
    }

    private String proxyUser() {
        return this.proxyUser;
    }

    private void proxyUser_$eq(String x$1) {
        this.proxyUser = x$1;
    }

    private boolean fileCreated() {
        return this.fileCreated;
    }

    private void fileCreated_$eq(boolean x$1) {
        this.fileCreated = x$1;
    }

    private boolean closed() {
        return this.closed;
    }

    private void closed_$eq(boolean x$1) {
        this.closed = x$1;
    }

    private Object WRITER_LOCK_CREATE() {
        return this.WRITER_LOCK_CREATE;
    }

    private Object WRITER_LOCK_CLOSE() {
        return this.WRITER_LOCK_CLOSE;
    }

    public MetaData getMetaData() {
        return this.rMetaData();
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser_$eq(proxyUser);
    }

    public boolean isEmpty() {
        return this.rMetaData() == null && this.buffer().length() <= Dolphin$.MODULE$.FILE_EMPTY();
    }

    public void init() {
        this.writeLine(this.resultSet.getResultSetHeader(), true);
    }

    public void createNewFile() {
        if (!this.fileCreated()) {
            Object object = this.WRITER_LOCK_CREATE();
            synchronized (object) {
                if (!this.fileCreated() && this.storePath != null && this.outputStream() == null) {
                    this.logger().info(new StringBuilder(43).append("Try to create a new file:").append(this.storePath).append(", with proxy user:").append(this.proxyUser()).toString());
                    this.fs_$eq(FSFactory$.MODULE$.getFsByProxyUser(this.storePath, this.proxyUser()));
                    this.fs().init(null);
                    FileSystemUtils$.MODULE$.createNewFile(this.storePath, this.proxyUser(), true);
                    this.outputStream_$eq(this.fs().write(this.storePath, true));
                    Fs fs = this.fs();
                    if (fs instanceof FileSystem) {
                        FileSystem fileSystem = (FileSystem)fs;
                        BoxesRunTime.boxToBoolean((boolean)fileSystem.setPermission(this.storePath, "rwx------"));
                    }
                    this.logger().info(new StringBuilder(29).append("Succeed to create a new file:").append(this.storePath).toString());
                    this.fileCreated_$eq(true);
                }
            }
            return;
        }
        if (this.storePath != null && this.outputStream() == null) {
            this.logger().warn("outputStream had been set null, but createNewFile() was called again.");
            return;
        }
    }

    public void writeLine(byte[] bytes, boolean cache) {
        if (this.closed()) {
            this.logger().warn("the writer had been closed, but writeLine() was still called.");
            return;
        }
        if ((long)bytes.length > LinkisStorageConf$.MODULE$.ROW_BYTE_MAX_LEN()) {
            throw new IOException(new StringBuilder(35).append("A single row of data cannot exceed ").append(LinkisStorageConf$.MODULE$.ROW_BYTE_MAX_LEN_STR()).toString());
        }
        if ((long)this.buffer().length() > this.maxCacheSize && !cache) {
            if (this.outputStream() == null) {
                this.createNewFile();
            }
            this.flush();
            this.outputStream().write(bytes);
            return;
        }
        this.buffer().appendAll((TraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)));
    }

    public boolean writeLine$default$2() {
        return false;
    }

    public String toString() {
        if (this.outputStream() == null) {
            if (this.isEmpty()) {
                return "";
            }
            return new String((byte[])this.buffer().toArray(ClassTag$.MODULE$.Byte()), Dolphin$.MODULE$.CHAR_SET());
        }
        return this.storePath.getSchemaPath();
    }

    public FsPath toFSPath() {
        return this.storePath;
    }

    public void addMetaDataAndRecordString(String content) {
        if (!this.moveToWriteRow()) {
            byte[] bytes = content.getBytes(Dolphin$.MODULE$.CHAR_SET());
            this.writeLine(bytes, this.writeLine$default$2());
        }
        this.moveToWriteRow_$eq(true);
    }

    public void addRecordString(String content) {
    }

    public void addMetaData(MetaData metaData) throws IOException {
        if (!this.moveToWriteRow()) {
            this.rMetaData_$eq(metaData);
            this.init();
            if (metaData == null) {
                this.writeLine(this.serializer().metaDataToBytes(metaData), true);
            } else {
                this.writeLine(this.serializer().metaDataToBytes(metaData), this.writeLine$default$2());
            }
            this.moveToWriteRow_$eq(true);
            return;
        }
    }

    public void addRecord(Record record) throws IOException {
        if (this.moveToWriteRow()) {
            this.rowCount_$eq(this.rowCount() + 1);
            this.writeLine(this.serializer().recordToBytes(record), this.writeLine$default$2());
            return;
        }
    }

    public void closeFs() {
        if (this.fs() != null) {
            IOUtils.closeQuietly((Closeable)this.fs());
            this.fs_$eq(null);
            return;
        }
    }

    public void close() {
        block5: {
            if (this.closed()) {
                this.logger().warn("the writer had been closed, but close() was still called.");
                return;
            }
            Object object = this.WRITER_LOCK_CLOSE();
            synchronized (object) {
                block4: {
                    if (this.closed()) break block4;
                    this.closed_$eq(true);
                    break block5;
                }
                return;
            }
        }
        Utils$.MODULE$.tryFinally((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (this.outputStream() != null) {
                this.flush();
                return;
            }
        }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (this.outputStream() != null) {
                IOUtils.closeQuietly((OutputStream)this.outputStream());
                this.outputStream_$eq(null);
            }
            this.closeFs();
        });
    }

    public void flush() {
        Object object;
        this.createNewFile();
        if (this.outputStream() != null) {
            if (this.buffer().nonEmpty()) {
                this.outputStream().write((byte[])this.buffer().toArray(ClassTag$.MODULE$.Byte()));
                this.buffer().clear();
            }
            object = Utils$.MODULE$.tryAndWarnMsg((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                OutputStream outputStream = this.outputStream();
                if (outputStream instanceof HdfsDataOutputStream) {
                    HdfsDataOutputStream hdfsDataOutputStream = (HdfsDataOutputStream)outputStream;
                    hdfsDataOutputStream.hflush();
                    return;
                }
                this.outputStream().flush();
            }, "Error encounters when flush result set ", this.logger());
        } else {
            object = BoxedUnit.UNIT;
        }
        if (this.closed()) {
            if (this.logger().isDebugEnabled()) {
                this.logger().debug("the writer had been closed, but flush() was still called.");
                return;
            }
            return;
        }
    }

    public StorageResultSetWriter(ResultSet<K, V> resultSet, long maxCacheSize, FsPath storePath) {
        this.resultSet = resultSet;
        this.maxCacheSize = maxCacheSize;
        this.storePath = storePath;
        super(resultSet, maxCacheSize, storePath);
        Logging.$init$((Logging)this);
        this.serializer = resultSet.createResultSetSerializer();
        this.moveToWriteRow = false;
        this.rowCount = 0;
        this.buffer = new ArrayBuffer();
        this.proxyUser = StorageUtils$.MODULE$.getJvmUser();
        this.fileCreated = false;
        this.closed = false;
        this.WRITER_LOCK_CREATE = new Object();
        this.WRITER_LOCK_CLOSE = new Object();
    }
}

