/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.server.restful;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.cs.common.entity.enumeration.ContextType;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.apache.linkis.cs.common.entity.source.ContextKey;
import org.apache.linkis.cs.common.entity.source.ContextKeyValue;
import org.apache.linkis.cs.common.entity.source.ContextValue;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.apache.linkis.cs.common.utils.CSCommonUtils;
import org.apache.linkis.cs.errorcode.LinkisCsServerErrorCodeSummary;
import org.apache.linkis.cs.exception.ContextSearchFailedException;
import org.apache.linkis.cs.server.enumeration.ServiceType;
import org.apache.linkis.cs.server.restful.CsRestfulParent;
import org.apache.linkis.cs.server.service.ContextService;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"cs(contextservice) operation"})
@RestController
@RequestMapping(path={"/contextservice"})
public class ContextRestfulApi
implements CsRestfulParent {
    private static final Logger logger = LoggerFactory.getLogger(ContextRestfulApi.class);
    @Autowired
    private ContextService contextService;
    private ObjectMapper objectMapper = new ObjectMapper();

    @ApiOperation(value="getContextValue", notes="get context value", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="contextKey", required=true, dataType="String"), @ApiImplicitParam(name="contextID", required=true, dataType="String")})
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"getContextValue"}, method={RequestMethod.POST})
    public Message getContextValue(HttpServletRequest req, @RequestBody JsonNode jsonNode) throws InterruptedException, CSErrorException, IOException, ClassNotFoundException {
        ContextID contextID = this.getContextIDFromJsonNode(jsonNode);
        if (StringUtils.isEmpty((CharSequence)contextID.getContextId())) {
            throw new CSErrorException(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorCode(), MessageFormat.format(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorDesc(), "ContextID"));
        }
        ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("getContextValue,contextID:" + contextID.getContextId()));
        ContextKey contextKey = this.getContextKeyFromJsonNode(jsonNode);
        ContextValue res = this.contextService.getContextValue(contextID, contextKey);
        return this.generateMessage(res, "contextValue");
    }

    @ApiOperation(value="searchContextValue", notes="search context value", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="condition", required=true, dataType="String"), @ApiImplicitParam(name="contextID", required=true, dataType="String")})
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"searchContextValue"}, method={RequestMethod.POST})
    public Message searchContextValue(HttpServletRequest req, @RequestBody JsonNode jsonNode) throws CSErrorException, IOException, ClassNotFoundException, ContextSearchFailedException {
        ContextID contextID = this.getContextIDFromJsonNode(jsonNode);
        if (StringUtils.isEmpty((CharSequence)contextID.getContextId())) {
            throw new CSErrorException(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorCode(), MessageFormat.format(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorDesc(), "ContextID"));
        }
        ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("searchContextValue,contextID:" + contextID.getContextId()));
        JsonNode condition = jsonNode.get("condition");
        Map conditionMap = (Map)this.objectMapper.convertValue((Object)condition, (TypeReference)new TypeReference<Map<Object, Object>>(){});
        List<ContextKeyValue> res = this.contextService.searchContextValue(contextID, conditionMap);
        return this.generateMessage(res, "contextKeyValue");
    }

    @ApiOperation(value="setValueByKey", notes="set value by key", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="contextKey", required=true, dataType="String"), @ApiImplicitParam(name="contextID", required=true, dataType="String")})
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"setValueByKey"}, method={RequestMethod.POST})
    public Message setValueByKey(HttpServletRequest req, @RequestBody JsonNode jsonNode) throws CSErrorException, IOException, ClassNotFoundException, InterruptedException {
        ContextID contextID = this.getContextIDFromJsonNode(jsonNode);
        if (StringUtils.isEmpty((CharSequence)contextID.getContextId())) {
            throw new CSErrorException(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorCode(), MessageFormat.format(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorDesc(), "ContextID"));
        }
        ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("setValueByKey,contextID:" + contextID.getContextId()));
        ContextKey contextKey = this.getContextKeyFromJsonNode(jsonNode);
        ContextValue contextValue = this.getContextValueFromJsonNode(jsonNode);
        this.contextService.setValueByKey(contextID, contextKey, contextValue);
        return this.generateMessage(null, "");
    }

    @ApiOperation(value="setValue", notes="set value", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="contextKeyValue", required=true, dataType="String"), @ApiImplicitParam(name="contextID", required=true, dataType="String")})
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"setValue"}, method={RequestMethod.POST})
    public Message setValue(HttpServletRequest req, @RequestBody JsonNode jsonNode) throws InterruptedException, CSErrorException, IOException, ClassNotFoundException {
        ContextID contextID = this.getContextIDFromJsonNode(jsonNode);
        if (StringUtils.isEmpty((CharSequence)contextID.getContextId())) {
            throw new CSErrorException(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorCode(), MessageFormat.format(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorDesc(), "ContextID"));
        }
        ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("setValue,contextID:" + contextID.getContextId()));
        ContextKeyValue contextKeyValue = this.getContextKeyValueFromJsonNode(jsonNode);
        this.contextService.setValue(contextID, contextKeyValue);
        return this.generateMessage(null, "");
    }

    @ApiOperation(value="resetValue", notes="reset value", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="contextKey", required=true, dataType="String"), @ApiImplicitParam(name="contextID", required=true, dataType="String")})
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"resetValue"}, method={RequestMethod.POST})
    public Message resetValue(HttpServletRequest req, @RequestBody JsonNode jsonNode) throws CSErrorException, IOException, ClassNotFoundException {
        ContextID contextID = this.getContextIDFromJsonNode(jsonNode);
        if (StringUtils.isEmpty((CharSequence)contextID.getContextId())) {
            throw new CSErrorException(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorCode(), MessageFormat.format(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorDesc(), "ContextID"));
        }
        ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("resetValue,contextID:" + contextID.getContextId()));
        ContextKey contextKey = this.getContextKeyFromJsonNode(jsonNode);
        this.contextService.resetValue(contextID, contextKey);
        return this.generateMessage(null, "");
    }

    @ApiOperation(value="removeValue", notes="remove value", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="contextKey", required=true, dataType="String"), @ApiImplicitParam(name="contextID", required=true, dataType="String")})
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"removeValue"}, method={RequestMethod.POST})
    public Message removeValue(HttpServletRequest req, @RequestBody JsonNode jsonNode) throws CSErrorException, IOException, ClassNotFoundException {
        ContextID contextID = this.getContextIDFromJsonNode(jsonNode);
        if (StringUtils.isEmpty((CharSequence)contextID.getContextId())) {
            throw new CSErrorException(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorCode(), MessageFormat.format(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorDesc(), "ContextID"));
        }
        ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("removeValue,contextID:" + contextID.getContextId()));
        ContextKey contextKey = this.getContextKeyFromJsonNode(jsonNode);
        this.contextService.removeValue(contextID, contextKey);
        return this.generateMessage(null, "");
    }

    @ApiOperation(value="removeAllValue", notes="remove all value", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="contextKey", required=true, dataType="String"), @ApiImplicitParam(name="contextID", required=true, dataType="String")})
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"removeAllValue"}, method={RequestMethod.POST})
    public Message removeAllValue(HttpServletRequest req, @RequestBody JsonNode jsonNode) throws CSErrorException, IOException, ClassNotFoundException {
        ContextID contextID = this.getContextIDFromJsonNode(jsonNode);
        if (StringUtils.isEmpty((CharSequence)contextID.getContextId())) {
            throw new CSErrorException(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorCode(), MessageFormat.format(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorDesc(), "ContextID"));
        }
        ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("removeAllValue,contextID:" + contextID.getContextId()));
        this.contextService.removeAllValue(contextID);
        return this.generateMessage(null, "");
    }

    @ApiOperation(value="removeAllValueByKeyPrefixAndContextType", notes="remove all value by key prefix and context type", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="contextKeyType", required=true, dataType="String"), @ApiImplicitParam(name="keyPrefix", required=true, dataType="String")})
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"removeAllValueByKeyPrefixAndContextType"}, method={RequestMethod.POST})
    public Message removeAllValueByKeyPrefixAndContextType(HttpServletRequest req, @RequestBody JsonNode jsonNode) throws InterruptedException, CSErrorException, IOException, ClassNotFoundException {
        ContextID contextID = this.getContextIDFromJsonNode(jsonNode);
        if (StringUtils.isEmpty((CharSequence)contextID.getContextId())) {
            throw new CSErrorException(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorCode(), MessageFormat.format(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorDesc(), "ContextID"));
        }
        ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("removeAllValueByKeyPrefixAndContextType,contextID:" + contextID.getContextId()));
        String contextType = jsonNode.get("contextKeyType").textValue();
        String keyPrefix = jsonNode.get("keyPrefix").textValue();
        this.contextService.removeAllValueByKeyPrefixAndContextType(contextID, ContextType.valueOf((String)contextType), keyPrefix);
        return this.generateMessage(null, "");
    }

    @ApiOperation(value="removeAllValueByKeyAndContextType", notes="remove all value by key and context type", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="contextKeyType", required=true, dataType="String"), @ApiImplicitParam(name="contextKey", required=true, dataType="String")})
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"removeAllValueByKeyAndContextType"}, method={RequestMethod.POST})
    public Message removeValueByKeyAndContextType(HttpServletRequest req, @RequestBody JsonNode jsonNode) throws InterruptedException, CSErrorException, IOException, ClassNotFoundException {
        ContextID contextID = this.getContextIDFromJsonNode(jsonNode);
        String contextType = jsonNode.get("contextKeyType").textValue();
        String keyStr = jsonNode.get("contextKey").textValue();
        this.contextService.removeValueByKeyAndContextType(contextID, ContextType.valueOf((String)contextType), keyStr);
        return this.generateMessage(null, "");
    }

    @ApiOperation(value="removeAllValueByKeyPrefix", notes="remove all value by key prefix", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="contextID", dataType="String"), @ApiImplicitParam(name="keyPrefix", dataType="String")})
    @RequestMapping(path={"removeAllValueByKeyPrefix"}, method={RequestMethod.POST})
    public Message removeAllValueByKeyPrefix(HttpServletRequest req, @RequestBody JsonNode jsonNode) throws InterruptedException, CSErrorException, IOException, ClassNotFoundException {
        ContextID contextID = this.getContextIDFromJsonNode(jsonNode);
        if (StringUtils.isEmpty((CharSequence)contextID.getContextId())) {
            throw new CSErrorException(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorCode(), MessageFormat.format(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorDesc(), "ContextID"));
        }
        ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("removeAllValueByKeyPrefix,contextID:" + contextID.getContextId()));
        String keyPrefix = jsonNode.get("keyPrefix").textValue();
        this.contextService.removeAllValueByKeyPrefix(contextID, keyPrefix);
        return this.generateMessage(null, "");
    }

    @ApiOperation(value="clearAllContextByID", notes="clear all context by id", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="idList", required=true, dataType="String", value="id list")})
    @RequestMapping(path={"clearAllContextByID"}, method={RequestMethod.POST})
    public Message clearAllContextByID(HttpServletRequest req, @RequestBody JsonNode jsonNode) throws InterruptedException, CSErrorException {
        if (null == jsonNode || !jsonNode.has("idList") || !jsonNode.get("idList").isArray() || jsonNode.get("idList").isArray() && jsonNode.get("idList").size() == 0) {
            throw new CSErrorException(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorCode(), MessageFormat.format(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorDesc(), "idList"));
        }
        ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"clearAllContextByID");
        ArrayNode idArray = (ArrayNode)jsonNode.get("idList");
        logger.info("clearAllContextByID idList size : {}", (Object)idArray.size());
        ArrayList<String> idList = new ArrayList<String>(idArray.size());
        for (int i = 0; i < idArray.size(); ++i) {
            idList.add(idArray.get(i).asText());
        }
        Message resp = this.generateMessage(this.contextService.clearAllContextByID(idList), "num");
        resp.setMethod("/api/contextservice/clearAllContextByID");
        return resp;
    }

    @ApiOperation(value="clearAllContextByID(time)", notes="clear all context by id(time)", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="createTimeStart", required=true, dataType="String"), @ApiImplicitParam(name="createTimeEnd", required=true, dataType="String"), @ApiImplicitParam(name="updateTimeStart", required=true, dataType="String"), @ApiImplicitParam(name="updateTimeEnd", required=true, dataType="String"), @ApiImplicitParam(name="accessTimeStart", required=true, dataType="String"), @ApiImplicitParam(name="accessTimeEnd", required=true, dataType="String")})
    @RequestMapping(path={"clearAllContextByTime"}, method={RequestMethod.POST})
    public Message clearAllContextByID(HttpServletRequest req, @RequestBody Map<String, Object> bodyMap) throws InterruptedException, CSErrorException {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"clearAllContextByTime");
        if (Configuration.isNotAdmin((String)username)) {
            throw new CSErrorException(LinkisCsServerErrorCodeSummary.NO_PERMISSION.getErrorCode(), LinkisCsServerErrorCodeSummary.NO_PERMISSION.getErrorDesc());
        }
        if (null == bodyMap || bodyMap.isEmpty()) {
            throw new CSErrorException(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorCode(), MessageFormat.format(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorDesc(), "idList"));
        }
        Date createTimeStart = null;
        Date createTimeEnd = null;
        Date updateTimeStart = null;
        Date updateTimeEnd = null;
        Date accessTimeStart = null;
        Date accessTimeEnd = null;
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        if (bodyMap.containsKey("createTimeStart") && null != bodyMap.get("createTimeStart")) {
            createTimeStart = CSCommonUtils.localDatetimeToDate((LocalDateTime)LocalDateTime.parse((String)bodyMap.get("createTimeStart"), dtf));
        }
        if (bodyMap.containsKey("createTimeEnd") && null != bodyMap.get("createTimeEnd")) {
            createTimeEnd = CSCommonUtils.localDatetimeToDate((LocalDateTime)LocalDateTime.parse((String)bodyMap.get("createTimeEnd"), dtf));
        }
        if (bodyMap.containsKey("updateTimeStart") && null != bodyMap.get("updateTimeStart")) {
            updateTimeStart = CSCommonUtils.localDatetimeToDate((LocalDateTime)LocalDateTime.parse((String)bodyMap.get("updateTimeStart"), dtf));
        }
        if (bodyMap.containsKey("updateTimeEnd") && null != bodyMap.get("updateTimeEnd")) {
            updateTimeEnd = CSCommonUtils.localDatetimeToDate((LocalDateTime)LocalDateTime.parse((String)bodyMap.get("updateTimeEnd"), dtf));
        }
        if (bodyMap.containsKey("accessTimeStart") && null != bodyMap.get("accessTimeStart")) {
            accessTimeStart = CSCommonUtils.localDatetimeToDate((LocalDateTime)LocalDateTime.parse((String)bodyMap.get("accessTimeStart"), dtf));
        }
        if (bodyMap.containsKey("accessTimeEnd") && null != bodyMap.get("accessTimeEnd")) {
            accessTimeEnd = CSCommonUtils.localDatetimeToDate((LocalDateTime)LocalDateTime.parse((String)bodyMap.get("accessTimeEnd"), dtf));
        }
        if (null == createTimeStart && null == createTimeEnd && null == updateTimeStart && null == updateTimeEnd) {
            throw new CSErrorException(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorCode(), MessageFormat.format(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorDesc(), "createTimeStart, createTimeEnd, updateTimeStart, updateTimeEnd"));
        }
        logger.info("clearAllContextByTime: user : {}, createTimeStart : {}, createTimeEnd : {}, updateTimeStart : {}, updateTimeEnd : {}, accessTimeStart : {}, accessTimeEnd : {}.", new Object[]{username, createTimeStart, createTimeEnd, updateTimeStart, updateTimeEnd, accessTimeStart, accessTimeEnd});
        Message resp = this.generateMessage(this.contextService.clearAllContextByTime(createTimeStart, createTimeEnd, updateTimeStart, updateTimeEnd, accessTimeStart, accessTimeEnd), "num");
        resp.setMethod("/api/contextservice/clearAllContextByTime");
        return resp;
    }

    @Override
    public ServiceType getServiceType() {
        return ServiceType.CONTEXT;
    }
}

