/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.server.service.impl;

import java.util.Arrays;
import java.util.List;
import org.apache.linkis.cs.common.entity.history.ContextHistory;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.apache.linkis.cs.persistence.ContextPersistenceManager;
import org.apache.linkis.cs.persistence.persistence.ContextHistoryPersistence;
import org.apache.linkis.cs.persistence.persistence.KeywordContextHistoryPersistence;
import org.apache.linkis.cs.server.enumeration.ServiceType;
import org.apache.linkis.cs.server.service.ContextHistoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContextHistoryServiceImpl
extends ContextHistoryService {
    @Autowired
    private ContextPersistenceManager persistenceManager;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public String getName() {
        return ServiceType.CONTEXT_HISTORY.name();
    }

    private ContextHistoryPersistence getPersistence() throws CSErrorException {
        return this.persistenceManager.getContextHistoryPersistence();
    }

    private KeywordContextHistoryPersistence getKeywordPersistence() throws CSErrorException {
        return this.persistenceManager.getKeywordContextHistoryPersistence();
    }

    @Override
    public void createHistroy(ContextID contextID, ContextHistory contextHistory) throws CSErrorException {
        this.getPersistence().createHistory(contextID, contextHistory);
        this.logger.info(String.format("createHistory,csId:%s,contextType:%s,source:%s", contextID.getContextId(), contextHistory.getContextType(), contextHistory.getSource()));
    }

    @Override
    public void removeHistory(ContextID contextID, ContextHistory contextHistory) throws CSErrorException {
        this.getPersistence().removeHistory(contextID, contextHistory.getSource());
        this.logger.info(String.format("removeHistory,csId:%s,contextType:%s,source:%s", contextID.getContextId(), contextHistory.getContextType(), contextHistory.getSource()));
    }

    @Override
    public List<ContextHistory> getHistories(ContextID contextID) throws CSErrorException {
        this.logger.info(String.format("getHistories,csId:%s", contextID.getContextId()));
        return this.getPersistence().getHistories(contextID);
    }

    @Override
    public ContextHistory getHistory(ContextID contextID, String source) throws CSErrorException {
        this.logger.info(String.format("getHistory,csId:%s,source:%s", contextID.getContextId(), source));
        return this.getPersistence().getHistory(contextID, source);
    }

    @Override
    public List<ContextHistory> searchHistory(ContextID contextID, String[] keywords) throws CSErrorException {
        this.logger.info(String.format("searchHistory,csId:%s,keywords:%s", contextID.getContextId(), Arrays.toString(keywords)));
        return this.getKeywordPersistence().search(contextID, keywords);
    }
}

