/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.server.service.impl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.apache.linkis.cs.common.entity.source.HAContextID;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.apache.linkis.cs.highavailable.ha.ContextHAChecker;
import org.apache.linkis.cs.persistence.ContextPersistenceManager;
import org.apache.linkis.cs.persistence.entity.PersistenceContextID;
import org.apache.linkis.cs.persistence.persistence.ContextIDPersistence;
import org.apache.linkis.cs.server.enumeration.ServiceType;
import org.apache.linkis.cs.server.service.ContextIDService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContextIDServiceImpl
extends ContextIDService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ContextPersistenceManager persistenceManager;
    @Autowired
    private ContextHAChecker contextHAChecker;

    private ContextIDPersistence getPersistence() throws CSErrorException {
        return this.persistenceManager.getContextIDPersistence();
    }

    @Override
    public String getName() {
        return ServiceType.CONTEXT_ID.name();
    }

    @Override
    public String createContextID(ContextID contextID) throws CSErrorException {
        ContextID res = this.getPersistence().createContextID(contextID);
        this.logger.info(String.format("createContextID,csId:%s", res.getContextId()));
        return res.getContextId();
    }

    @Override
    public ContextID getContextID(String id) throws CSErrorException {
        this.logger.info(String.format("getContextID,csId:%s", id));
        return this.getPersistence().getContextID(id);
    }

    @Override
    public void updateContextID(ContextID contextID) throws CSErrorException {
        this.logger.info(String.format("updateContextID,csId:%s", contextID.getContextId()));
        this.getPersistence().updateContextID(contextID);
    }

    @Override
    public void resetContextID(String id) throws CSErrorException {
    }

    @Override
    public void removeContextID(String id) throws CSErrorException {
        this.logger.info(String.format("removeContextID,csId:%s", id));
        this.getPersistence().deleteContextID(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> searchCSIDByTime(Date createTimeStart, Date createTimeEnd, Date updateTimeStart, Date updateTimeEnd, Date accessTimeStart, Date accessTimeEnd, Integer pageNow, Integer pageSize) throws CSErrorException {
        List<PersistenceContextID> rs = null;
        PageHelper.startPage((int)pageNow, (int)pageSize);
        try {
            rs = this.getPersistence().searchCSIDByTime(createTimeStart, createTimeEnd, updateTimeStart, updateTimeEnd, accessTimeStart, accessTimeEnd);
        }
        finally {
            PageHelper.clearPage();
        }
        PageInfo pageInfo = new PageInfo(rs);
        List pageResult = pageInfo.getList();
        ArrayList<String> result = new ArrayList<String>();
        ArrayList errList = new ArrayList();
        if (null != pageResult) {
            pageResult.stream().forEach(persistenceContextID -> {
                try {
                    result.add(this.contextHAChecker.convertHAIDToHAKey((HAContextID)persistenceContextID));
                }
                catch (CSErrorException e) {
                    this.logger.error("convert contextID to hdid failed. id : {}, source : {}", (Object)persistenceContextID.getContextId(), (Object)persistenceContextID.getSource());
                    errList.add(persistenceContextID);
                }
            });
        }
        if (errList.size() > 0) {
            throw new CSErrorException(97001, "There are " + errList.size() + " persistenceContextID that cannot be deserized from source.");
        }
        return result;
    }
}

