/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.monitor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.monitor.MultiMatchingQueries;
import org.apache.lucene.monitor.QueryMatch;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;

public abstract class CandidateMatcher<T extends QueryMatch> {
    protected final IndexSearcher searcher;
    private final Map<String, Exception> errors = new HashMap<String, Exception>();
    private final List<MatchHolder<T>> matches;
    private long searchTime = System.nanoTime();

    public CandidateMatcher(IndexSearcher searcher) {
        this.searcher = searcher;
        int docCount = searcher.getIndexReader().maxDoc();
        this.matches = new ArrayList<MatchHolder<T>>(docCount);
        for (int i = 0; i < docCount; ++i) {
            this.matches.add(new MatchHolder());
        }
    }

    protected abstract void matchQuery(String var1, Query var2, Map<String, String> var3) throws IOException;

    protected final void addMatch(T match, int doc) {
        MatchHolder<T> docMatches = this.matches.get(doc);
        docMatches.matches.compute(((QueryMatch)match).getQueryId(), (key, oldValue) -> {
            if (oldValue != null) {
                return this.resolve(match, oldValue);
            }
            return match;
        });
    }

    public abstract T resolve(T var1, T var2);

    void reportError(String queryId, Exception e) {
        this.errors.put(queryId, e);
    }

    final MultiMatchingQueries<T> finish(long buildTime, int queryCount) {
        this.doFinish();
        this.searchTime = TimeUnit.MILLISECONDS.convert(System.nanoTime() - this.searchTime, TimeUnit.NANOSECONDS);
        ArrayList results = new ArrayList();
        for (MatchHolder<T> matchHolder : this.matches) {
            results.add(matchHolder.matches);
        }
        return new MultiMatchingQueries(results, this.errors, buildTime, this.searchTime, queryCount, this.matches.size());
    }

    protected void doFinish() {
    }

    protected void copyMatches(CandidateMatcher<T> other) {
        this.matches.clear();
        this.matches.addAll(other.matches);
    }

    private static class MatchHolder<T> {
        Map<String, T> matches = new HashMap<String, T>();

        private MatchHolder() {
        }
    }
}

