/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl.model.profile;

import java.util.List;
import org.apache.maven.api.services.VersionParser;
import org.apache.maven.api.services.model.ProfileActivationContext;
import org.apache.maven.impl.model.profile.ConditionParser;

public class ConditionFunctions {
    private final ProfileActivationContext context;
    private final VersionParser versionParser;

    public ConditionFunctions(ProfileActivationContext context, VersionParser versionParser) {
        this.context = context;
        this.versionParser = versionParser;
    }

    public Object length(List<Object> args) {
        if (args.size() != 1) {
            throw new IllegalArgumentException("length function requires exactly one argument");
        }
        String s = ConditionParser.toString(args.get(0));
        return s.length();
    }

    public Object upper(List<Object> args) {
        if (args.size() != 1) {
            throw new IllegalArgumentException("upper function requires exactly one argument");
        }
        String s = ConditionParser.toString(args.get(0));
        return s.toUpperCase();
    }

    public Object lower(List<Object> args) {
        if (args.size() != 1) {
            throw new IllegalArgumentException("lower function requires exactly one argument");
        }
        String s = ConditionParser.toString(args.get(0));
        return s.toLowerCase();
    }

    public Object substring(List<Object> args) {
        if (args.size() < 2 || args.size() > 3) {
            throw new IllegalArgumentException("substring function requires 2 or 3 arguments");
        }
        String s = ConditionParser.toString(args.get(0));
        int start = ConditionParser.toInt(args.get(1));
        int end = args.size() == 3 ? ConditionParser.toInt(args.get(2)) : s.length();
        return s.substring(start, end);
    }

    public Object indexOf(List<Object> args) {
        if (args.size() != 2) {
            throw new IllegalArgumentException("indexOf function requires exactly two arguments");
        }
        String s = ConditionParser.toString(args.get(0));
        String substring = ConditionParser.toString(args.get(1));
        return s.indexOf(substring);
    }

    public Object contains(List<Object> args) {
        if (args.size() != 2) {
            throw new IllegalArgumentException("contains function requires exactly two arguments");
        }
        String s = ConditionParser.toString(args.get(0));
        String substring = ConditionParser.toString(args.get(1));
        return s.contains(substring);
    }

    public Object matches(List<Object> args) {
        if (args.size() != 2) {
            throw new IllegalArgumentException("matches function requires exactly two arguments");
        }
        String s = ConditionParser.toString(args.get(0));
        String regex = ConditionParser.toString(args.get(1));
        return s.matches(regex);
    }

    public Object not(List<Object> args) {
        if (args.size() != 1) {
            throw new IllegalArgumentException("not function requires exactly one argument");
        }
        return ConditionParser.toBoolean(args.get(0)) == false;
    }

    public Object if_(List<Object> args) {
        if (args.size() != 3) {
            throw new IllegalArgumentException("if function requires exactly three arguments");
        }
        boolean condition = ConditionParser.toBoolean(args.get(0));
        return condition ? args.get(1) : args.get(2);
    }

    public Object exists(List<Object> args) {
        if (args.size() != 1) {
            throw new IllegalArgumentException("exists function requires exactly one argument");
        }
        String path = ConditionParser.toString(args.get(0));
        return this.context.exists(path, true);
    }

    public Object missing(List<Object> args) {
        if (args.size() != 1) {
            throw new IllegalArgumentException("missing function requires exactly one argument");
        }
        String path = ConditionParser.toString(args.get(0));
        return !this.context.exists(path, true);
    }

    public Object inrange(List<Object> args) {
        if (args.size() != 2) {
            throw new IllegalArgumentException("inrange function requires exactly two arguments");
        }
        String version = ConditionParser.toString(args.get(0));
        String range = ConditionParser.toString(args.get(1));
        return this.versionParser.parseVersionRange(range).contains(this.versionParser.parseVersion(version));
    }
}

